/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.xsd;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.tip.pc.services.translation.framework.DOMValidator;
import oracle.tip.pc.services.translation.framework.ErrorValidator;
import oracle.tip.pc.services.translation.framework.TranslationContext;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.framework.Translator;
import oracle.tip.pc.services.translation.framework.XlatorHelper;
import oracle.tip.pc.services.translation.util.DeBatchXML;
import oracle.tip.pc.services.translation.xlators.nxsd.ErrorList;
import oracle.tip.pc.services.translation.xlators.nxsd.ExtendedXMLSAXSerializer;
import oracle.tip.pc.services.translation.xlators.nxsd.XMLTokenizer;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSDTranslator
implements Translator {
    private XMLSchema m_xsdDef = null;
    private XSDElement m_elem = null;
    private DeBatchXML fDeBatcher;
    private int fPublishSize;
    private BufferedInputStream fBufStream = null;
    private XMLError fXMLError;
    private XSDValidator fXSDValidator;
    private XMLTokenizer fXMLTokenizer;
    private PrintWriter fLogWriter = null;
    private String encoding = null;
    private String fPrologEncoding = null;

    public XSDTranslator(XMLSchema xsdDef, XSDElement elem) {
        this.m_xsdDef = xsdDef;
        this.m_elem = elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translateFromNative(InputStream inputStream, Result result, TranslationContext ctx) throws TranslationException {
        if (inputStream == null || result == null) {
            throw new TranslationException(11206, new Object[]{"Inbound XSD", "null", "InputStream/Result"});
        }
        this.fBufStream = new BufferedInputStream(inputStream);
        InputSource inputSource = new InputSource(this.fBufStream);
        boolean fValidate = XlatorHelper.getValidation(this.m_xsdDef, this.m_elem);
        if (ctx != null && ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/debatching") && ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/debatching")) {
            try {
                try {
                    if (this.encoding == null) {
                        this.setEncoding(inputSource, ctx);
                    }
                    this.fPublishSize = 1;
                    String publishSize = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/publishsize");
                    if (publishSize != null && publishSize.trim().length() > 0) {
                        this.fPublishSize = Integer.parseInt(publishSize);
                    }
                    boolean errorRecovery = false;
                    if (ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery")) {
                        errorRecovery = ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery");
                    }
                    if (errorRecovery) {
                        int iSkipRecords = 0;
                        ctx.setFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery", false);
                        this.fDeBatcher = new DeBatchXML(this.fBufStream, this.fPublishSize);
                        String skipRecords = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/records-processed");
                        if (skipRecords != null && skipRecords.trim().length() > 0) {
                            iSkipRecords = Integer.parseInt(skipRecords);
                        }
                        this.fDeBatcher.skipRecords(iSkipRecords);
                    } else if (this.fDeBatcher == null) {
                        this.fDeBatcher = new DeBatchXML(this.fBufStream, this.fPublishSize);
                    }
                    Node node = this.fDeBatcher.getNextFragment(ctx);
                    if (node != null && result instanceof DOMResult) {
                        ((DOMResult)result).setNode(node);
                    }
                    return;
                }
                catch (Exception ex) {
                    ErrorList errorList = new ErrorList();
                    errorList.addError(1, 1, -1, -1, -1L, -1L, ex);
                    errorList.setAllCorrupted(true);
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/error-list", errorList);
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/records-processed", String.valueOf(this.fDeBatcher.getTotalRecordsDone()));
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        this.setEncoding(inputSource, ctx);
        if (result instanceof SAXResult) {
            ContentHandler handler;
            SAXParser saxParser = XlatorHelper.getSAXParser(0, Boolean.TRUE, true);
            if (fValidate) {
                saxParser.setValidationMode(3);
                saxParser.setXMLSchema((Object)this.m_xsdDef);
                ErrorValidator errHandler = new ErrorValidator();
                saxParser.setErrorHandler((ErrorHandler)errHandler);
            }
            if ((handler = ((SAXResult)result).getHandler()) == null) {
                throw new TranslationException(11206, new Object[]{"Inbound XSD", "null", "SAXResult ContentHandler"});
            }
            XlatorHelper.saxParseInputSource(inputSource, (XMLReader)saxParser, handler);
        } else if (result instanceof DOMResult) {
            DOMParser domParser = new DOMParser();
            try {
                if (fValidate) {
                    DOMValidator validator = new DOMValidator(domParser);
                    validator.validateSchema(this.m_xsdDef, inputSource);
                } else {
                    domParser.setValidationMode(0);
                    domParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
                    domParser.parse(inputSource);
                }
            }
            catch (IOException e) {
                throw new TranslationException(11207, new Object[]{"Inbound XSD ", " DOM Parse InputStream "}, e);
            }
            catch (XMLParseException e) {
                throw new TranslationException(11211, new Object[]{"inbound XSD", "InputStream"}, e);
            }
            catch (SAXException e) {
                throw new TranslationException(11211, new Object[]{"inbound XSD", "InputStream"}, e);
            }
            XMLDocument doc = domParser.getDocument();
            ((DOMResult)result).setNode(doc.getDocumentElement());
        } else if (result instanceof StreamResult) {
            OutputStream out = ((StreamResult)result).getOutputStream();
            if (out == null) {
                throw new TranslationException(11206, new Object[]{"Inbound XSD", "null", "OutputStream in StreamResult"});
            }
            XlatorHelper.copyStream(inputStream, out);
        }
    }

    @Override
    public void translateToNative(Source source, OutputStream outputStream, TranslationContext ctx) throws TranslationException {
        if (source == null) {
            throw new TranslationException(11154);
        }
        if (source instanceof DOMSource && ((DOMSource)source).getNode() == null) {
            throw new TranslationException(11155);
        }
        if (outputStream == null || source == null) {
            throw new TranslationException(11206, new Object[]{"Outbound XSD", "null", "OutputStream/Source"});
        }
        try {
            XlatorHelper.writeXMLProlog(this.m_xsdDef, this.m_elem, outputStream, ctx);
        }
        catch (IOException ioe) {
            throw new TranslationException(11207, new Object[]{"Outbound XSD", "  write the XML Prolog "}, ioe);
        }
        String encoding = XlatorHelper.getEncoding(this.m_xsdDef, this.m_elem, ctx);
        XlatorHelper.logDebug("Encoding for outbound xml document = " + encoding);
        if (source instanceof SAXSource) {
            InputStream inputStream = ((SAXSource)source).getInputSource().getByteStream();
            XlatorHelper.copyStream(inputStream, outputStream);
        } else if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            if (node == null) {
                throw new TranslationException(11206, new Object[]{"Outbound XSD", "null", "DOMSource.getNode()"});
            }
            boolean fValidate = XlatorHelper.getValidation(this.m_xsdDef, this.m_elem);
            if (fValidate) {
                XlatorHelper.validateDOMNode((XMLNode)node, this.m_xsdDef);
            }
            this.doOutboundTranslation(source, outputStream, encoding);
        } else if (source instanceof StreamSource) {
            InputStream inputStream = ((StreamSource)source).getInputStream();
            XlatorHelper.copyStream(inputStream, outputStream);
        }
    }

    private void doOutboundTranslation(Source xmlSource, OutputStream outputStream, String encoding) throws TranslationException {
        try {
            ExtendedXMLSAXSerializer xmlSerializer = new ExtendedXMLSAXSerializer(outputStream);
            xmlSerializer.setProperty("oracle.xml.parser.v2.XMLSAXSerializer.encoding", encoding);
            this.fXMLTokenizer = new XMLTokenizer(xmlSource);
            this.fXMLTokenizer.setHandler((ContentHandler)((Object)xmlSerializer));
            this.fXMLTokenizer.tokenize(encoding);
        }
        catch (TranslationException te) {
            throw te;
        }
        catch (SAXException e) {
            throw new TranslationException(11210, new Object[]{"Outbound XSD", "  XML serialization failure. "}, e);
        }
        catch (IOException e) {
            throw new TranslationException(11207, new Object[]{"Outbound XSD", "  XML serializtion failure. "}, e);
        }
        catch (ParserConfigurationException e) {
            throw new TranslationException(11210, new Object[]{"outbound XSD", "outputstream"}, e);
        }
    }

    @Override
    public XMLSchema getSchema() {
        return this.m_xsdDef;
    }

    @Override
    public XSDElement getRootElement() {
        return this.m_elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translateFromNative(Reader reader, Result xmlResult, TranslationContext ctx) throws TranslationException {
        if (reader == null || xmlResult == null) {
            throw new TranslationException(11206, new Object[]{"Inbound XSD", "null", "Reader/Result"});
        }
        InputSource inputSource = new InputSource(reader);
        boolean fValidate = XlatorHelper.getValidation(this.m_xsdDef, this.m_elem);
        if (ctx != null && ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding") != null) {
            this.encoding = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding");
            XlatorHelper.logDebug("input encoding " + (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding"));
        } else {
            this.encoding = XlatorHelper.getSchemaAttrValue(this.m_xsdDef, this.m_elem, "encoding");
        }
        if (this.encoding == null) {
            XlatorHelper.logDebug("Defaulting to input encoding UTF-8");
            this.encoding = "UTF-8";
        }
        inputSource.setEncoding(this.encoding);
        if (ctx != null && ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/debatching") && ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/debatching")) {
            try {
                try {
                    this.fPublishSize = 1;
                    String publishSize = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/publishsize");
                    if (publishSize != null && publishSize.trim().length() > 0) {
                        this.fPublishSize = Integer.parseInt(publishSize);
                    }
                    boolean errorRecovery = false;
                    if (ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery")) {
                        errorRecovery = ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery");
                    }
                    if (errorRecovery) {
                        int iSkipRecords = 0;
                        ctx.setFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery", false);
                        this.fDeBatcher = new DeBatchXML(reader, this.fPublishSize);
                        String skipRecords = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/records-processed");
                        if (skipRecords != null && skipRecords.trim().length() > 0) {
                            iSkipRecords = Integer.parseInt(skipRecords);
                        }
                        this.fDeBatcher.skipRecords(iSkipRecords);
                    } else if (this.fDeBatcher == null) {
                        this.fDeBatcher = new DeBatchXML(reader, this.fPublishSize);
                    }
                    Node node = this.fDeBatcher.getNextFragment(ctx);
                    if (node != null && xmlResult instanceof DOMResult) {
                        ((DOMResult)xmlResult).setNode(node);
                    }
                    return;
                }
                catch (Exception ex) {
                    ErrorList errorList = new ErrorList();
                    errorList.addError(1, 1, -1, -1, -1L, -1L, ex);
                    errorList.setAllCorrupted(true);
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/error-list", errorList);
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if (xmlResult instanceof SAXResult) {
            ContentHandler handler;
            SAXParser saxParser = XlatorHelper.getSAXParser(0, Boolean.TRUE, true);
            if (fValidate) {
                saxParser.setValidationMode(3);
                saxParser.setXMLSchema((Object)this.m_xsdDef);
                ErrorValidator errHandler = new ErrorValidator();
                saxParser.setErrorHandler((ErrorHandler)errHandler);
            }
            if ((handler = ((SAXResult)xmlResult).getHandler()) == null) {
                throw new TranslationException(11206, new Object[]{"Inbound XSD", "null", "SAXResult ContentHandler"});
            }
            XlatorHelper.saxParseInputSource(inputSource, (XMLReader)saxParser, handler);
        } else if (xmlResult instanceof DOMResult) {
            DOMParser domParser = new DOMParser();
            try {
                if (fValidate) {
                    DOMValidator validator = new DOMValidator(domParser);
                    validator.validateSchema(this.m_xsdDef, inputSource);
                } else {
                    domParser.setValidationMode(0);
                    domParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
                    domParser.parse(inputSource);
                }
            }
            catch (IOException e) {
                throw new TranslationException(11207, new Object[]{"Inbound XSD ", " DOM Parse InputStream "}, e);
            }
            catch (XMLParseException e) {
                throw new TranslationException(11211, new Object[]{"inbound XSD", "InputStream"}, e);
            }
            catch (SAXException e) {
                throw new TranslationException(11211, new Object[]{"inbound XSD", "InputStream"}, e);
            }
            XMLDocument doc = domParser.getDocument();
            ((DOMResult)xmlResult).setNode(doc.getDocumentElement());
        } else if (xmlResult instanceof StreamResult) {
            Writer out = ((StreamResult)xmlResult).getWriter();
            if (out == null) {
                throw new TranslationException(11206, new Object[]{"Inbound XSD", "null", "Writer in StreamResult"});
            }
            XlatorHelper.copyReader(reader, out);
        }
    }

    @Override
    public void translateToNative(Source xmlSource, Writer writer, TranslationContext ctx) throws TranslationException {
        throw new TranslationException(11119, new Object[]{"Writer", "in XSD Translator yet."});
    }

    @Override
    public void setLogWriter(PrintWriter pw) {
        this.fLogWriter = pw;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.fLogWriter;
    }

    private void setEncoding(InputSource inputSource, TranslationContext ctx) throws TranslationException {
        try {
            if (this.fPrologEncoding != null) {
                XlatorHelper.logDebug("Encoding already resolved to :" + this.fPrologEncoding);
                inputSource.setEncoding(this.fPrologEncoding);
                return;
            }
            if (ctx != null && ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding") != null) {
                this.fPrologEncoding = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding");
                XlatorHelper.logDebug("input encoding " + (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding"));
            } else {
                this.fPrologEncoding = XlatorHelper.getSchemaAttrValue(this.m_xsdDef, this.m_elem, "encoding");
            }
            if (this.fPrologEncoding == null) {
                this.fPrologEncoding = XlatorHelper.prologHasEncoding(this.fBufStream) ? XlatorHelper.getPrologEncoding() : "UTF-8";
            }
            inputSource.setEncoding(this.fPrologEncoding);
        }
        catch (IOException e1) {
            throw new TranslationException(11207, new Object[]{"Inbound xml", "  XML prolog peek failure... "}, e1);
        }
    }
}

