/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.plugins;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.xlators.nxsd.DataFragmentHandler;
import oracle.tip.pc.services.translation.xlators.nxsd.DataFragmentHandlerContext;
import oracle.tip.pc.services.translation.xlators.nxsd.InputDataReader;
import oracle.tip.pc.services.translation.xlators.nxsd.OutputDataWriter;
import org.xml.sax.Attributes;

public class SignZoned
implements DataFragmentHandler {
    private static final int fDebug = 0;
    private static final String STYLE = "signZoned";
    private static final String ASSUMEDECIMAL = "assumeDecimal";
    private static final String PICSIZE = "picSize";
    private static final String SIGN = "sign";
    private static final String USE_SIGN = "useSign";
    private static final String SIGNPOSITION = "signPosn";
    private static final String TICKED = "ticked";
    private static final String UNTICKED = "unticked";
    private static final String HEAD = "head";
    private static final String TAIL = "tail";
    private static final String HEADUPPERNIBBLE = "headUpperNibble";
    private static final String TAILUPPERNIBBLE = "tailUpperNibble";
    private static final String CP037 = "cp037";
    private static final String ASCII = "ascii";
    private static final short SIGN_AT_HEAD = 0;
    private static final short SIGN_AT_TAIL = 1;
    private static final short SIGN_AT_HEADUPPERNIBBLE = 2;
    private static final short SIGN_AT_TAILUPPERNIBBLE = 3;
    private String fByteOrder;
    private String fEncoding;
    private String fUseSign;
    private boolean fBigEndian;
    private int fAssumeDecimal;
    private int fPicSize;
    private boolean fSigned;
    private short fSignPosition;

    @Override
    public String getHandlerName() {
        return STYLE;
    }

    @Override
    public void setLogWriter(PrintWriter pw) {
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLoggingLevel(int level) {
    }

    @Override
    public int getLoggingLevel() {
        return -1;
    }

    private void init(Attributes attrs, DataFragmentHandlerContext ctx) throws TranslationException {
        SignZoned.log("\nInit...");
        this.fSigned = false;
        this.fBigEndian = false;
        this.fPicSize = -1;
        this.fAssumeDecimal = -1;
        this.fSignPosition = (short)-1;
        this.fEncoding = ASCII;
        this.fUseSign = null;
        if (ctx != null && ctx.getByteOrder() != null) {
            this.fByteOrder = ctx.getByteOrder();
            if ("bigEndian".equals(this.fByteOrder)) {
                this.fBigEndian = true;
            } else if ("littleEndian".equals(this.fByteOrder)) {
                this.fBigEndian = false;
            } else {
                throw new TranslationException(11262, new Object[]{STYLE});
            }
        }
        if (ctx != null && ctx.getEncoding() != null) {
            this.fEncoding = ctx.getEncoding();
        }
        if (attrs == null) {
            throw new TranslationException(11259, new Object[]{STYLE});
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getLocalName(i);
            String uri = attrs.getURI(i);
            if (name.equals(ASSUMEDECIMAL) && uri.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions")) {
                try {
                    this.fAssumeDecimal = Integer.parseInt(attrs.getValue(i));
                }
                catch (Exception ex) {}
                continue;
            }
            if (name.equals(PICSIZE) && uri.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions")) {
                try {
                    this.fPicSize = Integer.parseInt(attrs.getValue(i));
                }
                catch (Exception ex) {}
                continue;
            }
            if (name.equals(SIGN) && uri.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions")) {
                if (TICKED.equals(attrs.getValue(i))) {
                    this.fSigned = true;
                    continue;
                }
                if (UNTICKED.equals(attrs.getValue(i))) {
                    this.fSigned = false;
                    continue;
                }
                throw new TranslationException(11263, new Object[]{STYLE});
            }
            if (name.equals(SIGNPOSITION) && uri.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions")) {
                if (HEAD.equals(attrs.getValue(i))) {
                    this.fSignPosition = 0;
                    continue;
                }
                if (TAIL.equals(attrs.getValue(i))) {
                    this.fSignPosition = 1;
                    continue;
                }
                if (HEADUPPERNIBBLE.equals(attrs.getValue(i))) {
                    this.fSignPosition = (short)2;
                    continue;
                }
                if (TAILUPPERNIBBLE.equals(attrs.getValue(i))) {
                    this.fSignPosition = (short)3;
                    continue;
                }
                throw new TranslationException(11252, new Object[]{STYLE});
            }
            if (!name.equals(USE_SIGN) || !uri.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions")) continue;
            this.fUseSign = attrs.getValue(i);
        }
        if (this.fPicSize == -1) {
            throw new TranslationException(11247, new Object[]{STYLE});
        }
        if (this.fSignPosition == -1) {
            // empty if block
        }
        if (this.fEncoding.equalsIgnoreCase("ASCII") || this.fEncoding.equalsIgnoreCase("US-ASCII")) {
            this.fEncoding = ASCII;
        }
        if (this.fEncoding.equalsIgnoreCase("CP037")) {
            this.fEncoding = CP037;
        }
        if (this.fUseSign == null || this.fUseSign.length() != 2) {
            // empty if block
        }
        SignZoned.log("big endian:" + this.fBigEndian);
        SignZoned.log("assumeDecimal :" + this.fAssumeDecimal);
        SignZoned.log("picSize :" + this.fPicSize);
        SignZoned.log("sign :" + this.fSigned);
        SignZoned.log("signPosition :" + this.fSignPosition);
    }

    @Override
    public String readFromNative(InputDataReader reader, Attributes attrs, DataFragmentHandlerContext ctx) throws TranslationException {
        this.init(attrs, ctx);
        String result = "";
        int bytesRead = -1;
        byte[] buf = null;
        int charsRead = -1;
        char[] charBuf = null;
        int signByte = -1;
        int upperNibble = -1;
        int lowerNibble = -1;
        try {
            char sign;
            StringBuffer temp;
            if (!this.fSigned) {
                charBuf = new char[this.fPicSize];
                charsRead = reader.readChars(charBuf);
                result = new String(charBuf);
            } else if (this.fSigned) {
                int i;
                String sign2;
                if (this.fSignPosition == 0) {
                    if (this.fUseSign == null) {
                        charBuf = new char[this.fPicSize + 1];
                        charsRead = reader.readChars(charBuf);
                        result = new String(charBuf);
                    } else {
                        charBuf = new char[this.fPicSize + 2];
                        charsRead = reader.readChars(charBuf);
                        result = new String(charBuf, 2, this.fPicSize);
                        sign2 = new String(charBuf, 0, 2);
                        result = sign2.equals("CR") || sign2.equals("DB") ? "-" + result : "+" + result;
                    }
                } else if (this.fSignPosition == 1) {
                    if (this.fUseSign == null) {
                        charBuf = new char[this.fPicSize + 1];
                        charsRead = reader.readChars(charBuf);
                        result = new String(charBuf, 0, charBuf.length - 1);
                        result = "" + charBuf[charBuf.length - 1] + result;
                    } else {
                        charBuf = new char[this.fPicSize + 2];
                        charsRead = reader.readChars(charBuf);
                        result = new String(charBuf, 0, this.fPicSize);
                        sign2 = new String(charBuf, this.fPicSize, 2);
                        result = sign2.equals("CR") || sign2.equals("DB") ? "-" + result : "+" + result;
                    }
                } else if (this.fSignPosition == 2) {
                    signByte = (byte)reader.readByte();
                    upperNibble = (byte)(signByte & 0xF0);
                    lowerNibble = (byte)(signByte & 0xF);
                    temp = new StringBuffer();
                    if (upperNibble == -16 && this.fEncoding.equals(CP037) || upperNibble == -64 && this.fEncoding.equals(CP037) || upperNibble == 48 && this.fEncoding.equals(ASCII)) {
                        temp.append('+');
                    } else if (upperNibble == -48 && this.fEncoding.equals(CP037) || upperNibble == -80 && this.fEncoding.equals(CP037) || upperNibble == 112 && this.fEncoding.equals(ASCII)) {
                        temp.append('-');
                    } else {
                        throw new TranslationException(11253, new Object[]{STYLE});
                    }
                    temp.append(lowerNibble);
                    buf = new byte[this.fPicSize - 1];
                    bytesRead = reader.readBytes(buf);
                    for (i = 0; i < bytesRead; ++i) {
                        temp.append(buf[i] & 0xF);
                    }
                    result = temp.toString();
                } else if (this.fSignPosition == 3) {
                    buf = new byte[this.fPicSize - 1];
                    bytesRead = reader.readBytes(buf);
                    temp = new StringBuffer();
                    for (i = 0; i < bytesRead; ++i) {
                        temp.append(buf[i] & 0xF);
                    }
                    signByte = (byte)reader.readByte();
                    upperNibble = (byte)(signByte & 0xF0);
                    lowerNibble = (byte)(signByte & 0xF);
                    if (upperNibble == -16 && this.fEncoding.equals(CP037) || upperNibble == -64 && this.fEncoding.equals(CP037) || upperNibble == 48 && this.fEncoding.equals(ASCII)) {
                        temp.insert(0, '+');
                    } else if (upperNibble == -48 && this.fEncoding.equals(CP037) || upperNibble == -80 && this.fEncoding.equals(CP037) || upperNibble == 112 && this.fEncoding.equals(ASCII)) {
                        temp.insert(0, '-');
                    } else {
                        throw new TranslationException(11254, new Object[]{STYLE});
                    }
                    temp.append(lowerNibble);
                    result = temp.toString();
                }
            }
            if (this.fAssumeDecimal != -1) {
                temp = new StringBuffer(result);
                if (this.fSigned) {
                    temp.insert(this.fAssumeDecimal + 1, '.');
                    sign = temp.charAt(0);
                    temp.deleteCharAt(0);
                    double val = Double.parseDouble(temp.toString());
                    temp = new StringBuffer();
                    temp.append(sign);
                    temp.append(val);
                    result = temp.toString();
                } else {
                    temp.insert(this.fAssumeDecimal, '.');
                    double val = Double.parseDouble(temp.toString());
                    temp = new StringBuffer();
                    temp.append(val);
                    result = temp.toString();
                }
            } else {
                temp = new StringBuffer(result);
                if (this.fSigned) {
                    sign = temp.charAt(0);
                    temp.deleteCharAt(0);
                    long val = Long.parseLong(temp.toString());
                    temp = new StringBuffer();
                    temp.append(sign);
                    temp.append(val);
                    result = temp.toString();
                } else {
                    long val = Long.parseLong(temp.toString());
                    temp = new StringBuffer();
                    temp.append(val);
                    result = temp.toString();
                }
            }
            result = result.trim();
        }
        catch (Exception e) {
            throw new TranslationException(11249, new Object[]{STYLE});
        }
        return result;
    }

    @Override
    public void writeToNative(String value, OutputDataWriter writer, Attributes attrs, DataFragmentHandlerContext ctx) throws TranslationException {
        this.init(attrs, ctx);
        value = this.getPaddedValue(value);
        try {
            if (!this.fSigned) {
                writer.writeString(value);
            } else if (this.fSigned) {
                if (this.fSignPosition == 0) {
                    if (this.fUseSign == null) {
                        writer.writeString(value);
                    } else {
                        if (value.charAt(0) == '-') {
                            writer.writeString(this.fUseSign);
                        } else {
                            writer.writeString("  ");
                        }
                        if (value.charAt(0) == '-' || value.charAt(0) == '+') {
                            writer.writeString(value.substring(1));
                        } else {
                            writer.writeString(value);
                        }
                    }
                } else if (this.fSignPosition == 1) {
                    if (this.fUseSign == null) {
                        String sign = value.substring(0, 1);
                        value = value.substring(1);
                        writer.writeString(value);
                        writer.writeString(sign);
                    } else {
                        if (value.charAt(0) == '-' || value.charAt(0) == '+') {
                            writer.writeString(value.substring(1));
                        } else {
                            writer.writeString(value);
                        }
                        if (value.charAt(0) == '-') {
                            writer.writeString(this.fUseSign);
                        } else {
                            writer.writeString("  ");
                        }
                    }
                } else if (this.fSignPosition == 2 || this.fSignPosition == 3) {
                    char sign = value.charAt(0);
                    value = value.substring(1);
                    byte dataByte = -1;
                    int dataMask = -1;
                    int signMask = -1;
                    if (this.fEncoding.equals(CP037)) {
                        dataMask = -16;
                    } else if (this.fEncoding.equals(ASCII)) {
                        dataMask = 48;
                    } else {
                        throw new TranslationException(11256, new Object[]{this.fEncoding, STYLE});
                    }
                    if (sign != '+' && sign != '-') {
                        throw new TranslationException(11257, new Object[]{"" + sign, STYLE});
                    }
                    if (sign == '+' && this.fEncoding.equals(CP037)) {
                        signMask = -64;
                    } else if (sign == '+' && this.fEncoding.equals(ASCII)) {
                        signMask = 48;
                    } else if (sign == '-' && this.fEncoding.equals(CP037)) {
                        signMask = -48;
                    } else if (sign == '-' && this.fEncoding.equals(ASCII)) {
                        signMask = 112;
                    }
                    for (int i = 0; i < this.fPicSize; ++i) {
                        dataByte = Byte.parseByte("" + value.charAt(i));
                        dataByte = i == 0 && this.fSignPosition == 2 ? (byte)((byte)(dataByte | signMask)) : (i + 1 == this.fPicSize && this.fSignPosition == 3 ? (byte)(dataByte | signMask) : (byte)((byte)(dataByte | dataMask)));
                        writer.writeByte(dataByte);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new TranslationException(11251, new Object[]{STYLE});
        }
    }

    private String getPaddedValue(String value) {
        int sign = -1;
        StringBuffer paddedValue = new StringBuffer();
        if (value.startsWith("+") || value.startsWith("-")) {
            paddedValue.append(value.charAt(0));
            value = value.substring(1);
        } else if (this.fSigned) {
            paddedValue.append(' ');
        }
        SignZoned.log("padding=" + value);
        if (value.indexOf(46) > -1) {
            int i;
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            StringBuffer pattern = new StringBuffer();
            for (i = 0; i < this.fAssumeDecimal; ++i) {
                pattern.append('0');
            }
            pattern.append('.');
            for (i = 0; i < this.fPicSize - this.fAssumeDecimal; ++i) {
                pattern.append('0');
            }
            String result = null;
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            if (nf instanceof DecimalFormat) {
                DecimalFormat df = (DecimalFormat)nf;
                df.applyPattern(pattern.toString());
                result = df.format(Double.parseDouble(value));
            }
            paddedValue.append(result);
            paddedValue.deleteCharAt(paddedValue.indexOf("."));
        } else {
            try {
                Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            StringBuffer pattern = new StringBuffer();
            for (int i = 0; i < this.fPicSize; ++i) {
                pattern.append('0');
            }
            String result = null;
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            if (nf instanceof DecimalFormat) {
                DecimalFormat df = (DecimalFormat)nf;
                df.applyPattern(pattern.toString());
                result = df.format(Long.parseLong(value));
            }
            paddedValue.append(result);
        }
        SignZoned.log("paddedVal=" + paddedValue.toString());
        return paddedValue.toString();
    }

    private static void log(String msg) {
    }
}

