/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.plugins;

import java.io.IOException;
import java.io.PrintWriter;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.xlators.nxsd.DataFragmentHandler;
import oracle.tip.pc.services.translation.xlators.nxsd.DataFragmentHandlerContext;
import oracle.tip.pc.services.translation.xlators.nxsd.InputDataReader;
import oracle.tip.pc.services.translation.xlators.nxsd.OutputDataWriter;
import org.xml.sax.Attributes;

public class Comp3
implements DataFragmentHandler {
    private final String STYLE = "comp3";
    private final String BIGENDIAN = "bigEndian";
    private final String LITTLEENDIAN = "littleEndian";
    private final String ASSUMEDECIMAL = "assumeDecimal";
    private final String LENGTH = "length";
    private final String SIGN = "sign";
    private final String SIGNPOSITION = "signPosn";
    private final String TICKED = "ticked";
    private final String UNTICKED = "unticked";
    private final String TAILLOWERNIBBLE = "tailLowerNibble";
    private final String HEADZONE = "headZone";
    private final String TAIL = "tail";
    private final String HEAD = "head";
    private final String PICSIZE = "picSize";
    private String m_decimalPosn = null;
    private String m_length = null;
    private String m_signPosn = null;
    private String m_sign = null;
    private String m_tempString = null;
    private String m_byteOrder = null;
    private String m_picSize = null;
    private byte m_temp;
    private byte m_tempUpperNibble;
    private byte m_tempLowerNibble;

    @Override
    public String getHandlerName() {
        return "comp3";
    }

    @Override
    public void setLogWriter(PrintWriter pw) {
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLoggingLevel(int level) {
    }

    @Override
    public int getLoggingLevel() {
        return -1;
    }

    private void init(Attributes attrs, DataFragmentHandlerContext ctx) throws TranslationException {
        if (attrs == null) {
            throw new TranslationException(11245, new Object[]{"comp3"});
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getLocalName(i);
            String uri = attrs.getURI(i);
            if (name.equals("assumeDecimal") && uri.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions")) {
                this.m_decimalPosn = attrs.getValue(i);
                continue;
            }
            if (name.equals("signPosn") && uri.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions")) {
                this.m_signPosn = attrs.getValue(i);
                continue;
            }
            if (name.equals("sign") && uri.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions")) {
                this.m_sign = attrs.getValue(i);
                continue;
            }
            if (!name.equals("picSize") || !uri.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions")) continue;
            this.m_picSize = attrs.getValue(i);
            this.m_length = "" + (int)Math.ceil(((double)Integer.parseInt(this.m_picSize) + 1.0) / 2.0);
        }
        if (this.m_sign == null) {
            throw new TranslationException(11246, new Object[]{"comp3"});
        }
    }

    @Override
    public String readFromNative(InputDataReader reader, Attributes attrs, DataFragmentHandlerContext ctx) throws TranslationException {
        String result = "";
        this.init(attrs, ctx);
        this.m_byteOrder = ctx.getByteOrder();
        try {
            int length = Integer.parseInt(this.m_length);
            byte[] inputBytes = new byte[length];
            if (this.m_byteOrder.equals("bigEndian")) {
                reader.readBytes(inputBytes);
            } else {
                reader.readBytes(inputBytes);
                for (int i = 0; i < length / 2; ++i) {
                    byte tmp = inputBytes[i];
                    inputBytes[i] = inputBytes[length - 1 - i];
                    inputBytes[length - 1 - i] = tmp;
                }
            }
            if (this.m_decimalPosn == null) {
                if (this.m_sign.equals("unticked")) {
                    for (int temp = 0; temp < length; ++temp) {
                        byte lowerNibble;
                        byte upperNibble;
                        if (temp == 0) {
                            upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                            lowerNibble = (byte)(inputBytes[temp] & 0xF);
                            if (Integer.parseInt(this.m_picSize) == Integer.parseInt(this.m_length) * 2 - 2) {
                                result = "" + lowerNibble;
                                continue;
                            }
                            result = "" + upperNibble;
                            result = result + lowerNibble;
                            continue;
                        }
                        if (temp == length - 1) {
                            upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                            result = result + upperNibble;
                            continue;
                        }
                        upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                        lowerNibble = (byte)(inputBytes[temp] & 0xF);
                        result = result + upperNibble;
                        result = result + lowerNibble;
                    }
                } else if (this.m_sign.equals("ticked")) {
                    String tempResult = "";
                    for (int temp = 0; temp < length; ++temp) {
                        byte lowerNibble;
                        byte upperNibble;
                        if (temp == 0) {
                            upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                            lowerNibble = (byte)(inputBytes[temp] & 0xF);
                            if (Integer.parseInt(this.m_picSize) == Integer.parseInt(this.m_length) * 2 - 2) {
                                tempResult = "" + lowerNibble;
                                continue;
                            }
                            tempResult = "" + upperNibble;
                            tempResult = tempResult + lowerNibble;
                            continue;
                        }
                        if (temp == length - 1) {
                            upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                            lowerNibble = (byte)(inputBytes[temp] & 0xF);
                            if (lowerNibble == 12 || lowerNibble == 15) {
                                tempResult = tempResult + upperNibble;
                                result = "+";
                                result = result + tempResult;
                                continue;
                            }
                            if (lowerNibble != 13 && lowerNibble != 11) continue;
                            tempResult = tempResult + upperNibble;
                            result = "-";
                            result = result + tempResult;
                            continue;
                        }
                        upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                        lowerNibble = (byte)(inputBytes[temp] & 0xF);
                        tempResult = tempResult + upperNibble;
                        tempResult = tempResult + lowerNibble;
                    }
                }
            } else {
                byte lowerNibble;
                byte upperNibble;
                int temp;
                int decimalPosn = Integer.parseInt(this.m_decimalPosn);
                boolean flag = true;
                if (this.m_sign.equals("unticked")) {
                    for (temp = 0; temp < length; ++temp) {
                        if (temp == 0) {
                            upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                            lowerNibble = (byte)(inputBytes[temp] & 0xF);
                            if (decimalPosn == 0) {
                                if (Integer.parseInt(this.m_picSize) == Integer.parseInt(this.m_length) * 2 - 2) {
                                    result = "." + lowerNibble;
                                } else {
                                    result = "." + upperNibble;
                                    result = result + lowerNibble;
                                }
                                --decimalPosn;
                                continue;
                            }
                            result = result + upperNibble;
                            if (--decimalPosn == 0) {
                                result = result + ".";
                                result = result + lowerNibble;
                                --decimalPosn;
                                continue;
                            }
                            result = result + lowerNibble;
                            --decimalPosn;
                            continue;
                        }
                        if (temp == length - 1) {
                            upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                            if (decimalPosn == 0) {
                                result = result + ".";
                                result = result + upperNibble;
                                flag = false;
                            } else {
                                result = result + upperNibble;
                            }
                            --decimalPosn;
                            continue;
                        }
                        upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                        lowerNibble = (byte)(inputBytes[temp] & 0xF);
                        if (decimalPosn == 0) {
                            result = result + ".";
                            result = result + upperNibble;
                            flag = false;
                        } else {
                            result = result + upperNibble;
                        }
                        if (--decimalPosn == 0) {
                            result = result + ".";
                            result = result + lowerNibble;
                            flag = false;
                        } else {
                            result = result + lowerNibble;
                        }
                        --decimalPosn;
                    }
                }
                if (this.m_sign.equals("ticked")) {
                    String tempResult = "";
                    for (temp = 0; temp < length; ++temp) {
                        if (decimalPosn == 0) {
                            flag = false;
                        }
                        if (temp == 0) {
                            upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                            lowerNibble = (byte)(inputBytes[temp] & 0xF);
                            if (decimalPosn == 0) {
                                if (Integer.parseInt(this.m_picSize) == Integer.parseInt(this.m_length) * 2 - 2) {
                                    tempResult = "." + lowerNibble;
                                } else {
                                    tempResult = "." + upperNibble;
                                    tempResult = tempResult + lowerNibble;
                                }
                                --decimalPosn;
                                continue;
                            }
                            if (upperNibble == 0) {
                                result = result + upperNibble;
                                --decimalPosn;
                            } else {
                                tempResult = tempResult + upperNibble;
                                --decimalPosn;
                            }
                            if (decimalPosn == 0) {
                                tempResult = tempResult + ".";
                                tempResult = tempResult + lowerNibble;
                                --decimalPosn;
                                continue;
                            }
                            tempResult = tempResult + lowerNibble;
                            --decimalPosn;
                            continue;
                        }
                        if (temp == length - 1) {
                            upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                            lowerNibble = (byte)(inputBytes[temp] & 0xF);
                            if (--decimalPosn == 0) {
                                tempResult = tempResult + ".";
                                tempResult = tempResult + upperNibble;
                                flag = false;
                            } else {
                                tempResult = tempResult + upperNibble;
                            }
                            if (lowerNibble == 12 || lowerNibble == 15) {
                                result = "+";
                                result = result + tempResult;
                                continue;
                            }
                            if (lowerNibble != 13 && lowerNibble != 11) continue;
                            result = "-";
                            result = result + tempResult;
                            continue;
                        }
                        upperNibble = (byte)((inputBytes[temp] & 0xF0) >> 4);
                        lowerNibble = (byte)(inputBytes[temp] & 0xF);
                        if (--decimalPosn == 0) {
                            tempResult = tempResult + upperNibble;
                            tempResult = tempResult + ".";
                            flag = false;
                        } else {
                            tempResult = tempResult + upperNibble;
                        }
                        if (--decimalPosn == 0) {
                            tempResult = tempResult + lowerNibble;
                            result = result + ".";
                            flag = false;
                            continue;
                        }
                        tempResult = tempResult + lowerNibble;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TranslationException(11249, new Object[]{"comp3"});
        }
        return result;
    }

    @Override
    public void writeToNative(String value, OutputDataWriter writer, Attributes attrs, DataFragmentHandlerContext ctx) throws TranslationException {
        block32: {
            this.init(attrs, ctx);
            this.m_byteOrder = ctx.getByteOrder();
            int byteLength = Integer.parseInt(this.m_length);
            int valueLength = value.length();
            byte[] result = new byte[byteLength];
            try {
                int temp;
                int length = Integer.parseInt(this.m_length);
                byte[] inputBytes = new byte[length];
                int charPos = 0;
                if (this.m_decimalPosn == null) {
                    if (this.m_sign.equals("unticked")) {
                        for (temp = 0; temp < byteLength; ++temp) {
                            if (temp == 0) {
                                if (valueLength % 2 == 0) {
                                    result[temp] = 0;
                                    result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + value.charAt(charPos++) + ""));
                                    continue;
                                }
                                result[temp] = (byte)((byte)Integer.parseInt("" + value.charAt(charPos++) + "") << 4);
                                result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + value.charAt(charPos++) + ""));
                                continue;
                            }
                            if (temp == byteLength - 1) {
                                result[temp] = (byte)((byte)Integer.parseInt("" + value.charAt(charPos++) + "") << 4);
                                result[temp] = (byte)(result[temp] | 0xF);
                                continue;
                            }
                            result[temp] = (byte)((byte)Integer.parseInt("" + value.charAt(charPos++) + "") << 4);
                            result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + value.charAt(charPos++) + ""));
                        }
                    } else if (this.m_sign.equals("ticked")) {
                        char sign = value.charAt(charPos);
                        ++charPos;
                        for (temp = 0; temp < byteLength; ++temp) {
                            if (temp == 0) {
                                if ((valueLength - 1) % 2 == 0) {
                                    result[temp] = 0;
                                    result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + value.charAt(charPos++) + ""));
                                    continue;
                                }
                                result[temp] = (byte)((byte)Integer.parseInt("" + value.charAt(charPos++) + "") << 4);
                                result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + value.charAt(charPos++) + ""));
                                continue;
                            }
                            if (temp == byteLength - 1) {
                                result[temp] = (byte)((byte)Integer.parseInt("" + value.charAt(charPos++) + "") << 4);
                                if (sign == '+') {
                                    result[temp] = (byte)(result[temp] | 0xF);
                                    continue;
                                }
                                if (sign != '-') continue;
                                result[temp] = (byte)(result[temp] | 0xD);
                                continue;
                            }
                            result[temp] = (byte)((byte)Integer.parseInt("" + value.charAt(charPos++) + "") << 4);
                            result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + value.charAt(charPos++) + ""));
                        }
                    }
                } else {
                    String tempValue = "";
                    for (int i = 0; i < value.length(); ++i) {
                        if (value.charAt(i) == '.') continue;
                        tempValue = tempValue + "" + value.charAt(i);
                    }
                    if (this.m_sign.equals("unticked")) {
                        for (temp = 0; temp < byteLength; ++temp) {
                            if (temp == 0) {
                                if ((valueLength - 1) % 2 == 0) {
                                    result[temp] = 0;
                                    result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + tempValue.charAt(charPos++) + ""));
                                    continue;
                                }
                                result[temp] = (byte)((byte)Integer.parseInt("" + tempValue.charAt(charPos++) + "") << 4);
                                result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + tempValue.charAt(charPos++) + ""));
                                continue;
                            }
                            if (temp == byteLength - 1) {
                                result[temp] = (byte)((byte)Integer.parseInt("" + tempValue.charAt(charPos++) + "") << 4);
                                result[temp] = (byte)(result[temp] | 0xF);
                                continue;
                            }
                            result[temp] = (byte)((byte)Integer.parseInt("" + tempValue.charAt(charPos++) + "") << 4);
                            result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + tempValue.charAt(charPos++) + ""));
                        }
                    } else if (this.m_sign.equals("ticked")) {
                        charPos = 0;
                        char sign = tempValue.charAt(charPos++);
                        for (temp = 0; temp < byteLength; ++temp) {
                            if (temp == 0) {
                                if (valueLength % 2 == 0) {
                                    result[temp] = 0;
                                    result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + tempValue.charAt(charPos++) + ""));
                                    continue;
                                }
                                result[temp] = (byte)((byte)Integer.parseInt("" + tempValue.charAt(charPos++) + "") << 4);
                                result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + tempValue.charAt(charPos++) + ""));
                                continue;
                            }
                            if (temp == byteLength - 1) {
                                result[temp] = (byte)((byte)Integer.parseInt("" + tempValue.charAt(charPos++) + "") << 4);
                                if (sign == '+') {
                                    result[temp] = (byte)(result[temp] | 0xF);
                                    continue;
                                }
                                if (sign != '-') continue;
                                result[temp] = (byte)(result[temp] | 0xD);
                                continue;
                            }
                            result[temp] = (byte)((byte)Integer.parseInt("" + tempValue.charAt(charPos++) + "") << 4);
                            result[temp] = (byte)(result[temp] | (byte)Integer.parseInt("" + tempValue.charAt(charPos++) + ""));
                        }
                    }
                }
                if (this.m_byteOrder.equals("bigEndian")) {
                    writer.writeBytes(result);
                    break block32;
                }
                if (this.m_byteOrder.equals("littleEndian")) {
                    for (int i = 0; i < byteLength / 2; ++i) {
                        byte tmp = result[i];
                        result[i] = result[byteLength - 1 - i];
                        result[byteLength - 1 - i] = tmp;
                        writer.writeBytes(result);
                    }
                    break block32;
                }
                throw new TranslationException(11250, new Object[]{"comp3"});
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TranslationException(11251, new Object[]{"comp3"});
            }
        }
    }
}

