/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.opaque;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.tip.pc.services.translation.framework.DOMUtil;
import oracle.tip.pc.services.translation.framework.TranslationContext;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.framework.Translator;
import oracle.tip.pc.services.translation.framework.XlatorHelper;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;

public class OpaqueTranslator
implements Translator {
    public static final String BASE64BIN_TYPE = "base64Binary";
    public static final String BASE64_ENC = "base64";
    private static final int STREAM_SIZE = 8192;
    private XMLSchema m_xsdDef = null;
    private XSDElement m_rootElement = null;
    private PrintWriter fLogWriter = null;

    public OpaqueTranslator(XMLSchema xsd, XSDElement elem) {
        this.m_xsdDef = xsd;
        this.m_rootElement = elem;
    }

    Element createElementNS(String elementName, String ns, String text) {
        XMLDocument doc = new XMLDocument();
        Element elem = doc.createElementNS(ns, elementName);
        Text textNode = doc.createTextNode(text);
        elem.appendChild(textNode);
        doc.appendChild((Node)elem);
        return elem;
    }

    @Override
    public void translateFromNative(InputStream inputStream, Result result, TranslationContext ctx) throws TranslationException {
        if (inputStream == null || result == null) {
            throw new TranslationException(11206, new Object[]{"Inbound Opaque ", "null", "InputStream/Result"});
        }
        String elementName = this.m_rootElement.getName();
        String type = this.m_rootElement.getType().getName();
        String ns = this.m_rootElement.getTargetNS();
        String encoding = XlatorHelper.getEncoding(this.m_xsdDef, this.m_rootElement);
        XlatorHelper.logDebug("Opaque inbound translator recieved element with type = " + type + " and namespace = " + ns);
        String strEncoded = null;
        if (!type.equals(BASE64BIN_TYPE)) {
            throw new TranslationException(11209, new Object[]{type, BASE64BIN_TYPE});
        }
        strEncoded = XlatorHelper.encodeAsBase64String(inputStream, encoding);
        Element elem = this.createElementNS(elementName, ns, strEncoded);
        if (result instanceof SAXResult) {
            ContentHandler handler = ((SAXResult)result).getHandler();
            if (handler == null) {
                throw new TranslationException(11206, new Object[]{"Inbound Opaque ", "null", "SAXResult ContentHandler"});
            }
            XlatorHelper.raiseEvents(elem, handler);
        } else if (result instanceof DOMResult) {
            ((DOMResult)result).setNode(elem);
        } else if (result instanceof StreamResult) {
            OutputStream out = ((StreamResult)result).getOutputStream();
            if (out == null) {
                throw new TranslationException(11206, new Object[]{"Inbound Opaque ", "null", "OutputStream in StreamResult"});
            }
            try {
                DOMUtil.printDOM(elem, out, encoding, true);
            }
            catch (IOException e) {
                throw new TranslationException(11207, new Object[]{"Outbound XSD", "  to write the node name " + elem.getLocalName() + " of node type : " + elem.getNodeType()}, e);
            }
        }
    }

    @Override
    public void translateToNative(Source source, OutputStream outputStream, TranslationContext ctx) throws TranslationException {
        if (source == null) {
            throw new TranslationException(11154);
        }
        if (source instanceof DOMSource && ((DOMSource)source).getNode() == null) {
            throw new TranslationException(11155);
        }
        if (outputStream == null || source == null) {
            throw new TranslationException(11206, new Object[]{"Outbound Opaque", "null", "OutputStream/Source"});
        }
        String elementName = this.m_rootElement.getName();
        String type = this.m_rootElement.getType().getName();
        String ns = this.m_rootElement.getTargetNS();
        String encoding = XlatorHelper.getEncoding(this.m_xsdDef, this.m_rootElement);
        XlatorHelper.logDebug("Opaque outbound translator recieved element with type = " + type + " and namespace = " + ns + " and encoding = " + encoding);
        if (!type.equals(BASE64BIN_TYPE)) {
            throw new TranslationException(11209, new Object[]{type, BASE64BIN_TYPE});
        }
        if (source instanceof SAXSource) {
            InputStream inputStream = ((SAXSource)source).getInputSource().getByteStream();
            InputStream ins = XlatorHelper.decodeBase64(inputStream);
            XlatorHelper.copyStream(ins, outputStream);
        } else if (source instanceof DOMSource) {
            Node root = ((DOMSource)source).getNode();
            if (root == null) {
                throw new TranslationException(11206, new Object[]{"Outbound Opaque", "null", "DOMSource.getNode()"});
            }
            if (root.getNodeType() == 9) {
                root = ((Document)root).getDocumentElement();
            }
            StringBuffer data = new StringBuffer();
            NodeList textNodes = root.getChildNodes();
            for (int i = 0; i < textNodes.getLength(); ++i) {
                if (textNodes.item(i).getNodeType() == 3) {
                    data.append(textNodes.item(i).getNodeValue());
                    continue;
                }
                XlatorHelper.logDebug("Ignoring non-text node with type = [" + textNodes.item(i).getNodeType() + "] and node name = [" + textNodes.item(i).getNodeName() + "]");
            }
            InputStream inputStream = XlatorHelper.decodeBase64(data.toString(), encoding);
            XlatorHelper.copyStream(inputStream, outputStream);
        } else if (source instanceof StreamSource) {
            InputStream inputStream = ((StreamSource)source).getInputStream();
            InputStream ins = XlatorHelper.decodeBase64(inputStream);
            XlatorHelper.copyStream(ins, outputStream);
        }
    }

    @Override
    public XMLSchema getSchema() {
        return this.m_xsdDef;
    }

    @Override
    public XSDElement getRootElement() {
        return this.m_rootElement;
    }

    @Override
    public void translateFromNative(Reader reader, Result result, TranslationContext ctx) throws TranslationException {
        if (reader == null || result == null) {
            throw new TranslationException(11206, new Object[]{"Inbound Opaque ", "null", "Reader/Result"});
        }
        String elementName = this.m_rootElement.getName();
        String type = this.m_rootElement.getType().getName();
        String ns = this.m_rootElement.getTargetNS();
        String inEncoding = XlatorHelper.getSchemaAttrValue(this.m_xsdDef, this.m_rootElement, "opaqueEncoding");
        String outEncoding = XlatorHelper.getSchemaAttrValue(this.m_xsdDef, this.m_rootElement, "encoding");
        XlatorHelper.logDebug("Opaque inbound translator recieved element with type = " + type + " and namespace = " + ns);
        String strEncoded = null;
        if (!type.equals(BASE64BIN_TYPE)) {
            throw new TranslationException(11209, new Object[]{type, BASE64BIN_TYPE});
        }
        strEncoded = XlatorHelper.encodeAsBase64String(reader, inEncoding, outEncoding);
        Element elem = this.createElementNS(elementName, ns, strEncoded);
        if (result instanceof SAXResult) {
            ContentHandler handler = ((SAXResult)result).getHandler();
            if (handler == null) {
                throw new TranslationException(11206, new Object[]{"Inbound Opaque ", "null", "SAXResult ContentHandler"});
            }
            XlatorHelper.raiseEvents(elem, handler);
        } else if (result instanceof DOMResult) {
            ((DOMResult)result).setNode(elem);
        } else if (result instanceof StreamResult) {
            OutputStream out = ((StreamResult)result).getOutputStream();
            if (out == null) {
                throw new TranslationException(11206, new Object[]{"Inbound Opaque ", "null", "OutputStream in StreamResult"});
            }
            try {
                DOMUtil.printDOM(elem, out, outEncoding, true);
            }
            catch (IOException e) {
                throw new TranslationException(11207, new Object[]{"Outbound XSD", "  to write the node name " + elem.getLocalName() + " of node type : " + elem.getNodeType()}, e);
            }
        }
    }

    @Override
    public void translateToNative(Source source, Writer writer, TranslationContext ctx) throws TranslationException {
        if (writer == null || source == null) {
            throw new TranslationException(11206, new Object[]{"Outbound Opaque", "null", "Writer/Source"});
        }
        String elementName = this.m_rootElement.getName();
        String type = this.m_rootElement.getType().getName();
        String ns = this.m_rootElement.getTargetNS();
        String inEncoding = XlatorHelper.getSchemaAttrValue(this.m_xsdDef, this.m_rootElement, "encoding");
        String outEncoding = XlatorHelper.getSchemaAttrValue(this.m_xsdDef, this.m_rootElement, "opaqueEncoding");
        XlatorHelper.logDebug("Opaque outbound translator recieved element with type = " + type + " and namespace = " + ns);
        if (!type.equals(BASE64BIN_TYPE)) {
            throw new TranslationException(11209, new Object[]{type, BASE64BIN_TYPE});
        }
        if (source instanceof SAXSource) {
            InputStream inputStream = ((SAXSource)source).getInputSource().getByteStream();
            InputStream ins = XlatorHelper.decodeBase64(inputStream);
            XlatorHelper.copyStreamToWriter(ins, writer, outEncoding);
        } else if (source instanceof DOMSource) {
            Node root = ((DOMSource)source).getNode();
            if (root == null) {
                throw new TranslationException(11206, new Object[]{"Outbound Opaque", "null", "DOMSource.getNode()"});
            }
            if (root.getNodeType() == 9) {
                root = ((Document)root).getDocumentElement();
            }
            StringBuffer data = new StringBuffer();
            NodeList textNodes = root.getChildNodes();
            for (int i = 0; i < textNodes.getLength(); ++i) {
                if (textNodes.item(i).getNodeType() == 3) {
                    data.append(textNodes.item(i).getNodeValue());
                    continue;
                }
                XlatorHelper.logDebug("Ignoring non-text node with type = [" + textNodes.item(i).getNodeType() + "] and node name = [" + textNodes.item(i).getNodeName() + "]");
            }
            InputStream inputStream = XlatorHelper.decodeBase64(data.toString(), inEncoding);
            XlatorHelper.copyStreamToWriter(inputStream, writer, outEncoding);
        } else if (source instanceof StreamSource) {
            InputStream inputStream = ((StreamSource)source).getInputStream();
            InputStream ins = XlatorHelper.decodeBase64(inputStream);
            XlatorHelper.copyStreamToWriter(ins, writer, outEncoding);
        }
    }

    @Override
    public void setLogWriter(PrintWriter pw) {
        this.fLogWriter = pw;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.fLogWriter;
    }
}

