/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.nxsd;

import java.io.OutputStream;
import java.util.Vector;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import oracle.tip.pc.services.translation.xlators.nxsd.ExtendedXMLSAXSerializer;
import oracle.xml.parser.v2.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLBuilder
extends DefaultHandler {
    private static final short START_ELEMENT = 0;
    private static final short CHARACTERS = 1;
    private static final short END_ELEMENT = 2;
    private Result fJAXPResult;
    private ContentHandler fContentHandler;
    private Vector fEventQueue;

    public XMLBuilder(Result jaxpResult) {
        this.fJAXPResult = jaxpResult;
        if (jaxpResult instanceof SAXResult) {
            this.fContentHandler = ((SAXResult)jaxpResult).getHandler();
        } else if (jaxpResult instanceof DOMResult) {
            this.fContentHandler = new DocumentBuilder();
        } else if (jaxpResult instanceof StreamResult) {
            OutputStream outputStream = ((StreamResult)jaxpResult).getOutputStream();
            this.fContentHandler = new ExtendedXMLSAXSerializer(outputStream);
        }
        this.fEventQueue = new Vector();
    }

    @Override
    public void startDocument() throws SAXException {
        this.fContentHandler.startDocument();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.fContentHandler.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.fContentHandler.characters(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.fContentHandler.endElement(namespaceURI, localName, qName);
    }

    @Override
    public void endDocument() throws SAXException {
        this.fContentHandler.endDocument();
        if (this.fJAXPResult instanceof DOMResult) {
            Node oldNode = ((DOMResult)this.fJAXPResult).getNode();
            if (oldNode != null) {
                Document doc = oldNode.getOwnerDocument();
                NodeList newNodes = ((DocumentBuilder)this.fContentHandler).getDocument().getChildNodes();
                Node newNode = null;
                Node importedNewNode = null;
                for (int i = 0; i < newNodes.getLength(); ++i) {
                    newNode = newNodes.item(i);
                    importedNewNode = doc.importNode(newNode, true);
                    oldNode.appendChild(importedNewNode);
                }
            } else {
                ((DOMResult)this.fJAXPResult).setNode(((DocumentBuilder)this.fContentHandler).getDocument().getDocumentElement());
            }
        }
    }

    public void queueStartElement(String namespaceURI, String localName, String qName, Attributes atts) {
        XMLEvent xmlEvent = new XMLEvent(namespaceURI, localName, qName, atts);
        this.fEventQueue.add(xmlEvent);
    }

    public void queueCharacters(char[] ch, int start, int length) {
        XMLEvent xmlEvent = new XMLEvent(ch, start, length);
        this.fEventQueue.add(xmlEvent);
    }

    public void queueEndElement(String namespaceURI, String localName, String qName) {
        XMLEvent xmlEvent = new XMLEvent(namespaceURI, localName, qName);
        this.fEventQueue.add(xmlEvent);
    }

    public void flushEvents() throws SAXException {
        XMLEvent xmlEvent = null;
        block5: for (int i = 0; i < this.fEventQueue.size(); ++i) {
            xmlEvent = (XMLEvent)this.fEventQueue.elementAt(i);
            switch (xmlEvent.getEventType()) {
                case 0: {
                    this.startElement(xmlEvent.getNamespaceURI(), xmlEvent.getLocalName(), xmlEvent.getQName(), xmlEvent.getAttributes());
                    continue block5;
                }
                case 1: {
                    this.characters(xmlEvent.getCharBuffer(), xmlEvent.getStartIndex(), xmlEvent.getLength());
                    continue block5;
                }
                case 2: {
                    this.endElement(xmlEvent.getNamespaceURI(), xmlEvent.getLocalName(), xmlEvent.getQName());
                }
            }
        }
        this.fEventQueue = new Vector();
    }

    public void clearEvents() {
        this.fEventQueue = new Vector();
    }

    private class XMLEvent {
        private short fEventType;
        private String fLocalName;
        private String fNamespaceURI;
        private String fQName;
        private Attributes fAttributes;
        private char[] fCharBuf;
        private int fStartIndex;
        private int fLength;

        public XMLEvent(String namespaceURI, String localName, String qName, Attributes atts) {
            this.fNamespaceURI = namespaceURI;
            this.fLocalName = localName;
            this.fQName = qName;
            this.fAttributes = atts;
            this.fEventType = 0;
        }

        public XMLEvent(String namespaceURI, String localName, String qName) {
            this.fNamespaceURI = namespaceURI;
            this.fLocalName = localName;
            this.fQName = qName;
            this.fEventType = (short)2;
        }

        public XMLEvent(char[] ch, int start, int length) {
            this.fCharBuf = ch;
            this.fStartIndex = start;
            this.fLength = length;
            this.fEventType = 1;
        }

        public short getEventType() {
            return this.fEventType;
        }

        public String getNamespaceURI() {
            return this.fNamespaceURI;
        }

        public String getLocalName() {
            return this.fLocalName;
        }

        public String getQName() {
            return this.fQName;
        }

        public Attributes getAttributes() {
            return this.fAttributes;
        }

        public char[] getCharBuffer() {
            return this.fCharBuf;
        }

        public int getStartIndex() {
            return this.fStartIndex;
        }

        public int getLength() {
            return this.fLength;
        }
    }
}

