/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.nxsd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.tip.pc.services.translation.xlators.nxsd.NXSDConstants;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.XMLAttr;

public class NativeDataDefinition
implements NXSDConstants {
    private static final String DEFAULT_PAD_STYLE = "none";
    private static final String DEFAULT_PADDED_BY = " ";
    private static final String DEFAULT_QUOTED_BY = "\"";
    private static final short MASK_LAST_ITEM = 1;
    private static final short MASK_LAST_CELL = 2;
    private static final short STYLE_FIXED_LENGTH = 0;
    private static final short MASK_STYLE_FIXED_LENGTH = 1;
    private static final short STYLE_SURROUNDED = 1;
    private static final short MASK_STYLE_SURROUNDED = 2;
    private static final short STYLE_TERMINATED = 2;
    private static final short MASK_STYLE_TERMINATED = 4;
    private static final short STYLE_ARRAY = 3;
    private static final short MASK_STYLE_ARRAY = 8;
    private static final short STYLE_LIST = 4;
    private static final short MASK_STYLE_LIST = 16;
    private static final short STYLE_MISC = 5;
    private static final short MASK_STYLE_MISC = 32;
    private static final short STYLE_MISC_ROOT = 6;
    private static final short MASK_STYLE_MISC_ROOT = 64;
    private static final short MAX_STYLES = 7;
    private static final short[] fAttrs_Length = new short[]{2, 3, 1, 4, 2, 33, 19};
    private static final short LENGTH = 0;
    private static final short IDENTIFIER_LENGTH = 1;
    private static final short SURROUNDED_BY = 0;
    private static final short LEFT_SURROUNDED_BY = 1;
    private static final short RIGHT_SURROUNDED_BY = 2;
    private static final short TERMINATED_BY = 0;
    private static final short ARRAY_IDENTIFIER_LENGTH = 0;
    private static final short CELL_SEPARATED_BY = 1;
    private static final short ARRAY_TERMINATED_BY = 2;
    private static final short ARRAY_LENGTH = 3;
    private static final short ITEM_SEPARATED_BY = 0;
    private static final short LIST_TERMINATED_BY = 1;
    private static final short PAD_STYLE = 0;
    private static final short PADDED_BY = 1;
    private static final short QUOTED_BY = 2;
    private static final short DATE_FORMAT = 3;
    private static final short CHOICE_CONDITION = 4;
    private static final short CONDITION_VALUE = 5;
    private static final short STARTS_WITH = 6;
    private static final short SKIP = 7;
    private static final short SKIP_UNTIL = 8;
    private static final short SKIP_LINES = 9;
    private static final short LINES_TERMINATED_BY = 10;
    private static final short LOCALE_LANG = 11;
    private static final short LOCALE_COUNTRY = 12;
    private static final short LOCALE_VARIANT = 13;
    private static final short LOOK_AHEAD = 14;
    private static final short LOOK_FOR = 15;
    private static final short SCAN_LENGTH = 16;
    private static final short ASSIGN_TO = 17;
    private static final short SKIP_MODE = 18;
    private static final short WRITE_MODE = 19;
    private static final short WRITE = 20;
    private static final short PREFIX_WITH = 21;
    private static final short SUFFIX_WITH = 22;
    private static final short DATE_PARSING_MODE = 23;
    private static final short XML_DATE_FORMAT = 24;
    private static final short USE_TIME_ZONE = 25;
    private static final short DISPLAY_TIME_ZONE = 26;
    private static final short TIME_ZONE = 27;
    private static final short XML_TIME_ZONE = 28;
    private static final short ALWAYS_QUOTE = 29;
    private static final short LOOK_FOR_PATTERN = 30;
    private static final short LOOK_FROM = 31;
    private static final short LOOK_TILL = 32;
    private static final short VERSION = 0;
    private static final short XML_VERSION = 1;
    private static final short ENCODING = 2;
    private static final short STANDALONE = 3;
    private static final short STREAM_TYPE = 4;
    private static final short BYTE_ORDER = 5;
    private static final short HEADER_LINES = 6;
    private static final short HEADER_LINES_TERMINATED_BY = 7;
    private static final short UNIQUE_MSG_SEPARATOR = 8;
    private static final short XLATION_MODE = 9;
    private static final short OUTBOUND_HEADER = 10;
    private static final short DATA_LINES = 11;
    private static final short FIELD_VALIDATION = 12;
    private static final short VALIDATION = 13;
    private static final short NORMALIZE_LINE_TERMINATORS = 14;
    private static final short ENCODE_LINE_TERMINATORS = 15;
    private static final short USE_ARRAY_IDENTIFIERS = 16;
    private static final short VALIDATE_NXSD = 17;
    private static final short PARSE_BOM = 18;
    private short fFlags;
    private short fStyle;
    private int fStyleCount;
    private String[][] fAttrs_Styles = new String[7][];
    private String fExtStyle;
    private String fNxsdNodeType;
    private String fNxsdNodeName;
    private XSDNode fNxsdNode;
    private int minOccurs = 1;
    private int maxOccurs = 1;
    private NativeDataDefinition parentDefinition;
    private ArrayList<NativeDataDefinition> childDefinitions;
    private NativeDataDefinition schemaDefinition;
    private HashMap<String, NativeDataDefinition> global_defs = new HashMap();

    public NativeDataDefinition() {
        for (int i = 0; i < 7; ++i) {
            this.fAttrs_Styles[i] = new String[fAttrs_Length[i]];
        }
    }

    public void clear() {
        this.fStyleCount = 0;
        this.fFlags = (short)(this.fFlags & 0);
        this.fStyle = (short)(this.fStyle & 0);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < fAttrs_Length[i]; ++j) {
                this.fAttrs_Styles[i][j] = null;
            }
        }
        this.fExtStyle = null;
        this.fNxsdNodeName = null;
        this.fNxsdNodeType = null;
    }

    public boolean isLastItem() {
        return (this.fFlags & 1) != 0;
    }

    public void markAsLastItem(boolean lastItem) {
        this.fFlags = lastItem ? (short)(this.fFlags | 1) : (short)(this.fFlags & 0xFFFFFFFE);
    }

    public boolean isLastCell() {
        return (this.fFlags & 2) != 0;
    }

    public void markAsLastCell(boolean lastCell) {
        this.fFlags = lastCell ? (short)(this.fFlags | 2) : (short)(this.fFlags & 0xFFFFFFFD);
    }

    public String getExtStyle() {
        return this.fExtStyle;
    }

    private void setNxsdNodeType(String nodeType) {
        this.fNxsdNodeType = nodeType;
    }

    public String getNxsdNodeType() {
        return this.fNxsdNodeType;
    }

    public boolean isComplexType() {
        return this.fNxsdNodeType.equals("complexType");
    }

    public boolean isType() {
        return this.isComplexType() || this.isScalarType();
    }

    public boolean isScalarType() {
        return this.isElement() && 2 == ((XSDElement)this.fNxsdNode).getType().getNodeType();
    }

    public boolean isElement() {
        return this.fNxsdNodeType.equals("element");
    }

    public boolean isGroup() {
        return 5 == this.fNxsdNode.getNodeType();
    }

    public boolean isSequence() {
        return this.fNxsdNodeType.equals("sequence");
    }

    public boolean isChoice() {
        return this.fNxsdNodeType.equals("choice");
    }

    public boolean isAll() {
        return this.fNxsdNodeType.equals("all");
    }

    private void setNxsdNodeName(String nodeName) {
        this.fNxsdNodeName = nodeName;
    }

    public String getNxsdNodeName() {
        return this.fNxsdNodeName;
    }

    public String getSchemaConstruct() {
        if (this.getNxsdNodeName() == null) {
            return "node:" + this.getNxsdNodeType();
        }
        return this.getNxsdNodeType() + ":" + this.getNxsdNodeName();
    }

    private void setNxsdNode(XSDNode node) {
        this.fNxsdNode = node;
    }

    public XSDNode getNxsdNode() {
        return this.fNxsdNode;
    }

    public String getNxsdNodeAsXML() {
        if (this.getNxsdNodeName() == null) {
            return "<" + this.getNxsdNodeType() + ">";
        }
        return "<" + this.getNxsdNodeType() + " name=\"" + this.getNxsdNodeName() + "\">";
    }

    public int getStyleCount() {
        return this.fStyleCount;
    }

    public boolean isFixedLength() {
        return (this.fStyle & 1) != 0;
    }

    private void setLength(String len) {
        this.fAttrs_Styles[0][0] = len;
    }

    public String getLength() {
        if (this.isFixedLength()) {
            return this.fAttrs_Styles[0][0];
        }
        return null;
    }

    private void setIdentifierLength(String len) {
        this.fAttrs_Styles[0][1] = len;
    }

    public String getIdentifierLength() {
        if (this.isFixedLength()) {
            return this.fAttrs_Styles[0][1];
        }
        return null;
    }

    public boolean isSurrounded() {
        return (this.fStyle & 2) != 0;
    }

    private void setSurroundedBy(String surroundedBy) {
        this.fAttrs_Styles[1][0] = surroundedBy;
    }

    public String getSurroundedBy() {
        if (this.isSurrounded()) {
            return this.fAttrs_Styles[1][0];
        }
        return null;
    }

    private void setLeftSurroundedBy(String leftSurroundedBy) {
        this.fAttrs_Styles[1][1] = leftSurroundedBy;
    }

    public String getLeftSurroundedBy() {
        if (this.isSurrounded()) {
            return this.fAttrs_Styles[1][1];
        }
        return null;
    }

    private void setRightSurroundedBy(String rightSurroundedBy) {
        this.fAttrs_Styles[1][2] = rightSurroundedBy;
    }

    public String getRightSurroundedBy() {
        if (this.isSurrounded()) {
            return this.fAttrs_Styles[1][2];
        }
        return null;
    }

    public boolean isTerminated() {
        return (this.fStyle & 4) != 0;
    }

    private void setTerminatedBy(String terminatedBy) {
        this.fAttrs_Styles[2][0] = terminatedBy;
    }

    public String getTerminatedBy() {
        if (this.isTerminated()) {
            return this.fAttrs_Styles[2][0];
        }
        return null;
    }

    public boolean isArray() {
        return (this.fStyle & 8) != 0;
    }

    private void setCellSeparatedBy(String cellSeparatedBy) {
        this.fAttrs_Styles[3][1] = cellSeparatedBy;
    }

    public String getCellSeparatedBy() {
        if (this.isArray()) {
            return this.fAttrs_Styles[3][1];
        }
        return null;
    }

    private void setArrayTerminatedBy(String arrayTerminatedBy) {
        this.fAttrs_Styles[3][2] = arrayTerminatedBy;
    }

    public String getArrayTerminatedBy() {
        if (this.isArray()) {
            return this.fAttrs_Styles[3][2];
        }
        return null;
    }

    private void setArrayIdentifierLength(String arrayIdentifierLength) {
        this.fAttrs_Styles[3][0] = arrayIdentifierLength;
    }

    public String getArrayIdentifierLength() {
        if (this.isArray()) {
            return this.fAttrs_Styles[3][0];
        }
        return null;
    }

    private void setArrayLength(String arrayLength) {
        this.fAttrs_Styles[3][3] = arrayLength;
    }

    public String getArrayLength() {
        if (this.isArray()) {
            return this.fAttrs_Styles[3][3];
        }
        return null;
    }

    public boolean isList() {
        return (this.fStyle & 0x10) != 0;
    }

    private void setItemSeparatedBy(String itemSeparatedBy) {
        this.fAttrs_Styles[4][0] = itemSeparatedBy;
    }

    public String getItemSeparatedBy() {
        if (this.isList()) {
            return this.fAttrs_Styles[4][0];
        }
        return null;
    }

    private void setListTerminatedBy(String listTerminatedBy) {
        this.fAttrs_Styles[4][1] = listTerminatedBy;
    }

    public String getListTerminatedBy() {
        if (this.isList()) {
            return this.fAttrs_Styles[4][1];
        }
        return null;
    }

    private void setPadStyle(String padStyle) {
        this.fAttrs_Styles[5][0] = padStyle;
    }

    public String getPadStyle() {
        return this.fAttrs_Styles[5][0];
    }

    private void setPaddedBy(String paddedBy) {
        this.fAttrs_Styles[5][1] = paddedBy;
    }

    public String getPaddedBy() {
        return this.fAttrs_Styles[5][1];
    }

    private void setQuotedBy(String quotedBy) {
        this.fAttrs_Styles[5][2] = quotedBy;
    }

    public String getQuotedBy() {
        return this.fAttrs_Styles[5][2];
    }

    private void setDateFormat(String dateFormat) {
        this.fAttrs_Styles[5][3] = dateFormat;
    }

    public String getDateFormat() {
        return this.fAttrs_Styles[5][3];
    }

    private void setChoiceCondition(String choiceCondition) {
        this.fAttrs_Styles[5][4] = choiceCondition;
    }

    public String getChoiceCondition() {
        return this.fAttrs_Styles[5][4];
    }

    private void setConditionValue(String conditionValue) {
        this.fAttrs_Styles[5][5] = conditionValue;
    }

    public String getConditionValue() {
        return this.fAttrs_Styles[5][5];
    }

    private void setStartsWith(String startsWith) {
        this.fAttrs_Styles[5][6] = startsWith;
    }

    public String getStartsWith() {
        return this.fAttrs_Styles[5][6];
    }

    private void setSkip(String skip) {
        this.fAttrs_Styles[5][7] = skip;
    }

    public String getSkip() {
        return this.fAttrs_Styles[5][7];
    }

    private void setSkipUntil(String skipUntil) {
        this.fAttrs_Styles[5][8] = skipUntil;
    }

    public String getSkipUntil() {
        return this.fAttrs_Styles[5][8];
    }

    private void setSkipLines(String skipLines) {
        this.fAttrs_Styles[5][9] = skipLines;
    }

    public String getSkipLines() {
        return this.fAttrs_Styles[5][9];
    }

    private void setLinesTerminatedBy(String linesTerminatedBy) {
        this.fAttrs_Styles[5][10] = linesTerminatedBy;
    }

    public String getLinesTerminatedBy() {
        return this.fAttrs_Styles[5][10];
    }

    private void setLocaleLang(String localeLang) {
        this.fAttrs_Styles[5][11] = localeLang;
    }

    public String getLocaleLang() {
        return this.fAttrs_Styles[5][11];
    }

    private void setLocaleCountry(String localeCountry) {
        this.fAttrs_Styles[5][12] = localeCountry;
    }

    public String getLocaleCountry() {
        return this.fAttrs_Styles[5][12];
    }

    private void setLocaleVariant(String localeVariant) {
        this.fAttrs_Styles[5][13] = localeVariant;
    }

    public String getLocaleVariant() {
        return this.fAttrs_Styles[5][13];
    }

    private void setLookAhead(String lookAhead) {
        this.fAttrs_Styles[5][14] = lookAhead;
    }

    public String getLookAhead() {
        return this.fAttrs_Styles[5][14];
    }

    private void setLookFor(String lookFor) {
        this.fAttrs_Styles[5][15] = lookFor;
    }

    public String getLookFor() {
        return this.fAttrs_Styles[5][15];
    }

    private void setLookForPattern(String lookForPattern) {
        this.fAttrs_Styles[5][30] = lookForPattern;
    }

    public String getLookForPattern() {
        return this.fAttrs_Styles[5][30];
    }

    private void setLookFrom(String lookFrom) {
        this.fAttrs_Styles[5][31] = lookFrom;
    }

    public String getLookFrom() {
        return this.fAttrs_Styles[5][31];
    }

    private void setLookTill(String lookTill) {
        this.fAttrs_Styles[5][32] = lookTill;
    }

    public String getLookTill() {
        return this.fAttrs_Styles[5][32];
    }

    private void setScanLength(String scanLen) {
        this.fAttrs_Styles[5][16] = scanLen;
    }

    public String getScanLength() {
        return this.fAttrs_Styles[5][16];
    }

    private void setAssignTo(String assignTo) {
        this.fAttrs_Styles[5][17] = assignTo;
    }

    public String getAssignTo() {
        return this.fAttrs_Styles[5][17];
    }

    private void setSkipMode(String skipMode) {
        this.fAttrs_Styles[5][18] = skipMode;
    }

    public String getSkipMode() {
        return this.fAttrs_Styles[5][18];
    }

    private void setWriteMode(String writeMode) {
        this.fAttrs_Styles[5][19] = writeMode;
    }

    public String getWriteMode() {
        return this.fAttrs_Styles[5][19];
    }

    private void setWrite(String data) {
        this.fAttrs_Styles[5][20] = data;
    }

    public String getWrite() {
        return this.fAttrs_Styles[5][20];
    }

    private void setPrefixWith(String prefix) {
        this.fAttrs_Styles[5][21] = prefix;
    }

    public String getPrefixWith() {
        return this.fAttrs_Styles[5][21];
    }

    private void setSuffixWith(String suffix) {
        this.fAttrs_Styles[5][22] = suffix;
    }

    public String getSuffixWith() {
        return this.fAttrs_Styles[5][22];
    }

    private void setDateParsingMode(String mode) {
        this.fAttrs_Styles[5][23] = mode;
    }

    public String getDateParsingMode() {
        return this.fAttrs_Styles[5][23];
    }

    private void setXmlDateFormat(String format) {
        this.fAttrs_Styles[5][24] = format;
    }

    public String getXmlDateFormat() {
        return this.fAttrs_Styles[5][24];
    }

    private void setUseTimeZone(String tz) {
        this.fAttrs_Styles[5][25] = tz;
    }

    public String getUseTimeZone() {
        return this.fAttrs_Styles[5][25];
    }

    private void setTimeZone(String tz) {
        this.fAttrs_Styles[5][27] = tz;
    }

    public String getTimeZone() {
        return this.fAttrs_Styles[5][27];
    }

    private void setXmlTimeZone(String tz) {
        this.fAttrs_Styles[5][28] = tz;
    }

    public String getXmlTimeZone() {
        return this.fAttrs_Styles[5][28];
    }

    private void setDisplayTimeZone(String display) {
        this.fAttrs_Styles[5][26] = display;
    }

    public boolean getDisplayTimeZone() {
        if (this.fAttrs_Styles[5][26] != null) {
            return Boolean.parseBoolean(this.fAttrs_Styles[5][26]);
        }
        return false;
    }

    private void setAlwaysQuote(String val) {
        this.fAttrs_Styles[5][29] = val;
    }

    public String getAlwaysQuote() {
        return this.fAttrs_Styles[5][29];
    }

    private void setVersion(String version) {
        this.fAttrs_Styles[6][0] = version;
    }

    public String getVersion() {
        return this.fAttrs_Styles[6][0];
    }

    private void setXmlVersion(String xmlversion) {
        this.fAttrs_Styles[6][1] = xmlversion;
    }

    public String getXmlVersion() {
        return this.fAttrs_Styles[6][1];
    }

    private void setEncoding(String encoding) {
        this.fAttrs_Styles[6][2] = encoding;
    }

    public String getEncoding() {
        return this.fAttrs_Styles[6][2];
    }

    private void setStandalone(String standalone) {
        this.fAttrs_Styles[6][3] = standalone;
    }

    public String getStandalone() {
        return this.fAttrs_Styles[6][3];
    }

    private void setStreamType(String streamType) {
        this.fAttrs_Styles[6][4] = streamType;
    }

    public String getStreamType() {
        return this.fAttrs_Styles[6][4];
    }

    private void setByteOrder(String byteOrder) {
        this.fAttrs_Styles[6][5] = byteOrder;
    }

    public String getByteOrder() {
        return this.fAttrs_Styles[6][5];
    }

    private void setHeaderLines(String headerLines) {
        this.fAttrs_Styles[6][6] = headerLines;
    }

    public String getHeaderLines() {
        return this.fAttrs_Styles[6][6];
    }

    private void setHeaderLinesTerminatedBy(String hdrTerminatedBy) {
        this.fAttrs_Styles[6][7] = hdrTerminatedBy;
    }

    public String getHeaderLinesTerminatedBy() {
        return this.fAttrs_Styles[6][7];
    }

    private void setUniqueMsgSeparator(String msgSeparator) {
        this.fAttrs_Styles[6][8] = msgSeparator;
    }

    public String getUniqueMsgSeparator() {
        return this.fAttrs_Styles[6][8];
    }

    private void setXlationMode(String mode) {
        this.fAttrs_Styles[6][9] = mode;
    }

    public String getXlationMode() {
        return this.fAttrs_Styles[6][9];
    }

    private void setOutboundHeader(String header) {
        this.fAttrs_Styles[6][10] = header;
    }

    public String getOutboundHeader() {
        return this.fAttrs_Styles[6][10];
    }

    private void setDataLines(String dataLines) {
        this.fAttrs_Styles[6][11] = dataLines;
    }

    public String getDataLines() {
        return this.fAttrs_Styles[6][11];
    }

    private void setFieldValidation(String fieldValidationFlag) {
        this.fAttrs_Styles[6][12] = fieldValidationFlag;
    }

    public String getFieldValidation() {
        return this.fAttrs_Styles[6][12];
    }

    private void setValidateNxsd(String validateNxsdFlag) {
        this.fAttrs_Styles[6][17] = validateNxsdFlag;
    }

    public String validateNxsd() {
        return this.fAttrs_Styles[6][17];
    }

    private void setParseBom(String bomFlag) {
        this.fAttrs_Styles[6][18] = bomFlag;
    }

    public boolean getParseBom() {
        String temp = this.fAttrs_Styles[6][18];
        return temp != null && temp.equalsIgnoreCase("true");
    }

    private void setUseArrayIdentifiers(String arrayMode) {
        this.fAttrs_Styles[6][16] = arrayMode;
    }

    public String getUseArrayIdentifiers() {
        return this.fAttrs_Styles[6][16];
    }

    private void setValidation(String validationFlag) {
        this.fAttrs_Styles[6][13] = validationFlag;
    }

    public String getValidation() {
        return this.fAttrs_Styles[6][13];
    }

    private void setNormalizeLineTerminators(String normalizeLineTerminators) {
        this.fAttrs_Styles[6][14] = normalizeLineTerminators;
    }

    public boolean getNormalizeLineTerminators() {
        String temp = this.fAttrs_Styles[6][14];
        return temp == null || !temp.equalsIgnoreCase("false");
    }

    private void setEncodeLineTerminators(String encodeLineTerminators) {
        this.fAttrs_Styles[6][15] = encodeLineTerminators;
    }

    public boolean getEncodeLineTerminators() {
        String temp = this.fAttrs_Styles[6][15];
        return temp != null && temp.equalsIgnoreCase("true");
    }

    public static String getDefaultPadStyle() {
        return DEFAULT_PAD_STYLE;
    }

    public static String getDefaultPaddedBy() {
        return DEFAULT_PADDED_BY;
    }

    public static String getDefaultQuotedBy() {
        return DEFAULT_QUOTED_BY;
    }

    public static void fillDef(XSDNode node, NativeDataDefinition def, boolean flush) {
        XSDAnnotation annotation = null;
        if (flush) {
            def.clear();
        }
        if (node != null) {
            def.setNxsdNode(node);
            switch (node.getNodeType()) {
                case 0: {
                    def.setNxsdNodeType("schema");
                    break;
                }
                case 3: {
                    def.setNxsdNodeType("element");
                    break;
                }
                case 1: {
                    def.setNxsdNodeType("complexType");
                    break;
                }
                case 5: {
                    switch (((XSDGroup)node).getOrder()) {
                        case 0: {
                            def.setNxsdNodeType("sequence");
                            break;
                        }
                        case 1: {
                            def.setNxsdNodeType("choice");
                            break;
                        }
                        case 2: {
                            def.setNxsdNodeType("all");
                        }
                    }
                    break;
                }
                case 2: {
                    def.setNxsdNodeType("simpleType");
                    break;
                }
                default: {
                    def.setNxsdNodeType("unknown");
                }
            }
            def.setNxsdNodeName(node.getName());
            try {
                if (node.getNodeType() == 3 && ((XSDElement)node).getRefState() == 0 && (annotation = node.getRefAnnotation()) != null) {
                    NativeDataDefinition.doFill(annotation, def);
                }
            }
            catch (NoSuchMethodError error) {
                // empty catch block
            }
            annotation = node.getAnnotation();
            NativeDataDefinition.doFill(annotation, def);
        }
    }

    private static void doFill(XSDAnnotation annotation, NativeDataDefinition def) {
        Vector attributes = null;
        XMLAttr attribute = null;
        if (annotation != null && (attributes = annotation.getAttributes()) != null) {
            String attName = null;
            String attVal = null;
            int len = attributes.size();
            for (int i = 0; i < len; ++i) {
                attribute = (XMLAttr)attributes.get(i);
                if (!"http://xmlns.oracle.com/pcbpel/nxsd".equals(attribute.getNamespaceURI())) continue;
                attName = attribute.getLocalName();
                attVal = attribute.getValue();
                if ("style".equals(attName) && attVal.indexOf(",") > 0) {
                    StringTokenizer styles = new StringTokenizer(attVal, ",");
                    while (styles.hasMoreTokens()) {
                        def.setNXSDProperty("style", styles.nextToken().trim());
                    }
                    continue;
                }
                def.setNXSDProperty(attName, attVal);
            }
        }
    }

    private void setStyle(short style) {
        this.fStyle = (short)(this.fStyle | style);
        ++this.fStyleCount;
    }

    private void setExtStyle(String extStyle) {
        this.fExtStyle = extStyle;
    }

    public void setNXSDProperty(String name, String val) {
        if ("style".equals(name)) {
            if ("fixedLength".equals(val)) {
                this.setStyle((short)1);
            } else if ("surrounded".equals(val)) {
                this.setStyle((short)2);
            } else if ("terminated".equals(val)) {
                this.setStyle((short)4);
            } else if ("array".equals(val)) {
                this.setStyle((short)8);
            } else if ("list".equals(val)) {
                this.setStyle((short)16);
            } else {
                this.setExtStyle(val);
            }
        } else if ("length".equals(name)) {
            this.setLength(val);
        } else if ("identifierLength".equals(name)) {
            this.setIdentifierLength(val);
        } else if ("surroundedBy".equals(name)) {
            this.setSurroundedBy(val);
        } else if ("leftSurroundedBy".equals(name)) {
            this.setLeftSurroundedBy(val);
        } else if ("rightSurroundedBy".equals(name)) {
            this.setRightSurroundedBy(val);
        } else if ("terminatedBy".equals(name)) {
            this.setTerminatedBy(val);
        } else if ("arrayLength".equals(name)) {
            this.setArrayLength(val);
        } else if ("arrayIdentifierLength".equals(name)) {
            this.setArrayIdentifierLength(val);
        } else if ("cellSeparatedBy".equals(name)) {
            this.setCellSeparatedBy(val);
        } else if ("arrayTerminatedBy".equals(name)) {
            this.setArrayTerminatedBy(val);
        } else if ("itemSeparatedBy".equals(name)) {
            this.setItemSeparatedBy(val);
        } else if ("listTerminatedBy".equals(name)) {
            this.setListTerminatedBy(val);
        } else if ("padStyle".equals(name)) {
            this.setPadStyle(val);
        } else if ("paddedBy".equals(name)) {
            this.setPaddedBy(val);
        } else if ("quotedBy".equals(name)) {
            this.setQuotedBy(val);
        } else if ("dateFormat".equals(name)) {
            this.setDateFormat(val);
        } else if ("choiceCondition".equals(name)) {
            this.setChoiceCondition(val);
            if ("terminated".equals(val)) {
                this.setStyle((short)4);
            } else if ("fixedLength".equals(val)) {
                this.setStyle((short)1);
            }
        } else if ("conditionValue".equals(name)) {
            this.setConditionValue(val);
        } else if ("startsWith".equals(name)) {
            this.setStartsWith(val);
        } else if ("skip".equals(name)) {
            this.setSkip(val);
        } else if ("skipUntil".equals(name)) {
            this.setSkipUntil(val);
        } else if ("skipLines".equals(name)) {
            this.setSkipLines(val);
        } else if ("linesTerminatedBy".equals(name)) {
            this.setLinesTerminatedBy(val);
        } else if ("localeLanguage".equals(name)) {
            this.setLocaleLang(val);
        } else if ("localeCountry".equals(name)) {
            this.setLocaleCountry(val);
        } else if ("localeVariant".equals(name)) {
            this.setLocaleVariant(val);
        } else if ("lookAhead".equals(name)) {
            this.setLookAhead(val);
        } else if ("lookFor".equals(name)) {
            this.setLookFor(val);
        } else if ("lookForPattern".equals(name)) {
            this.setLookForPattern(val);
        } else if ("lookFrom".equals(name)) {
            this.setLookFrom(val);
        } else if ("lookTill".equals(name)) {
            this.setLookTill(val);
        } else if ("scanLength".equals(name)) {
            this.setScanLength(val);
        } else if ("assignTo".equals(name)) {
            this.setAssignTo(val);
        } else if ("skipMode".equals(name)) {
            this.setSkipMode(val);
        } else if ("writeMode".equals(name)) {
            this.setWriteMode(val);
        } else if ("write".equals(name)) {
            this.setWrite(val);
        } else if ("prefixWith".equals(name)) {
            this.setPrefixWith(val);
        } else if ("suffixWith".equals(name)) {
            this.setSuffixWith(val);
        } else if ("dateParsingMode".equals(name)) {
            this.setDateParsingMode(val);
        } else if ("xmlDateFormat".equals(name)) {
            this.setXmlDateFormat(val);
        } else if ("useTimeZone".equals(name)) {
            this.setUseTimeZone(val);
        } else if ("timeZone".equals(name)) {
            this.setTimeZone(val);
        } else if ("xmlTimeZone".equals(name)) {
            this.setXmlTimeZone(val);
        } else if ("displayTimeZone".equals(name)) {
            this.setDisplayTimeZone(val);
        } else if ("alwaysQuote".equals(name)) {
            this.setAlwaysQuote(val);
        } else if ("version".equals(name)) {
            this.setVersion(val);
        } else if ("xmlversion".equals(name)) {
            this.setXmlVersion(val);
        } else if ("encoding".equals(name)) {
            this.setEncoding(val);
        } else if ("standalone".equals(name)) {
            this.setStandalone(val);
        } else if ("stream".equals(name)) {
            this.setStreamType(val);
        } else if ("byteOrder".equals(name)) {
            this.setByteOrder(val);
        } else if ("headerLines".equals(name)) {
            this.setHeaderLines(val);
        } else if ("headerLinesTerminatedBy".equals(name)) {
            this.setHeaderLinesTerminatedBy(val);
        } else if ("uniqueMessageSeparator".equals(name)) {
            this.setUniqueMsgSeparator(val);
        } else if ("xlationMode".equals(name)) {
            this.setXlationMode(val);
        } else if ("outboundHeader".equals(name)) {
            this.setOutboundHeader(val);
        } else if ("dataLines".equals(name)) {
            this.setDataLines(val);
        } else if ("fieldValidation".equals(name)) {
            this.setFieldValidation(val);
        } else if ("validation".equals(name)) {
            this.setValidation(val);
        } else if ("validateNxsd".equals(name)) {
            this.setValidateNxsd(val);
        } else if ("normalizeLineTerminators".equals(name)) {
            this.setNormalizeLineTerminators(val);
        } else if ("encodeLineTerminators".equals(name)) {
            this.setEncodeLineTerminators(val);
        } else if ("useArrayIdentifiers".equals(name)) {
            this.setUseArrayIdentifiers(val);
        } else if ("parseBom".equals(name)) {
            this.setParseBom(val);
        }
    }

    public String getNxsdAttributeValue(String name) {
        return this.getNxsdAttributeValue(null, name);
    }

    public String getNxsdAttributeValue(String namespace, String name) {
        Vector attributes = null;
        XSDAnnotation annotation = null;
        XMLAttr attribute = null;
        if (namespace == null) {
            namespace = "http://xmlns.oracle.com/pcbpel/nxsd";
        }
        if ((annotation = this.fNxsdNode.getAnnotation()) != null && (attributes = annotation.getAttributes()) != null) {
            String attName = null;
            String attVal = null;
            int len = attributes.size();
            for (int i = 0; i < len; ++i) {
                attribute = (XMLAttr)attributes.get(i);
                if (!namespace.equals(attribute.getNamespaceURI())) continue;
                attName = attribute.getLocalName();
                attVal = attribute.getValue();
                if (!name.equals(attName)) continue;
                return attVal;
            }
        }
        return null;
    }

    public Locale getLocale() {
        String lang = this.getLocaleLang();
        String country = this.getLocaleCountry();
        String variant = this.getLocaleVariant();
        if (lang == null && country == null && variant == null) {
            return null;
        }
        if (variant != null) {
            return new Locale(lang, country, variant);
        }
        if (country != null) {
            return new Locale(lang, country);
        }
        return new Locale(lang);
    }

    public ArrayList<NativeDataDefinition> getChildDefinitions() {
        return this.childDefinitions;
    }

    public void setChildDefinitions(ArrayList childDefinitions) {
        this.childDefinitions = childDefinitions;
    }

    public NativeDataDefinition getParentDefinition() {
        return this.parentDefinition;
    }

    public void setParentDefinition(NativeDataDefinition parentDefinition) {
        this.parentDefinition = parentDefinition;
    }

    public void loadDefinitions(XSDNode schemaNode, XSDNode rootNode, NativeDataDefinition def) {
        this.schemaDefinition = new NativeDataDefinition();
        NativeDataDefinition.fillDef(schemaNode, this.schemaDefinition, true);
        def.setParentDefinition(this.schemaDefinition);
        if (this.schemaDefinition.getVersion() != null && this.schemaDefinition.getVersion().equals("NXSD")) {
            this.parseDefinition(rootNode, def);
        }
    }

    public boolean hasChildNodes() {
        return this.getChildDefinitions() != null && this.getChildDefinitions().size() > 0;
    }

    private void parseDefinition(XSDNode node, NativeDataDefinition def) {
        ArrayList<NativeDataDefinition> childList = null;
        NativeDataDefinition.fillDef(node, def, true);
        switch (node.getNodeType()) {
            case 3: {
                XSDElement element = (XSDElement)node;
                def.setMinOccurs(element.getMinOccurs());
                def.setMaxOccurs(element.getMaxOccurs());
                if (1 == element.getType().getNodeType()) {
                    XSDComplexType complexType = (XSDComplexType)element.getType();
                    if (complexType.getAttributeWildcard() != null) {
                        return;
                    }
                    String key = this.getKey((XSDNode)complexType);
                    childList = new ArrayList();
                    if (key != null && this.global_defs.containsKey(key)) {
                        NativeDataDefinition ct = this.global_defs.get(key);
                        childList.add(ct);
                        def.setChildDefinitions(childList);
                        ct.setParentDefinition(def);
                    } else {
                        NativeDataDefinition ct = new NativeDataDefinition();
                        childList.add(ct);
                        def.setChildDefinitions(childList);
                        ct.setParentDefinition(def);
                        if (this.isGlobal((XSDNode)complexType)) {
                            this.global_defs.put(this.getKey((XSDNode)complexType), ct);
                        }
                        this.parseDefinition((XSDNode)complexType, ct);
                        XSDGroup group = complexType.getTypeGroup();
                        if (group != null) {
                            NativeDataDefinition groupDef = new NativeDataDefinition();
                            groupDef.setParentDefinition(ct);
                            childList = new ArrayList();
                            childList.add(groupDef);
                            ct.setChildDefinitions(childList);
                            this.parseDefinition((XSDNode)group, groupDef);
                        }
                    }
                }
                if (2 != element.getType().getNodeType()) break;
                return;
            }
            case 5: {
                XSDGroup group = (XSDGroup)node;
                def.setMinOccurs(group.getMinOccurs());
                def.setMaxOccurs(group.getMaxOccurs());
                Vector childNodes = group.getNodeVector();
                NativeDataDefinition childDef = null;
                childList = new ArrayList<NativeDataDefinition>();
                for (int i = 0; i < childNodes.size(); ++i) {
                    childDef = new NativeDataDefinition();
                    this.parseDefinition((XSDNode)childNodes.get(i), childDef);
                    if (i + 1 == childNodes.size()) {
                        childDef.markAsLastItem(true);
                    }
                    childDef.setParentDefinition(def);
                    childList.add(childDef);
                }
                def.setChildDefinitions(childList);
            }
        }
    }

    public NativeDataDefinition getSchemaDefinition() {
        return this.schemaDefinition;
    }

    public void setSchemaDefinition(NativeDataDefinition schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isGlobal(XSDNode node) {
        return 0 == node.getParent().getNodeType();
    }

    private String getKey(XSDNode node) {
        try {
            if (node.getTargetNS() != null && node.getName() != null) {
                return node.getTargetNS() + node.getName();
            }
        }
        catch (NullPointerException npe) {
            return null;
        }
        return null;
    }
}

