/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.nxsd;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import oracle.tip.pc.infra.DiagnosticService;
import oracle.tip.pc.infra.PCProperties;
import oracle.tip.pc.services.translation.framework.TranslationContext;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.framework.Translator;
import oracle.tip.pc.services.translation.framework.XlatorHelper;
import oracle.tip.pc.services.translation.xlators.nxsd.ByteDataReaderImpl;
import oracle.tip.pc.services.translation.xlators.nxsd.ByteDataWriterImpl;
import oracle.tip.pc.services.translation.xlators.nxsd.CharDataReaderImpl;
import oracle.tip.pc.services.translation.xlators.nxsd.CharDataWriterImpl;
import oracle.tip.pc.services.translation.xlators.nxsd.DataFragmentHandler;
import oracle.tip.pc.services.translation.xlators.nxsd.DataFragmentHandlerContext;
import oracle.tip.pc.services.translation.xlators.nxsd.ErrorList;
import oracle.tip.pc.services.translation.xlators.nxsd.InputDataReader;
import oracle.tip.pc.services.translation.xlators.nxsd.NXSDFieldValidator;
import oracle.tip.pc.services.translation.xlators.nxsd.NXSDStyleBasedFormatter;
import oracle.tip.pc.services.translation.xlators.nxsd.NXSDStyleBasedReader;
import oracle.tip.pc.services.translation.xlators.nxsd.NXSDValidator;
import oracle.tip.pc.services.translation.xlators.nxsd.NativeDataDefinition;
import oracle.tip.pc.services.translation.xlators.nxsd.OutputDataWriter;
import oracle.tip.pc.services.translation.xlators.nxsd.VariableSupport;
import oracle.tip.pc.services.translation.xlators.nxsd.XMLBuilder;
import oracle.tip.pc.services.translation.xlators.nxsd.XMLCommons;
import oracle.tip.pc.services.translation.xlators.nxsd.XMLTokenizer;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.XMLError;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class NXSDTranslatorImpl
extends DefaultHandler
implements Translator {
    private static final String EMPTY_STRING = "";
    private XMLSchema fNXSDSchema;
    private XSDElement fNXSDRootElement;
    private PrintWriter fLogWriter;
    private XSDValidator fXSDValidator;
    private String fEncoding;
    private String fXlationMode;
    private String fStreamType;
    private String fByteOrder;
    private boolean fDebatching;
    private boolean fErrorRecovery;
    private int fOffset;
    private int fPublishSize;
    private int fCurrentSize;
    private int fLastCharRead;
    private InputDataReader fInputDataReader;
    private XMLBuilder fXMLBuilder;
    private XSDElement fParentElement;
    private XSDElement fCurrentElement;
    private XSDElement fLastElement;
    private XSDElement fArrayElement;
    private Stack fStack;
    private XMLTokenizer fXMLTokenizer;
    private OutputDataWriter fOutputDataWriter;
    private NXSDStyleBasedFormatter fStyleBasedFormatter;
    private NXSDStyleBasedReader fStyleBasedReader;
    private VariableSupport fVariableSupport;
    private NativeDataDefinition fElementDefinition;
    private NativeDataDefinition fParentCTDefinition;
    private NativeDataDefinition fCurrentElementDefinition;
    private NativeDataDefinition schemaDef;
    private NativeDataDefinition fNXSDRootDef;
    private boolean fEof;
    private boolean fCharactersEvent;
    private HashMap fHandlers;
    private DataFragmentHandlerContext fDataFragmentHandlerContext;
    private String fUniqueMessageSeparator;
    private String fHeaderLines;
    private String fHeaderLinesTerminatedBy;
    private String fOutboundHeader;
    private boolean debug = false;
    private static Properties fHandlerProperties = new Properties();
    private XMLCommons fXMLCommons;
    private boolean fBatching;
    private boolean fIsFirstMessageInBatch;
    private boolean fIsLastMessageInBatch;
    private boolean fCorruptMessage;
    private long fBeginOffset;
    private long fEndOffset;
    private int fBeginLineNumber;
    private int fBeginColumnNumber;
    private int fEndLineNumber;
    private int fEndColumnNumber;
    private Vector fEventQueue;
    private ErrorList fErrorList;
    private Exception fCurrentException;
    private boolean fAllCorrupt;
    private XMLError fXMLError;
    private int fMaxLineNumber;
    private String fFieldValidation;
    private String fValidation;
    private boolean fNormalizeLineTerminators = true;
    private boolean fEncodeLineTerminators = false;
    private String fUseArrayIdentifiers;
    private boolean fParseBom = false;
    private static short START_ELEMENT;
    private static short CHARACTERS;
    private static short END_ELEMENT;
    private short fCurrentEvent;
    private short fLastEvent;
    private StringBuffer fCharEventBuffer = null;

    public NXSDTranslatorImpl(XMLSchema schema, XSDElement root, NativeDataDefinition def) throws TranslationException {
        this.fNXSDSchema = schema;
        this.fNXSDRootElement = root;
        this.fNXSDRootDef = def;
        XMLSchemaNode schemaNode = this.fNXSDSchema.getSchemaByTargetNS(root.getTargetNS());
        this.fElementDefinition = def;
        this.schemaDef = def.getSchemaDefinition();
        this.fEncoding = this.schemaDef.getEncoding();
        this.fStreamType = this.schemaDef.getStreamType();
        this.fByteOrder = this.schemaDef.getByteOrder();
        this.fHeaderLines = this.schemaDef.getHeaderLines();
        this.fHeaderLinesTerminatedBy = this.schemaDef.getHeaderLinesTerminatedBy();
        this.fOutboundHeader = this.schemaDef.getOutboundHeader();
        this.fUniqueMessageSeparator = this.schemaDef.getUniqueMsgSeparator();
        this.fXlationMode = this.schemaDef.getXlationMode();
        this.fValidation = this.schemaDef.getValidation();
        this.fFieldValidation = this.schemaDef.getFieldValidation();
        this.fNormalizeLineTerminators = this.schemaDef.getNormalizeLineTerminators();
        this.fEncodeLineTerminators = this.schemaDef.getEncodeLineTerminators();
        this.fUseArrayIdentifiers = this.schemaDef.getUseArrayIdentifiers();
        this.fParseBom = this.schemaDef.getParseBom();
        this.fMaxLineNumber = -1;
        if (this.schemaDef.getDataLines() != null) {
            this.fMaxLineNumber = Integer.parseInt(this.schemaDef.getDataLines());
            if (this.fHeaderLines != null) {
                this.fMaxLineNumber += Integer.parseInt(this.fHeaderLines);
            }
        }
        if (this.fXlationMode == null) {
            this.fXlationMode = "strict";
        }
        if (this.fStreamType == null) {
            this.fStreamType = "chars";
        }
        this.fHandlers = new HashMap();
        this.fDataFragmentHandlerContext = new DataFragmentHandlerContext();
        this.fDataFragmentHandlerContext.fByteOrder = this.fByteOrder;
        this.fDataFragmentHandlerContext.fEncoding = this.fEncoding;
        this.fDataFragmentHandlerContext.fStreamType = this.fStreamType;
        if (Boolean.parseBoolean(this.fElementDefinition.validateNxsd())) {
            NXSDValidator.validateSchema(schema, (XSDNode)root);
        } else {
            XlatorHelper.logDebug("IMP: nxsd_validate is currently not set. nxsd annotations defined by you are currently not being validated.");
            XlatorHelper.logDebug("If you want that annotations defined by you should be validated or if you encounter unexpected behavior, set this flag to true.");
        }
    }

    @Override
    public XMLSchema getSchema() {
        return this.fNXSDSchema;
    }

    @Override
    public XSDElement getRootElement() {
        return this.fNXSDRootElement;
    }

    @Override
    public void setLogWriter(PrintWriter pw) {
        this.fLogWriter = pw;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.fLogWriter;
    }

    @Override
    public void translateFromNative(InputStream inputStream, Result xmlResult, TranslationContext ctx) throws TranslationException {
        try {
            this.log("Starting translateFromNative using InputStream");
            this.resetInboundTranslator(ctx);
            XMLCommons.setFieldValidation(this.fFieldValidation);
            XMLCommons.setUseArrayIdentifiers(this.fUseArrayIdentifiers);
            if (this.fDebatching) {
                boolean errorRecovery = false;
                if (ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery")) {
                    errorRecovery = ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery");
                }
                if (errorRecovery) {
                    ctx.setFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery", false);
                    this.fInputDataReader = this.createReader(inputStream);
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/reader", this.fInputDataReader);
                    if (this.fStreamType.equals("chars")) {
                        int line = Integer.parseInt((String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/line-number"));
                        int col = Integer.parseInt((String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/column-number"));
                        this.fInputDataReader.skipLines(line - 1);
                        this.fInputDataReader.skip(col - 1);
                    } else {
                        String offset = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/offset");
                        if (offset != null && offset.trim().length() > 0) {
                            this.fOffset = Integer.parseInt(offset);
                            this.fInputDataReader.skip(this.fOffset);
                        }
                    }
                } else {
                    this.fInputDataReader = (InputDataReader)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/reader");
                    if (this.fInputDataReader == null) {
                        if (this.fParseBom) {
                            BufferedInputStream bufStream = new BufferedInputStream(inputStream);
                            String encoding = XlatorHelper.getEncodingFromBOM(bufStream);
                            if (encoding != null) {
                                this.fEncoding = encoding;
                                ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding", encoding);
                            }
                            this.fInputDataReader = this.createReader(bufStream);
                        } else {
                            this.fInputDataReader = this.createReader(inputStream);
                        }
                        ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/reader", this.fInputDataReader);
                        this.skipHeaders(this.fHeaderLines, this.fHeaderLinesTerminatedBy);
                    }
                }
                String publishSize = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/publishsize");
                if (publishSize != null && publishSize.trim().length() > 0) {
                    this.fPublishSize = Integer.parseInt(publishSize);
                }
                this.skipUniqueMessageSeparator();
            } else {
                if (this.fParseBom) {
                    BufferedInputStream bufStream = new BufferedInputStream(inputStream);
                    String encoding = XlatorHelper.getEncodingFromBOM(bufStream);
                    if (encoding != null) {
                        this.fEncoding = encoding;
                        ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding", encoding);
                    }
                    this.fInputDataReader = this.createReader(bufStream);
                } else {
                    this.fInputDataReader = this.createReader(inputStream);
                }
                this.skipHeaders(this.fHeaderLines, this.fHeaderLinesTerminatedBy);
            }
            int beginBatchLineNumber = this.fInputDataReader.getLineNumber();
            int beginBatchColumnNumber = this.fInputDataReader.getColumnNumber();
            long beginOffset = this.fInputDataReader.getOffset();
            this.doTranslateFromNative(ctx, xmlResult);
            int endBatchLineNumber = this.fInputDataReader.getLineNumber();
            int endBatchColumnNumber = this.fInputDataReader.getColumnNumber();
            long endOffset = this.fInputDataReader.getOffset();
            XlatorHelper.logDebug("result validation is " + XMLCommons.getValidation());
            if (XMLCommons.getValidation()) {
                try {
                    XlatorHelper.validate(xmlResult, this.getSchema());
                }
                catch (TranslationException te) {
                    if (this.fDebatching) {
                        this.fAllCorrupt = true;
                        this.fErrorList.setAllCorrupted(this.fAllCorrupt);
                        this.fErrorList.addError(beginBatchLineNumber, beginBatchColumnNumber, endBatchLineNumber, endBatchColumnNumber, beginOffset, endOffset, te);
                    }
                    throw te;
                }
            }
            this.log("Done with translateFromNative");
        }
        catch (TranslationException te) {
            throw te;
        }
        catch (Exception ex) {
            this.logError("translateFromNative Failed with exception = " + ex.getMessage());
            throw new TranslationException(11100, new Object[]{this.fInputDataReader.getPosition(), ex.getMessage()}, ex);
        }
    }

    @Override
    public void translateFromNative(Reader reader, Result xmlResult, TranslationContext ctx) throws TranslationException {
        try {
            this.log("Starting translateFromNative using Reader");
            this.resetInboundTranslator(ctx);
            this.fStreamType = "chars";
            XMLCommons.setFieldValidation(this.fFieldValidation);
            XMLCommons.setValidation(this.fValidation);
            XMLCommons.setUseArrayIdentifiers(this.fUseArrayIdentifiers);
            if (this.fDebatching) {
                this.fXMLCommons.setMessageSeparator(this.fUniqueMessageSeparator);
                boolean errorRecovery = false;
                if (ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery")) {
                    errorRecovery = ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery");
                }
                if (errorRecovery) {
                    ctx.setFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery", false);
                    this.fInputDataReader = this.createReader(reader);
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/reader", this.fInputDataReader);
                    int line = Integer.parseInt((String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/line-number"));
                    int col = Integer.parseInt((String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/column-number"));
                    this.fInputDataReader.skipLines(line - 1);
                    this.fInputDataReader.skip(col - 1);
                } else {
                    this.fInputDataReader = (InputDataReader)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/reader");
                    if (this.fInputDataReader == null) {
                        this.fInputDataReader = this.createReader(reader);
                        ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/reader", this.fInputDataReader);
                        this.skipHeaders(this.fHeaderLines, this.fHeaderLinesTerminatedBy);
                    }
                }
                String publishSize = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/publishsize");
                if (publishSize != null && publishSize.trim().length() > 0) {
                    this.fPublishSize = Integer.parseInt(publishSize);
                }
            } else {
                this.fInputDataReader = this.createReader(reader);
                this.skipHeaders(this.fHeaderLines, this.fHeaderLinesTerminatedBy);
            }
            int beginBatchLineNumber = this.fInputDataReader.getLineNumber();
            int beginBatchColumnNumber = this.fInputDataReader.getColumnNumber();
            long beginOffset = this.fInputDataReader.getOffset();
            this.doTranslateFromNative(ctx, xmlResult);
            int endBatchLineNumber = this.fInputDataReader.getLineNumber();
            int endBatchColumnNumber = this.fInputDataReader.getColumnNumber();
            long endOffset = this.fInputDataReader.getOffset();
            XlatorHelper.logDebug("result validation is " + XMLCommons.getValidation());
            if (XMLCommons.getValidation()) {
                try {
                    XlatorHelper.validate(xmlResult, this.getSchema());
                }
                catch (TranslationException te) {
                    if (this.fDebatching) {
                        this.fAllCorrupt = true;
                        this.fErrorList.setAllCorrupted(this.fAllCorrupt);
                        this.fErrorList.addError(beginBatchLineNumber, beginBatchColumnNumber, endBatchLineNumber, endBatchColumnNumber, beginOffset, endOffset, te);
                    }
                    throw te;
                }
            }
            this.log("Done with translateFromNative");
        }
        catch (TranslationException te) {
            throw te;
        }
        catch (Exception ex) {
            this.logError("translateFromNative Failed with exception = " + ex.getMessage());
            throw new TranslationException(11100, new Object[]{this.fInputDataReader.getPosition(), ex.getMessage()}, ex);
        }
    }

    private void skipUniqueMessageSeparator() {
        if (this.fUniqueMessageSeparator != null) {
            char[] uniqueMessageSequence = this.fXMLCommons.getParsedString(this.fUniqueMessageSeparator).toCharArray();
            this.fInputDataReader.skipUniqueMessage(uniqueMessageSequence);
        }
    }

    private void resetInboundTranslator(TranslationContext ctx) {
        this.fDebatching = false;
        this.fPublishSize = 1;
        this.fCurrentSize = 0;
        this.fStack = new Stack();
        this.fCorruptMessage = false;
        this.fAllCorrupt = true;
        this.fEndColumnNumber = -1;
        this.fEndLineNumber = -1;
        this.fEndOffset = -1;
        this.fEventQueue = new Vector();
        this.fErrorList = new ErrorList();
        this.fVariableSupport = new VariableSupport(ctx, false, this.fEncodeLineTerminators);
        this.fXMLCommons = new XMLCommons(this.fVariableSupport);
        this.fXMLCommons.setXlationMode(this.fXlationMode);
        XMLCommons.setFieldValidation(this.fFieldValidation);
        XMLCommons.setValidation(this.fValidation);
        XMLCommons.setUseArrayIdentifiers(this.fUseArrayIdentifiers);
        this.fXMLCommons.setNormalizeLineTerminators(this.fNormalizeLineTerminators);
        this.fBatching = false;
        this.fIsFirstMessageInBatch = false;
        this.fIsLastMessageInBatch = false;
        if (ctx != null && ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-file-name") != null) {
            this.fXMLCommons.setFileName((String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-file-name"));
        }
        if (ctx != null && ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding") != null) {
            this.fEncoding = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding");
        }
        if (ctx != null && ctx.getProperty("byteOrder") != null) {
            this.fByteOrder = (String)ctx.getProperty("byteOrder");
        }
        if (ctx != null && ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/debatching")) {
            this.fDebatching = ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/debatching");
        }
        if (ctx != null && ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/batching")) {
            this.fBatching = ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/batching");
        }
        if (ctx != null && ctx.hasFeature("parseBom")) {
            this.fParseBom = ctx.getFeature("parseBom");
        }
        if (this.fBatching) {
            if (ctx != null && ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/batching/firstmessage")) {
                this.fIsFirstMessageInBatch = ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/batching/firstmessage");
            }
            if (ctx != null && ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/batching/lastmessage")) {
                this.fIsLastMessageInBatch = ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/batching/lastmessage");
            }
        }
        this.resetDataFragmentHandler();
    }

    private void resetDataFragmentHandler() {
        this.fDataFragmentHandlerContext.fByteOrder = this.fByteOrder;
        this.fDataFragmentHandlerContext.fEncoding = this.fEncoding;
        this.fDataFragmentHandlerContext.fStreamType = this.fStreamType;
    }

    public void doTranslateFromNative(TranslationContext ctx, Result xmlResult) throws TranslationException {
        try {
            this.fBeginOffset = this.fInputDataReader.getOffset();
            this.fBeginLineNumber = this.fInputDataReader.getLineNumber();
            this.fBeginColumnNumber = this.fInputDataReader.getColumnNumber();
            this.fStyleBasedFormatter = new NXSDStyleBasedFormatter(this.fXMLCommons);
            this.fStyleBasedReader = new NXSDStyleBasedReader(this.fInputDataReader, this.fXMLCommons);
            this.fXMLBuilder = new XMLBuilder(xmlResult);
            this.fXMLBuilder.startDocument();
            this.parseNXSD(this.fElementDefinition);
            this.fXMLBuilder.endDocument();
            if (this.fDebatching) {
                this.fErrorList.setAllCorrupted(this.fAllCorrupt);
                ctx.setFeature("http://xmlns.oracle.com/pcbpel/nxsd/properties/end-of-file", this.fInputDataReader.isEof());
                ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/error-list", this.fErrorList);
                if (this.fUniqueMessageSeparator == null && this.fCorruptMessage) {
                    ctx.setFeature("http://xmlns.oracle.com/pcbpel/nxsd/properties/end-of-file", true);
                    if (this.fStreamType.equals("chars")) {
                        ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/line-number", EMPTY_STRING + this.fErrorList.getStartLineNumber(0));
                        ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/column-number", EMPTY_STRING + this.fErrorList.getStartColumnNumber(0));
                    } else {
                        ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/offset", EMPTY_STRING + this.fErrorList.getBeginOffset(0));
                    }
                } else if (this.fStreamType.equals("chars")) {
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/line-number", EMPTY_STRING + this.fInputDataReader.getLineNumber());
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/column-number", EMPTY_STRING + this.fInputDataReader.getColumnNumber());
                } else {
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/offset", EMPTY_STRING + this.fInputDataReader.getOffset());
                }
            }
            if (ctx != null && this.fEncoding != null) {
                ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/native-data-encoding", this.fEncoding);
            }
        }
        catch (TranslationException te) {
            if (!this.fDebatching) {
                if (this.fStreamType.equals("chars")) {
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/line-number", EMPTY_STRING + this.fInputDataReader.getLineNumber());
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/column-number", EMPTY_STRING + this.fInputDataReader.getColumnNumber());
                } else {
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/offset", EMPTY_STRING + this.fInputDataReader.getOffset());
                }
            }
            throw te;
        }
        catch (Exception ex) {
            this.logError("translateFromNative Failed with exception = " + ex.getMessage());
            if (!this.fDebatching) {
                if (this.fStreamType.equals("chars")) {
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/line-number", EMPTY_STRING + this.fInputDataReader.getLineNumber());
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/column-number", EMPTY_STRING + this.fInputDataReader.getColumnNumber());
                } else {
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/offset", EMPTY_STRING + this.fInputDataReader.getOffset());
                }
            }
            throw new TranslationException(11100, new Object[]{this.fInputDataReader.getPosition(), ex.getMessage()}, ex);
        }
    }

    @Override
    public void translateToNative(Source xmlSource, OutputStream outputStream, TranslationContext ctx) throws TranslationException {
        try {
            this.log("Starting translateToNative using output stream");
            if (xmlSource == null) {
                throw new TranslationException(11154);
            }
            if (xmlSource instanceof DOMSource && ((DOMSource)xmlSource).getNode() == null) {
                throw new TranslationException(11155);
            }
            this.resetOutboundTranslator(ctx);
            this.fUseArrayIdentifiers = this.schemaDef.getUseArrayIdentifiers();
            XMLCommons.setUseArrayIdentifiers(this.fUseArrayIdentifiers);
            this.fOutputDataWriter = new ByteDataWriterImpl(outputStream, this.fEncoding);
            this.doOutboundTranslation(xmlSource);
            this.log("Done with translateToNative");
        }
        catch (TranslationException te) {
            throw te;
        }
        catch (Exception ex) {
            this.logError("translateToNative Failed with exception = " + ex.getMessage());
            throw new TranslationException(11101, new Object[]{ex.getMessage()}, ex);
        }
    }

    @Override
    public void translateToNative(Source xmlSource, Writer writer, TranslationContext ctx) throws TranslationException {
        try {
            this.log("Starting translateToNative using writer");
            this.resetOutboundTranslator(ctx);
            this.fOutputDataWriter = new CharDataWriterImpl(writer);
            this.doOutboundTranslation(xmlSource);
            this.log("Done with translateToNative");
        }
        catch (TranslationException te) {
            throw te;
        }
        catch (Exception ex) {
            this.logError("translateToNative Failed with exception = " + ex.getMessage());
            throw new TranslationException(11101, new Object[]{ex.getMessage()}, ex);
        }
    }

    private void resetOutboundTranslator(TranslationContext ctx) {
        this.fLastElement = null;
        this.fParentElement = null;
        this.fCurrentElement = null;
        this.fStack = new Stack();
        this.fElementDefinition = new NativeDataDefinition();
        this.fCurrentElementDefinition = new NativeDataDefinition();
        this.fParentCTDefinition = new NativeDataDefinition();
        this.fVariableSupport = new VariableSupport(ctx, true, this.fEncodeLineTerminators);
        this.fXMLCommons = new XMLCommons(this.fVariableSupport);
        this.fXMLCommons.setNormalizeLineTerminators(this.fNormalizeLineTerminators);
        this.fStyleBasedFormatter = new NXSDStyleBasedFormatter(this.fXMLCommons);
        this.fCharEventBuffer = null;
        this.fLastEvent = (short)-1;
        this.fCurrentEvent = (short)-1;
        this.fXMLCommons.setXlationMode(this.fXlationMode);
        if (ctx != null && ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/output-encoding") != null) {
            this.fEncoding = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/output-encoding");
        }
        if (ctx != null && ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/outbound-header-property") != null) {
            this.fOutboundHeader = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/outbound-header-property");
        }
        if (ctx != null && ctx.getProperty("byteOrder") != null) {
            this.fByteOrder = (String)ctx.getProperty("byteOrder");
        }
        this.resetDataFragmentHandler();
    }

    public ContentHandler getContentHandler(OutputStream os, TranslationContext ctx) throws TranslationException {
        try {
            this.log("Starting getContentHandler...");
            this.resetOutboundTranslator(ctx);
            this.fOutputDataWriter = new ByteDataWriterImpl(os, this.fEncoding);
            if (this.fOutboundHeader != null) {
                this.fOutboundHeader = this.fXMLCommons.getParsedString(this.fOutboundHeader);
                this.fOutputDataWriter.writeString(this.fOutboundHeader);
            }
            this.fXMLError = new XMLError();
            this.fXSDValidator = new XSDValidator();
            this.fXSDValidator.setXMLProperty("fixedSchema", (Object)this.fNXSDSchema);
            this.fXSDValidator.setError(this.fXMLError);
            this.fXSDValidator.addContentHandler((ContentHandler)this);
            this.log("Done with getContentHandler");
            return this.fXSDValidator;
        }
        catch (TranslationException te) {
            throw te;
        }
        catch (Exception ex) {
            this.logError("translateToNative Failed with exception = " + ex.getMessage());
            throw new TranslationException(11101, new Object[]{ex.getMessage()}, ex);
        }
    }

    public void doOutboundTranslation(Source xmlSource) throws TranslationException {
        try {
            if (this.fOutboundHeader != null) {
                this.fOutboundHeader = this.fXMLCommons.getParsedString(this.fOutboundHeader);
                this.fOutputDataWriter.writeString(this.fOutboundHeader);
            }
            this.fXMLError = new XMLError();
            this.fXSDValidator = new XSDValidator();
            this.fXSDValidator.setXMLProperty("fixedSchema", (Object)this.fNXSDSchema);
            this.fXSDValidator.setError(this.fXMLError);
            this.fXSDValidator.addContentHandler((ContentHandler)this);
            this.fXMLTokenizer = new XMLTokenizer(xmlSource);
            this.fXMLTokenizer.setHandler((ContentHandler)this.fXSDValidator);
            this.fXMLTokenizer.tokenize();
            this.log("Done with translateToNative");
        }
        catch (TranslationException te) {
            throw te;
        }
        catch (Exception ex) {
            this.logError("translateToNative Failed with exception = " + ex.getMessage());
            throw new TranslationException(11101, new Object[]{ex.getMessage()}, ex);
        }
    }

    private InputDataReader createReader(InputStream inputStream) throws TranslationException {
        if (this.fStreamType != null) {
            if (this.fStreamType.equals("chars")) {
                CharDataReaderImpl reader = new CharDataReaderImpl(inputStream, this.fEncoding, this.fNormalizeLineTerminators);
                reader.setMessageSeparator(this.fXMLCommons.getCharsMessageSeparator());
                return reader;
            }
            return new ByteDataReaderImpl(inputStream, this.fEncoding);
        }
        return null;
    }

    private InputDataReader createReader(BufferedInputStream inputStream) throws TranslationException {
        if (this.fStreamType != null) {
            if (this.fStreamType.equals("chars")) {
                CharDataReaderImpl reader = new CharDataReaderImpl(inputStream, this.fEncoding, this.fNormalizeLineTerminators);
                reader.setMessageSeparator(this.fXMLCommons.getCharsMessageSeparator());
                return reader;
            }
            return new ByteDataReaderImpl(inputStream, this.fEncoding);
        }
        return null;
    }

    private InputDataReader createReader(Reader reader) throws TranslationException {
        CharDataReaderImpl dataReader = new CharDataReaderImpl(reader, this.fNormalizeLineTerminators);
        dataReader.setMessageSeparator(this.fXMLCommons.getCharsMessageSeparator());
        return dataReader;
    }

    private void skipHeaders(String headerLines, String headerLinesTerminatedBy) throws TranslationException {
        try {
            if (headerLines != null) {
                int lines = Integer.parseInt(headerLines);
                if (headerLinesTerminatedBy != null) {
                    char[] charsTerminatedBy = this.fXMLCommons.getParsedChars(headerLinesTerminatedBy);
                    long skipped = -1L;
                    StringBuffer flag = null;
                    for (int i = 0; i < lines; ++i) {
                        flag = new StringBuffer();
                        skipped = this.fInputDataReader.skipUntil(charsTerminatedBy, flag);
                        if (skipped != -1L && flag.length() != 0) continue;
                        throw new TranslationException(11179, new Object[]{this.fInputDataReader.getPosition(), headerLinesTerminatedBy, "schema", "headerLines", headerLines, "headerLinesTerminatedBy", headerLinesTerminatedBy});
                    }
                } else {
                    this.fInputDataReader.skipLines(lines);
                }
            }
        }
        catch (IOException ioe) {
            throw new TranslationException(11178, new Object[]{this.fInputDataReader.getPosition(), "schema", "headerLines", headerLines, ioe.getMessage()}, ioe);
        }
    }

    private void skipLookedPortion(NativeDataDefinition def) throws IOException {
        int skip_len = 0;
        int id_len = 0;
        if (def.getLookAhead() == null) {
            skip_len = this.fInputDataReader.getScanLength() - 1;
        } else {
            skip_len = Integer.parseInt(def.getLookAhead());
            id_len = 0;
            id_len = def.getLookForPattern() == null ? def.getLookFor().length() : (def.getLookFor() == null && def.getScanLength() == null ? def.getLookForPattern().length() : Integer.parseInt(def.getScanLength()));
        }
        this.fInputDataReader.skip(skip_len + id_len + 1);
    }

    private void parseNXSD(NativeDataDefinition def) throws TranslationException, SAXException, IOException {
        int minOccurs = 1;
        int maxOccurs = 1;
        int cardinality = 0;
        minOccurs = def.getMinOccurs();
        maxOccurs = def.getMaxOccurs();
        try {
            if (minOccurs == 0 && def.getStartsWith() == null ^ (def.getLookAhead() == null || def.getLookFrom() == null) && def.getNxsdNode().getNodeType() == 3 && ((XSDElement)def.getNxsdNode()).getType().getNodeType() != 2 && ((XSDElement)def.getNxsdNode()).getType().getNodeType() != 1) {
                throw new TranslationException(11140, new Object[]{def.getNxsdNodeAsXML()});
            }
            if (def.getArrayLength() != null || def.getArrayIdentifierLength() != null) {
                int size;
                minOccurs = maxOccurs = (size = Integer.parseInt(this.readArrayStyle(def)));
            }
            this.fVariableSupport.pushContext();
            while (cardinality < maxOccurs && this.continueLoop(def)) {
                if (!this.isLookAheadMatched(def)) {
                    if (!this.isChoiceCase(def)) {
                        this.skipLookedPortion(def);
                        --cardinality;
                    }
                } else {
                    this.doLookAheads(def);
                    if (def.getSkipMode() == null || "before".equals(def.getSkipMode()) || "both".equals(def.getSkipMode())) {
                        this.doSkip(def);
                    }
                    if (def.isElement()) {
                        this.processElement(def);
                    }
                    if (def.isComplexType()) {
                        this.processComplexType(def);
                    }
                    if (def.isGroup()) {
                        this.processGroup(def);
                    }
                    if (this.terminateLoop(def.getNxsdNode(), def)) {
                        ++cardinality;
                        break;
                    }
                    if ("after".equals(def.getSkipMode()) || "both".equals(def.getSkipMode())) {
                        this.doSkip(def);
                    }
                }
                ++cardinality;
            }
            this.fVariableSupport.popContext();
            if (!(cardinality >= minOccurs || this.fCorruptMessage || def.getParentDefinition() != null && def.getParentDefinition().getNxsdNode().getNodeType() == 5 && ((XSDGroup)def.getParentDefinition().getNxsdNode()).getOrder() == 1 || def.getStartsWith() != null || def.getLookAhead() != null)) {
                throw new TranslationException(11117, new Object[]{String.valueOf(minOccurs), def.getNxsdNodeAsXML(), String.valueOf(cardinality)});
            }
        }
        catch (TranslationException te) {
            if (this.fDebatching) {
                this.fCorruptMessage = true;
                this.fCurrentException = te;
                if (this.fEndLineNumber != -1) {
                    this.fErrorList.addError(this.fBeginLineNumber, this.fBeginColumnNumber, this.fEndLineNumber, this.fEndColumnNumber, this.fBeginOffset, this.fEndOffset, this.fCurrentException);
                }
                return;
            }
            throw te;
        }
    }

    private boolean conditionMatch(String value, String expr) throws TranslationException {
        boolean result = false;
        String originalExpr = expr;
        try {
            if (expr.indexOf(41) < 0) {
                return value.equals(expr);
            }
            String operand = null;
            String operator = null;
            String condition = null;
            String booleanOperator = null;
            expr = expr.trim();
            while (expr.indexOf(41) > 0) {
                if (expr.charAt(0) == '(') {
                    condition = expr.substring(1, expr.indexOf(41)).trim();
                } else {
                    booleanOperator = expr.substring(0, expr.indexOf(32)).trim();
                    condition = expr.substring(expr.indexOf(40) + 1, expr.indexOf(41)).trim();
                }
                expr = expr.indexOf(41) + 1 == expr.length() ? EMPTY_STRING : expr.substring(expr.indexOf(41) + 1).trim();
                operator = condition.substring(0, 2);
                operand = condition.substring(2).trim();
                if (operator.equals("==")) {
                    if (booleanOperator == null) {
                        result = value.equals(operand);
                        continue;
                    }
                    if (booleanOperator.equalsIgnoreCase("OR")) {
                        result = result || value.equals(operand);
                        continue;
                    }
                    if (!booleanOperator.equalsIgnoreCase("AND")) continue;
                    result = result && value.equals(operand);
                    continue;
                }
                if (operator.equals("!=")) {
                    if (booleanOperator == null) {
                        result = !value.equals(operand);
                        continue;
                    }
                    if (booleanOperator.equalsIgnoreCase("OR")) {
                        result = result || !value.equals(operand);
                        continue;
                    }
                    if (!booleanOperator.equalsIgnoreCase("AND")) continue;
                    result = result && !value.equals(operand);
                    continue;
                }
                throw new TranslationException(11120, new Object[]{operator, originalExpr});
            }
        }
        catch (Exception ex) {
            throw new TranslationException(11121, new Object[]{originalExpr}, ex);
        }
        return result;
    }

    private void raiseStartElement(String namespaceURI, String localName, String qName, Attributes atts, XSDNode node) throws SAXException {
        if (this.fBatching && node == this.fNXSDRootElement) {
            if (this.fIsFirstMessageInBatch) {
                this.fXMLBuilder.startElement(namespaceURI, localName, qName, atts);
            }
        } else if (this.fDebatching && node != this.fNXSDRootElement) {
            this.fXMLBuilder.queueStartElement(namespaceURI, localName, qName, atts);
        } else {
            this.fXMLBuilder.startElement(namespaceURI, localName, qName, atts);
        }
    }

    private void raiseCharacters(char[] ch, int start, int length, XSDNode node) throws SAXException {
        if (this.fDebatching && node != this.fNXSDRootElement) {
            this.fXMLBuilder.queueCharacters(ch, start, length);
        } else {
            this.fXMLBuilder.characters(ch, start, length);
        }
    }

    private void raiseEndElement(String namespaceURI, String localName, String qName, XSDNode node) throws SAXException {
        if (this.fBatching && node == this.fNXSDRootElement) {
            if (this.fIsLastMessageInBatch) {
                this.fXMLBuilder.endElement(namespaceURI, localName, qName);
            }
        } else if (this.fDebatching && node != this.fNXSDRootElement) {
            this.fXMLBuilder.queueEndElement(namespaceURI, localName, qName);
        } else {
            this.fXMLBuilder.endElement(namespaceURI, localName, qName);
        }
    }

    private boolean isChoiceCase(NativeDataDefinition def) {
        Object pnode = null;
        pnode = def.getNxsdNode().getDomNode();
        if (pnode != null) {
            pnode = pnode.getParentNode();
            XlatorHelper.logDebug("Parent Node NAme : " + pnode.getNodeName());
            if (pnode != null && pnode.getNodeName().endsWith("choice")) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLookAheadMatched(NativeDataDefinition def) throws TranslationException {
        String scanLength;
        String lookForPattern;
        String lookFor;
        String lookAhead;
        block23: {
            lookAhead = def.getLookAhead();
            lookFor = def.getLookFor();
            lookForPattern = def.getLookForPattern();
            scanLength = def.getScanLength();
            String lookFrom = def.getLookFrom();
            String lookTill = def.getLookTill();
            if (lookFrom != null) {
                char[] chars;
                if (lookFor != null) {
                    try {
                        chars = this.fXMLCommons.getParsedChars(lookFor);
                        if (!"chars".equals(this.fStreamType)) throw new TranslationException(11125, new Object[]{lookAhead, "lookFrom", def.getNxsdNodeAsXML()});
                        if (!this.fInputDataReader.lookAheadForMatch(this.fXMLCommons.getParsedString(lookFrom), this.fXMLCommons.getParsedString(lookTill), this.fXMLCommons.getParsedString(lookFor))) {
                            return false;
                        }
                        break block23;
                    }
                    catch (NumberFormatException nfe) {
                        throw new TranslationException(11130, new Object[]{lookAhead, "lookAhead", def.getNxsdNodeAsXML()}, nfe);
                    }
                    catch (IOException ioe) {
                        throw new TranslationException(11177, new Object[]{this.fInputDataReader.getPosition(), def.getNxsdNodeAsXML(), "lookAhead", lookAhead, ioe.getMessage()}, ioe);
                    }
                }
                if (lookForPattern != null) {
                    try {
                        chars = this.fXMLCommons.getParsedChars(lookForPattern);
                        if (!"chars".equals(this.fStreamType)) throw new TranslationException(11125, new Object[]{lookAhead, "lookFrom", def.getNxsdNodeAsXML()});
                        if (!this.fInputDataReader.lookAheadForMatch(this.fXMLCommons.getParsedString(lookFrom), this.fXMLCommons.getParsedString(lookTill), this.fXMLCommons.getParsedString(lookForPattern))) {
                            return false;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new TranslationException(11130, new Object[]{lookAhead, "lookAhead", def.getNxsdNodeAsXML()}, nfe);
                    }
                    catch (IOException ioe) {
                        throw new TranslationException(11177, new Object[]{this.fInputDataReader.getPosition(), def.getNxsdNodeAsXML(), "lookAhead", lookAhead, ioe.getMessage()}, ioe);
                    }
                }
            }
        }
        if (lookAhead == null) return true;
        if (lookFor != null) {
            try {
                int lookAheadLength = Integer.parseInt(this.fXMLCommons.getParsedString(lookAhead));
                char[] chars = this.fXMLCommons.getParsedChars(lookFor);
                if ("chars".equals(this.fStreamType)) {
                    if (this.fInputDataReader.lookAheadForMatch(lookAheadLength, chars)) return true;
                    return false;
                }
                byte[] bytes = null;
                bytes = this.fEncoding != null ? new String(chars).getBytes(this.fEncoding) : new String(chars).getBytes();
                if (this.fInputDataReader.lookAheadForMatch(lookAheadLength, bytes)) return true;
                return false;
            }
            catch (NumberFormatException nfe) {
                throw new TranslationException(11130, new Object[]{lookAhead, "lookAhead", def.getNxsdNodeAsXML()}, nfe);
            }
            catch (IOException ioe) {
                throw new TranslationException(11177, new Object[]{this.fInputDataReader.getPosition(), def.getNxsdNodeAsXML(), "lookAhead", lookAhead, ioe.getMessage()}, ioe);
            }
        }
        if (lookForPattern == null) return true;
        int charLen = 0;
        charLen = scanLength == null ? lookForPattern.length() : Integer.parseInt(scanLength);
        try {
            int lookAheadLength = Integer.parseInt(this.fXMLCommons.getParsedString(lookAhead));
            char[] chars = this.fXMLCommons.getParsedChars(lookForPattern);
            if ("chars".equals(this.fStreamType)) {
                if (this.fInputDataReader.lookAheadForMatch(lookAheadLength, chars, charLen)) return true;
                return false;
            } else {
                byte[] bytes = null;
                bytes = this.fEncoding != null ? new String(chars).getBytes(this.fEncoding) : new String(chars).getBytes();
                if (this.fInputDataReader.lookAheadForMatch(lookAheadLength, bytes, charLen)) return true;
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            throw new TranslationException(11130, new Object[]{lookAhead, "lookAhead", def.getNxsdNodeAsXML()}, nfe);
        }
        catch (IOException ioe) {
            throw new TranslationException(11177, new Object[]{this.fInputDataReader.getPosition(), def.getNxsdNodeAsXML(), "lookAhead", lookAhead, ioe.getMessage()}, ioe);
        }
    }

    private boolean continueLoop(NativeDataDefinition def) throws TranslationException, IOException {
        String startsWith = def.getStartsWith();
        String arrayTerminatedBy = def.getArrayTerminatedBy();
        boolean ret = true;
        if (this.isEndOfFile()) {
            ret = false;
        }
        if (this.fMaxLineNumber != -1 && this.fInputDataReader.getLineNumber() > this.fMaxLineNumber) {
            ret = false;
        }
        if (this.fDebatching) {
            if (this.fCorruptMessage) {
                ret = false;
            } else if (this.fCurrentSize == this.fPublishSize) {
                ret = false;
            }
        }
        if (ret && startsWith != null) {
            char[] chars = this.fXMLCommons.getParsedChars(startsWith);
            try {
                if (!this.fInputDataReader.exists(chars)) {
                    ret = false;
                } else {
                    this.fInputDataReader.skip(chars.length);
                }
            }
            catch (IOException ioe) {
                throw new TranslationException(11177, new Object[]{this.fInputDataReader.getPosition(), def.getNxsdNodeAsXML(), "startsWith", startsWith, ioe.getMessage()}, ioe);
            }
        }
        if (!ret && arrayTerminatedBy != null) {
            char[] charsTerminatedBy = this.fXMLCommons.getParsedChars(arrayTerminatedBy);
            if (this.fInputDataReader != null && this.fInputDataReader.exists(charsTerminatedBy)) {
                this.fInputDataReader.skip(charsTerminatedBy.length);
            }
        }
        return ret;
    }

    private void doLookAheads(NativeDataDefinition def) throws TranslationException {
        this.fStyleBasedReader.readLookAhead(def);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSkip(NativeDataDefinition def) throws TranslationException {
        String skip = def.getSkip();
        String skipUntil = def.getSkipUntil();
        String skipLines = def.getSkipLines();
        long skipped = -1L;
        StringBuffer flag = null;
        try {
            if (skip != null) {
                skipped = this.fInputDataReader.skip(Integer.parseInt(skip));
                if (skipped == -1L || skipped >= (long)Integer.parseInt(skip)) return;
                return;
            }
            if (skipUntil != null) {
                flag = new StringBuffer();
                skipped = this.fInputDataReader.skipUntil(this.fXMLCommons.getParsedChars(skipUntil), flag);
                if (skipped == -1L || flag.length() != 0) return;
                return;
            }
            if (skipLines == null) return;
            flag = new StringBuffer();
            skipped = this.fInputDataReader.skipLines(Integer.parseInt(skipLines));
            if (skipped != -1L && flag.length() != 0) return;
        }
        catch (IOException ioe) {
            String s1 = null;
            String s2 = null;
            if (skip != null) {
                s1 = "skip";
                s2 = skip;
                throw new TranslationException(11178, new Object[]{this.fInputDataReader.getPosition(), def.getNxsdNodeAsXML(), s1, s2, ioe.getMessage()}, ioe);
            } else if (skipUntil != null) {
                s1 = "skipUntil";
                s2 = skipUntil;
                throw new TranslationException(11178, new Object[]{this.fInputDataReader.getPosition(), def.getNxsdNodeAsXML(), s1, s2, ioe.getMessage()}, ioe);
            } else {
                s1 = "skipLines";
                s2 = skipLines;
            }
            throw new TranslationException(11178, new Object[]{this.fInputDataReader.getPosition(), def.getNxsdNodeAsXML(), s1, s2, ioe.getMessage()}, ioe);
        }
    }

    private boolean processVariables(XSDNode node) {
        return this.processVariables(node, null);
    }

    private boolean processVariables(XSDNode node, String value) {
        Vector appinfoNodes;
        XSDAnnotation annotation = node.getAnnotation();
        if (annotation != null && (appinfoNodes = annotation.getApplicationInformation()) != null) {
            Node appinfoNode = null;
            for (int i = 0; i < appinfoNodes.size(); ++i) {
                appinfoNode = (Node)appinfoNodes.get(i);
                NodeList children = appinfoNode.getChildNodes();
                Node child = null;
                for (int j = 0; j < children.getLength(); ++j) {
                    child = children.item(j);
                    if (!"http://xmlns.oracle.com/pcbpel/nxsd".equals(child.getNamespaceURI()) || !"variables".equals(child.getLocalName())) continue;
                    this.fVariableSupport.declareVariables(child, value);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean terminateLoop(XSDNode node, NativeDataDefinition def) throws TranslationException, SAXException {
        String cellSeparatedBy = def.getCellSeparatedBy();
        String arrayTerminatedBy = def.getArrayTerminatedBy();
        try {
            if (this.fDebatching && !this.fStack.empty()) {
                this.fParentElement = (XSDElement)this.fStack.peek();
                if (this.fParentElement == this.fNXSDRootElement && node.getNodeType() == 3) {
                    if (this.fCorruptMessage) {
                        if (this.fUniqueMessageSeparator != null) {
                            this.ignoreUniqueMessage(def);
                        }
                        this.fErrorList.addError(this.fBeginLineNumber, this.fBeginColumnNumber, this.fEndLineNumber, this.fEndColumnNumber, this.fBeginOffset, this.fEndOffset, this.fCurrentException);
                        this.fXMLBuilder.clearEvents();
                        if (this.fUniqueMessageSeparator == null) {
                            return true;
                        }
                        this.fBeginLineNumber = this.fInputDataReader.getLineNumber();
                        this.fBeginColumnNumber = this.fInputDataReader.getColumnNumber();
                        this.fBeginOffset = this.fInputDataReader.getOffset();
                        this.fEndColumnNumber = -1;
                        this.fEndLineNumber = -1;
                        this.fEndOffset = -1;
                        this.fCorruptMessage = false;
                        this.fXMLCommons.setEndOfMessage(false);
                        this.fCurrentException = null;
                        return this.isEndOfFile();
                    }
                    this.fXMLBuilder.flushEvents();
                    ++this.fCurrentSize;
                    this.fAllCorrupt = false;
                    this.fBeginLineNumber = this.fInputDataReader.getLineNumber();
                    this.fBeginColumnNumber = this.fInputDataReader.getColumnNumber();
                    this.fBeginOffset = this.fInputDataReader.getOffset();
                    this.fEndColumnNumber = -1;
                    this.fEndLineNumber = -1;
                    this.fEndOffset = -1;
                }
            }
            if (this.isEndOfFile()) {
                return true;
            }
            if (def.isArray() && def.getArrayIdentifierLength() == null) {
                if (def.isGroup() || def.isElement() && ((XSDElement)def.getNxsdNode()).getType().getNodeType() == 1) {
                    this.readArrayStyle(def);
                }
                if (def.isLastCell()) {
                    return true;
                }
            }
            if (this.isEndOfFile()) {
                return true;
            }
            if (this.fDebatching) {
                if (!this.fStack.empty()) {
                    this.fParentElement = (XSDElement)this.fStack.peek();
                    if (this.fParentElement == this.fNXSDRootElement && node.getNodeType() == 3) {
                        this.skipUniqueMessageSeparator();
                        this.fBeginLineNumber = this.fInputDataReader.getLineNumber();
                        this.fBeginColumnNumber = this.fInputDataReader.getColumnNumber();
                        this.fBeginOffset = this.fInputDataReader.getOffset();
                        this.fEndColumnNumber = -1;
                        this.fEndLineNumber = -1;
                        this.fEndOffset = -1;
                    }
                }
                if (this.fCurrentSize == this.fPublishSize) {
                    return true;
                }
            }
            if (this.isEndOfFile()) {
                return true;
            }
        }
        catch (TranslationException te) {
            if (this.fDebatching) {
                this.fCorruptMessage = true;
                this.fCurrentException = te;
            }
            throw te;
        }
        return false;
    }

    private boolean isEndOfFile() {
        try {
            return this.fInputDataReader.isEof();
        }
        catch (IOException iOException) {
            return true;
        }
    }

    private void ignoreMessage(NativeDataDefinition def) {
        try {
            if (this.fXMLCommons.isEndOfMessage()) {
                this.fEndLineNumber = this.fInputDataReader.getLineNumber();
                this.fEndColumnNumber = this.fInputDataReader.getColumnNumber();
                this.fEndOffset = this.fInputDataReader.getOffset();
            } else if (this.fXMLCommons.getMessageSeparator() != null) {
                StringBuffer flag = new StringBuffer();
                this.skipUntilMessageSeparator(this.fXMLCommons.getMessageSeparator());
                this.fEndLineNumber = this.fInputDataReader.getLineNumber();
                this.fEndColumnNumber = this.fInputDataReader.getColumnNumber();
                this.fEndOffset = this.fInputDataReader.getOffset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ignoreUniqueMessage(NativeDataDefinition def) {
        try {
            if (this.fXMLCommons.isEndOfMessage()) {
                this.fEndLineNumber = this.fInputDataReader.getLineNumber();
                this.fEndColumnNumber = this.fInputDataReader.getColumnNumber();
                this.fEndOffset = this.fInputDataReader.getOffset();
            } else if (this.fUniqueMessageSeparator != null) {
                StringBuffer flag = new StringBuffer();
                this.skipUntilMessageSeparator(this.fUniqueMessageSeparator);
                this.fEndLineNumber = this.fInputDataReader.getLineNumber();
                this.fEndColumnNumber = this.fInputDataReader.getColumnNumber();
                this.fEndOffset = this.fInputDataReader.getOffset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readMessageSeparator() {
        char[] msgSeparator = this.fXMLCommons.getCharsMessageSeparator();
        if (msgSeparator != null) {
            try {
                ((CharDataReaderImpl)this.fInputDataReader).setMessageSeparator(null);
                ((CharDataReaderImpl)this.fInputDataReader).skip(msgSeparator.length);
                ((CharDataReaderImpl)this.fInputDataReader).setMessageSeparator(msgSeparator);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void skipUntilMessageSeparator(String untilSeq) {
        char[] msgSeparator = this.fXMLCommons.getParsedString(untilSeq).toCharArray();
        if (msgSeparator != null) {
            try {
                ((CharDataReaderImpl)this.fInputDataReader).setMessageSeparator(null);
                ((CharDataReaderImpl)this.fInputDataReader).skipUntil(msgSeparator, new StringBuffer());
                ((CharDataReaderImpl)this.fInputDataReader).setMessageSeparator(msgSeparator);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String readFixedLengthStyle(NativeDataDefinition def) throws TranslationException {
        String text = this.fStyleBasedReader.readFixedLengthStyle(def);
        return this.fStyleBasedFormatter.formatFixedLengthStyleFromNative(text, def);
    }

    private String readSurroundedStyle(NativeDataDefinition def) throws TranslationException {
        String text = this.fStyleBasedReader.readSurroundedStyle(def);
        return this.fStyleBasedFormatter.formatSurroundedStyleFromNative(text, def);
    }

    private String readTerminatedStyle(NativeDataDefinition def) throws TranslationException {
        String text = this.fStyleBasedReader.readTerminatedStyle(def);
        return this.fStyleBasedFormatter.formatTerminatedStyleFromNative(text, def);
    }

    private String readListStyle(NativeDataDefinition def, NativeDataDefinition grandDef) throws TranslationException {
        String text = this.fStyleBasedReader.readListStyle(def, grandDef);
        return this.fStyleBasedFormatter.formatListStyleFromNative(text, def);
    }

    private String readArrayStyle(NativeDataDefinition def) throws TranslationException {
        String text = this.fStyleBasedReader.readArrayStyle(def);
        return this.fStyleBasedFormatter.formatArrayStyleFromNative(text, def);
    }

    private String readChoiceCondition(NativeDataDefinition def) throws TranslationException {
        String text = this.fStyleBasedReader.readChoiceCondition(def);
        return this.fStyleBasedFormatter.formatChoiceConditionFromNative(text, def);
    }

    private String readNativeData(NativeDataDefinition def) throws TranslationException {
        String text;
        block9: {
            text = null;
            NativeDataDefinition parentDef = def.getParentDefinition();
            NativeDataDefinition grandParentDef = parentDef.getParentDefinition();
            try {
                if (grandParentDef != null && grandParentDef.isList()) {
                    text = this.readListStyle(def, grandParentDef);
                    break block9;
                }
                if (def.isFixedLength()) {
                    text = this.readFixedLengthStyle(def);
                    break block9;
                }
                if (def.isSurrounded()) {
                    text = this.readSurroundedStyle(def);
                    break block9;
                }
                if (def.isTerminated()) {
                    text = this.readTerminatedStyle(def);
                    break block9;
                }
                if (def.isArray()) {
                    text = this.readArrayStyle(def);
                    break block9;
                }
                DataFragmentHandler handler = this.getHandler(def.getExtStyle());
                if (handler != null) {
                    Attributes atts = this.getAttributesFromSchemaNode(def.getNxsdNode());
                    this.fDataFragmentHandlerContext.setProperty("current.node", def.getNxsdNode());
                    text = handler.readFromNative(this.fInputDataReader, atts, this.fDataFragmentHandlerContext);
                    break block9;
                }
                throw new TranslationException(11174, new Object[]{this.fInputDataReader.getPosition(), def.getSchemaConstruct(), def.getExtStyle()});
            }
            catch (TranslationException te) {
                if (this.fDebatching) {
                    this.fCorruptMessage = true;
                    this.fCurrentException = te;
                }
                throw te;
            }
        }
        NXSDFieldValidator.validate(def, text, this.fInputDataReader);
        return text;
    }

    private DataFragmentHandler getHandler(String style) {
        DataFragmentHandler handler = null;
        try {
            String className;
            String styleName = "oracle.bpelpm.xlators.styles." + style;
            handler = (DataFragmentHandler)this.fHandlers.get(styleName);
            if (handler == null && (className = fHandlerProperties.getProperty(styleName)) != null) {
                Class<?> theClass = Class.forName(className);
                handler = (DataFragmentHandler)theClass.newInstance();
                this.fHandlers.put(style, handler);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler;
    }

    private Attributes getAttributesFromSchemaNode(XSDNode node) {
        Vector attributes;
        XSDAnnotation annotation = null;
        AttributesImpl atts = new AttributesImpl();
        if (node.getNodeType() == 3 && ((XSDElement)node).getRefState() == 0 && (annotation = node.getRefAnnotation()) != null && (attributes = annotation.getAttributes()) != null) {
            this.retrieveAttrs(attributes, atts);
        }
        if ((annotation = node.getAnnotation()) != null && (attributes = annotation.getAttributes()) != null) {
            this.retrieveAttrs(attributes, atts);
        }
        return atts;
    }

    private void retrieveAttrs(Vector source, AttributesImpl target) {
        Attr attribute = null;
        int len = source.size();
        for (int i = 0; i < len; ++i) {
            attribute = (Attr)source.get(i);
            target.addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getName(), "string", attribute.getValue());
        }
    }

    private String formatValue(String actualValue, NativeDataDefinition def, NativeDataDefinition parentDef) throws TranslationException {
        String text = null;
        if (parentDef != null && parentDef.isList()) {
            text = actualValue;
        } else if (def.isFixedLength()) {
            text = this.fStyleBasedFormatter.formatFixedLengthStyleToNative(actualValue, def);
        } else if (def.isSurrounded()) {
            text = this.fStyleBasedFormatter.formatSurroundedStyleToNative(actualValue, def);
        } else if (def.isTerminated()) {
            text = this.fStyleBasedFormatter.formatTerminatedStyleToNative(actualValue, def);
        } else if (def.isArray()) {
            text = actualValue;
        } else if (def.getChoiceCondition() != null) {
            text = this.fStyleBasedFormatter.formatChoiceConditionToNative(actualValue, def);
        } else {
            DataFragmentHandler handler = this.getHandler(def.getExtStyle());
            if (handler != null) {
                Attributes atts = this.getAttributesFromSchemaNode((XSDNode)this.fCurrentElement);
                this.fDataFragmentHandlerContext.setProperty("current.node", this.fCurrentElement);
                handler.writeToNative(actualValue, this.fOutputDataWriter, atts, this.fDataFragmentHandlerContext);
                return null;
            }
            throw new TranslationException(11103, new Object[]{EMPTY_STRING, def.getSchemaConstruct(), def.getExtStyle()});
        }
        return text;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.fOutputDataWriter.flush();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    @Override
    public void warning(SAXParseException exception) {
    }

    @Override
    public void error(SAXParseException exception) {
    }

    @Override
    public void fatalError(SAXParseException exception) {
    }

    private void log(String message) {
        DiagnosticService.log(4, DiagnosticService.DIAGNOSTICS_DEBUG, message);
    }

    private void logError(String message) {
        DiagnosticService.log(4, DiagnosticService.DIAGNOSTICS_ERRORS, message);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.fXMLError.getNumMessages() > 0) {
            throw new SAXException(this.fXMLError.getMessage(this.fXMLError.getFirstError()));
        }
        int lastElementIndex = -1;
        int currentElementIndex = -1;
        String marker = null;
        this.fParentElement = null;
        XSDNode[] children = null;
        this.fElementDefinition.clear();
        this.fParentCTDefinition.clear();
        this.fLastEvent = this.fCurrentEvent;
        this.fCurrentEvent = START_ELEMENT;
        this.fCharEventBuffer = null;
        try {
            int count;
            int i;
            this.fLastElement = this.fCurrentElement;
            this.fCurrentElement = this.fXSDValidator.getElementDeclaration();
            if (this.fCurrentElement == null) {
                throw new TranslationException(11105, new Object[]{namespaceURI, localName});
            }
            if (!this.fStack.empty()) {
                this.fParentElement = (XSDElement)this.fStack.peek();
                children = ((XSDComplexType)this.fParentElement.getType()).getElementSet();
                NativeDataDefinition.fillDef(this.fParentElement.getType(), this.fParentCTDefinition, true);
                for (i = 0; i < children.length; ++i) {
                    if (this.fCurrentElement.getEquivClassRef() != null) {
                        if (this.fCurrentElement.getEquivClassRef().equals(children[i].getName())) {
                            currentElementIndex = i;
                        }
                    } else if (this.fCurrentElement == children[i]) {
                        currentElementIndex = i;
                    }
                    if (this.fLastElement.getEquivClassRef() != null) {
                        if (this.fLastElement.getEquivClassRef().equals(children[i].getName())) {
                            lastElementIndex = i;
                        }
                    } else if (this.fLastElement == children[i]) {
                        lastElementIndex = i;
                    }
                    if (currentElementIndex != -1 && lastElementIndex != -1) break;
                }
            }
            this.fStack.push(this.fCurrentElement);
            NativeDataDefinition.fillDef((XSDNode)this.fCurrentElement, this.fCurrentElementDefinition, true);
            this.fVariableSupport.pushContext();
            if (this.fCurrentElement.getType().getNodeType() == 1) {
                this.processVariables((XSDNode)this.fCurrentElement);
            }
            if (this.fLastElement != null) {
                NativeDataDefinition.fillDef((XSDNode)this.fLastElement, this.fElementDefinition, true);
                if (this.fElementDefinition.isArray() && this.fElementDefinition.getArrayIdentifierLength() == null) {
                    if (this.fLastElement == this.fCurrentElement) {
                        marker = this.fStyleBasedFormatter.formatArrayStyleToNative(EMPTY_STRING, this.fElementDefinition);
                        this.writeToNative(marker, null, null);
                    } else if (this.fLastElement != this.fParentElement) {
                        this.fElementDefinition.markAsLastCell(true);
                        marker = this.fStyleBasedFormatter.formatArrayStyleToNative(EMPTY_STRING, this.fElementDefinition);
                        this.writeToNative(marker, null, null);
                    }
                }
            }
            if (this.fParentElement != null && ((XSDComplexType)this.fParentElement.getType()).getTypeGroup().getOrder() == 0 && currentElementIndex != 0) {
                for (i = lastElementIndex + 1; i < currentElementIndex; ++i) {
                    if (this.fParentCTDefinition.isList() && currentElementIndex != i + 1) {
                        marker = this.fStyleBasedFormatter.formatListStyleToNative(EMPTY_STRING, this.fParentCTDefinition);
                        this.writeToNative(marker, null, null);
                        continue;
                    }
                    if (((XSDElement)children[i]).getType().getNodeType() != 2) continue;
                    XSDElement child = (XSDElement)children[i];
                    NativeDataDefinition.fillDef((XSDNode)child, this.fElementDefinition, true);
                    if (child.getFixedVal() != null) {
                        this.writeToNative(child.getFixedVal(), this.fElementDefinition, null);
                        continue;
                    }
                    if (child.getDefaultVal() != null) {
                        this.writeToNative(child.getDefaultVal(), this.fElementDefinition, null);
                        continue;
                    }
                    this.writeToNative(EMPTY_STRING, this.fElementDefinition, null);
                }
            }
            if (this.fParentCTDefinition != null && this.fParentCTDefinition.isList() && currentElementIndex != 0) {
                marker = this.fStyleBasedFormatter.formatListStyleToNative(EMPTY_STRING, this.fParentCTDefinition);
                this.writeToNative(marker, null, null);
            }
            if (this.fCurrentElementDefinition.getConditionValue() != null) {
                NativeDataDefinition.fillDef((XSDNode)((XSDComplexType)this.fParentElement.getType()).getTypeGroup(), this.fElementDefinition, true);
                this.writeToNative(this.fCurrentElementDefinition.getConditionValue(), this.fElementDefinition, null);
            } else if (this.fCurrentElementDefinition.getStartsWith() != null) {
                String startsWith = this.fXMLCommons.getParsedString(this.fCurrentElementDefinition.getStartsWith());
                this.writeToNative(startsWith, null, null);
            } else if (this.fCurrentElementDefinition.isArray() && this.fCurrentElementDefinition.getArrayIdentifierLength() != null && (count = this.fXMLTokenizer.getCurrentNodeOccurence()) > 0) {
                marker = this.fStyleBasedFormatter.formatArrayIdentifierLengthToNative(EMPTY_STRING + count, this.fCurrentElementDefinition);
                this.writeToNative(marker, null, null);
            }
        }
        catch (TranslationException te) {
            throw new SAXException(te.getDescription(), te);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fXMLError.getNumMessages() > 0) {
            throw new SAXException(this.fXMLError.getMessage(this.fXMLError.getFirstError()));
        }
        this.fLastEvent = this.fCurrentEvent;
        this.fCurrentEvent = CHARACTERS;
        String text = new String(ch, start, length);
        if (this.fCharEventBuffer == null) {
            this.fCharEventBuffer = new StringBuffer();
        }
        if (this.fLastEvent != END_ELEMENT) {
            this.processVariables((XSDNode)this.fCurrentElement, text);
            this.fCharEventBuffer.append(text);
        } else {
            this.fCurrentEvent = END_ELEMENT;
        }
    }

    private boolean isIgnorableCharEvent(String input) {
        if (input == null) {
            return true;
        }
        char[] cArray = input.trim().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\n') continue;
            return false;
        }
        return true;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.fXMLError.getNumMessages() > 0) {
            throw new SAXException(this.fXMLError.getMessage(this.fXMLError.getFirstError()));
        }
        if (this.fCurrentEvent == CHARACTERS) {
            try {
                if (this.fCurrentElementDefinition.getWrite() != null && (this.fCurrentElementDefinition.getWriteMode() == null || "before".equals(this.fCurrentElementDefinition.getWriteMode()) || "both".equals(this.fCurrentElementDefinition.getWriteMode()))) {
                    this.fOutputDataWriter.writeString(this.fXMLCommons.getParsedString(this.fCurrentElementDefinition.getWrite()));
                }
                if (this.fCharEventBuffer.length() > 0) {
                    String temp = this.fCharEventBuffer.toString();
                    if (this.fEncodeLineTerminators) {
                        temp = this.fXMLCommons.processEntityReferences(temp);
                    }
                    this.writeToNative(temp, this.fCurrentElementDefinition, this.fParentCTDefinition);
                }
                this.fCharEventBuffer = new StringBuffer();
                if (this.fCurrentElementDefinition.getWrite() != null && ("after".equals(this.fCurrentElementDefinition.getWriteMode()) || "both".equals(this.fCurrentElementDefinition.getWriteMode()))) {
                    this.fOutputDataWriter.writeString(this.fXMLCommons.getParsedString(this.fCurrentElementDefinition.getWrite()));
                }
            }
            catch (TranslationException te) {
                throw new SAXException(te.getDescription(), te);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
        String marker = null;
        this.fParentElement = null;
        XSDNode[] children = null;
        this.fElementDefinition.clear();
        this.fParentCTDefinition.clear();
        this.fLastEvent = this.fCurrentEvent;
        this.fCurrentEvent = END_ELEMENT;
        this.fLastElement = this.fCurrentElement;
        try {
            this.fVariableSupport.popContext();
            this.fCurrentElement = (XSDElement)this.fStack.pop();
            NativeDataDefinition.fillDef((XSDNode)this.fCurrentElement, this.fCurrentElementDefinition, true);
            if (!this.fStack.empty()) {
                this.fParentElement = (XSDElement)this.fStack.peek();
                children = ((XSDComplexType)this.fParentElement.getType()).getElementSet();
                NativeDataDefinition.fillDef(this.fParentElement.getType(), this.fParentCTDefinition, true);
            }
            if (this.fCurrentElement.getType().getNodeType() == 1 && ((XSDComplexType)this.fCurrentElement.getType()).getTypeGroup().getOrder() == 0) {
                int i;
                XSDNode[] myChildren = ((XSDComplexType)this.fCurrentElement.getType()).getElementSet();
                for (i = 0; i < myChildren.length; ++i) {
                    if (this.fLastElement != myChildren[i]) continue;
                    ++i;
                    break;
                }
                NativeDataDefinition ctDef = new NativeDataDefinition();
                NativeDataDefinition.fillDef(this.fCurrentElement.getType(), ctDef, true);
                while (i < myChildren.length) {
                    if (ctDef.isList()) {
                        if (i != myChildren.length - 1) {
                            marker = this.fStyleBasedFormatter.formatListStyleToNative(EMPTY_STRING, this.fCurrentElementDefinition);
                            this.writeToNative(marker, null, null);
                        }
                    } else if (((XSDElement)myChildren[i]).getType().getNodeType() == 2) {
                        XSDElement child = (XSDElement)myChildren[i];
                        NativeDataDefinition.fillDef((XSDNode)child, this.fElementDefinition, true);
                        if (child.getFixedVal() != null) {
                            this.writeToNative(child.getFixedVal(), this.fElementDefinition, null);
                        } else if (child.getDefaultVal() != null) {
                            this.writeToNative(child.getDefaultVal(), this.fElementDefinition, null);
                        } else {
                            this.writeToNative(EMPTY_STRING, this.fElementDefinition, null);
                        }
                    }
                    ++i;
                }
            }
            if (this.fLastElement != null && this.fLastElement != this.fCurrentElement) {
                NativeDataDefinition.fillDef((XSDNode)this.fLastElement, this.fElementDefinition, true);
                if (this.fElementDefinition.isArray()) {
                    this.fElementDefinition.markAsLastCell(true);
                    marker = this.fStyleBasedFormatter.formatArrayStyleToNative(EMPTY_STRING, this.fElementDefinition);
                    this.writeToNative(marker, null, null);
                }
            }
            NativeDataDefinition.fillDef(this.fCurrentElement.getType(), this.fElementDefinition, true);
            if (this.fElementDefinition.isList()) {
                this.fElementDefinition.markAsLastItem(true);
                marker = this.fStyleBasedFormatter.formatListStyleToNative(EMPTY_STRING, this.fElementDefinition);
                this.writeToNative(marker, null, null);
            }
            if (this.fCurrentElement.getType().getNodeType() == 2 && this.fLastEvent != CHARACTERS) {
                this.writeToNative(EMPTY_STRING, this.fCurrentElementDefinition, null);
            }
        }
        catch (TranslationException te) {
            throw new SAXException(te.getDescription(), te);
        }
    }

    public void writeToNative(String data, NativeDataDefinition def, NativeDataDefinition parentDef) throws TranslationException {
        try {
            String val;
            if (def == null && parentDef == null) {
                this.fOutputDataWriter.writeString(data);
            } else if ((parentDef != null && parentDef.getStyleCount() != 0 || def != null && def.getStyleCount() != 0 || def != null && def.getExtStyle() != null) && (val = this.formatValue(data, def, parentDef)) != null) {
                this.fOutputDataWriter.writeString(val);
            }
        }
        catch (IOException ioe) {
            throw new TranslationException(11118, new Object[]{EMPTY_STRING, def.getSchemaConstruct(), data}, ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processScalarType(NativeDataDefinition def, XSDElement element) throws TranslationException, SAXException {
        String text = null;
        NativeDataDefinition grandParentDef = def.getParentDefinition().getParentDefinition();
        if ((grandParentDef == null || grandParentDef.getStyleCount() == 0) && def.getStyleCount() == 0 && def.getExtStyle() == null) {
            if (element.getFixedVal() != null) {
                text = element.getFixedVal();
            } else {
                if (element.getDefaultVal() == null) throw new TranslationException(11125, new Object[]{def.getSchemaConstruct()});
                text = element.getDefaultVal();
                text = this.fXMLCommons.getParsedString(text);
            }
        } else {
            try {
                text = this.readNativeData(def);
            }
            catch (TranslationException tex) {
                if (!this.fXMLCommons.isLaxMode() || element.getDefaultVal() == null) throw tex;
                text = element.getDefaultVal();
            }
        }
        if (text == null) return;
        this.processVariables(def.getNxsdNode(), text);
        if (EMPTY_STRING.equals(text) && (element.getFixedVal() != null || element.getDefaultVal() != null)) {
            if (element.getFixedVal() != null) {
                text = element.getFixedVal();
            } else if (element.getDefaultVal() != null) {
                text = element.getDefaultVal();
                text = this.fXMLCommons.getParsedString(text);
            }
            this.raiseStartElement(element.getTargetNS(), element.getName(), element.getName(), new AttributesImpl(), def.getNxsdNode());
            String temp = text;
            if (this.fEncodeLineTerminators) {
                temp = temp.replaceAll("\r", "&#13;");
                temp = temp.replaceAll("\n", "&#10;");
            }
            this.raiseCharacters(temp.toCharArray(), 0, temp.length(), def.getNxsdNode());
            this.raiseEndElement(element.getTargetNS(), element.getName(), element.getName(), def.getNxsdNode());
            return;
        } else {
            if (EMPTY_STRING.equals(text) && def.getMinOccurs() == 0) return;
            if (EMPTY_STRING.equals(text) && element.isNillable()) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi:nil", EMPTY_STRING, "true");
                this.raiseStartElement(element.getTargetNS(), element.getName(), element.getName(), attributes, def.getNxsdNode());
                this.raiseEndElement(element.getTargetNS(), element.getName(), element.getName(), def.getNxsdNode());
                return;
            } else {
                this.raiseStartElement(element.getTargetNS(), element.getName(), element.getName(), new AttributesImpl(), def.getNxsdNode());
                String temp = text;
                if (this.fEncodeLineTerminators) {
                    temp = temp.replaceAll("\r", "&#13;");
                    temp = temp.replaceAll("\n", "&#10;");
                }
                this.raiseCharacters(temp.toCharArray(), 0, temp.length(), def.getNxsdNode());
                this.raiseEndElement(element.getTargetNS(), element.getName(), element.getName(), def.getNxsdNode());
            }
        }
    }

    public void processGroup(NativeDataDefinition def) throws TranslationException, IOException, SAXException {
        int i;
        XSDNode node = def.getNxsdNode();
        this.processVariables(node);
        ArrayList<NativeDataDefinition> childDefs = null;
        childDefs = def.getChildDefinitions();
        if (def.isSequence()) {
            for (int i2 = 0; i2 < childDefs.size(); ++i2) {
                this.parseNXSD(childDefs.get(i2));
            }
        }
        if (def.isChoice()) {
            XSDNode matchedParticle = null;
            String choiceCondition = def.getChoiceCondition();
            if (choiceCondition == null) {
                for (i = 0; i < childDefs.size(); ++i) {
                    NativeDataDefinition tempDef = childDefs.get(i);
                    if (tempDef.getStartsWith() == null && tempDef.getLookAhead() == null) {
                        throw new TranslationException(11135, new Object[]{tempDef.getNxsdNodeAsXML()});
                    }
                    this.parseNXSD(tempDef);
                }
            } else {
                String identifier = this.readChoiceCondition(def);
                NativeDataDefinition elementDef = null;
                for (int i3 = 0; i3 < childDefs.size(); ++i3) {
                    elementDef = childDefs.get(i3);
                    if (elementDef.getConditionValue() != null) {
                        if (!this.conditionMatch(identifier, elementDef.getConditionValue())) continue;
                        matchedParticle = elementDef.getNxsdNode();
                        break;
                    }
                    throw new TranslationException(11128, new Object[]{elementDef.getNxsdNodeAsXML()});
                }
                if (matchedParticle != null) {
                    this.parseNXSD(elementDef);
                } else {
                    String s1 = null;
                    String s2 = null;
                    if (def.getLength() != null) {
                        s1 = "length";
                        s2 = def.getLength();
                    } else if (def.getTerminatedBy() != null) {
                        s1 = "terminatedBy";
                        s2 = def.getTerminatedBy();
                    }
                    throw new TranslationException(11104, new Object[]{this.fInputDataReader.getPosition(), identifier, choiceCondition, s1, s2});
                }
            }
        }
        if (def.isAll()) {
            boolean match = true;
            NativeDataDefinition elementDef = null;
            block3: while (match) {
                match = false;
                for (i = 0; i < childDefs.size(); ++i) {
                    elementDef = childDefs.get(i);
                    String startsWith = elementDef.getStartsWith();
                    if (startsWith == null) {
                        throw new TranslationException(11129, new Object[]{elementDef.getNxsdNodeAsXML()});
                    }
                    match = this.fInputDataReader.exists(this.fXMLCommons.getParsedChars(startsWith));
                    if (!match) continue;
                    childDefs.remove(i);
                    this.parseNXSD(elementDef);
                    continue block3;
                }
            }
        }
    }

    public void processElement(NativeDataDefinition def) throws TranslationException, SAXException, IOException {
        XSDElement element = (XSDElement)def.getNxsdNode();
        this.processVariables(def.getNxsdNode());
        if (!def.hasChildNodes()) {
            this.processScalarType(def, element);
        } else {
            this.raiseStartElement(element.getTargetNS(), element.getName(), element.getName(), new AttributesImpl(), def.getNxsdNode());
            this.fStack.push(def.getNxsdNode());
            for (int i = 0; i < def.getChildDefinitions().size(); ++i) {
                this.parseNXSD(def.getChildDefinitions().get(i));
            }
            this.raiseEndElement(element.getTargetNS(), element.getName(), element.getName(), def.getNxsdNode());
            this.fStack.pop();
        }
    }

    public void processComplexType(NativeDataDefinition def) throws SAXException, TranslationException, IOException {
        if (!def.hasChildNodes()) {
            return;
        }
        ArrayList<NativeDataDefinition> childDefs = def.getChildDefinitions();
        XSDNode node = def.getParentDefinition().getNxsdNode();
        if (node == this.fNXSDRootElement && this.fDebatching) {
            while (this.fPublishSize > this.fCurrentSize && !this.fInputDataReader.isEof()) {
                if (this.fCorruptMessage) {
                    this.terminateLoop(node, def.getParentDefinition());
                    this.fCorruptMessage = false;
                }
                for (int i = 0; i < childDefs.size(); ++i) {
                    this.parseNXSD(childDefs.get(i));
                }
            }
        } else {
            for (int i = 0; i < childDefs.size(); ++i) {
                this.parseNXSD(childDefs.get(i));
            }
        }
    }

    static {
        fHandlerProperties.setProperty("oracle.bpelpm.xlators.styles.comp", "oracle.tip.pc.services.translation.xlators.plugins.Comp");
        fHandlerProperties.setProperty("oracle.bpelpm.xlators.styles.comp1", "oracle.tip.pc.services.translation.xlators.plugins.Comp1");
        fHandlerProperties.setProperty("oracle.bpelpm.xlators.styles.comp2", "oracle.tip.pc.services.translation.xlators.plugins.Comp2");
        fHandlerProperties.setProperty("oracle.bpelpm.xlators.styles.comp3", "oracle.tip.pc.services.translation.xlators.plugins.Comp3");
        fHandlerProperties.setProperty("oracle.bpelpm.xlators.styles.comp5", "oracle.tip.pc.services.translation.xlators.plugins.Comp5");
        fHandlerProperties.setProperty("oracle.bpelpm.xlators.styles.signZoned", "oracle.tip.pc.services.translation.xlators.plugins.SignZoned");
        fHandlerProperties.setProperty("oracle.bpelpm.xlators.styles.virtualDecimal", "oracle.tip.pc.services.translation.xlators.plugins.VirtualDecimal");
        fHandlerProperties.setProperty("oracle.bpelpm.xlators.styles.integer", "oracle.tip.pc.services.translation.xlators.plugins.NXSDIntUtils");
        fHandlerProperties.setProperty("oracle.bpelpm.xlators.styles.decimal", "oracle.tip.pc.services.translation.xlators.plugins.NXSDFloatUtils");
        Properties internalHandlers = PCProperties.getProperties();
        if (internalHandlers != null) {
            Enumeration<Object> keys = internalHandlers.keys();
            String key = null;
            String val = null;
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                if (!key.startsWith("oracle.bpelpm.xlators.styles")) continue;
                val = internalHandlers.getProperty(key);
                fHandlerProperties.setProperty(key, val);
            }
        }
        try {
            String propsFileName = System.getProperty("oracle.bpelpm.xlators.styles.properties");
            if (propsFileName != null) {
                Properties externalHandlers = new Properties();
                externalHandlers.load(new FileInputStream(propsFileName));
                fHandlerProperties.putAll((Map<?, ?>)externalHandlers);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        START_ELEMENT = 0;
        CHARACTERS = 1;
        END_ELEMENT = (short)2;
    }
}

