/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.nxsd;

import java.io.IOException;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.xlators.nxsd.InputDataReader;
import oracle.tip.pc.services.translation.xlators.nxsd.NativeDataDefinition;
import oracle.tip.pc.services.translation.xlators.nxsd.XMLCommons;

public class NXSDStyleBasedReader {
    private String text;
    private String fReaderPosition;
    private InputDataReader fInputDataReader;
    private XMLCommons fXMLCommons;
    private int charCount = -1;

    public NXSDStyleBasedReader(InputDataReader reader, XMLCommons xmlCommons) {
        this.fInputDataReader = reader;
        this.fXMLCommons = xmlCommons;
    }

    public String readFixedLengthStyle(NativeDataDefinition def) throws TranslationException {
        this.text = null;
        String dateFormat = def.getDateFormat();
        String length = def.getLength();
        String identifierLength = def.getIdentifierLength();
        int len = -1;
        int charsRead = -1;
        char[] buf = null;
        try {
            if (identifierLength != null) {
                identifierLength = this.fXMLCommons.getParsedString(identifierLength);
                len = Integer.parseInt(identifierLength);
                buf = new char[len];
                this.fReaderPosition = this.fInputDataReader.getPosition();
                charsRead = this.fInputDataReader.readChars(buf);
                if (charsRead == -1 || charsRead < buf.length) {
                    throw new TranslationException(11162, new Object[]{this.getPositionInNativeData(this.fReaderPosition), String.valueOf(len), this.getPositionInDef(def), "style", "fixedLength", "identifierLength", identifierLength});
                }
                try {
                    this.text = new String(buf);
                    len = Integer.parseInt(this.text);
                }
                catch (NumberFormatException nfe) {
                    throw new TranslationException(11163, new Object[]{this.getPositionInNativeData(this.fReaderPosition), this.text, this.getPositionInDef(def), "style", "fixedLength", "identifierLength", identifierLength}, nfe);
                }
            } else {
                length = this.fXMLCommons.getParsedString(length);
                len = Integer.parseInt(length);
            }
            buf = new char[len];
            this.fReaderPosition = this.fInputDataReader.getPosition();
            charsRead = this.fInputDataReader.readChars(buf);
            if (charsRead == -1 || charsRead < buf.length) {
                throw new TranslationException(11162, new Object[]{this.getPositionInNativeData(this.fReaderPosition), String.valueOf(len), this.getPositionInDef(def), "style", "fixedLength", "length", length});
            }
        }
        catch (IOException ioe) {
            throw new TranslationException(11177, new Object[]{this.getPositionInNativeData(null), this.getPositionInDef(def), "style", "fixedLength", ioe.getMessage()}, ioe);
        }
        this.text = new String(buf);
        return this.text;
    }

    public String readSurroundedStyle(NativeDataDefinition def) throws TranslationException {
        this.text = null;
        String dateFormat = def.getDateFormat();
        String surroundedBy = def.getSurroundedBy();
        String leftSurroundedBy = def.getLeftSurroundedBy();
        String rightSurroundedBy = def.getRightSurroundedBy();
        if (surroundedBy != null) {
            leftSurroundedBy = rightSurroundedBy = surroundedBy;
        }
        char[] charsLeftSurroundedBy = this.fXMLCommons.getParsedChars(leftSurroundedBy);
        char[] charsRightSurroundedBy = this.fXMLCommons.getParsedChars(rightSurroundedBy);
        StringBuffer buf = new StringBuffer();
        StringBuffer flag = new StringBuffer();
        int charsRead = -1;
        try {
            this.fReaderPosition = this.fInputDataReader.getPosition();
            if (this.fInputDataReader.exists(charsLeftSurroundedBy)) {
                this.fInputDataReader.skip(charsLeftSurroundedBy.length);
                this.fReaderPosition = this.fInputDataReader.getPosition();
                charsRead = this.fInputDataReader.readCharsUntil(buf, charsRightSurroundedBy, flag);
                if (this.fXMLCommons.getMessageSeparator() != null && flag.toString().equals(this.fXMLCommons.getMessageSeparator())) {
                    throw new TranslationException(11164, new Object[]{this.getPositionInNativeData(this.fReaderPosition), rightSurroundedBy, "ending", this.getPositionInDef(def), leftSurroundedBy, rightSurroundedBy});
                }
                if (!(charsRead != -1 && flag.length() != 0 || this.fInputDataReader.isEof() && this.fXMLCommons.isEndOfLine(new String(charsRightSurroundedBy)))) {
                    throw new TranslationException(11164, new Object[]{this.getPositionInNativeData(this.fReaderPosition), rightSurroundedBy, "ending", this.getPositionInDef(def), leftSurroundedBy, rightSurroundedBy});
                }
            } else {
                throw new TranslationException(11165, new Object[]{this.getPositionInNativeData(this.fReaderPosition), leftSurroundedBy, "begining", this.getPositionInDef(def), leftSurroundedBy, rightSurroundedBy});
            }
            this.text = buf.toString();
        }
        catch (IOException ioe) {
            throw new TranslationException(11177, new Object[]{this.getPositionInNativeData(null), this.getPositionInDef(def), "style", "surrounded", ioe.getMessage()}, ioe);
        }
        return this.text;
    }

    public String readTerminatedStyle(NativeDataDefinition def) throws TranslationException {
        this.text = null;
        String dateFormat = def.getDateFormat();
        String terminatedBy = def.getTerminatedBy();
        String quotedBy = def.getQuotedBy() != null ? def.getQuotedBy() : def.getDefaultQuotedBy();
        char[] charsTerminatedBy = this.fXMLCommons.getParsedChars(terminatedBy);
        char[] charsQuotedBy = this.fXMLCommons.getParsedChars(quotedBy);
        StringBuffer buf = new StringBuffer();
        StringBuffer flag = new StringBuffer();
        int charsRead = -1;
        try {
            this.fReaderPosition = this.fInputDataReader.getPosition();
            if ("eof".equals(new String(charsTerminatedBy))) {
                char[] tempBuf = new char[1024];
                charsRead = this.fInputDataReader.readChars(tempBuf);
                while (charsRead != -1) {
                    buf.append(tempBuf, 0, charsRead);
                    charsRead = this.fInputDataReader.readChars(tempBuf);
                }
                return buf.toString();
            }
            if (this.fInputDataReader.exists(charsQuotedBy)) {
                this.fInputDataReader.skip(charsQuotedBy.length);
                this.fReaderPosition = this.fInputDataReader.getPosition();
                charsRead = this.readUntilClosingQuote(buf, charsQuotedBy, flag);
                if (this.fXMLCommons.getMessageSeparator() != null && flag.toString().equals(this.fXMLCommons.getMessageSeparator())) {
                    this.fXMLCommons.setEndOfMessage(true);
                    throw new TranslationException(11166, new Object[]{this.getPositionInNativeData(null), quotedBy, "closing", this.getPositionInDef(def), "style", "terminated"});
                }
                if (!(charsRead != -1 && flag.length() != 0 || this.fInputDataReader.isEof() && this.fXMLCommons.isEndOfLine(new String(charsQuotedBy)))) {
                    throw new TranslationException(11166, new Object[]{this.getPositionInNativeData(null), quotedBy, "closing", this.getPositionInDef(def), "style", "terminated"});
                }
                this.text = buf.toString();
                if (this.fInputDataReader.exists(charsTerminatedBy)) {
                    this.fInputDataReader.skip(charsTerminatedBy.length);
                } else if (!this.fInputDataReader.isEof() || !this.fXMLCommons.isEndOfLine(new String(charsTerminatedBy))) {
                    throw new TranslationException(11167, new Object[]{this.getPositionInNativeData(null), terminatedBy, this.getPositionInDef(def), "style", "terminated", "terminatedBy", terminatedBy});
                }
            } else {
                Object charsMsgSepr = null;
                this.fReaderPosition = this.fInputDataReader.getPosition();
                charsRead = this.fInputDataReader.readCharsUntil(buf, charsTerminatedBy, flag);
                if (this.fXMLCommons.getMessageSeparator() != null && flag.toString().equals(this.fXMLCommons.getMessageSeparator())) {
                    this.fXMLCommons.setEndOfMessage(true);
                    throw new TranslationException(11168, new Object[]{this.getPositionInNativeData(this.fReaderPosition), terminatedBy, this.getPositionInDef(def), "style", "terminated", "terminatedBy", terminatedBy});
                }
                if (!(charsRead != -1 && flag.length() != 0 || this.fInputDataReader.isEof() && this.fXMLCommons.isEndOfLine(new String(charsTerminatedBy)))) {
                    throw new TranslationException(11168, new Object[]{this.getPositionInNativeData(this.fReaderPosition), terminatedBy, this.getPositionInDef(def), "style", "terminated", "terminatedBy", terminatedBy});
                }
                this.text = buf.toString();
            }
        }
        catch (IOException ioe) {
            throw new TranslationException(11177, new Object[]{this.getPositionInNativeData(null), this.getPositionInDef(def), "style", "terminated", ioe.getMessage()}, ioe);
        }
        return this.text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readArrayStyle(NativeDataDefinition def) throws TranslationException {
        this.text = null;
        String dateFormat = def.getDateFormat();
        String cellSeparatedBy = def.getCellSeparatedBy();
        String arrayTerminatedBy = def.getArrayTerminatedBy();
        String arrayLength = def.getArrayLength();
        String arrayIdentifierLength = def.getArrayIdentifierLength();
        StringBuffer buf = new StringBuffer();
        StringBuffer flag = new StringBuffer();
        int charsRead = -1;
        try {
            if (arrayLength != null) {
                arrayLength = this.fXMLCommons.getParsedString(arrayLength);
                try {
                    this.text = arrayLength;
                    int size = Integer.parseInt(this.text);
                    return this.text;
                }
                catch (NumberFormatException nfe) {
                    throw new TranslationException(11163, new Object[]{this.getPositionInNativeData(this.fReaderPosition), this.text, this.getPositionInDef(def), "style", "array", "arrayLength", arrayLength}, nfe);
                }
            }
            if (arrayIdentifierLength != null) {
                arrayIdentifierLength = this.fXMLCommons.getParsedString(arrayIdentifierLength);
                int size = Integer.parseInt(arrayIdentifierLength);
                char[] buffer = new char[size];
                this.fReaderPosition = this.fInputDataReader.getPosition();
                charsRead = this.fInputDataReader.readChars(buffer);
                if (charsRead == -1 || charsRead < buffer.length) {
                    throw new TranslationException(11162, new Object[]{this.getPositionInNativeData(this.fReaderPosition), String.valueOf(size), this.getPositionInDef(def), "style", "array", "arrayIdentifierLength", arrayIdentifierLength});
                }
                try {
                    this.text = new String(buffer);
                    size = Integer.parseInt(this.text);
                    return this.text;
                }
                catch (NumberFormatException nfe) {
                    throw new TranslationException(11163, new Object[]{this.getPositionInNativeData(this.fReaderPosition), this.text, this.getPositionInDef(def), "style", "array", "arrayIdentifierLength", arrayIdentifierLength}, nfe);
                }
            }
            if (!def.isScalarType()) {
                if (cellSeparatedBy != null && arrayTerminatedBy != null) {
                    char[] charsSeparatedBy = this.fXMLCommons.getParsedChars(cellSeparatedBy);
                    char[] charsTerminatedBy = this.fXMLCommons.getParsedChars(arrayTerminatedBy);
                    this.fReaderPosition = this.fInputDataReader.getPosition();
                    if (this.fInputDataReader.exists(charsTerminatedBy)) {
                        this.fInputDataReader.skip(charsTerminatedBy.length);
                        def.markAsLastCell(true);
                        return "";
                    } else if (this.fInputDataReader.exists(charsSeparatedBy)) {
                        this.fInputDataReader.skip(charsSeparatedBy.length);
                        def.markAsLastCell(false);
                        return "";
                    } else {
                        if (!this.fInputDataReader.isEof() || !this.fXMLCommons.isEndOfLine(new String(charsTerminatedBy))) throw new TranslationException(11169, new Object[]{this.getPositionInNativeData(null), cellSeparatedBy, arrayTerminatedBy, this.getPositionInDef(def), "style", "array", "cellSeparatedBy", cellSeparatedBy, "arrayTerminatedBy", arrayTerminatedBy});
                        def.markAsLastCell(true);
                    }
                    return "";
                } else if (cellSeparatedBy != null) {
                    char[] charsSeparatedBy = this.fXMLCommons.getParsedChars(cellSeparatedBy);
                    if (this.fInputDataReader.exists(charsSeparatedBy)) {
                        this.fInputDataReader.skip(charsSeparatedBy.length);
                        if (!this.fInputDataReader.isEof()) return "";
                        def.markAsLastCell(true);
                        return "";
                    } else {
                        if (!this.fInputDataReader.isEof() || !this.fXMLCommons.isEndOfLine(new String(charsSeparatedBy))) throw new TranslationException(11167, new Object[]{this.getPositionInNativeData(null), cellSeparatedBy, this.getPositionInDef(def), "style", "array", "cellSeparatedBy", cellSeparatedBy});
                        def.markAsLastCell(true);
                    }
                    return "";
                } else {
                    if (arrayTerminatedBy == null) return "";
                    char[] charsTerminatedBy = this.fXMLCommons.getParsedChars(arrayTerminatedBy);
                    if (this.fInputDataReader.exists(charsTerminatedBy)) {
                        this.fInputDataReader.skip(charsTerminatedBy.length);
                        def.markAsLastCell(true);
                        return "";
                    } else {
                        if (!this.fInputDataReader.isEof() || !this.fXMLCommons.isEndOfLine(new String(charsTerminatedBy))) return "";
                        def.markAsLastCell(true);
                    }
                }
                return "";
            }
            if (cellSeparatedBy != null && arrayTerminatedBy != null) {
                char[] charsSeparatedBy = this.fXMLCommons.getParsedChars(cellSeparatedBy);
                char[] charsTerminatedBy = this.fXMLCommons.getParsedChars(arrayTerminatedBy);
                this.fReaderPosition = this.fInputDataReader.getPosition();
                charsRead = this.fInputDataReader.readCharsUntil(buf, charsSeparatedBy, charsTerminatedBy, flag);
                if (charsRead == -1 || flag.length() == 0) {
                    if (!this.fInputDataReader.isEof() || !this.fXMLCommons.isEndOfLine(new String(charsTerminatedBy))) {
                        throw new TranslationException(11170, new Object[]{this.getPositionInNativeData(this.fReaderPosition), cellSeparatedBy, arrayTerminatedBy, this.getPositionInDef(def), "style", "array", "cellSeparatedBy", cellSeparatedBy, "arrayTerminatedBy", arrayTerminatedBy});
                    }
                } else if (flag.toString().equals(new String(charsTerminatedBy))) {
                    def.markAsLastCell(true);
                }
                this.text = buf.toString();
                return this.text;
            } else if (cellSeparatedBy != null) {
                char[] charsSeparatedBy = this.fXMLCommons.getParsedChars(cellSeparatedBy);
                this.fReaderPosition = this.fInputDataReader.getPosition();
                charsRead = this.fInputDataReader.readCharsUntil(buf, charsSeparatedBy, flag);
                if (!(charsRead != -1 && flag.length() != 0 || this.fInputDataReader.isEof() && this.fXMLCommons.isEndOfLine(new String(charsSeparatedBy)))) {
                    throw new TranslationException(11168, new Object[]{this.getPositionInNativeData(this.fReaderPosition), cellSeparatedBy, this.getPositionInDef(def), "style", "array", "cellSeparatedBy", cellSeparatedBy});
                }
                this.text = buf.toString();
                return this.text;
            } else {
                if (arrayTerminatedBy == null) return this.text;
                char[] charsTerminatedBy = this.fXMLCommons.getParsedChars(arrayTerminatedBy);
                this.fReaderPosition = this.fInputDataReader.getPosition();
                charsRead = this.fInputDataReader.readCharsUntil(buf, charsTerminatedBy, flag);
                if (!(charsRead != -1 && flag.length() != 0 || this.fInputDataReader.isEof() && this.fXMLCommons.isEndOfLine(new String(charsTerminatedBy)))) {
                    throw new TranslationException(11168, new Object[]{this.getPositionInNativeData(this.fReaderPosition), arrayTerminatedBy, this.getPositionInDef(def), "style", "array", "arrayTerminatedBy", arrayTerminatedBy});
                }
                def.markAsLastCell(true);
                this.text = buf.toString();
            }
            return this.text;
        }
        catch (IOException ioe) {
            throw new TranslationException(11177, new Object[]{this.getPositionInNativeData(null), this.getPositionInDef(def), "style", "array", ioe.getMessage()}, ioe);
        }
    }

    public String readListStyle(NativeDataDefinition def, NativeDataDefinition grandDef) throws TranslationException {
        this.text = null;
        String dateFormat = def.getDateFormat();
        String itemSeparatedBy = grandDef.getItemSeparatedBy();
        String listTerminatedBy = grandDef.getListTerminatedBy();
        StringBuffer buf = new StringBuffer();
        StringBuffer flag = new StringBuffer();
        int charsRead = -1;
        try {
            if (listTerminatedBy != null && def.isLastItem()) {
                char[] charsTerminatedBy = this.fXMLCommons.getParsedChars(listTerminatedBy);
                this.fReaderPosition = this.fInputDataReader.getPosition();
                charsRead = this.fInputDataReader.readCharsUntil(buf, charsTerminatedBy, flag);
                if (!(charsRead != -1 && flag.length() != 0 || this.fInputDataReader.isEof() && this.fXMLCommons.isEndOfLine(new String(charsTerminatedBy)))) {
                    throw new TranslationException(11168, new Object[]{this.getPositionInNativeData(this.fReaderPosition), listTerminatedBy, this.getPositionInDef(def), "style", "list", "listTerminatedBy", listTerminatedBy});
                }
                this.text = buf.toString();
            } else {
                char[] charsSeparatedBy = this.fXMLCommons.getParsedChars(itemSeparatedBy);
                this.fReaderPosition = this.fInputDataReader.getPosition();
                charsRead = this.fInputDataReader.readCharsUntil(buf, charsSeparatedBy, flag);
                if (!(charsRead != -1 && flag.length() != 0 || this.fInputDataReader.isEof() && this.fXMLCommons.isEndOfLine(new String(charsSeparatedBy)))) {
                    throw new TranslationException(11168, new Object[]{this.getPositionInNativeData(this.fReaderPosition), itemSeparatedBy, this.getPositionInDef(def), "style", "list", "itemSeparatedBy", itemSeparatedBy});
                }
                this.text = buf.toString();
            }
        }
        catch (IOException ioe) {
            throw new TranslationException(11177, new Object[]{this.getPositionInNativeData(null), this.getPositionInDef(def), "style", "list", ioe.getMessage()}, ioe);
        }
        return this.text;
    }

    public String readChoiceCondition(NativeDataDefinition def) throws TranslationException {
        this.text = null;
        String choiceCondition = def.getChoiceCondition();
        String length = def.getLength();
        String terminatedBy = def.getTerminatedBy();
        int charsRead = -1;
        if ("fixedLength".equals(choiceCondition)) {
            return this.readFixedLengthStyle(def);
        }
        if ("terminated".equals(choiceCondition)) {
            return this.readTerminatedStyle(def);
        }
        if ("surrounded".equals(choiceCondition)) {
            return this.readSurroundedStyle(def);
        }
        if (choiceCondition.startsWith("${") && choiceCondition.endsWith("}")) {
            String val = this.fXMLCommons.getParsedString(choiceCondition);
            return val;
        }
        return this.text;
    }

    public String readLookAhead(NativeDataDefinition def) throws TranslationException {
        this.text = null;
        String scan = def.getScanLength();
        String lookAhead = def.getLookAhead();
        String assignTo = def.getAssignTo();
        int scanLen = -1;
        int lookAheadLen = -1;
        try {
            if (lookAhead != null) {
                lookAhead = new String(this.fXMLCommons.getParsedString(lookAhead));
                lookAheadLen = Integer.parseInt(lookAhead);
                if (scan != null) {
                    scan = new String(this.fXMLCommons.getParsedString(scan));
                    scanLen = Integer.parseInt(scan);
                    char[] buf = new char[scanLen];
                    this.fInputDataReader.lookAhead(lookAheadLen, buf);
                    this.text = new String(buf);
                    if (assignTo != null) {
                        if (this.fXMLCommons.getVariableSupport().isVariableDeclared(assignTo)) {
                            this.fXMLCommons.getVariableSupport().setValue(assignTo, this.text);
                        } else {
                            this.fXMLCommons.getVariableSupport().declareVariable(assignTo, this.text);
                        }
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            if (lookAheadLen == -1) {
                throw new TranslationException(11130, new Object[]{lookAhead, "lookAhead", def.getNxsdNodeAsXML()}, nfe);
            }
            throw new TranslationException(11130, new Object[]{scan, "scan", def.getNxsdNodeAsXML()}, nfe);
        }
        catch (IOException ioe) {
            throw new TranslationException(11171, new Object[]{this.getPositionInNativeData(null), "lookAhead", lookAhead, "scan", scan}, ioe);
        }
        return this.text;
    }

    private String getPositionInNativeData(String scannerPos) {
        String pos = "";
        if (this.fXMLCommons.getFileName() != null) {
            pos = "File=" + this.fXMLCommons.getFileName() + ", ";
        }
        if (scannerPos != null) {
            return pos + scannerPos;
        }
        return pos + this.fInputDataReader.getPosition();
    }

    private String getPositionInDef(NativeDataDefinition def) {
        if (def.getNxsdNodeName() != null) {
            return def.getNxsdNodeType() + " with name " + def.getNxsdNodeName();
        }
        return def.getNxsdNodeType();
    }

    private int readUntilClosingQuote(StringBuffer buf, char[] charsQuotedBy, StringBuffer flag) throws IOException {
        this.charCount = this.fInputDataReader.readCharsUntil(buf, charsQuotedBy, flag);
        if (this.fInputDataReader.exists(charsQuotedBy)) {
            this.fInputDataReader.skip(charsQuotedBy.length);
            buf.append(charsQuotedBy);
            this.charCount += charsQuotedBy.length;
            this.readUntilClosingQuote(buf, charsQuotedBy, flag);
        }
        return this.charCount;
    }
}

