/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.nxsd;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.xlators.nxsd.NativeDataDefinition;
import oracle.tip.pc.services.translation.xlators.nxsd.XMLCommons;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDSimpleType;

public class NXSDStyleBasedFormatter {
    private XMLCommons fXMLCommons;

    public NXSDStyleBasedFormatter(XMLCommons xmlCommons) {
        this.fXMLCommons = xmlCommons;
    }

    public String formatDateFromNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        if (this.fXMLCommons.isLaxMode() && (actualValue == null || actualValue.trim().length() == 0)) {
            return "";
        }
        String dateFormat = def.getDateFormat();
        String xmlDateFormat = def.getXmlDateFormat();
        String dateParsingMode = def.getDateParsingMode();
        Locale locale = def.getLocale();
        String formattedValue = actualValue;
        String useTimeZone = def.getUseTimeZone();
        String timeZone = def.getTimeZone();
        String xmlTimeZone = def.getXmlTimeZone();
        boolean displayTimeZone = def.getDisplayTimeZone();
        try {
            if (useTimeZone != null) {
                timeZone = xmlTimeZone = useTimeZone;
            }
            String iso8601DateFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
            XSDElement element = (XSDElement)def.getNxsdNode();
            XSDSimpleType elementType = null;
            if (element != null) {
                elementType = (XSDSimpleType)element.getType();
                if (elementType.getBasicType() == 9) {
                    iso8601DateFormat = "yyyy-MM-dd";
                    if (displayTimeZone) {
                        iso8601DateFormat = "yyyy-MM-ddZ";
                    }
                } else if (elementType.getBasicType() == 7) {
                    iso8601DateFormat = "yyyy-MM-dd'T'HH:mm:ss";
                    if (displayTimeZone) {
                        iso8601DateFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
                    }
                } else {
                    iso8601DateFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
                }
            }
            if (xmlDateFormat != null) {
                iso8601DateFormat = xmlDateFormat;
            }
            SimpleDateFormat customFormat = null;
            if (locale != null) {
                customFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, locale);
                customFormat.applyPattern(dateFormat);
            } else {
                customFormat = new SimpleDateFormat(dateFormat);
            }
            if (dateParsingMode != null && "strict".equals(dateParsingMode)) {
                customFormat.setLenient(false);
            }
            if (timeZone != null) {
                TimeZone tz = TimeZone.getTimeZone(timeZone);
                customFormat.setTimeZone(tz);
            }
            Date date = customFormat.parse(actualValue);
            SimpleDateFormat iso8601Format = null;
            if (locale != null) {
                iso8601Format = (SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, locale);
                iso8601Format.applyPattern(iso8601DateFormat);
            } else {
                iso8601Format = new SimpleDateFormat(iso8601DateFormat);
            }
            if (xmlTimeZone != null) {
                TimeZone tz = TimeZone.getTimeZone(xmlTimeZone);
                iso8601Format.setTimeZone(tz);
            }
            formattedValue = iso8601Format.format(date);
            if (!(elementType == null || elementType.getBasicType() != 9 && elementType.getBasicType() != 7 || formattedValue.charAt(formattedValue.length() - 5) != '+' && formattedValue.charAt(formattedValue.length() - 5) != '-')) {
                formattedValue = formattedValue.substring(0, formattedValue.length() - 2) + ":" + formattedValue.substring(formattedValue.length() - 2);
            }
        }
        catch (ParseException e) {
            throw new TranslationException(11186, new Object[]{this.fXMLCommons.getCurrentPosition(), def.getSchemaConstruct(), actualValue, "dateFormat", dateFormat}, e);
        }
        return formattedValue;
    }

    public String formatPrefixSuffixFromNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        String prefixWith = def.getPrefixWith();
        String suffixWith = def.getSuffixWith();
        StringBuffer formattedValue = new StringBuffer(actualValue);
        try {
            if (prefixWith != null) {
                prefixWith = this.fXMLCommons.getParsedString(prefixWith);
                formattedValue.insert(0, prefixWith);
            }
            if (suffixWith != null) {
                suffixWith = this.fXMLCommons.getParsedString(suffixWith);
                formattedValue.append(suffixWith);
            }
        }
        catch (Exception e) {
            throw new TranslationException(11192, new Object[]{this.fXMLCommons.getCurrentPosition(), def.getSchemaConstruct(), actualValue, "prefixWith=" + prefixWith, "suffixWith=" + suffixWith}, e);
        }
        return formattedValue.toString();
    }

    public String formatFixedLengthStyleFromNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        String padStyle = def.getPadStyle() != null ? def.getPadStyle() : def.getDefaultPadStyle();
        String paddedBy = def.getPaddedBy() != null ? def.getPaddedBy() : def.getDefaultPaddedBy();
        StringBuffer formattedValue = new StringBuffer(actualValue);
        String finalValue = null;
        try {
            if (!padStyle.equals("none")) {
                int i = -1;
                if (padStyle.equals("head")) {
                    i = formattedValue.indexOf(paddedBy);
                    while (i == 0) {
                        formattedValue.delete(i, i + paddedBy.length());
                        i = formattedValue.indexOf(paddedBy);
                    }
                } else {
                    i = formattedValue.lastIndexOf(paddedBy);
                    while (i > -1 && i + paddedBy.length() == formattedValue.length()) {
                        formattedValue.delete(i, i + paddedBy.length());
                        i = formattedValue.lastIndexOf(paddedBy);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new TranslationException(11188, new Object[]{this.fXMLCommons.getCurrentPosition(), def.getSchemaConstruct(), actualValue, "fixedLength", "padStyle", padStyle, "paddedBy", paddedBy}, e);
        }
        finalValue = formattedValue.toString();
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            finalValue = this.formatPrefixSuffixFromNative(finalValue, def);
        }
        if (def.getDateFormat() != null) {
            finalValue = this.formatDateFromNative(finalValue, def);
        }
        return finalValue;
    }

    public String formatSurroundedStyleFromNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        String finalValue = actualValue;
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            finalValue = this.formatPrefixSuffixFromNative(finalValue, def);
        }
        if (def.getDateFormat() != null) {
            finalValue = this.formatDateFromNative(finalValue, def);
        }
        return finalValue;
    }

    public String formatTerminatedStyleFromNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        String finalValue = actualValue;
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            finalValue = this.formatPrefixSuffixFromNative(finalValue, def);
        }
        if (def.getDateFormat() != null) {
            finalValue = this.formatDateFromNative(finalValue, def);
        }
        return finalValue;
    }

    public String formatListStyleFromNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        String finalValue = actualValue;
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            finalValue = this.formatPrefixSuffixFromNative(finalValue, def);
        }
        if (def.getDateFormat() != null) {
            finalValue = this.formatDateFromNative(finalValue, def);
        }
        return finalValue;
    }

    public String formatArrayStyleFromNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        String finalValue = actualValue;
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            finalValue = this.formatPrefixSuffixFromNative(finalValue, def);
        }
        if (def.getDateFormat() != null) {
            finalValue = this.formatDateFromNative(finalValue, def);
        }
        return finalValue;
    }

    public String formatChoiceConditionFromNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        String finalValue = actualValue;
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            finalValue = this.formatPrefixSuffixFromNative(finalValue, def);
        }
        if (def.getDateFormat() != null) {
            finalValue = this.formatDateFromNative(finalValue, def);
        }
        return finalValue;
    }

    public String formatPrefixSuffixToNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        String prefixWith = def.getPrefixWith();
        String suffixWith = def.getSuffixWith();
        StringBuffer formattedValue = new StringBuffer(actualValue);
        try {
            if (prefixWith != null && formattedValue.indexOf(prefixWith = this.fXMLCommons.getParsedString(prefixWith)) == 0) {
                formattedValue.delete(0, prefixWith.length());
            }
            if (suffixWith != null && formattedValue.lastIndexOf(suffixWith = this.fXMLCommons.getParsedString(suffixWith)) + suffixWith.length() == formattedValue.length()) {
                formattedValue.delete(formattedValue.lastIndexOf(suffixWith), formattedValue.length());
            }
        }
        catch (Exception e) {
            throw new TranslationException(11192, new Object[]{this.fXMLCommons.getCurrentPosition(), def.getSchemaConstruct(), actualValue, "prefixWith=" + prefixWith, "suffixWith=" + suffixWith}, e);
        }
        return formattedValue.toString();
    }

    public String formatFixedLengthStyleToNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        if (def.getDateFormat() != null) {
            actualValue = this.formatDateToNative(actualValue, def);
        }
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            actualValue = this.formatPrefixSuffixToNative(actualValue, def);
        }
        StringBuffer formattedValue = new StringBuffer(actualValue);
        String length = def.getLength();
        String padStyle = def.getPadStyle() != null ? def.getPadStyle() : def.getDefaultPadStyle();
        String paddedBy = def.getPaddedBy() != null ? def.getPaddedBy() : def.getDefaultPaddedBy();
        String identifierLength = def.getIdentifierLength();
        try {
            if (identifierLength != null) {
                identifierLength = this.fXMLCommons.getParsedString(identifierLength);
                int expectedIdentifierLen = Integer.parseInt(identifierLength);
                StringBuffer actualIdentifier = new StringBuffer("" + actualValue.length());
                int actualIdentifierLen = actualIdentifier.length();
                if (actualIdentifier.length() < expectedIdentifierLen) {
                    while (actualIdentifier.length() < expectedIdentifierLen) {
                        actualIdentifier.insert(0, "0");
                    }
                } else if (actualIdentifier.length() > expectedIdentifierLen) {
                    throw new TranslationException(11185, new Object[]{"", def.getSchemaConstruct(), actualValue, "identifierLength", identifierLength});
                }
                formattedValue.insert(0, actualIdentifier.toString());
            } else if (length != null) {
                length = this.fXMLCommons.getParsedString(length);
                int expectedLen = Integer.parseInt(length);
                if (formattedValue.length() < expectedLen) {
                    while (formattedValue.length() < expectedLen) {
                        if (padStyle.equals("none") || padStyle.equals("head")) {
                            formattedValue.insert(0, paddedBy);
                            continue;
                        }
                        if (!padStyle.equals("tail")) continue;
                        formattedValue.append(paddedBy);
                    }
                }
                if (formattedValue.length() > expectedLen) {
                    while (formattedValue.length() != expectedLen) {
                        if (padStyle.equals("none") || padStyle.equals("head")) {
                            formattedValue.deleteCharAt(0);
                            continue;
                        }
                        formattedValue.deleteCharAt(formattedValue.length() - 1);
                    }
                }
            }
        }
        catch (TranslationException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TranslationException(11190, new Object[]{"", def.getSchemaConstruct(), actualValue, "fixedLength", "length", length, "padStyle", padStyle, "paddedBy", paddedBy, "identifierLength", identifierLength}, e);
        }
        return formattedValue.toString();
    }

    public String formatSurroundedStyleToNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        if (def.getDateFormat() != null) {
            actualValue = this.formatDateToNative(actualValue, def);
        }
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            actualValue = this.formatPrefixSuffixToNative(actualValue, def);
        }
        String formattedValue = actualValue;
        String surroundedBy = def.getSurroundedBy();
        String leftSurroundedBy = def.getLeftSurroundedBy();
        String rightSurroundedBy = def.getRightSurroundedBy();
        try {
            if (surroundedBy != null) {
                leftSurroundedBy = rightSurroundedBy = this.fXMLCommons.getParsedString(surroundedBy, actualValue);
            } else {
                leftSurroundedBy = this.fXMLCommons.getParsedString(leftSurroundedBy, actualValue);
                rightSurroundedBy = this.fXMLCommons.getParsedString(rightSurroundedBy, actualValue);
            }
            formattedValue = leftSurroundedBy + actualValue + rightSurroundedBy;
        }
        catch (Exception e) {
            throw new TranslationException(11187, new Object[]{"", def.getSchemaConstruct(), actualValue, "surrounded", "surroundedBy", surroundedBy}, e);
        }
        return formattedValue;
    }

    private String formatEscapedQuotesToNative(String quotedBy, String actualValue) {
        actualValue = actualValue.replaceAll(quotedBy, quotedBy + quotedBy);
        return quotedBy + actualValue + quotedBy;
    }

    public String formatTerminatedStyleToNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        if (def.getDateFormat() != null) {
            actualValue = this.formatDateToNative(actualValue, def);
        }
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            actualValue = this.formatPrefixSuffixToNative(actualValue, def);
        }
        String formattedValue = actualValue;
        String terminatedBy = def.getTerminatedBy();
        String quotedBy = def.getQuotedBy();
        String defaultQuotedBy = def.getDefaultQuotedBy();
        boolean alwaysQuote = def.getAlwaysQuote() == null ? false : Boolean.parseBoolean(def.getAlwaysQuote());
        try {
            terminatedBy = this.fXMLCommons.getParsedString(terminatedBy, actualValue);
            if (!"eof".equals(terminatedBy)) {
                if (alwaysQuote) {
                    if (quotedBy != null) {
                        quotedBy = this.fXMLCommons.getParsedString(quotedBy, actualValue);
                        formattedValue = this.formatEscapedQuotesToNative(quotedBy, actualValue);
                    } else {
                        formattedValue = this.formatEscapedQuotesToNative(quotedBy, actualValue);
                    }
                } else if (quotedBy != null && actualValue.indexOf(terminatedBy) > -1) {
                    quotedBy = this.fXMLCommons.getParsedString(quotedBy, actualValue);
                    formattedValue = this.formatEscapedQuotesToNative(quotedBy, actualValue);
                }
                formattedValue = formattedValue + terminatedBy;
            }
        }
        catch (Exception e) {
            throw new TranslationException(11188, new Object[]{"", def.getSchemaConstruct(), actualValue, "terminated", "terminatedBy", terminatedBy, "quotedBy", quotedBy}, e);
        }
        return formattedValue;
    }

    public String formatDateToNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        String formattedValue = actualValue;
        String dateFormat = def.getDateFormat();
        String xmlDateFormat = def.getXmlDateFormat();
        String dateParsingMode = def.getDateParsingMode();
        Locale locale = def.getLocale();
        String useTimeZone = def.getUseTimeZone();
        String timeZone = def.getTimeZone();
        String xmlTimeZone = def.getXmlTimeZone();
        try {
            dateFormat = this.fXMLCommons.getParsedString(dateFormat);
            if (useTimeZone != null) {
                timeZone = xmlTimeZone = useTimeZone;
            }
            String iso8601DateFormat = null;
            XSDElement element = (XSDElement)def.getNxsdNode();
            XSDSimpleType elementType = (XSDSimpleType)element.getType();
            if (elementType.getBasicType() == 9) {
                iso8601DateFormat = "yyyy-MM-dd";
                if (formattedValue.charAt(formattedValue.length() - 3) == ':') {
                    iso8601DateFormat = "yyyy-MM-ddZ";
                    formattedValue = formattedValue.substring(0, formattedValue.length() - 3) + formattedValue.substring(formattedValue.length() - 2);
                }
            } else if (elementType.getBasicType() == 7) {
                iso8601DateFormat = "yyyy-MM-dd'T'HH:mm:ss";
                if (formattedValue.charAt(formattedValue.length() - 6) == '+' || formattedValue.charAt(formattedValue.length() - 6) == '-') {
                    iso8601DateFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
                    formattedValue = formattedValue.substring(0, formattedValue.length() - 3) + formattedValue.substring(formattedValue.length() - 2);
                }
            } else {
                iso8601DateFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
            }
            if (xmlDateFormat != null) {
                iso8601DateFormat = xmlDateFormat;
            }
            SimpleDateFormat iso8601Format = null;
            if (locale != null) {
                iso8601Format = (SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, locale);
                iso8601Format.applyPattern(iso8601DateFormat);
            } else {
                iso8601Format = new SimpleDateFormat(iso8601DateFormat);
            }
            if (xmlTimeZone != null) {
                TimeZone tz = TimeZone.getTimeZone(xmlTimeZone);
                iso8601Format.setTimeZone(tz);
            }
            Date date = iso8601Format.parse(formattedValue);
            SimpleDateFormat customFormat = null;
            if (locale != null) {
                customFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, locale);
                customFormat.applyPattern(dateFormat);
            } else {
                customFormat = new SimpleDateFormat(dateFormat);
            }
            if (dateParsingMode != null && "strict".equals(dateParsingMode)) {
                customFormat.setLenient(false);
            }
            if (timeZone != null) {
                TimeZone tz = TimeZone.getTimeZone(timeZone);
                customFormat.setTimeZone(tz);
            }
            formattedValue = customFormat.format(date);
        }
        catch (ParseException e) {
            throw new TranslationException(11186, new Object[]{"", def.getSchemaConstruct(), actualValue, "dateFormat", dateFormat}, e);
        }
        return formattedValue;
    }

    public String formatChoiceConditionToNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        String formattedValue = actualValue;
        String choiceCondition = def.getChoiceCondition();
        try {
            formattedValue = choiceCondition.equals("fixedLength") ? this.formatFixedLengthStyleToNative(actualValue, def) : this.formatTerminatedStyleToNative(actualValue, def);
        }
        catch (TranslationException te) {
            throw new TranslationException(11186, new Object[]{"", def.getSchemaConstruct(), actualValue, "choiceCondition", choiceCondition}, te);
        }
        return formattedValue;
    }

    public String formatListStyleToNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        if (def.getDateFormat() != null) {
            actualValue = this.formatDateToNative(actualValue, def);
        }
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            actualValue = this.formatPrefixSuffixToNative(actualValue, def);
        }
        String formattedValue = actualValue;
        String separatedBy = def.getItemSeparatedBy();
        String terminatedBy = def.getListTerminatedBy();
        try {
            formattedValue = terminatedBy != null && def.isLastItem() ? formattedValue + this.fXMLCommons.getParsedString(terminatedBy, actualValue) : formattedValue + this.fXMLCommons.getParsedString(separatedBy, actualValue);
        }
        catch (Exception e) {
            throw new TranslationException(11188, new Object[]{"", def.getSchemaConstruct(), actualValue, "list", "separatedBy", separatedBy, "terminatedBy", terminatedBy}, e);
        }
        return formattedValue;
    }

    public String formatArrayStyleToNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        if (def.getDateFormat() != null) {
            actualValue = this.formatDateToNative(actualValue, def);
        }
        if (def.getPrefixWith() != null || def.getSuffixWith() != null) {
            actualValue = this.formatPrefixSuffixToNative(actualValue, def);
        }
        String cellSeparatedBy = def.getCellSeparatedBy();
        String arrayTerminatedBy = def.getArrayTerminatedBy();
        String formattedValue = actualValue;
        try {
            formattedValue = arrayTerminatedBy != null && def.isLastCell() ? formattedValue + this.fXMLCommons.getParsedString(arrayTerminatedBy, actualValue) : formattedValue + this.fXMLCommons.getParsedString(cellSeparatedBy, actualValue);
        }
        catch (Exception e) {
            // empty catch block
        }
        return formattedValue;
    }

    public String formatArrayIdentifierLengthToNative(String actualValue, NativeDataDefinition def) throws TranslationException {
        StringBuffer actualIdentifier = new StringBuffer(actualValue);
        String arrayIdentifierLength = def.getArrayIdentifierLength();
        try {
            int expectedIdentifierLen = Integer.parseInt(arrayIdentifierLength);
            int actualIdentifierLen = actualIdentifier.length();
            if (actualIdentifier.length() < expectedIdentifierLen) {
                while (actualIdentifier.length() < expectedIdentifierLen) {
                    actualIdentifier.insert(0, "0");
                }
            } else if (actualIdentifier.length() > expectedIdentifierLen) {
                throw new TranslationException(11185, new Object[]{"", def.getSchemaConstruct(), actualValue, "arrayIdentifierLength", arrayIdentifierLength});
            }
        }
        catch (TranslationException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TranslationException(11186, new Object[]{"", def.getSchemaConstruct(), actualValue, "arrayIdentifierLength", arrayIdentifierLength}, e);
        }
        return actualIdentifier.toString();
    }
}

