/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.nxsd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class NXSDLineNumberReader
extends BufferedReader {
    private int lineNumber = 0;
    private int markedLineNumber;
    private boolean skipLF;
    private boolean prevCharWasCarriageReturn;
    private boolean markedSkipLF;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer = null;

    public NXSDLineNumberReader(Reader in) {
        super(in);
    }

    public NXSDLineNumberReader(Reader in, int sz) {
        super(in, sz);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int c = super.read();
            if (c == 13) {
                this.prevCharWasCarriageReturn = true;
                ++this.lineNumber;
                return c;
            }
            if (c == 10 && !this.prevCharWasCarriageReturn) {
                ++this.lineNumber;
            }
            this.prevCharWasCarriageReturn = false;
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n = super.read(cbuf, off, len);
            for (int i = off; i < off + n; ++i) {
                char c = cbuf[i];
                if (c == '\r') {
                    this.prevCharWasCarriageReturn = true;
                    ++this.lineNumber;
                    continue;
                }
                if (c == '\n' && !this.prevCharWasCarriageReturn) {
                    ++this.lineNumber;
                }
                this.prevCharWasCarriageReturn = false;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String l = super.readLine();
            this.skipLF = false;
            if (l != null) {
                ++this.lineNumber;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip() value is negative");
        }
        int nn = (int)Math.min(n, 8192L);
        Object object = this.lock;
        synchronized (object) {
            long r;
            int nc;
            if (this.skipBuffer == null || this.skipBuffer.length < nn) {
                this.skipBuffer = new char[nn];
            }
            for (r = n; r > 0L && (nc = this.read(this.skipBuffer, 0, (int)Math.min(r, (long)nn))) != -1; r -= (long)nc) {
            }
            return n - r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.mark(readAheadLimit);
            this.markedLineNumber = this.lineNumber;
            this.markedSkipLF = this.skipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.reset();
            this.lineNumber = this.markedLineNumber;
            this.skipLF = this.markedSkipLF;
        }
    }
}

