/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.nxsd;

import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.framework.XlatorHelper;
import oracle.tip.pc.services.translation.xlators.nxsd.InputDataReader;
import oracle.tip.pc.services.translation.xlators.nxsd.NativeDataDefinition;
import oracle.tip.pc.services.translation.xlators.nxsd.XMLCommons;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDTypeConstants;

public class NXSDFieldValidator {
    private static XSDNode xsdNode;
    private static XSDSimpleType xsdSimpleType;
    private static String dataType;

    public static boolean validate(NativeDataDefinition def, String actualValue, InputDataReader fInputDataReader) throws TranslationException {
        if (!XMLCommons.getFieldValidation()) {
            XlatorHelper.logDebug("Field validation disabled.");
            return false;
        }
        XlatorHelper.logDebug("Field validation enabled.");
        xsdNode = def.getNxsdNode();
        int type = xsdNode.getNodeType();
        if (xsdNode.getNodeType() == 3) {
            XSDElement elem = (XSDElement)xsdNode;
            dataType = elem.getType().getName();
            try {
                if (XSDTypeConstants.STRING.equals(dataType)) {
                    return true;
                }
                if (XSDTypeConstants.BOOLEAN.equals(dataType)) {
                    if ("true".equalsIgnoreCase(actualValue) || "false".equalsIgnoreCase(actualValue) || "0".equals(actualValue) || "1".equals(actualValue)) {
                        return true;
                    }
                    throw new NumberFormatException(actualValue + " does not correspond to a valid boolean value.");
                }
                if ("int".equals(dataType)) {
                    Integer.parseInt(actualValue);
                    return true;
                }
                if (XSDTypeConstants.DOUBLE.equals(dataType)) {
                    Double.parseDouble(actualValue);
                    return true;
                }
                if (XSDTypeConstants.FLOAT.equals(dataType)) {
                    Float.parseFloat(actualValue);
                    return true;
                }
                if ("short".equals(dataType)) {
                    Short.parseShort(actualValue);
                    return true;
                }
                if ("long".equals(dataType)) {
                    Long.parseLong(actualValue);
                    return true;
                }
                if ("byte".equals(dataType)) {
                    Byte.parseByte(actualValue);
                    return true;
                }
                if (XSDTypeConstants.DECIMAL.equals(dataType)) {
                    int decimalPos;
                    String temp = actualValue;
                    if (temp.charAt(0) == '+' || temp.charAt(0) == '-') {
                        temp = temp.substring(1);
                    }
                    if ((decimalPos = temp.indexOf(".")) == -1) {
                        Integer.parseInt(temp);
                    } else {
                        if (decimalPos != 0) {
                            Integer.parseInt(temp.substring(0, decimalPos));
                        }
                        Integer.parseInt(temp.substring(decimalPos + 1));
                    }
                    return true;
                }
                if ("integer".equals(dataType)) {
                    Integer.parseInt(actualValue);
                    return true;
                }
            }
            catch (NumberFormatException nfe) {
                XlatorHelper.logError("field validation Failure");
                XlatorHelper.logError("dataType = " + dataType);
                XlatorHelper.logError("value = " + actualValue);
                throw new TranslationException(11156, new Object[]{actualValue, dataType, fInputDataReader.getPosition()}, nfe);
            }
        }
        return true;
    }
}

