/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.nxsd;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.framework.XlatorHelper;
import oracle.tip.pc.services.translation.xlators.nxsd.InputDataReader;
import oracle.tip.pc.services.translation.xlators.nxsd.LineColumnNumberReader;

public class CharDataReaderImpl
implements InputDataReader {
    private static final int END_OF_MESSAGE = -2;
    private LineColumnNumberReader fLCReader;
    private String fEncoding;
    private char[] fCharsMessageSeparator;
    private String fMessageSeparator;
    private boolean fNormalizeLineTerminators = true;
    private int scanLength;

    public CharDataReaderImpl(InputStream in, String encoding) throws TranslationException {
        this(in, encoding, true);
    }

    public CharDataReaderImpl(InputStream in, String encoding, boolean normalizeLineTerminators) throws TranslationException {
        this.fNormalizeLineTerminators = normalizeLineTerminators;
        try {
            if (encoding != null) {
                this.fEncoding = encoding;
                this.fLCReader = new LineColumnNumberReader(new InputStreamReader(in, encoding), this.fNormalizeLineTerminators);
            } else {
                this.fLCReader = new LineColumnNumberReader(new InputStreamReader(in), this.fNormalizeLineTerminators);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new TranslationException(11111, new Object[]{encoding}, ex);
        }
        if (!this.fLCReader.markSupported()) {
            throw new TranslationException(11116);
        }
    }

    public CharDataReaderImpl(BufferedInputStream in, String encoding, boolean normalizeLineTerminators) throws TranslationException {
        this.fNormalizeLineTerminators = normalizeLineTerminators;
        try {
            if (encoding != null) {
                this.fEncoding = encoding;
                this.fLCReader = new LineColumnNumberReader(new InputStreamReader((InputStream)in, encoding), this.fNormalizeLineTerminators);
            } else {
                this.fLCReader = new LineColumnNumberReader(new InputStreamReader(in), this.fNormalizeLineTerminators);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new TranslationException(11111, new Object[]{encoding}, ex);
        }
        if (!this.fLCReader.markSupported()) {
            throw new TranslationException(11116);
        }
    }

    public CharDataReaderImpl(Reader reader, boolean normalizeLineTerminators) throws TranslationException {
        this.fLCReader = new LineColumnNumberReader(reader, normalizeLineTerminators);
        if (!this.fLCReader.markSupported()) {
            throw new TranslationException(11116);
        }
    }

    public void setMessageSeparator(char[] messageSeparator) {
        this.fCharsMessageSeparator = messageSeparator;
        this.fMessageSeparator = messageSeparator != null ? new String(messageSeparator) : null;
    }

    @Override
    public int readChar() throws IOException {
        if (this.fCharsMessageSeparator != null) {
            return this.readChar(this.fCharsMessageSeparator);
        }
        return this.fLCReader.read();
    }

    @Override
    public int readChars(char[] buf) throws IOException {
        if (this.fCharsMessageSeparator != null) {
            return this.readChars(buf, 0, buf.length, this.fCharsMessageSeparator);
        }
        return this.fLCReader.read(buf);
    }

    @Override
    public int readChars(char[] buf, int off, int len) throws IOException {
        if (this.fCharsMessageSeparator != null) {
            return this.readChars(buf, off, len, this.fCharsMessageSeparator);
        }
        return this.fLCReader.read(buf, off, len);
    }

    @Override
    public int readCharsUntil(StringBuffer buf, char[] delim, StringBuffer flag) throws IOException {
        if (this.fCharsMessageSeparator != null && !this.fMessageSeparator.equals(new String(delim))) {
            return this.readCharsUntil(buf, delim, this.fCharsMessageSeparator, flag);
        }
        if (delim.length == 1) {
            return this.readCharsUntil(buf, delim[0], flag);
        }
        int ch = this.fLCReader.read();
        while (ch != -1) {
            int n;
            if (ch == delim[0] && ((n = this.match(buf, ch, delim, flag)) == -1 || n == 1)) {
                return buf.length();
            }
            buf.append((char)ch);
            ch = this.fLCReader.read();
        }
        if (buf.length() > 0) {
            return buf.length();
        }
        return -1;
    }

    @Override
    public int readCharsUntil(StringBuffer buf, char[] delim1, char[] delim2, StringBuffer flag) throws IOException {
        if (this.fCharsMessageSeparator != null && !this.fMessageSeparator.equals(new String(delim1)) && !this.fMessageSeparator.equals(new String(delim2))) {
            return this.readCharsUntil(buf, delim1, delim2, this.fCharsMessageSeparator, flag);
        }
        if (delim1.length == 1 && delim2.length == 1) {
            return this.readCharsUntil(buf, delim1[0], delim2[0], flag);
        }
        int ch = this.fLCReader.read();
        while (ch != -1) {
            int n;
            if (ch == delim2[0] && ((n = this.match(buf, ch, delim2, flag)) == -1 || n == 1)) {
                return buf.length();
            }
            if (ch == delim1[0] && ((n = this.match(buf, ch, delim1, flag)) == -1 || n == 1)) {
                return buf.length();
            }
            buf.append((char)ch);
            ch = this.fLCReader.read();
        }
        if (buf.length() > 0) {
            return buf.length();
        }
        return -1;
    }

    @Override
    public long skipUntil(char[] delim, StringBuffer flag) throws IOException {
        if (this.fCharsMessageSeparator != null && !this.fMessageSeparator.equals(new String(delim))) {
            return this.readCharsUntil(new StringBuffer(), delim, this.fCharsMessageSeparator, flag);
        }
        return this.readCharsUntil(new StringBuffer(), delim, flag);
    }

    @Override
    public int skipLines(int lines) throws IOException {
        if (this.fCharsMessageSeparator != null && !this.fMessageSeparator.equals(new String("\n"))) {
            return this.readCharsUntil(new StringBuffer(), this.fCharsMessageSeparator, new StringBuffer());
        }
        return this.fLCReader.skipLines(lines);
    }

    @Override
    public int peekChars(char[] buf) throws IOException {
        this.fLCReader.mark(buf.length * 2);
        int n = this.fLCReader.read(buf);
        this.fLCReader.reset();
        return n;
    }

    @Override
    public boolean exists(char[] seq) throws IOException {
        this.fLCReader.mark(seq.length * 2);
        char[] buf = new char[seq.length];
        int n = this.fLCReader.read(buf);
        this.fLCReader.reset();
        if (n < seq.length) {
            return false;
        }
        for (int i = 0; i < seq.length; ++i) {
            if (buf[i] == seq[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int readByte() throws IOException {
        throw new IOException("NOT SUPPORTED");
    }

    @Override
    public int readBytes(byte[] b) throws IOException {
        throw new IOException("NOT SUPPORTED");
    }

    @Override
    public int readBytes(byte[] b, int off, int len) throws IOException {
        throw new IOException("NOT SUPPORTED");
    }

    @Override
    public int peekBytes(byte[] b) throws IOException {
        throw new IOException("NOT SUPPORTED");
    }

    @Override
    public boolean exists(byte[] seq) throws IOException {
        throw new IOException("NOT SUPPORTED");
    }

    @Override
    public int skip(int n) throws IOException {
        if (this.fCharsMessageSeparator != null) {
            char[] buf = new char[n];
            return this.readChars(buf, 0, n, this.fCharsMessageSeparator);
        }
        return this.fLCReader.skip(n);
    }

    @Override
    public boolean markSupported() {
        return this.fLCReader.markSupported();
    }

    @Override
    public void mark(int readlimit) throws IOException {
        this.fLCReader.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.fLCReader.reset();
    }

    @Override
    public long getOffset() {
        return -1L;
    }

    @Override
    public int getLineNumber() {
        return this.fLCReader.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.fLCReader.getColumnNumber();
    }

    @Override
    public String getPosition() {
        return "Line=" + this.getLineNumber() + ", Col=" + this.getColumnNumber();
    }

    @Override
    public boolean isEof() throws IOException {
        this.fLCReader.mark(2);
        if (this.fLCReader.read() == -1) {
            this.fLCReader.reset();
            return true;
        }
        this.fLCReader.reset();
        return false;
    }

    @Override
    public void close() throws IOException {
        this.fLCReader.close();
    }

    @Override
    public short getStreamType() {
        return -1;
    }

    @Override
    public String getEncoding() {
        return this.fEncoding;
    }

    private int readChar(char[] stopper) throws IOException {
        if (!this.exists(stopper)) {
            return this.fLCReader.read();
        }
        return -2;
    }

    private int readChars(char[] buf, int off, int len, char[] stopper) throws IOException {
        int charsRead = 0;
        int ch = -1;
        for (int i = off; i < off + len; ++i) {
            if (!this.exists(stopper)) {
                ch = this.fLCReader.read();
                if (ch == -1) break;
                ++charsRead;
            } else {
                return charsRead;
            }
            buf[i] = (char)ch;
        }
        return charsRead;
    }

    private int readCharsUntil(StringBuffer buf, char delim, StringBuffer flag) throws IOException {
        int ch = this.fLCReader.read();
        while (ch != -1) {
            if (ch == delim) {
                flag.append(delim);
                return buf.length();
            }
            buf.append((char)ch);
            ch = this.fLCReader.read();
        }
        if (buf.length() > 0) {
            return buf.length();
        }
        return -1;
    }

    private int readCharsUntil(StringBuffer buf, char delim1, char delim2, StringBuffer flag) throws IOException {
        int ch = this.fLCReader.read();
        while (ch != -1) {
            if (ch == delim2) {
                flag.append(delim2);
                return buf.length();
            }
            if (ch == delim1) {
                flag.append(delim1);
                return buf.length();
            }
            buf.append((char)ch);
            ch = this.fLCReader.read();
        }
        if (buf.length() > 0) {
            return buf.length();
        }
        return -1;
    }

    private int readCharsUntil(StringBuffer buf, char[] delim1, char[] delim2, char[] stopper, StringBuffer flag) throws IOException {
        int ch = this.fLCReader.read();
        while (ch != -1) {
            int n;
            if (ch == stopper[0] && ((n = this.match(buf, ch, stopper, flag)) == -1 || n == 1)) {
                return buf.length();
            }
            if (ch == delim2[0] && ((n = this.match(buf, ch, delim2, flag)) == -1 || n == 1)) {
                return buf.length();
            }
            if (ch == delim1[0] && ((n = this.match(buf, ch, delim1, flag)) == -1 || n == 1)) {
                return buf.length();
            }
            buf.append((char)ch);
            ch = this.fLCReader.read();
        }
        if (buf.length() > 0) {
            return buf.length();
        }
        return -1;
    }

    private long skipUntil(char delim, StringBuffer flag) throws IOException {
        long i = 0L;
        int ch = this.fLCReader.read();
        StringBuffer tempbuf = new StringBuffer();
        while (ch != -1) {
            tempbuf.append((char)ch);
            if (ch == delim) {
                flag.append(delim);
                return i;
            }
            ++i;
            ch = this.fLCReader.read();
        }
        return i;
    }

    private boolean exists(char seq) throws IOException {
        this.fLCReader.mark(2);
        int ch = this.fLCReader.read();
        this.fLCReader.reset();
        return ch == seq;
    }

    @Override
    public int match(StringBuffer buf, int ch, char[] delim, StringBuffer flag) throws IOException {
        int n = -1;
        boolean match = true;
        if (delim.length > 1) {
            char[] delimBuf = new char[delim.length];
            this.fLCReader.mark(delim.length * 2);
            n = this.fLCReader.read(delimBuf, 1, delimBuf.length - 1);
            if (n < delimBuf.length - 1) {
                buf.append((char)ch);
                buf.append(delimBuf, 1, n);
                return -1;
            }
            for (int i = 1; i < delim.length; ++i) {
                if (delimBuf[i] == delim[i]) continue;
                match = false;
                break;
            }
        } else {
            flag.append(delim);
            return 1;
        }
        if (match) {
            flag.append(delim);
            return 1;
        }
        this.fLCReader.reset();
        return 0;
    }

    @Override
    public void skipUniqueMessage(char[] sequence) {
        try {
            int n = -1;
            this.fLCReader.mark(sequence.length * 2);
            if (sequence.length > 1) {
                char[] sequenceBuf = new char[sequence.length];
                n = this.fLCReader.read(sequenceBuf, 0, sequence.length);
                if (n < sequenceBuf.length - 1) {
                    this.fLCReader.reset();
                    return;
                }
                for (int i = 0; i < sequence.length; ++i) {
                    if (sequence[i] == sequenceBuf[i]) continue;
                    this.fLCReader.reset();
                    return;
                }
            } else {
                n = this.fLCReader.read();
                if (sequence[0] != (char)n) {
                    this.fLCReader.reset();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean lookAheadForMatch(String lookFrom, String lookTill, String lookFor) throws IOException {
        int skip = this.startIndex(this.fLCReader, lookFrom.toCharArray(), Character.valueOf(lookTill.charAt(0)), 0);
        if (skip == -1) {
            return false;
        }
        this.scanLength = this.startIndex(this.fLCReader, lookTill.toCharArray(), null, skip - 1);
        if (this.scanLength == -1) {
            return false;
        }
        return this.lookAheadForMatch(skip - 1, lookFor.toCharArray(), this.scanLength - skip - 1);
    }

    @Override
    public boolean lookAheadForMatch(int skip, char[] peek) throws IOException {
        this.fLCReader.mark(skip + peek.length + 5);
        char[] buf = new char[skip];
        int n = this.fLCReader.read(buf);
        if (n != -1) {
            buf = new char[peek.length];
            n = this.fLCReader.read(buf);
            this.fLCReader.reset();
            if (n < peek.length) {
                return false;
            }
            for (int i = 0; i < peek.length; ++i) {
                if (buf[i] == peek[i]) continue;
                return false;
            }
            return true;
        }
        this.fLCReader.reset();
        return false;
    }

    @Override
    public boolean lookAheadForMatch(int skip, byte[] peek) throws IOException {
        throw new IOException("Byte lookAhead Not supported by CharDataReaderImpl");
    }

    @Override
    public boolean lookAheadForMatch(int skip, char[] peek, int scanLength) throws IOException {
        this.fLCReader.mark(skip + peek.length + 5);
        char[] buf = new char[skip];
        int n = this.fLCReader.read(buf);
        if (n != -1) {
            buf = new char[scanLength];
            n = this.fLCReader.read(buf);
            this.fLCReader.reset();
            if (n < scanLength) {
                return false;
            }
            String regex = new String(peek);
            String charSequence = new String(buf);
            return charSequence.matches(regex);
        }
        this.fLCReader.reset();
        return false;
    }

    @Override
    public boolean lookAheadForMatch(int skip, byte[] peek, int scanLength) throws IOException {
        throw new IOException("Byte lookAhead Not supported by CharDataReaderImpl");
    }

    @Override
    public int lookAhead(int skip, char[] buf) throws IOException {
        this.fLCReader.mark(skip + buf.length);
        char[] temp = new char[skip];
        int n = this.fLCReader.read(temp);
        if (n != -1) {
            n = this.fLCReader.read(buf);
        }
        this.fLCReader.reset();
        return n;
    }

    @Override
    public int lookAhead(int skip, byte[] buf) throws IOException {
        throw new IOException("Byte lookAhead Not supported by CharDataReaderImpl");
    }

    private int startIndex(LineColumnNumberReader bufRdr, char[] needle, Character bar, int slip) throws IOException {
        int m = needle.length;
        int n = -1;
        int rLim = needle.length;
        int counter = 0;
        int status = -1;
        bufRdr.mark(rLim);
        bufRdr.skip(slip);
        counter += slip;
        block0: while ((n = bufRdr.read()) != -1 && (bar == null || (char)n != bar.charValue())) {
            ++counter;
            if ((char)n != needle[0]) {
                bufRdr.reset();
                bufRdr.mark(++rLim);
                bufRdr.skip(counter);
                continue;
            }
            if (m == 1) {
                XlatorHelper.logDebug("there is nothing more to compare.");
                status = bufRdr.getColumnNumber();
                bufRdr.reset();
                return status;
            }
            for (int j = 1; j < m; ++j) {
                n = bufRdr.read();
                ++counter;
                if (n == -1 || bar != null && (char)n == bar.charValue()) {
                    bufRdr.reset();
                    return status;
                }
                if ((char)n == needle[j]) {
                    if (j != m - 1) continue;
                    status = bufRdr.getColumnNumber();
                    bufRdr.reset();
                    return status;
                }
                bufRdr.reset();
                bufRdr.mark(rLim += j);
                bufRdr.skip(counter);
                continue block0;
            }
        }
        bufRdr.reset();
        return status;
    }

    @Override
    public int getScanLength() {
        return this.scanLength;
    }
}

