/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.nxsd;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.xlators.nxsd.InputDataReader;

public class ByteDataReaderImpl
implements InputDataReader {
    private static int BUF_SIZE = 1024;
    private BufferedInputStream fStream;
    private String fEncoding;
    private CharsetDecoder fDecoder;
    private float fMaxCharsPerByte;
    private long fOffset;

    public ByteDataReaderImpl(InputStream in, String encoding) throws TranslationException {
        this(new BufferedInputStream(in), encoding);
    }

    public ByteDataReaderImpl(BufferedInputStream in, String encoding) throws TranslationException {
        block6: {
            this.fStream = in;
            this.fMaxCharsPerByte = 1.0f;
            if (encoding != null) {
                this.fEncoding = encoding;
                try {
                    Charset cs = Charset.forName(encoding);
                    this.fDecoder = cs.newDecoder();
                    if (this.fDecoder.maxCharsPerByte() != this.fDecoder.averageCharsPerByte()) {
                        throw new TranslationException(11111, new Object[]{encoding});
                    }
                    this.fMaxCharsPerByte = this.fDecoder.maxCharsPerByte();
                }
                catch (IllegalCharsetNameException ex1) {
                    throw new TranslationException(11111, new Object[]{encoding}, ex1);
                }
                catch (UnsupportedCharsetException ex2) {
                    if (this.fEncoding.equals("IBM037") || this.fEncoding.equals("cp037") || this.fEncoding.equals("ebcdic-cp-us") || this.fEncoding.equals("ebcdic-cp-ca") || this.fEncoding.equals("ebcdic-cp-wt") || this.fEncoding.equals("ebcdic-cp-nl") || this.fEncoding.equals("csIBM037")) break block6;
                    throw new TranslationException(11111, new Object[]{encoding}, ex2);
                }
            }
        }
        if (!this.fStream.markSupported()) {
            throw new TranslationException(11116);
        }
    }

    @Override
    public int readChar() throws IOException {
        char[] c = new char[1];
        int n = this.readChars(c);
        if (n != -1) {
            return c[0];
        }
        return -1;
    }

    @Override
    public int readChars(char[] buf) throws IOException {
        return this.readChars(buf, 0, buf.length);
    }

    @Override
    public int readChars(char[] buf, int off, int len) throws IOException {
        byte[] b = new byte[this.getByteCount(buf.length)];
        int n = this.fStream.read(b, 0, b.length);
        if (n != -1) {
            this.fOffset += (long)n;
            String str = null;
            str = this.fEncoding != null ? new String(b, 0, n, this.fEncoding) : new String(b, 0, n);
            System.arraycopy(str.toCharArray(), 0, buf, 0, str.length());
            return str.length();
        }
        return -1;
    }

    public int readCharsUntil(StringBuffer buf, char delim, StringBuffer flag) throws IOException {
        int ch = this.readChar();
        while (ch != -1) {
            if (ch == delim) {
                flag.append(delim);
                return buf.length();
            }
            buf.append((char)ch);
            ch = this.readChar();
        }
        return -1;
    }

    @Override
    public int readCharsUntil(StringBuffer buf, char[] delim, StringBuffer flag) throws IOException {
        if (delim.length == 1) {
            return this.readCharsUntil(buf, delim[0], flag);
        }
        int n = -1;
        int ch = -1;
        ch = this.readChar();
        while (ch != -1) {
            if (ch == delim[0] && ((n = this.match(buf, ch, delim, flag)) == -1 || n == 1)) {
                return buf.length();
            }
            buf.append((char)ch);
            ch = this.readChar();
        }
        return -1;
    }

    public int readCharsUntil(StringBuffer buf, char delim1, char delim2, StringBuffer flag) throws IOException {
        int ch = -1;
        ch = this.readChar();
        while (ch != -1) {
            if (ch == delim2) {
                flag.append((char)delim2);
                return buf.length();
            }
            if (ch == delim1) {
                flag.append(delim1);
                return buf.length();
            }
            buf.append((char)ch);
            ch = this.readChar();
        }
        return -1;
    }

    @Override
    public int readCharsUntil(StringBuffer buf, char[] delim1, char[] delim2, StringBuffer flag) throws IOException {
        int n = -1;
        int ch = -1;
        ch = this.readChar();
        while (ch != -1) {
            if (ch == delim2[0] && ((n = this.match(buf, ch, delim2, flag)) == -1 || n == 1)) {
                return buf.length();
            }
            if (ch == delim1[0] && ((n = this.match(buf, ch, delim1, flag)) == -1 || n == 1)) {
                return buf.length();
            }
            buf.append((char)ch);
            ch = this.readChar();
        }
        return -1;
    }

    public long skipUntil(char delim, StringBuffer flag) throws IOException {
        int i = 0;
        int ch = this.readChar();
        while (ch != -1) {
            if (ch == delim) {
                flag.append(delim);
                return i;
            }
            ++i;
            ch = this.readChar();
        }
        return i;
    }

    @Override
    public long skipUntil(char[] delim, StringBuffer flag) throws IOException {
        if (delim.length == 1) {
            return this.skipUntil(delim[0], flag);
        }
        int i = 0;
        int n = -1;
        int ch = -1;
        ch = this.readChar();
        while (ch != -1) {
            if (ch == delim[0] && ((n = this.match(new StringBuffer(), ch, delim, flag)) == -1 || n == 1)) {
                return i;
            }
            ++i;
            ch = this.readChar();
        }
        return i;
    }

    @Override
    public int skipLines(int lines) throws IOException {
        return -1;
    }

    @Override
    public int peekChars(char[] buf) throws IOException {
        this.fStream.mark(this.getByteCount(buf.length));
        int n = this.readCharacters(buf, null);
        this.fStream.reset();
        return n;
    }

    public boolean exists(char seq) throws IOException {
        this.fStream.mark(this.getByteCount(1));
        int ch = this.readCharacter(null);
        this.fStream.reset();
        return ch == seq;
    }

    @Override
    public boolean exists(char[] seq) throws IOException {
        this.fStream.mark(this.getByteCount(seq.length));
        char[] buf = new char[seq.length];
        int n = this.readCharacters(buf, null);
        this.fStream.reset();
        if (n < seq.length) {
            return false;
        }
        for (int i = 0; i < seq.length; ++i) {
            if (buf[i] == seq[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int readByte() throws IOException {
        int b = this.fStream.read();
        if (b != -1) {
            ++this.fOffset;
        }
        return b;
    }

    @Override
    public int readBytes(byte[] buf) throws IOException {
        return this.readBytes(buf, 0, buf.length);
    }

    @Override
    public int readBytes(byte[] buf, int off, int len) throws IOException {
        int b = this.fStream.read(buf, off, len);
        if (b != -1) {
            this.fOffset += (long)b;
        }
        return b;
    }

    @Override
    public int peekBytes(byte[] buf) throws IOException {
        this.fStream.mark(buf.length);
        int n = this.fStream.read(buf);
        this.fStream.reset();
        return n;
    }

    public boolean exists(byte seq) throws IOException {
        this.fStream.mark(1);
        int b = this.fStream.read();
        this.fStream.reset();
        return b == seq;
    }

    @Override
    public boolean exists(byte[] seq) throws IOException {
        this.fStream.mark(seq.length);
        byte[] buf = new byte[seq.length];
        int n = this.fStream.read(buf);
        this.fStream.reset();
        if (n < seq.length) {
            return false;
        }
        for (int i = 0; i < seq.length; ++i) {
            if (buf[i] == seq[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int skip(int n) throws IOException {
        int skipped = (int)this.fStream.skip(n);
        this.fOffset += (long)skipped;
        while (skipped < n && !this.isEof()) {
            int temp = (int)this.fStream.skip(n - skipped);
            skipped += temp;
            this.fOffset += (long)temp;
        }
        return skipped;
    }

    @Override
    public boolean markSupported() {
        return this.fStream.markSupported();
    }

    @Override
    public void mark(int readlimit) throws IOException {
        this.fStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.fStream.reset();
    }

    @Override
    public long getOffset() {
        return this.fOffset;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public String getPosition() {
        return "Offset=" + this.getOffset();
    }

    @Override
    public boolean isEof() throws IOException {
        this.fStream.mark(1);
        int b = this.fStream.read();
        this.fStream.reset();
        return b == -1;
    }

    @Override
    public void close() throws IOException {
        this.fStream.close();
    }

    @Override
    public short getStreamType() {
        return 0;
    }

    @Override
    public String getEncoding() {
        return this.fEncoding;
    }

    @Override
    public int match(StringBuffer buf, int ch, char[] delim, StringBuffer flag) throws IOException {
        int n = -1;
        boolean match = true;
        char[] delimBuf = new char[delim.length];
        StringBuffer bytesRead = new StringBuffer();
        if (delim.length > 1) {
            this.fStream.mark(this.getByteCount(delim.length));
            n = this.readCharacters(delimBuf, 1, delimBuf.length - 1, bytesRead);
            if (n < delimBuf.length - 1) {
                buf.append((char)ch);
                buf.append(delimBuf, 1, n);
                return -1;
            }
            for (int i = 1; i < delim.length; ++i) {
                if (delimBuf[i] == delim[i]) continue;
                match = false;
                break;
            }
        }
        if (match) {
            this.fOffset += (long)Integer.parseInt(bytesRead.toString());
            flag.append(delim);
            return 1;
        }
        this.fStream.reset();
        return 0;
    }

    private int getByteCount(int chars) {
        if (this.fEncoding != null) {
            return (int)Math.ceil(1.0 / (double)this.fMaxCharsPerByte) * chars;
        }
        return (int)(this.fMaxCharsPerByte * (float)chars);
    }

    private int readCharacter(StringBuffer bytes) throws IOException {
        byte[] buf = new byte[this.getByteCount(1)];
        int n = this.fStream.read(buf, 0, buf.length);
        if (n != -1) {
            String str = null;
            str = this.fEncoding != null ? new String(buf, 0, n, this.fEncoding) : new String(buf, 0, n);
            if (bytes != null) {
                bytes.append(n);
            }
            return str.charAt(0);
        }
        return -1;
    }

    private int readCharacters(char[] buf, StringBuffer bytes) throws IOException {
        return this.readCharacters(buf, 0, buf.length, bytes);
    }

    private int readCharacters(char[] buf, int off, int len, StringBuffer bytes) throws IOException {
        byte[] b = new byte[this.getByteCount(buf.length)];
        int n = this.fStream.read(b, 0, b.length);
        if (n != -1) {
            String str = null;
            str = this.fEncoding != null ? new String(b, 0, n, this.fEncoding) : new String(b, 0, n);
            System.arraycopy(str.toCharArray(), 0, buf, 0, str.length());
            if (bytes != null) {
                bytes.append(n);
            }
            return str.length();
        }
        return -1;
    }

    @Override
    public boolean lookAheadForMatch(int skip, byte[] peek) throws IOException {
        this.fStream.mark(skip + peek.length);
        byte[] buf = new byte[skip];
        int n = this.fStream.read(buf);
        if (n != -1) {
            buf = new byte[peek.length];
            n = this.fStream.read(buf);
            this.fStream.reset();
            if (n < peek.length) {
                return false;
            }
            for (int i = 0; i < peek.length; ++i) {
                if (buf[i] == peek[i]) continue;
                return false;
            }
            return true;
        }
        this.fStream.reset();
        return false;
    }

    @Override
    public boolean lookAheadForMatch(int skip, char[] peek) throws IOException {
        throw new IOException("Char lookAhead Not supported by ByteStream");
    }

    @Override
    public boolean lookAheadForMatch(int skip, byte[] peek, int scanLength) throws IOException {
        this.fStream.mark(skip + peek.length);
        byte[] buf = new byte[skip];
        int n = this.fStream.read(buf);
        if (n != -1) {
            buf = new byte[scanLength];
            n = this.fStream.read(buf);
            this.fStream.reset();
            if (n < scanLength) {
                return false;
            }
            String regex = new String(peek);
            String charSequence = new String(buf);
            return charSequence.matches(regex);
        }
        this.fStream.reset();
        return false;
    }

    @Override
    public boolean lookAheadForMatch(int skip, char[] peek, int scanLength) throws IOException {
        throw new IOException("Char lookAhead Not supported by ByteStream");
    }

    @Override
    public int lookAhead(int skip, char[] buf) throws IOException {
        throw new IOException("Char lookAhead Not supported by ByteStream");
    }

    @Override
    public int lookAhead(int skip, byte[] buf) throws IOException {
        this.fStream.mark(skip + buf.length);
        byte[] temp = new byte[skip];
        int n = this.fStream.read(temp);
        if (n != -1) {
            n = this.fStream.read(buf);
        }
        this.fStream.reset();
        return n;
    }

    @Override
    public void skipUniqueMessage(char[] sequence) {
    }

    @Override
    public boolean lookAheadForMatch(String lookFrom, String lookTill, String lookFor) throws IOException {
        return false;
    }

    @Override
    public int getScanLength() {
        return -1;
    }
}

