/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.xlators.dtd;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.tip.pc.services.translation.framework.TranslationContext;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.framework.Translator;
import oracle.tip.pc.services.translation.framework.XlatorHelper;
import oracle.tip.pc.services.translation.util.DeBatchXML;
import oracle.tip.pc.services.translation.xlators.dtd.InboundXMLFilter;
import oracle.tip.pc.services.translation.xlators.dtd.OutboundXMLFilter;
import oracle.tip.pc.services.translation.xlators.nxsd.ErrorList;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class DTDTranslator
implements Translator {
    private XMLSchema m_xsdDef = null;
    private XSDElement m_rootElem = null;
    private PrintWriter fLogWriter = null;
    private BufferedInputStream fBufStream = null;
    private int fPublishSize;
    private DeBatchXML fDeBatcher;
    private String fPrologEncoding = null;
    private String encoding = null;

    public DTDTranslator(XMLSchema defn, XSDElement elem) {
        this.m_xsdDef = defn;
        this.m_rootElem = elem;
    }

    private String getTargetNS() throws TranslationException {
        if (this.m_rootElem == null) {
            throw new TranslationException(11206, new Object[]{"Inbound DTD", "null", "Schema Root element"});
        }
        String ns = this.m_rootElem.getTargetNS();
        if (ns == null) {
            throw new TranslationException(11206, new Object[]{"Inbound DTD", "null", "root element namespace"});
        }
        return ns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translateFromNative(InputStream inputStream, Result result, TranslationContext ctx) throws TranslationException {
        if (inputStream == null || result == null) {
            throw new TranslationException(11206, new Object[]{"Inbound DTD", "null", "InputStream/Result"});
        }
        this.fBufStream = new BufferedInputStream(inputStream);
        InputSource inputSource = new InputSource(this.fBufStream);
        boolean fValidate = XlatorHelper.getValidation(this.m_xsdDef, this.m_rootElem);
        String ns = this.getTargetNS();
        XlatorHelper.logDebug(" Adding the namespace : " + ns + " in the inbound xml instance in the DTD Inbound Translator.");
        if (ctx != null && ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/debatching") && ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/debatching")) {
            try {
                try {
                    if (this.encoding == null) {
                        this.setEncoding(inputSource, ctx);
                    }
                    this.fPublishSize = 1;
                    String publishSize = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/publishsize");
                    if (publishSize != null && publishSize.trim().length() > 0) {
                        this.fPublishSize = Integer.parseInt(publishSize);
                    }
                    boolean errorRecovery = false;
                    if (ctx.hasFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery")) {
                        errorRecovery = ctx.getFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery");
                    }
                    if (errorRecovery) {
                        int iSkipRecords = 0;
                        ctx.setFeature("http://xmlns.oracle.com/pcbpel/nxsd/features/errorrecovery", false);
                        this.fDeBatcher = new DeBatchXML(this.fBufStream, this.fPublishSize);
                        String skipRecords = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/records-processed");
                        if (skipRecords != null && skipRecords.trim().length() > 0) {
                            iSkipRecords = Integer.parseInt(skipRecords);
                        }
                        this.fDeBatcher.skipRecords(iSkipRecords);
                    } else if (this.fDeBatcher == null) {
                        this.fDeBatcher = new DeBatchXML(this.fBufStream, this.fPublishSize);
                    }
                    Node node = this.fDeBatcher.getNextFragment(ctx);
                    if (node != null && result instanceof DOMResult) {
                        Document doc = node.getOwnerDocument();
                        Element rootElem = doc.getDocumentElement();
                        rootElem.setAttribute("xmlns", ns);
                        ((DOMResult)result).setNode(rootElem);
                    }
                    return;
                }
                catch (Exception ex) {
                    ErrorList errorList = new ErrorList();
                    errorList.addError(1, 1, -1, -1, -1L, -1L, ex);
                    errorList.setAllCorrupted(true);
                    ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/error-list", errorList);
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        this.setEncoding(inputSource, ctx);
        SAXParser saxParser = XlatorHelper.getSAXParser(0, Boolean.TRUE, true);
        InboundXMLFilter filter = new InboundXMLFilter((XMLReader)saxParser, ns);
        if (result instanceof SAXResult) {
            ContentHandler handler = ((SAXResult)result).getHandler();
            if (handler == null) {
                throw new TranslationException(11206, new Object[]{"Inbound DTD", "null", "SAXResult ContentHandler"});
            }
            XlatorHelper.saxParseInputStream(this.fBufStream, filter, handler);
        } else if (result instanceof DOMResult) {
            DocumentBuilder docBldr = new DocumentBuilder();
            XlatorHelper.setLexicalHdlr((XMLReader)saxParser, (LexicalHandler)docBldr);
            XMLDocument doc = XlatorHelper.buildDomFromSaxEvents(this.fBufStream, docBldr, saxParser, filter);
            ((DOMResult)result).setNode(doc.getDocumentElement());
        } else if (result instanceof StreamResult) {
            OutputStream out = ((StreamResult)result).getOutputStream();
            if (out == null) {
                throw new TranslationException(11206, new Object[]{"Inbound DTD", "null", "StreamResult OutputStream"});
            }
            XlatorHelper.copyStream(this.fBufStream, out);
        }
        XlatorHelper.logDebug("DTD translator : Inbound translation successfull.");
    }

    @Override
    public void translateToNative(Source source, OutputStream outputStream, TranslationContext ctx) throws TranslationException {
        if (source == null) {
            throw new TranslationException(11154);
        }
        if (source instanceof DOMSource && ((DOMSource)source).getNode() == null) {
            throw new TranslationException(11155);
        }
        if (outputStream == null || source == null) {
            throw new TranslationException(11206, new Object[]{"Outbound DTD", "null", "OutputStream/Source"});
        }
        InputStream inputStream = null;
        try {
            XlatorHelper.writeXMLProlog(this.m_xsdDef, this.m_rootElem, outputStream);
        }
        catch (IOException ioe) {
            throw new TranslationException(11207, new Object[]{"Outbound DTD", "  write the XML Prolog "}, ioe);
        }
        String encoding = XlatorHelper.getEncoding(this.m_xsdDef, this.m_rootElem);
        if (source instanceof SAXSource) {
            InputSource ins = ((SAXSource)source).getInputSource();
            if (ins == null) {
                throw new TranslationException(11206, new Object[]{"Outbound XSD", "null", "InputSource in SAXSource"});
            }
            inputStream = ins.getByteStream();
            SAXParser saxParser = XlatorHelper.getSAXParser(0, Boolean.TRUE, true);
            OutboundXMLFilter filter = new OutboundXMLFilter((XMLReader)saxParser, outputStream, encoding);
            XlatorHelper.setLexicalHdlr((XMLReader)saxParser, filter);
            XlatorHelper.saxParseInputStream(inputStream, filter, (ContentHandler)filter.getSerializer());
        } else if (source instanceof DOMSource) {
            OutboundXMLFilter filter = new OutboundXMLFilter(outputStream, encoding);
            filter.setContentHandler((ContentHandler)filter.getSerializer());
            XlatorHelper.raiseEvents((DOMSource)source, (ContentHandler)filter);
        } else if (source instanceof StreamSource) {
            inputStream = ((StreamSource)source).getInputStream();
            SAXParser saxParser = XlatorHelper.getSAXParser(0, Boolean.TRUE);
            OutboundXMLFilter filter = new OutboundXMLFilter((XMLReader)saxParser, outputStream, encoding);
            XlatorHelper.setLexicalHdlr((XMLReader)saxParser, filter);
            XlatorHelper.saxParseInputStream(inputStream, filter, (ContentHandler)filter.getSerializer());
        }
        XlatorHelper.logDebug("DTD translator : Outbound translation successfull.");
    }

    @Override
    public XMLSchema getSchema() {
        return this.m_xsdDef;
    }

    @Override
    public XSDElement getRootElement() {
        return this.m_rootElem;
    }

    @Override
    public void translateFromNative(Reader reader, Result xmlResult, TranslationContext ctx) throws TranslationException {
        throw new TranslationException(11119, new Object[]{"Reader", "in DTD Translator yet."});
    }

    @Override
    public void translateToNative(Source xmlSource, Writer writer, TranslationContext ctx) throws TranslationException {
        throw new TranslationException(11119, new Object[]{"Writer", "in DTD Translator yet."});
    }

    @Override
    public void setLogWriter(PrintWriter pw) {
        this.fLogWriter = pw;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.fLogWriter;
    }

    private void setEncoding(InputSource inputSource, TranslationContext ctx) throws TranslationException {
        try {
            if (this.fPrologEncoding != null) {
                XlatorHelper.logDebug("Encoding already resolved to :" + this.fPrologEncoding);
                inputSource.setEncoding(this.fPrologEncoding);
                return;
            }
            if (ctx != null && ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding") != null) {
                this.fPrologEncoding = (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding");
                XlatorHelper.logDebug("input encoding " + (String)ctx.getProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/input-encoding"));
            } else {
                this.fPrologEncoding = XlatorHelper.getSchemaAttrValue(this.m_xsdDef, this.m_rootElem, "encoding");
            }
            if (this.fPrologEncoding == null) {
                this.fPrologEncoding = XlatorHelper.prologHasEncoding(this.fBufStream) ? XlatorHelper.getPrologEncoding() : "UTF-8";
            }
            inputSource.setEncoding(this.fPrologEncoding);
        }
        catch (IOException e1) {
            throw new TranslationException(11207, new Object[]{"Inbound xml", "  XML prolog peek failure... "}, e1);
        }
    }
}

