/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.util;

import java.io.InputStream;
import java.io.Reader;
import java.util.Stack;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import oracle.tip.pc.services.translation.framework.TranslationContext;
import oracle.tip.pc.services.translation.xlators.nxsd.ErrorList;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DeBatchXML {
    private static final String FILLER = "XXXX";
    private Stack fStack;
    private Element fRoot;
    private Attributes fRootAttrs;
    private DocumentBuilder fDOMBuilder;
    private XMLStreamReader fXMLStreamReader;
    private int fPublishSize;
    private int fCurrentSize;
    private int fTotalRecordsDone;

    public DeBatchXML(InputStream in, int pubSize) throws FactoryConfigurationError, XMLStreamException {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        this.fXMLStreamReader = xmlif.createXMLStreamReader(in);
        this.fStack = new Stack();
        this.fPublishSize = pubSize;
        this.fCurrentSize = 0;
        this.fTotalRecordsDone = 0;
    }

    public DeBatchXML(Reader in, int pubSize) throws FactoryConfigurationError, XMLStreamException {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        this.fXMLStreamReader = xmlif.createXMLStreamReader(in);
        this.fStack = new Stack();
        this.fPublishSize = pubSize;
        this.fCurrentSize = 0;
        this.fTotalRecordsDone = 0;
    }

    public Node getNextFragment(TranslationContext ctx) throws XMLStreamException, SAXException {
        this.reset();
        int curLine = 0;
        int curColumn = 0;
        int startLine = 0;
        int startColumn = 0;
        while (this.fXMLStreamReader.hasNext()) {
            if (this.fStack.size() == 1) {
                curLine = this.fXMLStreamReader.getLocation().getLineNumber();
                curColumn = this.fXMLStreamReader.getLocation().getColumnNumber();
            }
            int eventType = this.fXMLStreamReader.next();
            switch (eventType) {
                case 1: {
                    AttributesImpl attrs = new AttributesImpl();
                    for (int i = 0; i < this.fXMLStreamReader.getAttributeCount(); ++i) {
                        attrs.addAttribute(this.fXMLStreamReader.getAttributeNamespace(i), this.fXMLStreamReader.getAttributeLocalName(i), this.fXMLStreamReader.getAttributeLocalName(i), this.fXMLStreamReader.getAttributeType(i), this.fXMLStreamReader.getAttributeValue(i));
                    }
                    this.fDOMBuilder.startElement(this.fXMLStreamReader.getNamespaceURI() == null ? "" : this.fXMLStreamReader.getNamespaceURI(), this.fXMLStreamReader.getLocalName(), this.fXMLStreamReader.getLocalName(), (Attributes)attrs);
                    if (this.fStack.empty()) {
                        XMLDocument doc = new XMLDocument();
                        this.fRoot = (Element)doc.importNode((Node)this.fDOMBuilder.getDocument().getDocumentElement(), true);
                        this.fRootAttrs = attrs;
                    }
                    if (this.fStack.size() == 1 && startLine == 0) {
                        startLine = curLine;
                        startColumn = curColumn;
                        if (ctx != null) {
                            ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/line-number", "" + startLine);
                            ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/column-number", "" + startColumn);
                        }
                    }
                    this.fStack.push(FILLER);
                    break;
                }
                case 2: {
                    this.fDOMBuilder.endElement(this.fXMLStreamReader.getNamespaceURI() == null ? "" : this.fXMLStreamReader.getNamespaceURI(), this.fXMLStreamReader.getLocalName(), this.fXMLStreamReader.getLocalName());
                    this.fStack.pop();
                    if (this.fStack.size() != 1) break;
                    ++this.fCurrentSize;
                    if (this.fCurrentSize != this.fPublishSize) break;
                    this.endRootElement();
                    this.done(false, ctx);
                    return this.fDOMBuilder.getDocument().getDocumentElement();
                }
                case 4: {
                    this.fDOMBuilder.characters(this.fXMLStreamReader.getTextCharacters(), this.fXMLStreamReader.getTextStart(), this.fXMLStreamReader.getTextLength());
                    break;
                }
                case 3: {
                    this.fDOMBuilder.processingInstruction(this.fXMLStreamReader.getPITarget(), this.fXMLStreamReader.getPIData());
                    break;
                }
                case 12: {
                    this.fDOMBuilder.cDATASection(this.fXMLStreamReader.getTextCharacters(), this.fXMLStreamReader.getTextStart(), this.fXMLStreamReader.getTextLength());
                    break;
                }
                case 5: {
                    this.fDOMBuilder.comment(this.fXMLStreamReader.getTextCharacters(), this.fXMLStreamReader.getTextStart(), this.fXMLStreamReader.getTextLength());
                    break;
                }
            }
        }
        if (this.fCurrentSize > 0) {
            this.done(true, ctx);
            return this.fDOMBuilder.getDocument().getDocumentElement();
        }
        ctx.setFeature("http://xmlns.oracle.com/pcbpel/nxsd/properties/end-of-file", true);
        return null;
    }

    public void skipRecords(int n) throws XMLStreamException {
        this.fCurrentSize = 0;
        while (this.fXMLStreamReader.hasNext()) {
            int eventType = this.fXMLStreamReader.next();
            switch (eventType) {
                case 1: {
                    if (this.fStack.empty()) {
                        XMLDocument doc = new XMLDocument();
                        this.fRoot = doc.createElementNS(this.fXMLStreamReader.getNamespaceURI() == null ? "" : this.fXMLStreamReader.getNamespaceURI(), this.fXMLStreamReader.getLocalName());
                        AttributesImpl attrs = new AttributesImpl();
                        for (int i = 0; i < this.fXMLStreamReader.getAttributeCount(); ++i) {
                            attrs.addAttribute(this.fXMLStreamReader.getAttributeNamespace(i), this.fXMLStreamReader.getAttributeLocalName(i), this.fXMLStreamReader.getAttributeName(i).toString(), this.fXMLStreamReader.getAttributeType(i), this.fXMLStreamReader.getAttributeValue(i));
                        }
                        this.fRootAttrs = attrs;
                    }
                    this.fStack.push(FILLER);
                    break;
                }
                case 2: {
                    this.fStack.pop();
                    if (this.fStack.size() != 1) break;
                    ++this.fCurrentSize;
                    if (this.fCurrentSize != n) break;
                    return;
                }
            }
        }
    }

    private void reset() throws SAXException {
        this.fCurrentSize = 0;
        this.fDOMBuilder = new DocumentBuilder();
        this.fDOMBuilder.startDocument();
        if (this.fRoot != null) {
            this.startRootElement();
        }
    }

    private void done(boolean eof, TranslationContext ctx) throws SAXException {
        if (!eof) {
            this.fDOMBuilder.endDocument();
        }
        this.fTotalRecordsDone += this.fCurrentSize;
        if (ctx != null) {
            ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/records-processed", "" + this.fTotalRecordsDone);
            ErrorList errorList = new ErrorList();
            ctx.setProperty("http://xmlns.oracle.com/pcbpel/nxsd/properties/error-list", errorList);
            ctx.setFeature("http://xmlns.oracle.com/pcbpel/nxsd/properties/end-of-file", eof);
        }
    }

    private void startRootElement() throws SAXException {
        this.fDOMBuilder.startElement(this.fRoot.getNamespaceURI(), this.fRoot.getLocalName(), this.fRoot.getNodeName(), this.fRootAttrs);
    }

    private void endRootElement() throws SAXException {
        this.fDOMBuilder.endElement(this.fRoot.getNamespaceURI(), this.fRoot.getLocalName(), this.fRoot.getNodeName());
    }

    public int getTotalRecordsDone() {
        return this.fTotalRecordsDone;
    }
}

