/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.tools.ecx;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.tip.pc.services.translation.framework.Translator;
import oracle.tip.pc.services.translation.framework.TranslatorFactory;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;

public class Converter {
    public static void main(String[] args) {
        try {
            Converter converter = new Converter();
            XSDBuilder schemaBuilder = new XSDBuilder();
            XMLSchema nativeSchema = null;
            String root = null;
            StreamSource xsl = null;
            XSDElement rootElement = null;
            if (args.length < 9 || "-help".equals(args[0]) || args.length > 11 || !"-outbound".equals(args[0]) && !"-inbound".equals(args[0])) {
                Converter.showUsage();
            } else if ("-outbound".equals(args[0])) {
                FileInputStream ecgFF = null;
                StreamResult edifecsXML = null;
                for (int i = 1; i < args.length; ++i) {
                    if ("-xml".equals(args[i])) {
                        edifecsXML = new StreamResult(new FileOutputStream(args[++i]));
                        continue;
                    }
                    if ("-ff".equals(args[i])) {
                        ecgFF = new FileInputStream(args[++i]);
                        continue;
                    }
                    if ("-xsl".equals(args[i])) {
                        if (args[i + 1].equals("null")) {
                            ++i;
                            continue;
                        }
                        xsl = new StreamSource(args[++i]);
                        continue;
                    }
                    if ("-schema".equals(args[i])) {
                        nativeSchema = schemaBuilder.build(args[++i]);
                        continue;
                    }
                    if (!"-root".equals(args[i])) continue;
                    root = args[++i];
                }
                if (edifecsXML == null || ecgFF == null || nativeSchema == null || root == null) {
                    throw new Exception("Cannot proceed with xlation and xformation as some of the arguments passed is null.");
                }
                rootElement = nativeSchema.getElement(nativeSchema.getSchemaTargetNS(), root);
                converter.convertFromECG(ecgFF, nativeSchema, rootElement, xsl, edifecsXML);
            } else if ("-inbound".equals(args[0])) {
                FileOutputStream ecgFF = null;
                String xmlFile = null;
                for (int i = 1; i < args.length; ++i) {
                    if ("-xml".equals(args[i])) {
                        xmlFile = args[++i];
                        continue;
                    }
                    if ("-ff".equals(args[i])) {
                        ecgFF = new FileOutputStream(args[++i]);
                        continue;
                    }
                    if ("-xsl".equals(args[i])) {
                        if (args[i + 1].equals("null")) {
                            ++i;
                            continue;
                        }
                        xsl = new StreamSource(args[++i]);
                        continue;
                    }
                    if ("-schema".equals(args[i])) {
                        nativeSchema = schemaBuilder.build(args[++i]);
                        continue;
                    }
                    if (!"-root".equals(args[i])) continue;
                    root = args[++i];
                }
                if (xmlFile == null || ecgFF == null || nativeSchema == null || root == null) {
                    throw new Exception("Cannot proceed with xlation and xformation as some of the arguments passed is null.");
                }
                DOMParser parser = new DOMParser();
                parser.parse(xmlFile);
                XMLDocument doc = parser.getDocument();
                DOMSource edifecsXML = new DOMSource((Node)doc);
                rootElement = nativeSchema.getElement(nativeSchema.getSchemaTargetNS(), root);
                converter.convertToECG(edifecsXML, xsl, nativeSchema, rootElement, ecgFF);
            }
            System.out.println("\n[SUCCESS] Conversion done successfully.");
        }
        catch (Exception e) {
            System.out.println("\n[FAILURE] " + e.getMessage());
            System.out.println("STACKTRACE\n[[");
            e.printStackTrace();
            System.out.println("]]");
        }
    }

    private static void showUsage() {
        System.out.println("\nusage: java oracle.ecg.tools.Converter <command>");
        System.out.println("\ncommands:");
        System.out.println("-outbound  Converts an ECG FF to EDIFECS XML.");
        System.out.println(" options:\n\t-ff <ecg FF location> \n\t-schema <NativeSchema URI> \n\t-root <localname of root> \n\t-xsl <XSL URI> \n\t-xml <output XML file location>");
        System.out.println("\n-inbound Converts an EDIFECS XML to ECG FF.");
        System.out.println(" options:\n\t-xml <edifecs XML URI> \n\t-xsl <XSL URI> \n\t-schema <NativeSchema URI> \n\t-root <localname of root> \n\t-ff <output FF location>");
        System.exit(0);
    }

    public void convertToECG(Source edifecsXML, Source xsl, XMLSchema nativeSchema, XSDElement root, OutputStream ecgFF) throws Exception {
        DOMResult ecgXMLresult = new DOMResult((Node)new XMLDocument());
        TransformerFactory xformerFactory = TransformerFactory.newInstance();
        Transformer xformer = null;
        xformer = xsl == null ? xformerFactory.newTransformer() : xformerFactory.newTransformer(xsl);
        xformer.transform(edifecsXML, ecgXMLresult);
        DOMSource ecgXML = new DOMSource(ecgXMLresult.getNode());
        TranslatorFactory xlatorFactory = TranslatorFactory.getInstance();
        Translator xlator = xlatorFactory.createTranslator(nativeSchema, root);
        xlator.translateToNative((Source)ecgXML, ecgFF, null);
    }

    public void convertFromECG(InputStream ecgFF, XMLSchema nativeSchema, XSDElement root, Source xsl, Result edifecsXML) throws Exception {
        TranslatorFactory xlatorFactory = TranslatorFactory.getInstance();
        Translator xlator = xlatorFactory.createTranslator(nativeSchema, root);
        DOMResult ecgXMLresult = new DOMResult();
        xlator.translateFromNative(ecgFF, (Result)ecgXMLresult, null);
        DOMSource ecgXML = new DOMSource(ecgXMLresult.getNode());
        TransformerFactory xformerFactory = TransformerFactory.newInstance();
        Transformer xformer = null;
        xformer = xsl == null ? xformerFactory.newTransformer() : xformerFactory.newTransformer(xsl);
        xformer.transform(ecgXML, edifecsXML);
    }
}

