/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.importer.dtd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import oracle.tip.pc.services.translation.importer.dtd.DTDImportException;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DTDImporter {
    public static final String TARGETNAMESPACE = "targetNamespace";
    public static final String DEFAULTNAMESPACE = "xmlns";
    public static final String DTD = "DTD";
    public static final String NXSD_NAMESPACE_URI = "http://xmlns.oracle.com/pcbpel/nxsd";
    public static final String DEF_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String VERSION = "nxsd:version";
    public static final String COMMENT = "This Schema has been generated from a DTD. A target namespace has been added to the schema.";
    public static final String NAMESPACE_key = "NAMESPACE";
    public static final String ROOTNAME_key = "ROOTNAME";
    public static final String DTDNAME_key = "DTDNAME";

    public static XMLDocument createNXSD(String dtdLocn, Hashtable table) throws DTDImportException {
        String nameSpace = (String)table.get(NAMESPACE_key);
        String rootName = (String)table.get(ROOTNAME_key);
        return DTDImporter.convertDTD2Schema(dtdLocn, nameSpace, rootName);
    }

    public static XMLDocument createNXSD(StringBuffer dtdStringBuff, Hashtable table) throws DTDImportException {
        String nameSpace = (String)table.get(NAMESPACE_key);
        String rootName = (String)table.get(ROOTNAME_key);
        String dtdName = (String)table.get(DTDNAME_key);
        return DTDImporter.convertDTD2Schema(dtdStringBuff, nameSpace, rootName, dtdName);
    }

    public static XMLDocument convertDTD2Schema(StringBuffer dtdStringBuff, String targetNS, String dtdRoot, String dtdName) throws DTDImportException {
        XMLDocument xsdDoc = null;
        try {
            DTD dtd = DTDImporter.getDTD(dtdStringBuff, dtdRoot);
            xsdDoc = dtd.convertDTD2Schema();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DTDImportException(11238, new Object[]{dtdName + " Please ensure that the root element is set to the root element of the DTD "}, e);
        }
        catch (IOException e) {
            throw new DTDImportException(11238, new Object[]{dtdName + " This was caused by an IO exception. Please verify that the dtd is specified correctly"}, e);
        }
        catch (SAXException e) {
            throw new DTDImportException(11238, new Object[]{dtdName + " Error parsing DTD. Ensure DTD is valid"}, e);
        }
        DTDImporter.validateSchema(xsdDoc);
        DTDImporter.insertNS(xsdDoc, targetNS);
        return xsdDoc;
    }

    public static XMLDocument convertDTD2Schema(String dtdLocn, String targetNS, String dtdRoot) throws DTDImportException {
        XMLDocument xsdDoc = null;
        try {
            URL dtdURL = DTDImporter.createURL(dtdLocn);
            DTD dtd = DTDImporter.getDTD(dtdURL, dtdRoot);
            xsdDoc = dtd.convertDTD2Schema();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DTDImportException(11238, new Object[]{dtdLocn + " Please ensure that the root element is set to the root element of the DTD "}, e);
        }
        catch (MalformedURLException e) {
            throw new DTDImportException(11238, new Object[]{dtdLocn + " Please verify that the dtd location is specified correctly"}, e);
        }
        catch (IOException e) {
            throw new DTDImportException(11238, new Object[]{dtdLocn + " This was caused by an IO exception. Please verify that the dtd location is specified correctly"}, e);
        }
        catch (XMLParseException e) {
            throw new DTDImportException(11238, new Object[]{dtdLocn + " Error parsing DTD. Ensure DTD is valid"}, e);
        }
        catch (SAXException e) {
            throw new DTDImportException(11238, new Object[]{dtdLocn + " Error parsing DTD. Ensure DTD is valid"}, e);
        }
        DTDImporter.validateSchema(xsdDoc);
        DTDImporter.insertNS(xsdDoc, targetNS);
        return xsdDoc;
    }

    private static void validateSchema(XMLDocument xsdDoc) {
        try {
            XSDBuilder builder = new XSDBuilder();
            XMLSchema xMLSchema = builder.build(xsdDoc, null);
        }
        catch (XSDException e) {
            System.out.println("Generated native schema has errors that need to be corrected." + e.getMessage());
        }
    }

    private static DTD getDTD(StringBuffer dtdStrBuff, String rootName) throws IOException, SAXException {
        DOMParser parser = new DOMParser();
        DTD dtd = null;
        parser.setValidationMode(0);
        parser.setErrorStream((OutputStream)System.out);
        parser.showWarnings(true);
        StringReader strReader = new StringReader(dtdStrBuff.toString());
        parser.parseDTD((Reader)strReader, rootName);
        dtd = parser.getDoctype();
        return dtd;
    }

    private static DTD getDTD(URL dtdURL, String rootName) throws IOException, XMLParseException, SAXException {
        DOMParser parser = new DOMParser();
        DTD dtd = null;
        parser.setValidationMode(0);
        parser.setErrorStream((OutputStream)System.out);
        parser.showWarnings(true);
        parser.parseDTD(dtdURL, rootName);
        dtd = parser.getDoctype();
        return dtd;
    }

    private static URL createURL(String fileName) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            String path = f.getAbsolutePath();
            String fs = System.getProperty("file.separator");
            if (fs.length() == 1) {
                char sep = fs.charAt(0);
                if (sep != '/') {
                    path = path.replace(sep, '/');
                }
                if (path.charAt(0) != '/') {
                    path = '/' + path;
                }
            }
            path = "file://" + path;
            url = new URL(path);
        }
        return url;
    }

    private static void insertNS(XMLDocument xsdDoc, String targetNamespace) {
        Element schemaElement = xsdDoc.getDocumentElement();
        Comment comment = xsdDoc.createComment(COMMENT);
        schemaElement.getParentNode().insertBefore(comment, schemaElement);
        schemaElement.setAttribute(TARGETNAMESPACE, targetNamespace);
        schemaElement.setAttribute(DEFAULTNAMESPACE, targetNamespace);
        schemaElement.setAttributeNS(NXSD_NAMESPACE_URI, VERSION, DTD);
    }

    private static String readFile(String fileName) {
        try {
            FileInputStream stream = new FileInputStream(fileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuffer fileContents = new StringBuffer();
            String line = new String();
            while ((line = reader.readLine()) != null) {
                fileContents = fileContents.append(line);
            }
            return fileContents.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: java DTDImporter <dtd_locn> <tgt_namespace> <rootElement> <<apps_mode>>");
            return;
        }
        String dtdlocn = args[0];
        String ns = args[1];
        String rootName = args[2];
        String appsMode = null;
        if (args.length > 3) {
            appsMode = args[3];
        }
        boolean isAppsMode = new Boolean(appsMode);
        try {
            Hashtable<String, String> ht = new Hashtable<String, String>(3);
            ht.put(NAMESPACE_key, ns);
            ht.put(ROOTNAME_key, rootName);
            XMLDocument xsd = null;
            if (!isAppsMode) {
                xsd = DTDImporter.createNXSD(dtdlocn, ht);
            } else {
                StringBuffer strBuff = new StringBuffer(DTDImporter.readFile(dtdlocn));
                xsd = DTDImporter.createNXSD(strBuff, ht);
            }
            try {
                xsd.print((OutputStream)new FileOutputStream(dtdlocn + ".xsd"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (DTDImportException e) {
            e.printStackTrace();
        }
    }
}

