/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.importer.ccb;

import java.util.List;
import java.util.StringTokenizer;
import oracle.tip.pc.services.translation.importer.ccb.CopyBookException;
import oracle.tip.pc.services.translation.importer.ccb.ElementaryItem;
import oracle.tip.pc.services.translation.importer.ccb.GroupItem;
import oracle.tip.pc.services.translation.importer.ccb.IGroupItem;
import oracle.tip.pc.services.translation.importer.ccb.Item;
import oracle.tip.pc.services.translation.importer.ccb.Usage;

public class StructureBuilder {
    public static final int MAXLEVELS = 50;
    public static final String[] SIMPLE_EDITS = new String[]{" ", "/", ","};
    public static final String[] NUMERIC_EDITS = new String[]{".", "$", "+", "-"};
    public static final String UNSUPPORTED_CLAUSE = ": \n Clause could not be correctly converted to a schema type. Please modify the generated schema to cater to this type.\n  Refer to the documentation for assistance.";
    private int m_currLineNum;
    private boolean m_isBinary = false;
    private IGroupItem m_masterGroup;

    public boolean isBinaryMode() {
        return this.m_isBinary;
    }

    void buildStructure(String ccbString, IGroupItem records) throws CopyBookException {
        IGroupItem prevGroup = records;
        this.m_masterGroup = records;
        Item currentItem = null;
        String itemString = "";
        StringTokenizer lineTokenizer = new StringTokenizer(ccbString, System.getProperty("line.separator"), false);
        while (lineTokenizer.hasMoreTokens()) {
            itemString = this.getLine(lineTokenizer);
            if (itemString.trim().length() <= 0) continue;
            currentItem = this.createItem(itemString);
            this.setStreamType(currentItem);
            prevGroup = this.insert(currentItem, prevGroup, records);
        }
    }

    private void setStreamType(Item item) {
        if (item.getSignClause() != -1 || !item.getUsage().equals("DISPLAY")) {
            this.m_isBinary = true;
        }
    }

    private IGroupItem insert(Item currentItem, IGroupItem prevGroup, IGroupItem tree) throws CopyBookException {
        int currLevel = currentItem.getLevelNum();
        int prevLevel = ((Item)((Object)prevGroup)).getLevelNum();
        if (prevLevel == 0) {
            tree.addChild(currentItem);
            currentItem.setParent(tree);
        } else if (currLevel == prevLevel) {
            currentItem.setParent(((Item)((Object)prevGroup)).getParent());
            ((Item)((Object)prevGroup)).getParent().addChild(currentItem);
        } else if (currLevel > prevLevel) {
            prevGroup.addChild(currentItem);
            currentItem.setParent(prevGroup);
        } else if (currLevel < prevLevel) {
            while (currLevel <= prevLevel) {
                prevGroup = ((Item)((Object)prevGroup)).getParent();
                prevLevel = ((Item)((Object)prevGroup)).getLevelNum();
            }
            prevGroup.addChild(currentItem);
            currentItem.setParent(prevGroup);
        }
        if (currentItem.getRedefines()) {
            currentItem.setRedefinedItem(currentItem.getRedefinedItemName());
        }
        if (currentItem instanceof ElementaryItem) {
            return currentItem.getParent();
        }
        return (IGroupItem)((Object)currentItem);
    }

    private String getLine(StringTokenizer lineTokenizer) {
        String currentLine = lineTokenizer.nextToken();
        ++this.m_currLineNum;
        if (!currentLine.trim().startsWith("*") && currentLine.trim().length() > 0) {
            while (!currentLine.trim().endsWith(".")) {
                currentLine = currentLine + lineTokenizer.nextToken();
                ++this.m_currLineNum;
            }
            currentLine = currentLine.substring(0, currentLine.lastIndexOf("."));
            return currentLine;
        }
        return "";
    }

    private Item createItem(String currLine) throws CopyBookException {
        StringTokenizer lineTokens = new StringTokenizer(currLine);
        Item item = null;
        String[] tokens = new String[lineTokens.countTokens()];
        int index = 0;
        while (lineTokens.hasMoreTokens()) {
            tokens[index++] = lineTokens.nextToken();
        }
        index = 0;
        String tokenLevel = tokens[index++];
        int levelNumber = StructureBuilder.intFromString(tokenLevel);
        boolean namedData = true;
        String name = null;
        if (this.isKeyWord(tokens[index])) {
            name = Item.FILLER;
            namedData = false;
        } else {
            name = tokens[index++];
        }
        item = this.isElementaryItem(tokens) ? new ElementaryItem(levelNumber, name) : new GroupItem(levelNumber, name);
        try {
            this.setItemAttrs(item, tokens, index);
            item.setCobolClause(currLine);
        }
        catch (CopyBookException ccbExcptn) {
            System.out.println(ccbExcptn.getMessage());
            item.setCobolClause(currLine + UNSUPPORTED_CLAUSE);
        }
        return item;
    }

    private void setItemAttrs(Item item, String[] tokens, int index) throws CopyBookException {
        int incr = 0;
        for (int i = index; i < tokens.length; i += incr) {
            if (tokens[i].equalsIgnoreCase("PIC") || tokens[i].equalsIgnoreCase("PICTURE")) {
                incr = this.setPicAttrs(item, tokens, i);
                continue;
            }
            if (tokens[i].equalsIgnoreCase("OCCURS")) {
                incr = this.setOccursAttrs(item, tokens, i);
                continue;
            }
            if (tokens[i].equalsIgnoreCase("REDEFINES")) {
                incr = this.setRedefAttrs(item, tokens, i);
                continue;
            }
            if (tokens[i].equalsIgnoreCase("USAGE") || Usage.getCanonicalUsage(tokens[i]) != null) {
                incr = this.setUsageAttrs(item, tokens, i);
                continue;
            }
            if (tokens[i].equalsIgnoreCase("SYNC") || tokens[i].equalsIgnoreCase("SYNCHRONIZED")) {
                incr = this.setSyncAttrs(item, tokens, i);
                continue;
            }
            if (tokens[i].equalsIgnoreCase("JUST") || tokens[i].equalsIgnoreCase("JUSTIFIED")) {
                incr = this.setJustAttrs(item, tokens, i);
                continue;
            }
            if (tokens[i].equalsIgnoreCase("SIGN") || tokens[i].equalsIgnoreCase("LEADING") || tokens[i].equalsIgnoreCase("TRAILING")) {
                incr = this.setSignAttrs(item, tokens, i);
                continue;
            }
            if (tokens[i].equalsIgnoreCase("GLOBAL")) {
                incr = this.setGlobalAttrs(item, tokens, i);
                continue;
            }
            if (tokens[i].equalsIgnoreCase("EXTERNAL")) {
                incr = this.setExternalAttrs(item, tokens, i);
                continue;
            }
            if (tokens[i].equalsIgnoreCase("BLANK")) {
                incr = this.setBlankWhenZeroAttrs(item, tokens, i);
                continue;
            }
            throw new CopyBookException(11222, new Object[]{tokens[i], String.valueOf(this.m_currLineNum)});
        }
    }

    private int setPicAttrs(Item item, String[] tokens, int index) throws CopyBookException {
        int picSize = 0;
        int incr = index + 1;
        if (tokens[incr].equalsIgnoreCase("IS")) {
            // empty if block
        }
        ElementaryItem field = (ElementaryItem)item;
        int n = ++incr;
        ++incr;
        String picStmt = tokens[n];
        if (picStmt.toUpperCase().startsWith("A")) {
            field.setType(3);
            picSize = this.getSize(picStmt, field);
            field.setPicSize(picSize);
        } else if (picStmt.toUpperCase().startsWith("X")) {
            if (this.isPresent(SIMPLE_EDITS, picStmt)) {
                field.setType(5);
            } else {
                field.setType(2);
            }
            picSize = this.getSize(picStmt, field);
            field.setPicSize(picSize);
        } else if (picStmt.toUpperCase().startsWith("9") || picStmt.toUpperCase().startsWith("V") || picStmt.toUpperCase().startsWith("S")) {
            if (this.isPresent(SIMPLE_EDITS, picStmt) || this.isPresent(NUMERIC_EDITS, picStmt)) {
                field.setType(4);
            } else {
                field.setType(1);
            }
            picSize = this.getSize(picStmt, field);
            field.setPicSize(picSize);
        }
        return incr - index;
    }

    int setUsageAttrs(Item item, String[] tokens, int index) {
        int incr = index;
        if (!tokens[incr].equalsIgnoreCase("USAGE") || tokens[++incr].equalsIgnoreCase("IS")) {
            // empty if block
        }
        int n = ++incr;
        ++incr;
        String usage = Usage.getCanonicalUsage(tokens[n]);
        item.setUsage(usage);
        if (item instanceof ElementaryItem && (usage.equals("COMP-1") || usage.equals("COMP-2"))) {
            ((ElementaryItem)item).setType(1);
        }
        return incr - index;
    }

    int setRedefAttrs(Item item, String[] tokens, int index) throws CopyBookException {
        int incr = index + 1;
        String dataName2 = tokens[incr++];
        item.setRedefines(true);
        item.setRedefinedItemName(dataName2);
        return incr - index;
    }

    int setJustAttrs(Item item, String[] tokens, int index) {
        int incr = index + 1;
        if (incr < tokens.length && tokens[incr].equalsIgnoreCase("RIGHT")) {
            ++incr;
        }
        item.setJustified(true);
        return incr - index;
    }

    int setExternalAttrs(Item item, String[] tokens, int index) {
        return 1;
    }

    int setBlankWhenZeroAttrs(Item item, String[] tokens, int index) {
        int incr = index + 1;
        if (tokens[incr].equalsIgnoreCase("WHEN")) {
            ++incr;
        }
        if (tokens[incr].equalsIgnoreCase("ZERO") || tokens[incr].equalsIgnoreCase("ZEROS") || tokens[incr].equalsIgnoreCase("ZEROES")) {
            ++incr;
        }
        return incr - index;
    }

    int setGlobalAttrs(Item item, String[] tokens, int index) {
        return 1;
    }

    int setSignAttrs(Item item, String[] tokens, int index) {
        int incr = index;
        if (tokens[incr].equalsIgnoreCase("SIGN") && tokens[++incr].equalsIgnoreCase("IS")) {
            ++incr;
        }
        if (tokens[incr].equalsIgnoreCase("LEADING")) {
            ++incr;
            item.setSignClause(0);
        } else if (tokens[incr].equalsIgnoreCase("TRAILING")) {
            ++incr;
            item.setSignClause(1);
        }
        if (incr < tokens.length && tokens[incr].equalsIgnoreCase("SEPARATE")) {
            ++incr;
            if (item.getSignClause() == 0) {
                item.setSignClause(2);
            } else if (item.getSignClause() == 1) {
                item.setSignClause(3);
            }
            if (incr < tokens.length && tokens[incr].equalsIgnoreCase("CHARACTER")) {
                ++incr;
            }
        }
        return incr - index;
    }

    int setSyncAttrs(Item item, String[] tokens, int index) {
        int incr = index + 1;
        if (incr < tokens.length && (tokens[incr].equalsIgnoreCase("RIGHT") || tokens[incr].equalsIgnoreCase("LEFT"))) {
            ++incr;
        }
        return incr - index;
    }

    int getSize(String picStmt, ElementaryItem field) throws CopyBookException {
        char[] picChars = picStmt.toCharArray();
        int length = picChars.length;
        int index = 0;
        int size = 0;
        block9: while (index < length) {
            char currentChar = picChars[index];
            switch (currentChar) {
                case '(': {
                    String number = new String();
                    --size;
                    currentChar = picChars[++index];
                    while (index < length && currentChar != ')') {
                        number = number + currentChar;
                        currentChar = picChars[++index];
                    }
                    try {
                        Integer value = new Integer(number);
                        size += value.intValue();
                    }
                    catch (NumberFormatException exception) {
                        throw new CopyBookException(11223, new Object[]{String.valueOf(this.m_currLineNum), "In pic statement a valid integer must be enclosed by the parenthesis"}, exception);
                    }
                    if (currentChar == ')') {
                        ++index;
                        continue block9;
                    }
                    throw new CopyBookException(11223, new Object[]{String.valueOf(this.m_currLineNum), "An open parenthesis must be followed by a close parenthesis"});
                }
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case '9': 
                case 'A': 
                case 'P': 
                case 'X': 
                case 'Z': 
                case 'a': 
                case 'p': 
                case 'x': 
                case 'z': {
                    ++size;
                    ++index;
                    continue block9;
                }
                case 'V': 
                case 'v': {
                    field.setDecimalPosn(size);
                    ++index;
                    continue block9;
                }
                case 'S': 
                case 's': {
                    field.setSignClause(1);
                    ++index;
                    continue block9;
                }
                case '.': {
                    if (index == length - 1) {
                        return size;
                    }
                    ++index;
                    ++size;
                    continue block9;
                }
            }
            throw new CopyBookException(11223, new Object[]{String.valueOf(this.m_currLineNum), "Invalid character: " + currentChar + " in pic statement"});
        }
        return size;
    }

    int setOccursAttrs(Item item, String[] tokens, int index) throws CopyBookException {
        String maxOccurs;
        int incr = index + 1;
        String odoObjectName = null;
        String minOccurs = maxOccurs = tokens[incr++];
        if (tokens[incr].equalsIgnoreCase("TO")) {
            int n = ++incr;
            ++incr;
            maxOccurs = tokens[n];
        }
        if (tokens[incr].equalsIgnoreCase("TIMES")) {
            ++incr;
        }
        if (incr < tokens.length && tokens[incr].equalsIgnoreCase("DEPENDING")) {
            if (tokens[++incr].equalsIgnoreCase("ON")) {
                // empty if block
            }
            int n = ++incr;
            ++incr;
            odoObjectName = tokens[n];
        }
        if (incr < tokens.length && tokens[incr].equalsIgnoreCase("INDEXED")) {
            if (tokens[++incr].equalsIgnoreCase("BY")) {
                ++incr;
            }
            ++incr;
        }
        if (odoObjectName != null) {
            Item odoObject = this.m_masterGroup.getChildByName(odoObjectName);
            item.setIsVariableLengthArray(true);
            if (odoObject instanceof ElementaryItem) {
                item.setArrayLengthDependency((ElementaryItem)odoObject);
            } else {
                throw new CopyBookException(11223, new Object[]{String.valueOf(this.m_currLineNum), " The array : " + item.getItemName() + " depends on an undefined elementary item:" + odoObjectName});
            }
        }
        item.setMinOccurs(minOccurs);
        item.setMaxOccurs(maxOccurs);
        return incr - index;
    }

    private boolean isKeyWord(String word) {
        String[] keyWords = new String[]{"pic", "picture", "redefines", "blank", "external", "global", "justified", "just", "occurs", "sign", "sync", "synchronized", "usage"};
        for (int i = 0; i < keyWords.length; ++i) {
            if (!word.equalsIgnoreCase(keyWords[i])) continue;
            return true;
        }
        return false;
    }

    boolean isElementaryItem(String[] currLine) {
        for (int i = 0; i < currLine.length; ++i) {
            if (!currLine[i].equalsIgnoreCase("PIC") && !currLine[i].equalsIgnoreCase("PICTURE") && !currLine[i].equalsIgnoreCase("COMP-1") && !currLine[i].equalsIgnoreCase("COMP-2") && !currLine[i].equalsIgnoreCase("COMPUTATIONAL-1") && !currLine[i].equalsIgnoreCase("COMPUTATIONAL-2") && !currLine[i].equalsIgnoreCase("POINTER") && !currLine[i].equalsIgnoreCase("PROCEDURE-POINTER") && !currLine[i].equalsIgnoreCase("INDEX")) continue;
            return true;
        }
        return false;
    }

    public static int intFromString(String token) throws CopyBookException {
        int ret = 0;
        try {
            ret = Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            throw new CopyBookException(11223, new Object[]{"Unknown, Trying to get an integer value from String = " + token, "Number format error while parsing CCB "}, e);
        }
        return ret;
    }

    void print(List list, String indent) {
        for (int i = 0; i < list.size(); ++i) {
            Item item = (Item)list.get(i);
            int level = item.getLevelNum();
            System.out.println(indent + item.toString());
            if (!(item instanceof IGroupItem)) continue;
            this.print(((IGroupItem)((Object)item)).getChildItems(), indent + " ");
        }
    }

    private boolean isPresent(String[] arr, String sym) {
        for (int i = 0; i < arr.length; ++i) {
            if (sym.indexOf(arr[i]) <= -1) continue;
            return true;
        }
        return false;
    }
}

