/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.importer.ccb;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.tip.pc.services.translation.importer.ccb.CCBImporter;
import oracle.tip.pc.services.translation.importer.ccb.ElementaryItem;
import oracle.tip.pc.services.translation.importer.ccb.GroupItem;
import oracle.tip.pc.services.translation.importer.ccb.IGroupItem;
import oracle.tip.pc.services.translation.importer.ccb.Item;
import oracle.tip.pc.services.translation.importer.ccb.Variable;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NXSDBuilder {
    public static final String SCHEMA_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    public static final String NXSD_NAMESPACE_URI = "http://xmlns.oracle.com/pcbpel/nxsd";
    public static final String NXSD_EXT_NAMESPACE_URI = "http://xmlns.oracle.com/pcbpel/nxsd/extensions";
    public static final String NXSD_PREFIX_COLON = "nxsd:";
    public static final String EXTN_PREFIX_COLON = "extn:";
    public static final String SCHEMA_PREFIX_COLON = "xsd:";
    public static final String NXSD_PREFIX = "nxsd";
    public static final String TNS_PREFIX = "tns";
    public static final String SCHEMA_PREFIX = "xsd";
    public static final String EXTN_PREFIX = "extn";
    public static final String XML_VERSION = "1.0";
    public static final String STYLE = "style";
    public static final String VERSION = "version";
    public static final String CHARSET = "encoding";
    public static final String BYTE_ORDER = "byteOrder";
    public static final String PADDEDBY = "paddedBy";
    public static final String PADSTYLE = "padStyle";
    public static final String LENGTH = "length";
    public static final String PICSIZE = "picSize";
    public static final String STREAMTYPE = "stream";
    public static final String CELLSEPERATEDBY = "cellSeparatedBy";
    public static final String TERMINATED = "terminated";
    public static final String TERMINATEDBY = "terminatedBy";
    public static final String ARRAYLENGTH = "arrayLength";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String LOOKAHEAD = "lookAhead";
    public static final String LOOKFOR = "lookFor";
    public static final String VARIABLES = "variables";
    public static final String VARIABLE = "variable";
    public static final String ASSIGN = "assign";
    public static final String VERSION_VAL = "NXSD";
    public static final String ARRAY = "array";
    public static final String FIXEDLENGTH = "fixedLength";
    public static final String HEAD = "head";
    public static final String TAIL = "tail";
    public static final String CHARS = "chars";
    public static final String BINARY = "bytes";
    public static final String COBOL_NUMERIC_PAD = "0";
    public static final String COBOL_CHAR_PAD = " ";
    public static final String ASSUMEDECIMAL = "assumeDecimal";
    public static final String SIGN = "sign";
    public static final String SIGNPOSN = "signPosn";
    public static final String SIGNTICK = "ticked";
    public static final String SIGNUNTICK = "unticked";
    public static final String HEAD_UPPERNIBBLE = "headUpperNibble";
    public static final String TAIL_UPPERNIBBLE = "tailUpperNibble";
    public static final String TAIL_LOWERNIBBLE = "tailLowerNibble";
    public static final String VIRTUALDECIMAL = "virtualDecimal";
    public static final String SIGNZONED = "signZoned";
    public static final String COMP1 = "comp1";
    public static final String COMP2 = "comp2";
    public static final String COMP3 = "comp3";
    public static final String COMP = "comp";
    private XMLDocument m_xmlDoc = new XMLDocument();
    private CCBImporter m_ccb;

    public NXSDBuilder() {
        this.m_xmlDoc.setVersion(XML_VERSION);
    }

    private Element createSchemaElement(String nameSpace) {
        Element elemRoot = this.m_xmlDoc.createElementNS(SCHEMA_NAMESPACE_URI, "xsd:schema");
        elemRoot.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:" + SCHEMA_PREFIX, SCHEMA_NAMESPACE_URI);
        elemRoot.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:" + NXSD_PREFIX, NXSD_NAMESPACE_URI);
        elemRoot.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:" + EXTN_PREFIX, NXSD_EXT_NAMESPACE_URI);
        elemRoot.setAttribute("targetNamespace", nameSpace);
        elemRoot.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:" + TNS_PREFIX, nameSpace);
        elemRoot.setAttribute("elementFormDefault", "qualified");
        elemRoot.setAttribute("attributeFormDefault", "unqualified");
        elemRoot.setAttributeNS(NXSD_NAMESPACE_URI, NXSD_PREFIX_COLON + VERSION, VERSION_VAL);
        elemRoot.setAttributeNS(NXSD_NAMESPACE_URI, NXSD_PREFIX_COLON + CHARSET, this.m_ccb.getEncoding());
        elemRoot.setAttributeNS(NXSD_NAMESPACE_URI, NXSD_PREFIX_COLON + BYTE_ORDER, this.m_ccb.getByteOrder());
        if (this.m_ccb.getBinaryMode()) {
            elemRoot.setAttributeNS(NXSD_NAMESPACE_URI, NXSD_PREFIX_COLON + STREAMTYPE, BINARY);
        } else {
            elemRoot.setAttributeNS(NXSD_NAMESPACE_URI, NXSD_PREFIX_COLON + STREAMTYPE, CHARS);
        }
        this.m_xmlDoc.appendChild((Node)elemRoot);
        this.createComment("NXSDWIZ:" + this.m_ccb.getCCBLocation() + ":", elemRoot);
        return elemRoot;
    }

    private void createComment(String commentString, Element elem) {
        Comment comment = this.m_xmlDoc.createComment(commentString);
        elem.getParentNode().insertBefore(comment, elem);
    }

    private Element createContainer(String name, Element root) {
        Element group = null;
        Element elem = this.createElement(SCHEMA_NAMESPACE_URI, "element", root);
        elem.setAttribute(NAME, name);
        Element complex = this.createElement(SCHEMA_NAMESPACE_URI, "complexType", elem);
        if (this.m_ccb.hasMultipleRoots() && this.m_ccb.hasImplicitRedefines()) {
            group = this.createChoiceModelGroup(complex);
            group.setAttribute("minOccurs", "1");
            group.setAttribute("maxOccurs", "unbounded");
        } else if (this.m_ccb.hasMultipleRoots() && !this.m_ccb.hasImplicitRedefines()) {
            group = this.createElement(SCHEMA_NAMESPACE_URI, "sequence", complex);
            group.setAttribute("minOccurs", "1");
            group.setAttribute("maxOccurs", "unbounded");
        } else if (!this.m_ccb.hasMultipleRoots()) {
            group = this.createElement(SCHEMA_NAMESPACE_URI, "sequence", complex);
        }
        return group;
    }

    private Element createElement(String ns, String name, Element root) {
        Element elem = null;
        elem = ns.equals(SCHEMA_NAMESPACE_URI) ? this.m_xmlDoc.createElementNS(ns, SCHEMA_PREFIX_COLON + name) : this.m_xmlDoc.createElementNS(ns, name);
        root.appendChild(elem);
        return elem;
    }

    public XMLDocument buildNXSD(CCBImporter ccb) {
        IGroupItem grpItem = ccb.getMasterGroup();
        this.m_ccb = ccb;
        Element elemRoot = this.createSchemaElement(ccb.getNamespace());
        Element containerElem = this.createContainer(ccb.getContainerName(), elemRoot);
        this.setVariables(containerElem, (Item)((Object)grpItem));
        ArrayList list = (ArrayList)grpItem.getChildItems();
        this.parseStructure(list, containerElem);
        return this.m_xmlDoc;
    }

    private void parseStructure(ArrayList list, Element root) {
        Element elem = null;
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            Item item = (Item)list.get(i);
            if (item.isRedefined()) {
                elem = this.createChoiceModelGroup(root);
                this.createXMLElement(item, elem);
                ArrayList cList = item.getRedefList();
                this.parseStructure(cList, elem);
                for (int j = 0; j < cList.size(); ++j) {
                    list.remove(cList.get(j));
                    --listSize;
                }
                continue;
            }
            this.createXMLElement(item, root);
        }
    }

    private Element createChoiceModelGroup(Element root) {
        Element choice = this.createElement(SCHEMA_NAMESPACE_URI, "choice", root);
        this.createComment("Please add values for nxsd:lookAhead attributes for the elements in the choice model group.", choice);
        return choice;
    }

    private void createXMLElement(Item item, Element root) {
        Element elem = null;
        if (item instanceof IGroupItem) {
            elem = this.createComplexType(root, (GroupItem)item);
            ArrayList cList = (ArrayList)((IGroupItem)((Object)item)).getChildItems();
            this.parseStructure(cList, elem);
        } else if (item instanceof ElementaryItem) {
            elem = this.createSimpleType(root, (ElementaryItem)item);
        }
    }

    private Element createComplexType(Element root, GroupItem grpItem) {
        Element elem = this.createElement(SCHEMA_NAMESPACE_URI, "element", root);
        elem.setAttribute(NAME, grpItem.getItemName());
        this.setVariables(elem, grpItem);
        Element cmplx = this.createElement(SCHEMA_NAMESPACE_URI, "complexType", elem);
        Element seq = this.createElement(SCHEMA_NAMESPACE_URI, "sequence", cmplx);
        this.setArrayAttrs(elem, grpItem);
        this.setLookAheadAttributes(elem, grpItem);
        this.createComment("COBOL declaration :" + grpItem.getCobolClause(), elem);
        return seq;
    }

    private Element createSimpleType(Element root, ElementaryItem elemItem) {
        Element elem = null;
        elem = this.createElement(SCHEMA_NAMESPACE_URI, "element", root);
        elem.setAttribute(NAME, elemItem.getItemName());
        this.setVariables(elem, elemItem);
        this.setNXSDAttrs(elem, elemItem);
        this.setArrayAttrs(elem, elemItem);
        this.setLookAheadAttributes(elem, elemItem);
        this.createComment("COBOL declaration :" + elemItem.getCobolClause(), elem);
        return elem;
    }

    private void addRootLevelAttrs(Element elem, Item item) {
        if (!this.m_ccb.getRecDelimiter().equals("")) {
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:style", ARRAY);
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:cellSeparatedBy", this.m_ccb.getRecDelimiter());
        }
        elem.setAttribute("maxOccurs", "unbounded");
    }

    void setVariables(Element elem, Item item) {
        int i;
        List list = null;
        Element annotate = null;
        Element appInfo = null;
        Element variables = null;
        Element varAction = null;
        Variable var = null;
        if (item.getDeclaredVariables() == null && item.getDefinedVariables() == null) {
            return;
        }
        annotate = this.createElement(SCHEMA_NAMESPACE_URI, "annotation", elem);
        appInfo = this.createElement(SCHEMA_NAMESPACE_URI, "appinfo", annotate);
        variables = this.createElement(NXSD_NAMESPACE_URI, "nxsd:variables", appInfo);
        if (item.getDeclaredVariables() != null) {
            list = item.getDeclaredVariables();
            for (i = 0; i < list.size(); ++i) {
                var = (Variable)list.get(i);
                varAction = this.createElement(NXSD_NAMESPACE_URI, "nxsd:variable", variables);
                varAction.setAttribute(NAME, var.getName());
            }
        }
        if (item.getDefinedVariables() != null) {
            list = item.getDefinedVariables();
            for (i = 0; i < list.size(); ++i) {
                var = (Variable)list.get(i);
                varAction = this.createElement(NXSD_NAMESPACE_URI, "nxsd:assign", variables);
                varAction.setAttribute(NAME, var.getName());
                if (var.getEndIndex() == -1) {
                    varAction.setAttribute(VALUE, "${" + String.valueOf(var.getStartIndex()) + "}");
                    continue;
                }
                varAction.setAttribute(VALUE, "${" + String.valueOf(var.getStartIndex()) + "," + String.valueOf(var.getEndIndex()) + "}");
            }
        }
    }

    private void setArrayAttrs(Element elem, Item item) {
        String maxOccurs = item.getMaxOccurs();
        String minOccurs = item.getMinOccurs();
        if (item.getIsVariableLengthArray()) {
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:style", ARRAY);
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:arrayLength", item.getVariableArrayLength());
        }
        if (!minOccurs.equals("1") || !maxOccurs.equals("1")) {
            elem.setAttribute("minOccurs", minOccurs);
            elem.setAttribute("maxOccurs", maxOccurs);
            if (item.isRootLevel() && !this.m_ccb.hasMultipleRoots() && !"".equals(item.getItemDelimiter())) {
                elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:style", ARRAY);
                elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:cellSeparatedBy", this.m_ccb.getRecDelimiter());
            }
        }
    }

    private void setLookAheadAttributes(Element elem, Item item) {
        boolean lookAheadTemplateNeeded = false;
        if (item.isRedefined() || item.getRedefines()) {
            lookAheadTemplateNeeded = true;
        }
        if (item.isRootLevel() && this.m_ccb.hasMultipleRoots() && this.m_ccb.hasImplicitRedefines()) {
            lookAheadTemplateNeeded = true;
        }
        if (lookAheadTemplateNeeded) {
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:lookAhead", "");
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:lookFor", "");
        }
    }

    private void setNXSDAttrs(Element elem, ElementaryItem elemItem) {
        int picSize = elemItem.getPicSize();
        String pics = String.valueOf(picSize);
        switch (elemItem.getType()) {
            case 2: 
            case 3: {
                elem.setAttribute("type", "xsd:string");
                if (elemItem.getJustified()) {
                    this.addFixedLengthNXSDAttrs(elem, HEAD, COBOL_CHAR_PAD, pics);
                    break;
                }
                this.addFixedLengthNXSDAttrs(elem, TAIL, COBOL_CHAR_PAD, pics);
                break;
            }
            case 1: {
                if (elemItem.getUsage().equals("DISPLAY") && elemItem.getSignClause() == -1 && elemItem.getDecimalPosn() == -1) {
                    elem.setAttribute("type", "xsd:long");
                    this.addFixedLengthNXSDAttrs(elem, HEAD, COBOL_NUMERIC_PAD, pics);
                    break;
                }
                this.setNXSDAttrsNumeric(elem, elemItem);
                break;
            }
            case 4: 
            case 5: {
                elem.setAttribute("type", "xsd:string");
                this.addFixedLengthNXSDAttrs(elem, null, null, pics);
                break;
            }
        }
    }

    private void setNXSDAttrsNumeric(Element elem, ElementaryItem item) {
        int picSize = item.getPicSize();
        String pics = String.valueOf(picSize);
        String recDelim = this.m_ccb.getRecDelimiter();
        if (item.getUsage().equals("DISPLAY")) {
            if (item.getDecimalPosn() != -1 && item.getSignClause() == -1) {
                elem.setAttribute("type", "xsd:decimal");
                elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:style", VIRTUALDECIMAL);
                elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:assumeDecimal", String.valueOf(item.getDecimalPosn()));
                elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:picSize", pics);
            } else if (item.getSignClause() != -1) {
                elem.setAttribute("type", "xsd:string");
                elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:style", SIGNZONED);
                elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:sign", SIGNTICK);
                elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:picSize", pics);
                if (item.getDecimalPosn() != -1) {
                    elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:assumeDecimal", String.valueOf(item.getDecimalPosn()));
                }
                this.setSignAttr(elem, item);
            }
        } else if (item.getUsage().equals("COMP")) {
            if (item.getDecimalPosn() != -1) {
                elem.setAttribute("type", "xsd:decimal");
                elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:assumeDecimal", String.valueOf(item.getDecimalPosn()));
            } else {
                elem.setAttribute("type", "xsd:long");
            }
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:style", COMP);
            elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:picSize", pics);
            if (item.getSignClause() != -1) {
                elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:sign", SIGNTICK);
            } else {
                elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:sign", SIGNUNTICK);
            }
        } else if (item.getUsage().equals("COMP-3")) {
            if (item.getDecimalPosn() != -1) {
                elem.setAttribute("type", "xsd:decimal");
                elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:assumeDecimal", String.valueOf(item.getDecimalPosn()));
            } else {
                elem.setAttribute("type", "xsd:long");
            }
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:style", COMP3);
            elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:sign", SIGNTICK);
            elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:picSize", pics);
            if (item.getSignClause() != -1) {
                elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:sign", SIGNTICK);
            } else {
                elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:sign", SIGNUNTICK);
            }
        } else if (item.getUsage().equals("COMP-1")) {
            elem.setAttribute("type", "xsd:float");
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:style", COMP1);
            elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:sign", SIGNTICK);
        } else if (item.getUsage().equals("COMP-2")) {
            elem.setAttribute("type", "xsd:double");
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:style", COMP2);
            elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:sign", SIGNTICK);
        }
    }

    private void addFixedLengthNXSDAttrs(Element elem, String padStyle, String paddedBy, String length) {
        elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:style", FIXEDLENGTH);
        if (padStyle != null && paddedBy != null) {
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:padStyle", padStyle);
            elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:paddedBy", paddedBy);
        }
        elem.setAttributeNS(NXSD_NAMESPACE_URI, "nxsd:length", length);
    }

    private void setSignAttr(Element elem, Item item) {
        if (item.getSignClause() == 0) {
            elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:signPosn", HEAD_UPPERNIBBLE);
        } else if (item.getSignClause() == 1) {
            elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:signPosn", TAIL_UPPERNIBBLE);
        } else if (item.getSignClause() == 2) {
            elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:signPosn", HEAD);
        } else if (item.getSignClause() == 3) {
            elem.setAttributeNS(NXSD_EXT_NAMESPACE_URI, "extn:signPosn", TAIL);
        }
    }

    public static void printTree(XMLDocument nd, OutputStream os) {
        try {
            nd.print(os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

