/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.importer.ccb;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.tip.pc.services.translation.importer.ccb.CopyBookException;
import oracle.tip.pc.services.translation.importer.ccb.ElementaryItem;
import oracle.tip.pc.services.translation.importer.ccb.GroupItem;
import oracle.tip.pc.services.translation.importer.ccb.IGroupItem;
import oracle.tip.pc.services.translation.importer.ccb.Item;
import oracle.tip.pc.services.translation.importer.ccb.NXSDBuilder;
import oracle.tip.pc.services.translation.importer.ccb.StructureBuilder;
import oracle.xml.parser.v2.XMLDocument;

public class CCBImporter {
    public static final int MASTER_LEVEL = 0;
    public static final String NAMESPACE_key = "NAMESPACE";
    public static final String ROOTNAME_key = "ROOTNAME";
    public static final String BYTEORDER_key = "BYTEORDER";
    public static final String CHARSET_key = "CHARSET";
    public static final String CCB_CHARSET_key = "CCB_CHARSET";
    public static final String RECDELIM_key = "RECDELIM";
    public static final String NO_RECDELIM = "";
    private IGroupItem m_masterGroup = new GroupItem(0, "MASTER");
    private Hashtable m_userTable;
    private boolean isBinary = false;
    private boolean m_hasMultipleRoots;
    private boolean m_hasImpliciteRedefines;
    private String m_ccbLocation;

    public void setBinaryMode(boolean bool) {
        this.isBinary = bool;
    }

    public boolean getBinaryMode() {
        return this.isBinary;
    }

    public void setUserInput(Hashtable table) {
        this.m_userTable = table;
    }

    public IGroupItem getMasterGroup() {
        return this.m_masterGroup;
    }

    public String getNamespace() {
        return (String)this.m_userTable.get(NAMESPACE_key);
    }

    public String getContainerName() {
        return (String)this.m_userTable.get(ROOTNAME_key);
    }

    public String getEncoding() {
        return (String)this.m_userTable.get(CHARSET_key);
    }

    public String getByteOrder() {
        return (String)this.m_userTable.get(BYTEORDER_key);
    }

    public String getRecDelimiter() {
        return (String)this.m_userTable.get(RECDELIM_key);
    }

    public String getCCBLocation() {
        return this.m_ccbLocation;
    }

    public boolean hasMultipleRoots() {
        return this.m_hasMultipleRoots;
    }

    public boolean hasImplicitRedfines() {
        return this.m_hasImpliciteRedefines;
    }

    public static XMLDocument createNXSD(String ccbLocn, Hashtable table) throws CopyBookException {
        CCBImporter ccbRepn = CCBImporter.createCCBMetaData(ccbLocn, table);
        ccbRepn.m_ccbLocation = ccbLocn;
        NXSDBuilder nxsdBldr = new NXSDBuilder();
        return nxsdBldr.buildNXSD(ccbRepn);
    }

    public static CCBImporter createCCBMetaData(String ccbLocn, Hashtable table) throws CopyBookException {
        CCBImporter ccbRepn = new CCBImporter();
        ccbRepn.setUserInput(table);
        IGroupItem masterGrp = ccbRepn.getMasterGroup();
        String ccbCharset = null;
        if (table.containsKey(CCB_CHARSET_key)) {
            ccbCharset = (String)table.get(CCB_CHARSET_key);
        }
        String copyBookString = ccbRepn.readFile(ccbLocn, ccbCharset);
        StructureBuilder parser = new StructureBuilder();
        parser.buildStructure(copyBookString, masterGrp);
        ccbRepn.getMasterGroup().calculateByteSize();
        ccbRepn.setRootLevelMarkers();
        ccbRepn.setBinaryMode(parser.isBinaryMode());
        return ccbRepn;
    }

    public boolean hasImplicitRedefines() {
        List childList = this.m_masterGroup.getChildItems();
        int size = childList.size();
        for (int i = 0; i < size; ++i) {
            if (((Item)childList.get(i)).getLevelNum() == 1) continue;
            return false;
        }
        return true;
    }

    private void setRootLevelMarkers() {
        List childList = this.m_masterGroup.getChildItems();
        int size = childList.size();
        if (size > 1) {
            this.m_hasMultipleRoots = true;
        } else {
            this.m_hasMultipleRoots = false;
            ((Item)childList.get(0)).setMaxOccurs("unbounded");
        }
        Object item = null;
        for (int i = 0; i < size; ++i) {
            ((Item)childList.get(i)).setRootLevel(true);
            ((Item)childList.get(i)).setItemDelimiter(this.getRecDelimiter());
        }
        if (this.m_hasMultipleRoots) {
            this.m_hasImpliciteRedefines = this.hasImplicitRedefines();
        }
    }

    private void setLastField(Item item) {
        Item redef = null;
        ArrayList list = null;
        if (item instanceof GroupItem) {
            List childList = ((IGroupItem)((Object)item)).getChildItems();
            int size = childList.size();
            Item lastItem = (Item)childList.get(size - 1);
            this.setLastField(lastItem);
        } else if (item instanceof ElementaryItem) {
            int i;
            if (item.getRedefines()) {
                redef = item.getRedefinedItem();
                ((ElementaryItem)redef).setDelimLastField(true);
                list = redef.getRedefList();
                for (i = 0; i < list.size(); ++i) {
                    this.setRecDelim((Item)list.get(i));
                }
            }
            ((ElementaryItem)item).setDelimLastField(true);
            if (((Item)((Object)item.getParent())).getRedefines()) {
                redef = item.getRedefinedItem();
                list = redef.getRedefList();
                for (i = 0; i < list.size(); ++i) {
                    this.setRecDelim((Item)list.get(i));
                }
            }
        }
    }

    void setRecDelim(Item item) {
        if (item instanceof IGroupItem) {
            List childList = ((IGroupItem)((Object)item)).getChildItems();
            int size = childList.size();
            Item lastItem = (Item)childList.get(size - 1);
            this.setRecDelim(lastItem);
        } else if (item instanceof ElementaryItem) {
            ((ElementaryItem)item).setDelimLastField(true);
        }
    }

    private String readFile(String fileName) throws CopyBookException {
        try {
            FileInputStream stream = new FileInputStream(fileName);
            byte[] bytes = new byte[stream.available()];
            stream.read(bytes);
            return new String(bytes);
        }
        catch (FileNotFoundException e) {
            throw new CopyBookException(11220, new Object[]{fileName}, e);
        }
        catch (IOException e) {
            throw new CopyBookException(11220, new Object[]{fileName}, e);
        }
    }

    private String readFile(String fileName, String charset) throws CopyBookException {
        try {
            FileInputStream stream = new FileInputStream(fileName);
            String ccbcharSet = charset == null ? "UTF-8" : charset;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, ccbcharSet));
            StringBuffer fileContents = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                fileContents = fileContents.append(line).append(System.getProperty("line.separator"));
            }
            return fileContents.toString();
        }
        catch (FileNotFoundException e) {
            throw new CopyBookException(11220, new Object[]{fileName}, e);
        }
        catch (IOException e) {
            throw new CopyBookException(11220, new Object[]{fileName}, e);
        }
    }

    public static void main(String[] args) {
        Hashtable<String, String> ht = new Hashtable<String, String>(8);
        if (args.length < 6) {
            System.out.println("Usage: java CCBImporter <ccb_locn> <namespace> <charset> <byteOrder> <recDelim> <rootName> <<ccb_charset>>");
            System.exit(1);
        }
        String filePath = args[0];
        ht.put(NAMESPACE_key, args[1]);
        ht.put(CHARSET_key, args[2]);
        ht.put(BYTEORDER_key, args[3]);
        ht.put(RECDELIM_key, args[4]);
        ht.put(ROOTNAME_key, args[5]);
        if (args.length > 6) {
            ht.put(CCB_CHARSET_key, args[6]);
        }
        try {
            XMLDocument doc = CCBImporter.createNXSD(filePath, ht);
            NXSDBuilder.printTree(doc, new FileOutputStream(args[0] + ".xsd"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CopyBookException ccbExp) {
            ccbExp.printStackTrace();
        }
    }
}

