/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.framework;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import oracle.tip.pc.infra.DiagnosticService;
import oracle.tip.pc.infra.PCProperties;
import oracle.tip.pc.services.translation.framework.StyleReader;
import oracle.tip.pc.services.translation.framework.StyleWriter;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.framework.Translator;
import oracle.tip.pc.services.translation.xlators.nxsd.ByteDataReaderImpl;
import oracle.tip.pc.services.translation.xlators.nxsd.ByteDataWriterImpl;
import oracle.tip.pc.services.translation.xlators.nxsd.CharDataReaderImpl;
import oracle.tip.pc.services.translation.xlators.nxsd.InputDataReader;
import oracle.tip.pc.services.translation.xlators.nxsd.NativeDataDefinition;
import oracle.tip.pc.services.translation.xlators.nxsd.OutputDataWriter;
import oracle.tip.pc.services.translation.xlators.nxsd.StyleReaderImpl;
import oracle.tip.pc.services.translation.xlators.nxsd.StyleWriterImpl;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;

public class TranslatorFactory {
    private static final String CUSTOM_XLATOR_CLASS_SUFFIX = "_XlatorClass";
    private static TranslatorFactory fTranslatorFactory = new TranslatorFactory();
    private static Properties fXlators = new Properties();

    private TranslatorFactory() {
    }

    public static TranslatorFactory getInstance() {
        return fTranslatorFactory;
    }

    public Translator createTranslator(XMLSchema schemaDoc, XSDElement rootElement) throws TranslationException {
        Translator xlator = null;
        String xlatorVersion = "XSD";
        this.log("Inside TranslatorFactory");
        if (schemaDoc == null && rootElement == null) {
            this.logError("Null arguments passed to createTranslator method.");
            throw new TranslationException(11108);
        }
        String[] allTNS = schemaDoc.getAllTargetNS();
        for (int i = 0; i < allTNS.length; ++i) {
            if (!"http://xmlns.oracle.com/pcbpel/nxsd".equals(allTNS[i]) && !"http://xmlns.oracle.com/pcbpel/nxsd/extensions".equals(allTNS[i])) continue;
            throw new TranslationException(11112, new Object[]{allTNS[i]});
        }
        String targetNS = rootElement.getTargetNS();
        XMLSchemaNode schemaNode = schemaDoc.getSchemaByTargetNS(targetNS);
        NativeDataDefinition def = new NativeDataDefinition();
        def.loadDefinitions((XSDNode)schemaNode, (XSDNode)rootElement, def);
        NativeDataDefinition schemaDefinition = def.getSchemaDefinition();
        if (schemaDefinition.getVersion() != null) {
            xlatorVersion = schemaDefinition.getVersion();
        } else if ("http://xmlns.oracle.com/pcbpel/adapter/opaque/".equals(targetNS)) {
            xlatorVersion = "OPAQUE";
        } else {
            targetNS = schemaDoc.getSchemaTargetNS();
            schemaNode = schemaDoc.getSchemaByTargetNS(targetNS);
            NativeDataDefinition.fillDef((XSDNode)schemaNode, schemaDefinition, true);
            if (schemaDefinition.getVersion() != null) {
                xlatorVersion = schemaDefinition.getVersion();
            } else if ("http://xmlns.oracle.com/pcbpel/adapter/opaque/".equals(targetNS)) {
                xlatorVersion = "OPAQUE";
            }
        }
        this.log("using version attribute = " + xlatorVersion);
        String xlatorPropertyName = "oracle.bpelpm.xlators." + xlatorVersion;
        String xlatorClassName = fXlators.getProperty(xlatorPropertyName);
        if (xlatorClassName == null) {
            this.log("could be a custom translator with version = " + xlatorVersion);
            xlatorClassName = def.getNxsdAttributeValue(xlatorVersion + CUSTOM_XLATOR_CLASS_SUFFIX);
            if (xlatorClassName == null && (xlatorClassName = PCProperties.getProperty(xlatorPropertyName)) == null) {
                this.logError("no Translator found registered for version = " + xlatorVersion);
                throw new TranslationException(11110, new Object[]{xlatorVersion, ""});
            }
        }
        try {
            this.log("loading xlator class..." + xlatorClassName);
            Class<?> theClass = Class.forName(xlatorClassName);
            if (xlatorVersion.equalsIgnoreCase("NXSD")) {
                Class[] params = new Class[]{Class.forName("oracle.xml.parser.schema.XMLSchema"), Class.forName("oracle.xml.parser.schema.XSDElement"), Class.forName("oracle.tip.pc.services.translation.xlators.nxsd.NativeDataDefinition")};
                Constructor<?> constructor = theClass.getConstructor(params);
                xlator = (Translator)constructor.newInstance(schemaDoc, rootElement, def);
                this.log("Native xlator class loaded");
            } else {
                Class[] params = new Class[]{Class.forName("oracle.xml.parser.schema.XMLSchema"), Class.forName("oracle.xml.parser.schema.XSDElement")};
                Constructor<?> constructor = theClass.getConstructor(params);
                xlator = (Translator)constructor.newInstance(schemaDoc, rootElement);
                this.log("class loaded");
            }
        }
        catch (InvocationTargetException itex) {
            this.logError("Failed loading xlator class..." + xlatorClassName + " because: " + itex.getMessage());
            if (itex.getCause() != null && itex.getCause() instanceof TranslationException) {
                throw new TranslationException(11134, new Object[]{xlatorVersion, ((TranslationException)itex.getCause()).getDescription(), ((TranslationException)itex.getCause()).getFix()}, itex);
            }
            throw new TranslationException(11110, new Object[]{xlatorVersion, itex.getMessage()}, itex);
        }
        catch (Exception cnfe) {
            this.logError("Failed loading xlator class..." + xlatorClassName + " because: " + cnfe.getMessage());
            throw new TranslationException(11110, new Object[]{xlatorVersion, cnfe.getMessage()}, cnfe);
        }
        return xlator;
    }

    private void log(String message) {
        DiagnosticService.log(4, DiagnosticService.DIAGNOSTICS_DEBUG, message);
    }

    private void logError(String message) {
        DiagnosticService.log(4, DiagnosticService.DIAGNOSTICS_ERRORS, message);
    }

    public static String getAnnotationValue(XSDNode node, String namespace, String localName) {
        NativeDataDefinition def = new NativeDataDefinition();
        NativeDataDefinition.fillDef(node, def, true);
        return def.getNxsdAttributeValue(namespace, localName);
    }

    public InputDataReader newDataReader(InputStream is, String enc, boolean charOnly) throws TranslationException {
        InputDataReader reader = null;
        reader = charOnly ? new CharDataReaderImpl(is, enc) : new ByteDataReaderImpl(is, enc);
        return reader;
    }

    public OutputDataWriter newDataWriter(OutputStream os, String enc) throws TranslationException {
        return new ByteDataWriterImpl(os, enc);
    }

    public StyleReader newStyleBasedReader(InputDataReader reader) throws TranslationException {
        return new StyleReaderImpl(reader);
    }

    public StyleReader newStyleBasedReader(InputStream is, String enc, boolean charOnly) throws TranslationException {
        return this.newStyleBasedReader(this.newDataReader(is, enc, charOnly));
    }

    public StyleWriter newStyleBasedWriter(OutputDataWriter writer) throws TranslationException {
        return new StyleWriterImpl(writer);
    }

    public StyleWriter newStyleBasedWriter(OutputStream os, String enc) throws TranslationException {
        return this.newStyleBasedWriter(this.newDataWriter(os, enc));
    }

    static {
        fXlators.setProperty("oracle.bpelpm.xlators.XSD", "oracle.tip.pc.services.translation.xlators.xsd.XSDTranslator");
        fXlators.setProperty("oracle.bpelpm.xlators.DTD", "oracle.tip.pc.services.translation.xlators.dtd.DTDTranslator");
        fXlators.setProperty("oracle.bpelpm.xlators.NXSD", "oracle.tip.pc.services.translation.xlators.nxsd.NXSDTranslatorImpl");
        fXlators.setProperty("oracle.bpelpm.xlators.OPAQUE", "oracle.tip.pc.services.translation.xlators.opaque.OpaqueTranslator");
    }
}

