/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.translation.framework;

import java.io.IOException;
import java.io.OutputStream;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DOMUtil {
    public static void printDOM(Node node, OutputStream outputStream, String encoding, boolean pretty) throws IOException {
        String enc;
        if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        }
        XMLElement xdkElement = null;
        Object nodeValue = null;
        String string = enc = encoding == null ? "UTF-8" : encoding;
        if (node instanceof XMLElement) {
            xdkElement = (XMLElement)node;
            xdkElement.print(outputStream, enc);
        } else {
            XMLDocument xdoc = new XMLDocument();
            xdkElement = (XMLElement)xdoc.importNode(node, true);
            xdkElement.print(outputStream, enc);
        }
    }

    public static void reportSAXEvents(Node node, ContentHandler handler) throws SAXException {
        DOMUtil.traverse(node, handler);
    }

    private static void traverse(Node node, ContentHandler handler) throws SAXException {
        switch (node.getNodeType()) {
            case 9: {
                handler.startDocument();
                DOMUtil.traverse(((Document)node).getDocumentElement(), handler);
                handler.endDocument();
                break;
            }
            case 1: {
                AttributesImpl attributes = new AttributesImpl();
                NamedNodeMap attributeSet = node.getAttributes();
                Attr attribute = null;
                if (attributeSet != null) {
                    for (int i = 0; i < attributeSet.getLength(); ++i) {
                        attribute = (Attr)attributeSet.item(i);
                        attributes.addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getName(), "CDATA", attribute.getValue());
                    }
                }
                handler.startElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), attributes);
                NodeList childs = node.getChildNodes();
                for (int i = 0; i < childs.getLength(); ++i) {
                    DOMUtil.traverse(childs.item(i), handler);
                }
                handler.endElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName());
                break;
            }
            case 3: {
                if (DOMUtil.isWhitespaceNode(node)) break;
                String str = node.getNodeValue();
                handler.characters(str.toCharArray(), 0, str.length());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                handler.processingInstruction(pi.getTarget(), pi.getData());
                break;
            }
        }
    }

    private static boolean isWhitespaceNode(Node node) {
        Node tempNode;
        for (tempNode = node; tempNode != null && tempNode.getNodeType() == 3; tempNode = tempNode.getNextSibling()) {
        }
        if (tempNode == null) {
            for (tempNode = node; tempNode != null && tempNode.getNodeType() == 3; tempNode = tempNode.getPreviousSibling()) {
            }
            if (tempNode == null) {
                return false;
            }
        }
        return true;
    }
}

