/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.pipeline.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import oracle.tip.pc.services.pipeline.InputStreamContext;
import oracle.tip.pc.services.pipeline.Pipeline;
import oracle.tip.pc.services.pipeline.PipelineContext;
import oracle.tip.pc.services.pipeline.PipelineFactory;
import oracle.tip.pc.services.pipeline.PipelineUtils;

public class TestReentrantValves {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String zipFile = args[0];
        PipelineContext ctx = new PipelineContext();
        ctx.setControlDirectory(new File("controlDir"));
        InputStream configStream = TestReentrantValves.class.getResourceAsStream("pipeline.xml");
        ctx.setPipelineConfig(configStream);
        Pipeline pipeline = PipelineFactory.createPipeline(ctx);
        FileInputStream fis = null;
        int counter = 0;
        try {
            fis = new FileInputStream(zipFile);
            InputStreamContext inCtx = new InputStreamContext(fis);
            inCtx.setMessageOriginReference(zipFile);
            InputStreamContext returnCtx = null;
            do {
                if ((returnCtx = pipeline.execute(inCtx)) == null) continue;
                TestReentrantValves.copyFile(returnCtx.getInputStream(), ctx.getControlDirectory(), "File" + ++counter);
                pipeline.finalize(returnCtx);
            } while (pipeline.hasNext());
        }
        finally {
            fis.close();
        }
        pipeline.cleanup();
        configStream.close();
    }

    private static void copyFile(InputStream in, File dir, String file) throws Exception {
        FileOutputStream dest = new FileOutputStream(new File(dir, file));
        PipelineUtils.copyStream(in, dest);
        dest.close();
    }
}

