/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.pipeline;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.tip.pc.services.pipeline.BatchNotificationHandler;
import oracle.tip.pc.services.pipeline.ConsoleBatchNotificationHandler;
import oracle.tip.pc.services.pipeline.InputStreamContext;
import oracle.tip.pc.services.pipeline.Pipeline;
import oracle.tip.pc.services.pipeline.PipelineContext;
import oracle.tip.pc.services.pipeline.PipelineException;
import oracle.tip.pc.services.pipeline.PipelineFactory;
import oracle.tip.pc.services.pipeline.PipelineUtils;
import oracle.tip.pc.services.pipeline.StagedValve;
import oracle.tip.pc.services.pipeline.Valve;

public class PipelineImpl
implements Pipeline,
Cloneable {
    protected ArrayList<Valve> valves;
    protected boolean useStaging = true;
    private PipelineContext pipelineContext;
    private Valve lastValve;
    private File pipelineStagingFile;
    private String batchNotificationHandlerClass;

    public PipelineImpl(PipelineContext pipelineContext) throws PipelineException {
        PipelineUtils.createDirectoryIfRequiredBlocking(pipelineContext.getControlDirectory());
        this.pipelineContext = pipelineContext;
        this.valves = new ArrayList();
    }

    @Override
    public PipelineContext getPipelineContext() {
        return this.pipelineContext;
    }

    @Override
    public void addValve(Valve valve) {
        valve.setPipeline(this);
        this.valves.add(valve);
        this.lastValve = valve;
    }

    @Override
    public boolean hasNext() {
        return this.valves.get(0).isReentrant() && this.valves.get(0).hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStreamContext execute(InputStreamContext inCtx) throws PipelineException, IOException {
        ArrayList<InputStream> intermediateStreams = new ArrayList<InputStream>();
        for (int i = 0; i < this.valves.size(); ++i) {
            Valve v = this.valves.get(i);
            inCtx = v.execute(inCtx);
            if (inCtx == null || inCtx.getInputStream() == null || i >= this.valves.size() - 1) continue;
            intermediateStreams.add(inCtx.getInputStream());
        }
        for (InputStream in : intermediateStreams) {
            try {
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                in = null;
            }
        }
        if (inCtx == null) {
            return null;
        }
        boolean usePipelineStaging = true;
        if (this.lastValve instanceof StagedValve && PipelineUtils.isValidFile(((StagedValve)this.lastValve).getStagingFile())) {
            usePipelineStaging = false;
        }
        if (this.useStaging && usePipelineStaging && inCtx != null) {
            this.pipelineStagingFile = PipelineUtils.getUniqueStagingFile(this.pipelineContext.getControlDirectory());
            this.writeToStagingFile(inCtx.getInputStream());
            this.closeStream(inCtx.getInputStream());
            FileInputStream stagingIn = new FileInputStream(this.pipelineStagingFile);
            inCtx.setInputStream(stagingIn);
        }
        return inCtx;
    }

    public boolean isReentrant() {
        return this.valves.get(0).isReentrant();
    }

    @Override
    public void setBatchNotificationHandlerClass(String batchNotificationHandlerClass) {
        this.batchNotificationHandlerClass = batchNotificationHandlerClass;
    }

    @Override
    public String getBatchNotificationHandlerClass() {
        return this.batchNotificationHandlerClass;
    }

    @Override
    public BatchNotificationHandler newBatchNotificationHandler() throws Exception {
        String clazz = ConsoleBatchNotificationHandler.class.getName();
        if (!PipelineUtils.isBlank(this.batchNotificationHandlerClass)) {
            clazz = this.batchNotificationHandlerClass;
        } else {
            System.err.println("Using default BatchNotificationHandler.");
        }
        return PipelineFactory.getBatchNotificationInstance(clazz, this);
    }

    @Override
    public void validate() throws PipelineException {
        if (this.valves == null || this.valves.size() == 0) {
            throw new PipelineException("Invalid configurations for valves");
        }
        int i = 0;
        for (Valve v : this.valves) {
            if (i > 0 && v.isReentrant()) {
                throw new PipelineException("Only the first valve can be reentrant");
            }
            ++i;
        }
    }

    @Override
    public InputStream getStagedInputStream() throws PipelineException, IOException {
        File temp = this.pipelineStagingFile;
        if (temp == null) {
            temp = ((StagedValve)this.lastValve).getStagingFile();
        }
        if (temp == null) {
            throw new PipelineException("Staging file not found");
        }
        try {
            return new FileInputStream(temp);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            throw new PipelineException("Unable to get staging input stream", t);
        }
    }

    @Override
    public void cleanup() throws PipelineException, IOException {
        for (Valve v : this.valves) {
            v.cleanup();
        }
        if (this.pipelineStagingFile != null) {
            this.pipelineStagingFile.delete();
        }
        this.pipelineStagingFile = null;
    }

    @Override
    public void finalize(InputStreamContext in) {
        if (in != null) {
            in.closeStream();
        }
        if (this.pipelineStagingFile != null && this.pipelineStagingFile.exists()) {
            this.pipelineStagingFile.delete();
        }
        for (Valve v : this.valves) {
            v.finalize(in);
        }
    }

    private void closeStream(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeToStagingFile(InputStream in) throws PipelineException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.pipelineStagingFile);
            PipelineUtils.copyStream(in, out);
        }
        catch (Exception _e) {
            throw new PipelineException("Write to staging file failed " + _e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public List<Valve> getValves() {
        return this.valves;
    }

    public void setUseStaging(boolean useStaging) {
        this.useStaging = useStaging;
    }

    public boolean getUseStaging() {
        return this.useStaging;
    }
}

