/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.pipeline;

import java.io.PrintWriter;
import java.io.StringWriter;

public class BatchContext {
    private Throwable throwable;
    private long lineNumber = -1L;
    private long columnNumber = -1L;
    private long recordNumber = -1L;
    private long offset = -1L;
    private String batchId;

    public BatchContext(long lineNumber, long columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public BatchContext(long offset) {
        this.offset = offset;
    }

    public BatchContext() {
    }

    public void setRecordNumber(long recordNumber) {
        this.recordNumber = recordNumber;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setLineNumber(long lineNumber) {
        this.lineNumber = lineNumber;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public void setColumnNumber(long columnNumber) {
        this.columnNumber = columnNumber;
    }

    public long getColumnNumber() {
        return this.columnNumber;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setThrowable(Throwable t) {
        this.throwable = t;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean hasErrors() {
        return this.throwable != null;
    }

    public String toString() {
        String str = "BatchId[" + this.batchId + "], Line Number[" + this.lineNumber + "], Column Number[" + this.columnNumber + "], RecordNumber [" + this.recordNumber + "],  Offset [" + this.offset + "]";
        if (this.hasErrors()) {
            str = str + ", Error [" + BatchContext.getStackTraceAsString(this.throwable) + "]";
        }
        return str;
    }

    private static String getStackTraceAsString(Throwable t) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            return "------\r\n" + sw.toString() + "------\r\n";
        }
        catch (Throwable thr) {
            return "";
        }
    }
}

