/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.infra.exception.collaxa;

import java.io.IOException;
import java.io.Writer;
import oracle.tip.pc.infra.exception.collaxa.NonSyncStringBuffer;

public final class NonSyncStringWriter
extends Writer {
    NonSyncStringBuffer buf;
    boolean isClosed;
    long mLastAccessed;

    public NonSyncStringWriter() {
        this.buf = new NonSyncStringBuffer();
    }

    public NonSyncStringWriter(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buf = new NonSyncStringBuffer(i);
    }

    public NonSyncStringWriter(NonSyncStringBuffer buf) {
        this.buf = buf;
    }

    public final void reset() {
        this.buf.reset();
        this.isClosed = false;
    }

    public int capacity() {
        return this.buf.capacity();
    }

    public long lastAccessed() {
        return this.mLastAccessed;
    }

    public void setLastAccessed(long time) {
        this.mLastAccessed = time;
    }

    @Override
    public final void close() throws IOException {
        this.isClosed = true;
    }

    @Override
    public final void flush() {
    }

    public final NonSyncStringBuffer getBuffer() {
        return this.buf;
    }

    public final void ensureFreeSpace(int freeSpace) {
        this.buf.ensureFreeSpace(freeSpace);
    }

    public final String toString() {
        return this.buf.toString();
    }

    @Override
    public final void write(char[] ac) {
        this.write(ac, 0, ac.length);
    }

    @Override
    public final void write(char[] ac, int i, int j) {
        if (i < 0 || i > ac.length || j < 0 || i + j > ac.length || i + j < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (j != 0) {
            this.buf.append(ac, i, j);
        }
    }

    @Override
    public final void write(int i) {
        this.buf.append((char)i);
    }

    @Override
    public final void write(String s) {
        this.buf.append(s);
    }

    @Override
    public final void write(String s, int i, int j) {
        this.buf.append(s.substring(i, i + j));
    }
}

