/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.infra.exception.collaxa;

public final class NonSyncStringBuffer {
    private static final int DEFAULT_BLOCK_SIZE = 128;
    long mLastAccessed;
    public int m_blocksize;
    public char[] m_map;
    public int m_firstFree = 0;
    public int m_mapSize;

    public NonSyncStringBuffer() {
        this.m_blocksize = 128;
        this.m_mapSize = 128;
        this.m_map = new char[128];
    }

    public NonSyncStringBuffer(int blocksize) {
        this(blocksize, blocksize);
    }

    public NonSyncStringBuffer(int blocksize, int size) {
        this.m_blocksize = blocksize;
        if (blocksize <= 0) {
            blocksize = 128;
        }
        if (size < blocksize) {
            size = blocksize;
        }
        this.m_mapSize = size;
        this.m_map = new char[size];
    }

    public NonSyncStringBuffer(String content) {
        int len = content.length();
        this.m_mapSize = this.m_blocksize = len > 128 ? len + 32 : 128;
        this.m_map = new char[this.m_blocksize];
        this.append(content);
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final int length() {
        return this.m_firstFree;
    }

    public final char[] getRawBuffer() {
        return this.m_map;
    }

    public final void reset() {
        this.m_firstFree = 0;
    }

    public int capacity() {
        return this.m_mapSize;
    }

    public long lastAccessed() {
        return this.mLastAccessed;
    }

    public void setLastAccessed(long time) {
        this.mLastAccessed = time;
    }

    public final void setLength(int l) {
        this.m_firstFree = l;
    }

    public final String toString() {
        return new String(this.m_map, 0, this.m_firstFree);
    }

    public final void ensureFreeSpace(int newSize) {
        if (this.m_firstFree + newSize >= this.m_mapSize) {
            int size = this.m_mapSize + newSize;
            this.m_mapSize = (int)((float)size * 1.5f);
            char[] newMap = new char[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
    }

    public final void replace(char search, char replace) {
        int n = this.m_firstFree;
        for (int i = 0; i < n; ++i) {
            if (this.m_map[i] != search) continue;
            this.m_map[i] = replace;
        }
    }

    public final int replaceInto(NonSyncStringBuffer buf, String search, String replace) {
        if (search == null || replace == null) {
            return 0;
        }
        char[] str = search.toCharArray();
        int idx = this.indexOf(str, 0);
        if (idx < 0) {
            return 0;
        }
        int len = this.size();
        int addn = replace.length() - search.length();
        addn = addn > 0 ? len / search.length() * addn : 0;
        buf.ensureFreeSpace(len + addn);
        int prevIdx = 0;
        int sLen = search.length();
        int i = 0;
        while (idx >= 0) {
            this.copySubstring(buf, prevIdx, idx);
            buf.append(replace);
            prevIdx = idx + sLen;
            idx = this.indexOf(str, prevIdx);
            ++i;
        }
        this.copySubstring(buf, prevIdx, len);
        return i;
    }

    private void copySubstring(NonSyncStringBuffer buf, int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.size() || beginIndex > endIndex) {
            return;
        }
        if (beginIndex == 0 && endIndex == this.size()) {
            buf.append(this);
        } else {
            buf.append(this.m_map, beginIndex, endIndex - beginIndex);
        }
    }

    private int indexOf(char[] search, int fromIndex) {
        if (search == null) {
            return -1;
        }
        char[] v1 = this.m_map;
        char[] v2 = search;
        int count = this.m_firstFree;
        int scount = search.length;
        int max = count - scount;
        if (fromIndex >= count) {
            if (count == 0 && fromIndex == 0 && scount == 0) {
                return 0;
            }
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (scount == 0) {
            return fromIndex;
        }
        int strOffset = 0;
        char first = v2[strOffset];
        int i = fromIndex;
        block0: while (true) {
            if (i <= max && v1[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + scount - 1;
            int k = strOffset + 1;
            while (j < end) {
                if (v1[j++] == v2[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public final NonSyncStringBuffer append(boolean b) {
        int len;
        String bValue;
        if (b) {
            bValue = "true";
            len = 4;
        } else {
            bValue = "false";
            len = 5;
        }
        this.ensureFreeSpace(len);
        bValue.getChars(0, len, this.m_map, this.m_firstFree);
        this.m_firstFree += len;
        return this;
    }

    public final NonSyncStringBuffer append(char c) {
        this.ensureFreeSpace(1);
        this.m_map[this.m_firstFree++] = c;
        return this;
    }

    public final NonSyncStringBuffer append(char[] str) {
        if (str != null) {
            return this.append(str, 0, str.length);
        }
        return this.append((String)null);
    }

    public final NonSyncStringBuffer append(char[] str, int offset, int len) {
        if (str != null) {
            this.ensureFreeSpace(len);
            System.arraycopy(str, offset, this.m_map, this.m_firstFree, len);
            this.m_firstFree += len;
            return this;
        }
        return this.append((String)null);
    }

    public final NonSyncStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public final NonSyncStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public final NonSyncStringBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public final NonSyncStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public final NonSyncStringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public final NonSyncStringBuffer append(String str) {
        if (str == null) {
            str = "null";
        }
        int len = str.length();
        this.ensureFreeSpace(len);
        str.getChars(0, len, this.m_map, this.m_firstFree);
        this.m_firstFree += len;
        return this;
    }

    public final NonSyncStringBuffer append(StringBuffer value) {
        int len = value.length();
        this.ensureFreeSpace(len);
        value.getChars(0, len, this.m_map, this.m_firstFree);
        this.m_firstFree += len;
        return this;
    }

    public final NonSyncStringBuffer append(NonSyncStringBuffer value) {
        int length = value.m_firstFree;
        this.ensureFreeSpace(length);
        System.arraycopy(value.m_map, 0, this.m_map, this.m_firstFree, length);
        this.m_firstFree += length;
        return this;
    }

    public final NonSyncStringBuffer prepend(String str) {
        if (str == null) {
            str = "null";
        }
        int len = str.length();
        this.ensureFreeSpace(len);
        String copy = this.toString();
        copy.getChars(0, copy.length(), this.m_map, len);
        str.getChars(0, len, this.m_map, 0);
        this.m_firstFree += len;
        return this;
    }

    public static void main(String[] args) {
        NonSyncStringBuffer buf0 = new NonSyncStringBuffer(args[0]);
        NonSyncStringBuffer buf1 = new NonSyncStringBuffer();
        int i = buf0.replaceInto(buf1, args[1], args[2]);
        if (i > 0) {
            System.out.println(buf1.toString());
        } else {
            System.out.println("not found");
        }
    }
}

