/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.infra.exception.collaxa;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.tip.pc.infra.exception.collaxa.NonSyncStringBuffer;

public final class CXStringUtils {
    private static final String EMPTY = "";
    private static final char[] gsN2H = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int[] gsHI = new int[]{4096, 256, 16};

    public static int count(String content, String sub) {
        int counter = 0;
        int cursor = 0;
        while ((cursor = content.indexOf(sub, cursor)) > -1) {
            ++counter;
            ++cursor;
        }
        return counter;
    }

    public static String capitalize(String s) {
        char[] cs = s.toCharArray();
        cs[0] = Character.toUpperCase(cs[0]);
        return new String(cs);
    }

    public static String escapeJava(String s) {
        return CXStringUtils.escape(s, false);
    }

    public static String escapeJavaScript(String s) {
        return CXStringUtils.escape(s, true);
    }

    private static String escape(String s, boolean escapeSingleQuotes) {
        if (s == null) {
            return null;
        }
        NonSyncStringBuffer buf = new NonSyncStringBuffer(s.length() * 2);
        int sz = s.length();
        block12: for (int i = 0; i < sz; ++i) {
            char ch = s.charAt(i);
            if (ch > '\u0fff') {
                buf.append("\\u").append(CXStringUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                buf.append("\\u0").append(CXStringUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                buf.append("\\u00").append(CXStringUtils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        buf.append('\\').append('b');
                        break;
                    }
                    case '\n': {
                        buf.append('\\').append('n');
                        break;
                    }
                    case '\t': {
                        buf.append('\\').append('t');
                        break;
                    }
                    case '\f': {
                        buf.append('\\').append('f');
                        break;
                    }
                    case '\r': {
                        buf.append('\\').append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            buf.append("\\u00").append(CXStringUtils.hex(ch));
                            break;
                        }
                        buf.append("\\u000").append(CXStringUtils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuotes) {
                        buf.append('\\');
                    }
                    buf.append('\'');
                    continue block12;
                }
                case '\"': {
                    buf.append('\\').append('\"');
                    continue block12;
                }
                case '\\': {
                    buf.append('\\').append('\\');
                    continue block12;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }

    public static String trimToSize(String value, int length) {
        return CXStringUtils.trimToSize(value, length, true);
    }

    public static String trimToSize(String value, int length, boolean ellipses) {
        if (value != null && value.length() > length) {
            NonSyncStringBuffer buf = new NonSyncStringBuffer(length);
            if (ellipses) {
                return buf.append(value.substring(0, length - 4)).append(" ...").toString();
            }
            return buf.append(value.substring(0, length)).toString();
        }
        return value;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return CXStringUtils.startsWithIgnoreCase(str, prefix, 0);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        if (str == null || suffix == null) {
            return false;
        }
        return CXStringUtils.startsWithIgnoreCase(str, suffix, str.length() - suffix.length());
    }

    private static boolean startsWithIgnoreCase(String str, String prefix, int toffset) {
        if (str == null || prefix == null) {
            return false;
        }
        int to = toffset;
        int tlim = str.length();
        int po = 0;
        int plim = prefix.length();
        if (toffset < 0 || toffset > tlim - plim) {
            return false;
        }
        while (--plim >= 0) {
            char tc = str.charAt(to++);
            char pc = prefix.charAt(po++);
            if (Character.toLowerCase(tc) == Character.toLowerCase(pc)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithPeriod(String str) {
        if (str == null) {
            return false;
        }
        for (int i = str.length() - 1; i > 0; --i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c) || c != '.') continue;
            return true;
        }
        return false;
    }

    public static String trimFromEnd(String value, int nChars) {
        if (value == null || nChars <= 0) {
            return value;
        }
        int len = value.length();
        if (nChars >= value.length()) {
            return EMPTY;
        }
        return value.substring(0, len - nChars);
    }

    public static String replace(String str, char oldChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        NonSyncStringBuffer buf = null;
        boolean bFound = false;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (c == oldChar) {
                if (!bFound) {
                    buf = new NonSyncStringBuffer(n);
                    for (int j = 0; j < i; ++j) {
                        buf.append(str.charAt(j));
                    }
                    bFound = true;
                }
                buf.append(replaceChar);
                continue;
            }
            if (!bFound) continue;
            buf.append(c);
        }
        if (bFound) {
            return buf.toString();
        }
        return str;
    }

    public static String replace(String str, char oldChar, String replace) {
        if (str == null) {
            return null;
        }
        NonSyncStringBuffer buf = null;
        boolean bFound = false;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (c == oldChar) {
                if (!bFound) {
                    buf = new NonSyncStringBuffer(n * 2);
                    for (int j = 0; j < i; ++j) {
                        buf.append(str.charAt(j));
                    }
                    bFound = true;
                }
                buf.append(replace);
                continue;
            }
            if (!bFound) continue;
            buf.append(c);
        }
        if (bFound) {
            return buf.toString();
        }
        return str;
    }

    public static String replace(String str, String search, String replace) {
        int idx;
        if (str == null) {
            return null;
        }
        if (search == null) {
            return str;
        }
        if (replace == null) {
            replace = EMPTY;
        }
        if ((idx = str.indexOf(search)) < 0) {
            return str;
        }
        int len = str.length();
        int addn = replace.length() - search.length();
        addn = addn > 0 ? len / search.length() * addn : 0;
        NonSyncStringBuffer buf = new NonSyncStringBuffer(len + addn);
        int prevIdx = 0;
        int sLen = search.length();
        while (idx >= 0) {
            buf.append(str.substring(prevIdx, idx));
            buf.append(replace);
            prevIdx = idx + sLen;
            idx = str.indexOf(search, prevIdx);
        }
        buf.append(str.substring(prevIdx));
        return buf.toString();
    }

    public static String replace(String str, String[] search, String[] replace) {
        if (str == null) {
            return str;
        }
        NonSyncStringBuffer buf0 = new NonSyncStringBuffer(str);
        NonSyncStringBuffer buf1 = new NonSyncStringBuffer();
        int j = 0;
        int n = search.length;
        for (int i = 0; i < n; ++i) {
            int k = buf0.replaceInto(buf1, search[i], replace[i]);
            if (k <= 0) continue;
            NonSyncStringBuffer swap = buf0;
            buf0 = buf1;
            buf1 = swap;
            buf1.reset();
            j += k;
        }
        if (j > 0) {
            return buf0.toString();
        }
        return str;
    }

    public static String replace(String str, String[] search, String replace) {
        if (str == null) {
            return str;
        }
        NonSyncStringBuffer buf0 = new NonSyncStringBuffer(str);
        NonSyncStringBuffer buf1 = new NonSyncStringBuffer();
        int j = 0;
        int n = search.length;
        for (int i = 0; i < n; ++i) {
            int k = buf0.replaceInto(buf1, search[i], replace);
            if (k <= 0) continue;
            NonSyncStringBuffer swap = buf0;
            buf0 = buf1;
            buf1 = swap;
            buf1.reset();
            j += k;
        }
        if (j > 0) {
            return buf0.toString();
        }
        return str;
    }

    public static String removeFromStart(String str, char c) {
        char cc;
        int i;
        if (str == null) {
            return null;
        }
        int n = str.length();
        for (i = 0; i < n && c == (cc = str.charAt(i)); ++i) {
        }
        if (i == 0) {
            return str;
        }
        if (i < n) {
            return str.substring(i);
        }
        return EMPTY;
    }

    public static String removeFromStart(String str, String prefix) {
        if (str == null) {
            return null;
        }
        if (prefix == null) {
            return str;
        }
        if (str.indexOf(prefix) == 0) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removeFromEnd(String str, char c) {
        char cc;
        int i;
        if (str == null) {
            return null;
        }
        int n = str.length();
        for (i = n - 1; i > 0 && c != (cc = str.charAt(i)); --i) {
        }
        if (i == n - 1) {
            return str;
        }
        if (i > 0) {
            return str.substring(0, i);
        }
        return EMPTY;
    }

    public static String removeFromEnd(String str, String suffix) {
        if (str == null) {
            return null;
        }
        if (suffix == null) {
            return str;
        }
        int i = str.length() - suffix.length();
        if (i < 0) {
            return str;
        }
        if (str.lastIndexOf(suffix) == i) {
            return str.substring(0, i);
        }
        return str;
    }

    public static String remove(String str, char removeChar) {
        if (str == null) {
            return null;
        }
        NonSyncStringBuffer buf = new NonSyncStringBuffer(str.length());
        char[] c = str.toCharArray();
        int start = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != removeChar) continue;
            buf.append(str.substring(start, i));
            start = i + 1;
        }
        buf.append(str.substring(start));
        return buf.toString();
    }

    public static String extractBetween(String str, String prefix, String suffix) {
        int i;
        if (str == null) {
            return null;
        }
        if (prefix == null || suffix == null) {
            return str;
        }
        if (str.indexOf(prefix) == 0) {
            str = str.substring(prefix.length());
        }
        if ((i = str.length() - suffix.length()) < 0) {
            return str;
        }
        if (str.lastIndexOf(suffix) == i) {
            return str.substring(0, i);
        }
        return str;
    }

    public static boolean isEmpty(String value) {
        if (value == null || EMPTY.equals(value)) {
            return true;
        }
        char[] arr = value.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (Character.isWhitespace(arr[i])) continue;
            return false;
        }
        return true;
    }

    public static String[] split(String s, int size) {
        if (s == null || size <= 0) {
            return new String[0];
        }
        int sLen = s.length();
        if (sLen <= size) {
            return new String[]{s};
        }
        int n = (int)Math.ceil((double)sLen / (double)size);
        String[] sl = new String[n];
        int last = 0;
        int len = n - 1;
        for (int i = 0; i < len; ++i) {
            sl[i] = s.substring(last, last + size);
            last += size;
        }
        sl[i] = s.substring(last);
        return sl;
    }

    public static String[] split(NonSyncStringBuffer buf, int size) {
        if (buf == null || buf.size() == 0) {
            return new String[0];
        }
        char[] cs = buf.getRawBuffer();
        int bLen = buf.size();
        if (bLen <= size) {
            return new String[]{buf.toString()};
        }
        int n = (int)Math.ceil((double)bLen / (double)size);
        String[] sl = new String[n];
        int j = 0;
        int len = n - 1;
        for (int i = 0; i < len; ++i) {
            sl[i] = new String(cs, j, size);
            j += size;
        }
        sl[i] = new String(cs, j, bLen - j);
        return sl;
    }

    public static ArrayList split(String value, char delimiter) {
        return CXStringUtils.split(value, delimiter, new ArrayList(32));
    }

    public static ArrayList split(String value, char delimiter, ArrayList list) {
        return CXStringUtils.split(value, delimiter, Integer.MAX_VALUE, list);
    }

    public static ArrayList split(String value, char delimiter, int pieces) {
        ArrayList list = new ArrayList(pieces > 0 ? pieces : 10);
        return CXStringUtils.split(value, delimiter, pieces, list);
    }

    public static ArrayList split(String value, char delimiter, int pieces, ArrayList list) {
        if (value != null) {
            int prevIdx = 0;
            int delimIdx = value.indexOf(delimiter);
            while (delimIdx >= 0 && --pieces > 0) {
                String token = value.substring(prevIdx, delimIdx);
                list.add(token);
                prevIdx = delimIdx + 1;
                delimIdx = value.indexOf(delimiter, prevIdx);
            }
            if (prevIdx <= value.length()) {
                list.add(value.substring(prevIdx));
            }
        }
        return list;
    }

    public static ArrayList split(String value, String delimiters) {
        return CXStringUtils.split(value, delimiters, new ArrayList(32));
    }

    public static ArrayList split(String value, String delimiters, ArrayList list) {
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, delimiters);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }

    public static HashMap splitToMap(String value) {
        return CXStringUtils.splitToMap(value, ';');
    }

    public static HashMap splitToMap(String value, char delimiter) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (value != null) {
            int eqIdx;
            int prevIdx = 0;
            int delimIdx = value.indexOf(delimiter);
            while (delimIdx >= 0) {
                eqIdx = value.indexOf(61, prevIdx);
                if (eqIdx >= prevIdx && eqIdx < delimIdx) {
                    props.put(value.substring(prevIdx, eqIdx), value.substring(eqIdx + 1, delimIdx));
                }
                prevIdx = delimIdx + 1;
                delimIdx = value.indexOf(delimiter, prevIdx);
            }
            if (prevIdx <= value.length() && (eqIdx = value.indexOf(61, prevIdx)) >= prevIdx) {
                props.put(value.substring(prevIdx, eqIdx), value.substring(eqIdx + 1));
            }
        }
        return props;
    }

    public static HashMap splitToMap(NonSyncStringBuffer buf) {
        return CXStringUtils.splitToMap(buf, ';');
    }

    public static HashMap splitToMap(NonSyncStringBuffer buf, char delimiter) {
        HashMap props = new HashMap();
        if (buf != null) {
            char[] ac = buf.getRawBuffer();
            int n = buf.size();
            int prevIdx = 0;
            for (int i = 0; i < n; ++i) {
                char c = ac[i];
                if (c != delimiter) continue;
                CXStringUtils.parseKVPair(ac, prevIdx, i, props);
                prevIdx = i + 1;
            }
            if (prevIdx <= n) {
                CXStringUtils.parseKVPair(ac, prevIdx, n, props);
            }
        }
        return props;
    }

    private static void parseKVPair(char[] ac, int start, int end, HashMap props) {
        for (int i = start; i < end; ++i) {
            char c = ac[i];
            if (c != '=' || i <= start || i >= end) continue;
            props.put(new String(ac, start, i - start), new String(ac, i + 1, end - i - 1));
        }
    }

    public static String join(Object[] value, String separator) {
        if (value != null) {
            NonSyncStringBuffer buf = new NonSyncStringBuffer();
            for (int i = 0; i < value.length; ++i) {
                if (i != 0) {
                    buf.append(separator);
                }
                buf.append(value[i].toString());
            }
            return buf.toString();
        }
        return null;
    }

    public static String join(ArrayList list, String separator) {
        if (list != null) {
            NonSyncStringBuffer buf = new NonSyncStringBuffer();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    buf.append(separator);
                }
                buf.append(list.get(i));
            }
            return buf.toString();
        }
        return null;
    }

    public static String join(Map properties) {
        return CXStringUtils.join(properties, ';');
    }

    public static String join(Map properties, char delimiter) {
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        CXStringUtils.join(properties, delimiter, buf);
        return buf.toString();
    }

    public static void join(Map properties, NonSyncStringBuffer buf) {
        CXStringUtils.join(properties, ';', buf);
    }

    public static void join(Map properties, char delimiter, NonSyncStringBuffer buf) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        buf.reset();
        Iterator keys = properties.keySet().iterator();
        int size = properties.size();
        int i = 0;
        while (size > 0) {
            String key = (String)keys.next();
            String val = String.valueOf(properties.get(key));
            if (!CXStringUtils.isEmpty(val)) {
                if (i > 0) {
                    buf.append(delimiter);
                }
                buf.append(key).append('=').append(val);
            }
            --size;
            ++i;
        }
    }

    public static String repeat(String str, int repeat) {
        if (str == null || repeat < 0) {
            return null;
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static String wordWrap(String str) {
        return CXStringUtils.wordWrap(str, 80, "\n", "-");
    }

    public static String wordWrap(String str, int width) {
        return CXStringUtils.wordWrap(str, width, "\n", "-");
    }

    public static String wordWrap(String str, int width, String delim, String split) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        if (sz < width) {
            return str;
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(sz / ++width * delim.length() + sz);
        width -= delim.length();
        int idx = -1;
        String substr = null;
        for (int i = 0; i < sz; i += width) {
            int j;
            if (i > sz - width) {
                buffer.append(str.substring(i));
                break;
            }
            substr = str.substring(i, i + width);
            idx = substr.indexOf(delim);
            if (idx != -1) {
                char c;
                buffer.append(substr.substring(0, idx));
                buffer.append(delim);
                i -= width - idx - delim.length();
                if (substr.length() <= idx + 1 || (c = substr.charAt(idx + 1)) == '\n' || !Character.isWhitespace(c)) continue;
                ++i;
                continue;
            }
            idx = -1;
            char[] chrs = substr.toCharArray();
            for (j = width; j > 0; --j) {
                if (!Character.isWhitespace(chrs[j - 1])) continue;
                idx = j;
                break;
            }
            if (idx == -1) {
                for (j = width; j > 0; --j) {
                    if (chrs[j - 1] != '-') continue;
                    idx = j;
                    break;
                }
                if (idx == -1) {
                    buffer.append(substr);
                    buffer.append(delim);
                    continue;
                }
                if (idx != width) {
                    ++idx;
                }
                buffer.append(substr.substring(0, idx));
                buffer.append(delim);
                i -= width - idx;
                continue;
            }
            buffer.append(substr.substring(0, idx));
            buffer.append(CXStringUtils.repeat(" ", width - idx));
            buffer.append(delim);
            i -= width - idx;
        }
        return buffer.toString();
    }

    public static String toUnicode(String s) {
        NonSyncStringBuffer buf = new NonSyncStringBuffer(s.length());
        char[] ca = s.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (!CXStringUtils.isAsciiPrintable(ca[i])) {
                CXStringUtils.toUnicode(buf, ca[i]);
                continue;
            }
            buf.append(ca[i]);
        }
        return buf.toString();
    }

    public static String toUnicode(char c) {
        return CXStringUtils.toUnicode(new NonSyncStringBuffer(6), c);
    }

    public static boolean isAsciiPrintable(char c) {
        if (c < ' ') {
            return c == '\t' || c == '\r' || c == '\n';
        }
        return c <= '~';
    }

    public static String chomp(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            char ch = str.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return EMPTY;
            }
            return str;
        }
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (last != '\r') {
            ++lastIdx;
        }
        return str.substring(0, lastIdx);
    }

    public static String chomp(String str, String separator) {
        if (str == null || str.length() == 0 || separator == null) {
            return str;
        }
        if (str.endsWith(separator)) {
            return str.substring(0, str.length() - separator.length());
        }
        return str;
    }

    private static String toUnicode(NonSyncStringBuffer buf, char c) {
        buf.append("\\u");
        int ci = c;
        for (int i = 0; i < gsHI.length; ++i) {
            if (ci > gsHI[i]) {
                int d = ci / gsHI[i];
                buf.append(gsN2H[d]);
                ci %= gsHI[i];
                continue;
            }
            buf.append('0');
        }
        buf.append(gsN2H[ci]);
        return buf.toString();
    }

    public static String getURLEncodedFilepath(String path) {
        String result = path;
        try {
            NonSyncStringBuffer buf = new NonSyncStringBuffer();
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c < '\u00ff') {
                    buf.append(c);
                    continue;
                }
                buf.append(URLEncoder.encode(Character.toString(c), "UTF-8"));
            }
            result = buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static int indexOfIgnoreCase(String source, String target) {
        return CXStringUtils.indexOfIgnoreCase(source, target, 0);
    }

    public static int indexOfIgnoreCase(String source, String target, int fromIndex) {
        if (source == null || target == null) {
            return -1;
        }
        return CXStringUtils.indexOfIgnoreCase(source, 0, source.length(), target, 0, target.length(), fromIndex);
    }

    private static int indexOfIgnoreCase(String source, int sourceOffset, int sourceCount, String target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = Character.toLowerCase(target.charAt(targetOffset));
        int i = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (i <= max && source.charAt(i) != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end) {
                char tc;
                char sc;
                if ((sc = Character.toLowerCase(source.charAt(j++))) == (tc = Character.toLowerCase(target.charAt(k++)))) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i - sourceOffset;
    }

    public static boolean compareStrs(String s1, String s2) {
        if (s1 == null) {
            return s2 == null || s2.equals(EMPTY);
        }
        if (s2 == null) {
            return s1 == null || s1.equals(EMPTY);
        }
        return s1.equals(s2);
    }

    public static void main(String[] args) {
        String s1 = "abc\n  efg\ngh";
        System.out.println("trimFromEnd( boohoo, 3 ) = " + CXStringUtils.trimFromEnd("boohoo", 3));
        System.out.println("trimFromEnd( boohoo, 6 ) = " + CXStringUtils.trimFromEnd("boohoo", 6));
        System.out.println("trimFromEnd( boohoo, 7 ) = " + CXStringUtils.trimFromEnd("boohoo", 7));
        System.out.println("replace( hee/hee/, '/', \"\\\" ) = " + CXStringUtils.replace("hee/hee/", '/', "\\"));
        System.out.println("replace( abcdefghidef, def, boo ) = " + CXStringUtils.replace("abcdefghidef", "def", "boo"));
        System.out.println("replace( defdef, def, boo ) = " + CXStringUtils.replace("defdef", "def", "boo"));
        System.out.println("replace( abcghi, def, boo ) = " + CXStringUtils.replace("abcghi", "def", "boo"));
        System.out.println("replace( abcdef, abc, null ) = " + CXStringUtils.replace("abcdef", "abc", null));
        Object[] sl = CXStringUtils.split("woohoowheeeehaha", 3);
        System.out.println("split( woohoowheeeehaha, 3 ) = " + CXStringUtils.join(sl, " "));
        sl = CXStringUtils.split("b", 10);
        System.out.println("split( b, 10 ) = " + CXStringUtils.join(sl, " "));
        sl = CXStringUtils.split("wooooo", 0);
        System.out.println("split( wooooo, 0 ) = " + CXStringUtils.join(sl, " "));
        System.out.println("startsWith( boOhoo, BOO ) = " + CXStringUtils.startsWithIgnoreCase("boOhoo", "BOO"));
        System.out.println("startsWith( BoOhOo, BoOhOo! ) = " + CXStringUtils.startsWithIgnoreCase("BoOhOo", "BoOhOo!"));
        System.out.println("endsWith( boOhOo, oHoO ) = " + CXStringUtils.endsWithIgnoreCase("boOhOo", "oHoO"));
        System.out.println("endsWith( boOhOo, boOhOo! ) = " + CXStringUtils.endsWithIgnoreCase("boOhOo", "boOhOo!"));
        String propertyValue = "key1= val1  ;key2= _val2 __ ;key3=   val3 ";
        System.out.println("property string = '" + propertyValue + "'");
        HashMap map = CXStringUtils.splitToMap(propertyValue, ';');
        System.out.println("get( key1 ) = '" + map.get("key1") + "'");
        System.out.println("get( key2 ) = '" + map.get("key2") + "'");
        System.out.println("get( key3 ) = '" + map.get("key3") + "'");
        String propString = CXStringUtils.join((Map)map, ';');
        System.out.println("property string '" + propString + "'");
        map = CXStringUtils.splitToMap(propString, ';');
        System.out.println("get( key1 ) = '" + map.get("key1") + "'");
        System.out.println("get( key2 ) = '" + map.get("key2") + "'");
        System.out.println("get( key3 ) = '" + map.get("key3") + "'");
        propertyValue = "key1=val1;";
        System.out.println("property string " + propertyValue);
        map = CXStringUtils.splitToMap(propertyValue, ';');
        System.out.println("get( key1 ) = '" + map.get("key1") + "'");
        System.out.println("get( key2 ) = '" + map.get("key2") + "'");
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        propertyValue = "key1= val1  ;key2= _val2 __ ;key3=   val3 ";
        System.out.println("property string = '" + propertyValue + "'");
        buf.append(propertyValue);
        map = CXStringUtils.splitToMap(buf);
        System.out.println("get( key1 ) = '" + map.get("key1") + "'");
        System.out.println("get( key2 ) = '" + map.get("key2") + "'");
        System.out.println("get( key3 ) = '" + map.get("key3") + "'");
        propertyValue = "key1=val1;";
        System.out.println("property string " + propertyValue);
        buf.reset();
        buf.append(propertyValue);
        map = CXStringUtils.splitToMap(buf);
        System.out.println("get( key1 ) = '" + map.get("key1") + "'");
        System.out.println("get( key2 ) = '" + map.get("key2") + "'");
        String s = "bpel_A_1.0.jar";
        System.out.println("extract between = " + CXStringUtils.extractBetween(s, "bpel_A_", ".jar"));
    }
}

