/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.infra.exception;

import java.io.Serializable;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.tip.pc.infra.DiagnosticService;
import oracle.tip.pc.infra.PCProperties;
import oracle.tip.pc.infra.exception.PCExceptionIndex;
import oracle.tip.pc.infra.exception.PCExceptionResourceBundles;
import oracle.tip.pc.infra.exception.PCRuntimeException;
import oracle.tip.pc.infra.exception.collaxa.CubeException;

public class PCException
extends CubeException
implements Serializable {
    private static String gsListBundleName = null;
    private static Locale gsLocale = null;
    private static ListResourceBundle gsPRB = null;
    private static boolean gsLogErrorToSchema = false;
    private int m_componentId = 0;
    private String m_processName;
    private String m_processRevision;
    private String m_domainId;

    public PCException(int err) {
        super(err);
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        DiagnosticService.log(this);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        System.out.println("PCException(): err is " + err);
    }

    public PCException(int err, Throwable t) {
        super(err, t);
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        DiagnosticService.log(this);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
    }

    public PCException(PCException pce) {
        super(pce);
        this.m_componentId = pce.getComponent();
        DiagnosticService.log(this);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
    }

    public PCException(PCRuntimeException pcre) {
        super(pcre);
        this.m_componentId = pcre.getComponent();
        DiagnosticService.log(this);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
    }

    public PCException(Throwable t) {
        super(t);
        DiagnosticService.log(this);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
    }

    public PCException(Throwable t, int component) {
        super(t);
        this.m_componentId = component;
        DiagnosticService.log(this);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
    }

    public PCException(int err, Object[] objs) {
        super(err, objs);
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        DiagnosticService.log(this);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
    }

    public PCException(int err, Object[] objs, Throwable t) {
        super(err, objs, t);
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        DiagnosticService.log(this);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
    }

    public PCException(int err, Object[] objs, Object[] context) {
        super(err, objs, context);
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        DiagnosticService.log(this);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
    }

    public PCException(int err, Object[] objs, Object[] context, Throwable t) {
        super(err, objs, context, t);
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        DiagnosticService.log(this);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
    }

    public PCException(int err, int componentId, Object[] objs, Object[] context, Throwable t) {
        super(err, objs, context, t);
        this.m_componentId = componentId;
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        DiagnosticService.log(this);
    }

    public PCException(String procName, String procRev, String domainId, int err) {
        super(err);
        this.m_processName = procName;
        this.m_processRevision = procRev;
        this.m_domainId = domainId;
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        DiagnosticService.log(this);
    }

    public PCException(String procName, String procRev, String domainId, int err, Throwable t) {
        super(err, t);
        this.m_processName = procName;
        this.m_processRevision = procRev;
        this.m_domainId = domainId;
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        DiagnosticService.log(this);
    }

    public PCException(String procName, String procRev, String domainId, PCException pce) {
        super(pce);
        this.m_processName = procName;
        this.m_processRevision = procRev;
        this.m_domainId = domainId;
        this.m_componentId = pce.getComponent();
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        DiagnosticService.log(this);
    }

    public PCException(String procName, String procRev, String domainId, PCRuntimeException pcre) {
        super(pcre);
        this.m_processName = procName;
        this.m_processRevision = procRev;
        this.m_domainId = domainId;
        this.m_componentId = pcre.getComponent();
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        DiagnosticService.log(this);
    }

    public PCException(String procName, String procRev, String domainId, int err, Object[] objs) {
        super(err, objs);
        this.m_processName = procName;
        this.m_processRevision = procRev;
        this.m_domainId = domainId;
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        DiagnosticService.log(this);
    }

    public PCException(String procName, String procRev, String domainId, int err, Object[] objs, Throwable t) {
        super(err, objs, t);
        this.m_processName = procName;
        this.m_processRevision = procRev;
        this.m_domainId = domainId;
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        DiagnosticService.log(this);
    }

    public PCException(String procName, String procRev, String domainId, int err, Object[] objs, Object[] context) {
        super(err, objs, context);
        this.m_processName = procName;
        this.m_processRevision = procRev;
        this.m_domainId = domainId;
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        DiagnosticService.log(this);
    }

    public PCException(String procName, String procRev, String domainId, int err, Object[] objs, Object[] context, Throwable t) {
        super(err, objs, context, t);
        this.m_processName = procName;
        this.m_processRevision = procRev;
        this.m_domainId = domainId;
        this.m_componentId = PCExceptionIndex.getLogComponent(err);
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        DiagnosticService.log(this);
    }

    public PCException(String procName, String procRev, String domainId, int err, int componentId, Object[] objs, Object[] context, Throwable t) {
        super(err, objs, context, t);
        this.m_componentId = componentId;
        this.m_processName = procName;
        this.m_processRevision = procRev;
        this.m_domainId = domainId;
        if (gsLogErrorToSchema) {
            this.logPcError();
        }
        DiagnosticService.log(this);
    }

    public int getComponent() {
        return this.m_componentId;
    }

    public String getProcessName() {
        return this.m_processName;
    }

    public String getProcessRevision() {
        return this.m_processRevision;
    }

    public String getDomainId() {
        return this.m_domainId;
    }

    public static void setPropertyBundleName(String name, Locale locale) throws Exception {
        gsLocale = locale;
        gsPRB = (ListResourceBundle)ResourceBundle.getBundle(name, gsLocale);
        gsListBundleName = name;
    }

    public static void setPropertyBundleName(String name) throws Exception {
        PCException.setPropertyBundleName(name, Locale.getDefault());
    }

    public static void setLocale(Locale l) throws Exception {
        if (gsListBundleName == null) {
            PCExceptionResourceBundles.setLocale(l);
        } else {
            PCException.setPropertyBundleName(gsListBundleName, l);
        }
    }

    @Override
    protected String getResourceString(String key) throws MissingResourceException {
        try {
            if (gsListBundleName != null) {
                return gsPRB.getString(key);
            }
            return PCExceptionResourceBundles.getResourceString(key);
        }
        catch (MissingResourceException mre) {
            return super.getResourceString(key);
        }
    }

    private void logPcError() {
    }

    static {
        gsLogErrorToSchema = PCProperties.getBooleanProperty("oracle.tip.pc.services.reports.persist_errors", false);
    }
}

