/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.infra;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.tip.pc.infra.exception.PCException;
import oracle.tip.pc.infra.exception.PCRuntimeException;
import oracle.tip.pc.infra.exception.collaxa.NonSyncStringBuffer;

public class DiagnosticService {
    public static final int INVALIDCOMPONENT = -1;
    public static final int INFRACOMPONENT = 0;
    public static final int SERVICESCOMPONENT = 1;
    public static final int HUMANWORKFLOWCOMPONENT = 1;
    public static final int NOTIFICATIONCOMPONENT = 1;
    public static final int ORACLEWORKFLOWCOMPONENT = 1;
    public static final int VALIDATION = 1;
    public static final int REPORTSCOMPONENT = 2;
    public static final int CONSOLECOMPONENT = 3;
    public static final int UICOMPONENT = 3;
    public static final int TRANSLATION_COMPONENT = 4;
    public static final boolean[] IS_DOMAIN_LOGGER;
    public static final String[] COMPONENTS;
    private static final String[] COMPONENT_LOGGERS;
    protected static HashMap[] gsLoggers;
    protected static Object[] gsLockObj;
    protected static HashMap gsComponentLoggerMap;
    private static String DEFAULT_KEY;
    public static final int DIAGNOSTICS_ALL;
    public static final int DIAGNOSTICS_DEBUG;
    public static final int DIAGNOSTICS_INFORMATION;
    public static final int DIAGNOSTICS_WARNING;
    public static final int DIAGNOSTICS_ERRORS;
    public static final int DIAGNOSTICS_FATAL;
    public static final int DIAGNOSTICS_NONE;
    public static final String DEBUG;
    public static final String INFORMATION;
    public static final String WARNING;
    public static final String ERROR;
    public static final String FATAL;
    public static final String NONE;

    public static void log(int component, int severity, String message) {
        DiagnosticService.__log(component, COMPONENTS[component], severity, "", "", message, true);
    }

    public static void logNoMethod(int component, int severity, String message) {
        DiagnosticService.__log(component, COMPONENTS[component], severity, "", "", message, false);
    }

    public static void log(int component, String componentName, int severity, String message) {
        DiagnosticService.__log(component, componentName, severity, "", "", message, true);
    }

    protected static Logger getLogger(int component) {
        boolean isDomainLogger = IS_DOMAIN_LOGGER[component];
        if (component == -1) {
            return null;
        }
        String key = DEFAULT_KEY;
        if (key == null || "".equals(key)) {
            key = DEFAULT_KEY;
            isDomainLogger = false;
        }
        Logger logger = (Logger)gsLoggers[component].get(key);
        return logger;
    }

    private static void __logException(int component, int severity, Object message, Throwable t) {
        Logger logger = DiagnosticService.getLogger(component);
        Level lev = DiagnosticService.toLevel(severity);
    }

    private static String constructMessage(Object message) {
        String methodName;
        String className;
        block4: {
            className = null;
            methodName = null;
            try {
                int idx;
                Exception ex = new Exception();
                StackTraceElement[] elems = ex.getStackTrace();
                for (idx = 1; idx < elems.length && gsComponentLoggerMap.get(elems[idx].getClassName()) != null; ++idx) {
                }
                className = elems[idx].getClassName();
                className = className.substring(1 + className.lastIndexOf(46));
                methodName = elems[idx].getMethodName();
            }
            catch (Exception ex) {
                if (className == null) {
                    className = "";
                }
                if (methodName != null) break block4;
                methodName = "";
            }
        }
        return DiagnosticService.constructMessage(className, methodName, message);
    }

    public static void __log(int component, String componentName, int severity, String className, String methodName, String message, boolean logMethod) {
        Logger logger = DiagnosticService.getLogger(component);
        Level lev = DiagnosticService.toLevel(severity);
    }

    private static String getStackTrace(Exception e) {
        String stackTrace = null;
        try {
            StringWriter strWriter = new StringWriter(1000);
            PrintWriter prWriter = new PrintWriter(strWriter);
            e.printStackTrace(prWriter);
            prWriter.close();
            strWriter.close();
            stackTrace = strWriter.getBuffer().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stackTrace;
    }

    private static int convertPCRuntimeExceptionLogLevel(PCRuntimeException pe) {
        int exLevel = pe.getExceptionType();
        switch (exLevel) {
            case 1: {
                return DIAGNOSTICS_ERRORS;
            }
            case 0: {
                return DIAGNOSTICS_INFORMATION;
            }
            case 3: {
                return DIAGNOSTICS_WARNING;
            }
        }
        return DIAGNOSTICS_ERRORS;
    }

    private static int convertPCExceptionLogLevel(PCException pe) {
        int exLevel = pe.getExceptionType();
        switch (exLevel) {
            case 1: {
                return DIAGNOSTICS_ERRORS;
            }
            case 0: {
                return DIAGNOSTICS_INFORMATION;
            }
            case 3: {
                return DIAGNOSTICS_WARNING;
            }
        }
        return DIAGNOSTICS_ERRORS;
    }

    public static void log(PCException e) {
        DiagnosticService.log(e.getComponent(), DiagnosticService.convertPCExceptionLogLevel(e), e.getMessage());
        if (DiagnosticService.canLog(e.getComponent(), DIAGNOSTICS_DEBUG)) {
            Throwable cause;
            String stackTrace = DiagnosticService.getStackTrace(e);
            if (stackTrace != null) {
                DiagnosticService.log(e.getComponent(), DIAGNOSTICS_DEBUG, stackTrace);
            }
            if ((cause = e.getCause()) != null) {
                DiagnosticService.__logException(e.getComponent(), DIAGNOSTICS_DEBUG, cause.getMessage(), cause);
            }
        }
    }

    public static void log(PCRuntimeException e) {
        DiagnosticService.log(e.getComponent(), DiagnosticService.convertPCRuntimeExceptionLogLevel(e), e.getMessage());
        if (DiagnosticService.canLog(e.getComponent(), DIAGNOSTICS_DEBUG)) {
            Throwable cause;
            String stackTrace = DiagnosticService.getStackTrace(e);
            if (stackTrace != null) {
                DiagnosticService.log(e.getComponent(), DIAGNOSTICS_DEBUG, stackTrace);
            }
            if ((cause = e.getCause()) != null) {
                DiagnosticService.__logException(e.getComponent(), DIAGNOSTICS_DEBUG, cause.getMessage(), cause);
            }
        }
    }

    public static boolean canLog(int component, int severity) {
        Logger l = DiagnosticService.getLogger(component);
        Level msgLevel = DiagnosticService.toLevel(severity);
        return false;
    }

    public static int getComponentLevel(int component) {
        Logger l = DiagnosticService.getLogger(component);
        return l.getLevel().intValue();
    }

    public static int getLogLevel(int component) {
        return DiagnosticService.getComponentLevel(component);
    }

    public static void main(String[] args) {
        LoggerTest test = new LoggerTest();
        NullPointerException npe = new NullPointerException("dummy msg");
        test.log("========PCException======== test logging...make sure the cause (npe) is also logged", 1);
        test.logPCException(npe, 2, Level.FINE);
        test.log("========PCException======== since the level is debug, the stack trace should be printed", 1);
        test.logPCException(10605, new Object[]{"dp1", "JMSQueue"}, 2, Level.FINE);
        test.log("========PCException======== since the level is info, the stack trace should be hidden", 1);
        test.logPCException(10605, new Object[]{"dp1", "JMSQueue"}, 2, Level.INFO);
        test.log("========PCRuntimeException======== test logging...make sure the cause (npe) is also logged", 1);
        test.logPCRuntimeException(npe, 1, Level.FINE);
        test.log("========PCRuntimeException======== since the level is debug, the stack trace should be printed", 1);
        test.logPCRuntimeException(10605, new Object[]{"dp1", "JMSQueue"}, 2, Level.FINE);
        test.log("========PCRuntimeException======== since the level is info, the stack trace should be hidden", 1);
        test.logPCRuntimeException(10605, new Object[]{"dp1", "JMSQueue"}, 2, Level.INFO);
    }

    private static Level toLevel(int val) {
        if (val == Level.ALL.intValue()) {
            return Level.ALL;
        }
        if (val == Level.FINE.intValue()) {
            return Level.FINE;
        }
        if (val == Level.INFO.intValue()) {
            return Level.INFO;
        }
        if (val == Level.WARNING.intValue()) {
            return Level.WARNING;
        }
        if (val == Level.SEVERE.intValue()) {
            return Level.SEVERE;
        }
        if (val == Level.OFF.intValue()) {
            return Level.OFF;
        }
        return Level.FINE;
    }

    protected static String constructMessage(String className, String methodName, Object arg1) {
        return DiagnosticService.constructMessage(className, methodName, arg1, null, null, null, null, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String constructMessage(String className, String methodName, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        if (className == null) {
            className = "";
        }
        if (methodName == null) {
            methodName = "";
        }
        String s1 = null;
        String s2 = null;
        String s3 = null;
        String s4 = null;
        String s5 = null;
        String s6 = null;
        String s7 = null;
        String s8 = null;
        String s9 = null;
        String s10 = null;
        if (arg1 != null) {
            s1 = String.valueOf(arg1);
        }
        if (arg2 != null) {
            s2 = String.valueOf(arg2);
        }
        if (arg3 != null) {
            s3 = String.valueOf(arg3);
        }
        if (arg4 != null) {
            s4 = String.valueOf(arg4);
        }
        if (arg5 != null) {
            s5 = String.valueOf(arg5);
        }
        if (arg6 != null) {
            s6 = String.valueOf(arg6);
        }
        if (arg7 != null) {
            s7 = String.valueOf(arg7);
        }
        if (arg8 != null) {
            s8 = String.valueOf(arg8);
        }
        if (arg9 != null) {
            s9 = String.valueOf(arg9);
        }
        if (arg10 != null) {
            s10 = String.valueOf(arg10);
        }
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        buf.append('<').append(className).append("::").append(methodName).append("> ");
        if (s1 != null) {
            buf.append(s1);
        }
        if (s2 != null) {
            buf.append(s2);
        }
        if (s3 != null) {
            buf.append(s3);
        }
        if (s4 != null) {
            buf.append(s4);
        }
        if (s5 != null) {
            buf.append(s5);
        }
        if (s6 != null) {
            buf.append(s6);
        }
        if (s7 != null) {
            buf.append(s7);
        }
        if (s8 != null) {
            buf.append(s8);
        }
        if (s9 != null) {
            buf.append(s9);
        }
        if (s10 != null) {
            buf.append(s10);
        }
        String string = buf.toString();
        return string;
    }

    static {
        int i;
        IS_DOMAIN_LOGGER = new boolean[]{false, true, true, false, true};
        COMPONENTS = new String[]{"collaxa.cube.infrastructure", "collaxa.cube.services", "collaxa.cube.sensor", "collaxa.cube.console.reports", "collaxa.cube.translation"};
        COMPONENT_LOGGERS = new String[]{"oracle.tip.pc.services.reports.common.ReportsLogger", "oracle.tip.pc.services.hw.task.repos.ReposLogger", "oracle.tip.pc.services.common.Logger", DiagnosticService.class.getName()};
        gsLoggers = new HashMap[COMPONENTS.length];
        gsLockObj = new Object[COMPONENTS.length];
        gsComponentLoggerMap = new HashMap();
        DEFAULT_KEY = "server";
        for (i = 0; i < COMPONENT_LOGGERS.length; ++i) {
            gsComponentLoggerMap.put(COMPONENT_LOGGERS[i], COMPONENT_LOGGERS[i]);
        }
        for (i = 0; i < COMPONENTS.length; ++i) {
            DiagnosticService.gsLoggers[i] = new HashMap();
            DiagnosticService.gsLockObj[i] = new Object();
        }
        DIAGNOSTICS_ALL = Level.ALL.intValue();
        DIAGNOSTICS_DEBUG = Level.FINE.intValue();
        DIAGNOSTICS_INFORMATION = Level.INFO.intValue();
        DIAGNOSTICS_WARNING = Level.WARNING.intValue();
        DIAGNOSTICS_ERRORS = Level.SEVERE.intValue();
        DIAGNOSTICS_FATAL = Level.SEVERE.intValue();
        DIAGNOSTICS_NONE = Level.OFF.intValue();
        DEBUG = Level.FINE.toString();
        INFORMATION = Level.INFO.toString();
        WARNING = Level.WARNING.toString();
        ERROR = Level.SEVERE.toString();
        FATAL = Level.SEVERE.toString();
        NONE = Level.OFF.toString();
    }

    private static class LoggerTest {
        public void log(String msg, int component) {
            Logger l = DiagnosticService.getLogger(component);
            l.setLevel(Level.FINE);
            DiagnosticService.log(component, DIAGNOSTICS_DEBUG, msg);
        }

        public void logPCException(Throwable cause, int component, Level lev) {
            Logger l = DiagnosticService.getLogger(component);
            l.setLevel(lev);
            DiagnosticService.log(new PCException(cause, component));
        }

        public void logPCRuntimeException(int err, Object[] msgArgs, int component, Level lev) {
            Logger l = DiagnosticService.getLogger(component);
            l.setLevel(lev);
            DiagnosticService.log(new PCRuntimeException(err, msgArgs));
        }

        public void logPCException(int err, Object[] msgArgs, int component, Level lev) {
            Logger l = DiagnosticService.getLogger(component);
            l.setLevel(lev);
            DiagnosticService.log(new PCException(err, msgArgs));
        }

        public void logPCRuntimeException(Throwable cause, int component, Level lev) {
            Logger l = DiagnosticService.getLogger(component);
            l.setLevel(lev);
            DiagnosticService.log(new PCRuntimeException(cause, component));
        }
    }
}

