/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.utils;

import javax.xml.namespace.QName;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.catalog.parser.xsd.SFSNamespace;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import org.jetbrains.annotations.NotNull;

public class Utils {
    @NotNull
    public static CatalogType createCatalogTypeForSchemaType(@NotNull String name, @NotNull String namespace, @NotNull XmlElementType xmlElementType, @NotNull ComponentCatalog catalog, boolean exceptionObject, boolean isArray) {
        CatalogType result;
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            TypeDescription td = (TypeDescription)SFSNamespace.S2001_NAMESPACE.getAllDefinedTypes().get(name);
            assert (td != null) : "Missing Type Description for simple type: '" + name + "'";
            TypeDescription type = isArray ? TypeFactory.getArray((TypeRef)td) : td;
            result = CatalogType.Default.get((TypeRef)type);
        } else {
            String uniqueId = UUIDFactory.createXmlId((XmlElementType)xmlElementType, (String)namespace, (String)name).getId();
            TypeRef ref = exceptionObject ? catalog.findExceptionObjectBySchemaId(uniqueId) : catalog.findBpmObjectBySchemaId(uniqueId);
            if (ref == null) {
                ref = catalog.findById(ComponentType.XML, uniqueId);
            }
            if (ref == null) {
                ref = catalog.findById(ComponentType.SYSTEM_FAULTS, new QName(namespace, name).toString());
            }
            Object td = ref != null ? (isArray ? TypeFactory.getArray((TypeRef)ref) : ref.get()) : UnknownType.create((String)name, (ComponentCatalog)catalog, (String)uniqueId);
            result = CatalogObjectImpl.get((TypeRef)td);
        }
        return result;
    }

    @NotNull
    public static CatalogType createCatalogTypeForFaultType(@NotNull String name, @NotNull String namespace, @NotNull String message, @NotNull String messageNamespace, @NotNull ComponentCatalog catalog) {
        String uniqueId = UUIDFactory.createFaultId((String)namespace, (String)name, (String)messageNamespace, (String)message).getId();
        TypeRef ref = catalog.findExceptionObjectBySchemaId(uniqueId);
        if (ref == null) {
            ref = catalog.findById(ComponentType.XML, uniqueId);
        }
        Object td = ref != null ? ref.get() : UnknownType.create((String)name, (ComponentCatalog)catalog, (String)uniqueId);
        CatalogType result = CatalogObjectImpl.get((TypeRef)td);
        return result;
    }
}

