/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation.model;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import oracle.bpm.project.io.serializers.simulation.migrator.ModelSimulationMigrator;
import oracle.bpm.project.io.serializers.simulation.model.PersistentBaseModelSimulation;
import oracle.bpm.project.io.serializers.simulation.model.PersistentElementParser;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlparser.ParserException;
import oracle.bpm.xmlparser.UnexpectedContentException;

public class PersistentModelSimulation
extends PersistentBaseModelSimulation {
    public PersistentModelSimulation() {
        NamespaceContext namespaceContext = new NamespaceContext();
        namespaceContext.addNamespace("", this.getNamespace());
        this.setNSContext(namespaceContext);
    }

    public static ModelSimulation buildFrom(Reader reader, ResourceContainer container, String modelId) throws ProjectException {
        ModelSimulation modelSimulation;
        try {
            PersistentModelSimulation persistentModelSimulation;
            try {
                persistentModelSimulation = PersistentModelSimulation.parse(reader);
            }
            catch (UnexpectedContentException e) {
                DefaultElement defaultElement = e.getRootAsDefaultElement();
                persistentModelSimulation = ModelSimulationMigrator.migrate(defaultElement);
            }
            modelSimulation = container.createModelSimulation(modelId, persistentModelSimulation.getName());
            persistentModelSimulation.addTo(modelSimulation);
        }
        catch (ParserException e) {
            throw ProjectException.wrap((ProjectObject)container, e);
        }
        return modelSimulation;
    }

    public static ModelSimulation buildFrom(File file, Process process) throws ProjectException {
        ModelSimulation modelSimulation;
        try {
            PersistentModelSimulation persistentModelSimulation;
            try {
                persistentModelSimulation = PersistentModelSimulation.parse(file);
            }
            catch (UnexpectedContentException e) {
                DefaultElement defaultElement = e.getRootAsDefaultElement();
                persistentModelSimulation = ModelSimulationMigrator.migrate(defaultElement);
            }
            modelSimulation = process.getProject().getSimulations().createModelSimulation(process.getId(), persistentModelSimulation.getName());
            persistentModelSimulation.addTo(modelSimulation);
        }
        catch (ParserException e) {
            throw ProjectException.wrap((ProjectObject)process, e);
        }
        return modelSimulation;
    }

    public static PersistentModelSimulation parse(Reader reader) throws ParserException {
        return new PersistentElementParser().parseModelSimulation(null, reader);
    }

    public static void main(String[] args) {
        try {
            PersistentModelSimulation parsedModel;
            try {
                parsedModel = PersistentModelSimulation.parse(new File("C:\\Documents and Settings\\jorged\\Desktop\\OldSimulations\\FooProcess3_ModelSimulation3C.xsim"));
            }
            catch (UnexpectedContentException e) {
                DefaultElement defaultElement = e.getRootAsDefaultElement();
                parsedModel = ModelSimulationMigrator.migrate(defaultElement);
            }
            parsedModel.store(new File("C:\\Documents and Settings\\jorged\\Desktop\\OldSimulations\\FooProcess3_ModelSimulation3C-MIGRATED.xsim"));
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTo(ModelSimulation modelSimulation) {
        super.addTo(modelSimulation);
        modelSimulation.setMaxInstances(this.getMaxInstances());
        modelSimulation.setUseMaxInstances(this.getUseMaxInstances());
    }
}

