/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation.model;

import oracle.bpm.project.io.serializers.simulation.model.PersistentBaseActivity;
import oracle.bpm.project.io.serializers.simulation.model.PersistentCalculatedDistributions;
import oracle.bpm.project.io.serializers.simulation.model.PersistentDistribution;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.CostType;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ParticipantSelectionPolicy;
import oracle.bpm.project.model.simulation.QueuePolicy;
import oracle.bpm.project.model.simulation.SimulationFlowNode;

public class PersistentActivity
extends PersistentBaseActivity {
    @Override
    public void addTo(ModelSimulation modelSimulation) {
        if (this.getName() != null) {
            SimulationFlowNode simulationActivity = modelSimulation.createSimulationFlowNode(this.getName());
            if (simulationActivity == null) {
                return;
            }
            simulationActivity.setQueueWarningLevel(this.getQueueWarningLevel());
            simulationActivity.setQueuePolicy(QueuePolicy.valueOf(this.getQueuePolicy()));
            simulationActivity.setCostType(CostType.valueOf(this.getActivityCostType()));
            simulationActivity.setParticipantSelectionPolicy(ParticipantSelectionPolicy.valueOf(this.getParticipantSelectionPolicy()));
            simulationActivity.setExceptionProbability(this.getExceptionProbability());
            simulationActivity.setAbortProbability(this.getAbortProbability());
            simulationActivity.setCost(this.getCost());
            simulationActivity.setUseOrgResources(this.getUseOrgResources());
            simulationActivity.setCapacity(this.getCapacity());
            simulationActivity.setInnerSimulation(this.getInnerSimulation());
            this.generateDistributionData(simulationActivity);
            try {
                modelSimulation.addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getQueuePolicy() {
        String queuePolicy = super.getQueuePolicy();
        if (queuePolicy == null) {
            queuePolicy = QueuePolicy.FIFO.toString();
        }
        return queuePolicy;
    }

    @Override
    public String getActivityCostType() {
        String activityCostType = super.getActivityCostType();
        if (activityCostType == null) {
            activityCostType = CostType.FIXED_BASE_COST.toString();
        }
        return activityCostType;
    }

    @Override
    public String getParticipantSelectionPolicy() {
        String participantSelectionPolicy = super.getParticipantSelectionPolicy();
        if (participantSelectionPolicy == null) {
            participantSelectionPolicy = ParticipantSelectionPolicy.MINIMUM_COST.toString();
        }
        return participantSelectionPolicy;
    }

    private void generateDistributionData(SimulationFlowNode simulationActivity) {
        PersistentCalculatedDistributions calculatedDistributions;
        PersistentDistribution distribution = this.getDistribution();
        if (distribution != null) {
            distribution.addTo(simulationActivity);
        }
        if ((calculatedDistributions = this.getCalculatedDistributions()) != null) {
            calculatedDistributions.addTo(simulationActivity);
        }
    }
}

