/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation.migrator;

import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.lang.Str;
import oracle.bpm.project.io.serializers.simulation.project.PersistentCategoryProbabilities;
import oracle.bpm.project.io.serializers.simulation.project.PersistentCategoryProbability;
import oracle.bpm.project.io.serializers.simulation.project.PersistentModelSimulation;
import oracle.bpm.project.io.serializers.simulation.project.PersistentModelSimulations;
import oracle.bpm.project.io.serializers.simulation.project.PersistentProjectSimulation;
import oracle.bpm.project.io.serializers.simulation.project.PersistentResource;
import oracle.bpm.project.io.serializers.simulation.project.PersistentResources;
import oracle.bpm.project.io.serializers.simulation.project.PersistentRole;
import oracle.bpm.project.io.serializers.simulation.project.PersistentRoles;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.Element;

public class ProjectSimulationMigrator {
    private ProjectSimulationMigrator() {
    }

    public static PersistentProjectSimulation migrate(DefaultElement rootElement) {
        PersistentProjectSimulation persistentProjectSimulation = new PersistentProjectSimulation();
        if (rootElement.getNamespace() != null && rootElement.getNamespace().equals("")) {
            OldProjectSimulationMigrationPolicy.migrate(rootElement, persistentProjectSimulation);
        }
        return persistentProjectSimulation;
    }

    private static class OldProjectSimulationMigrationPolicy {
        private static final String RESOURCE_TAG_NAME = "resource";
        private static final String PROCESS_MODEL_ENTRY_TAG_NAME = "processModelEntry";
        private static final String PROJECT_SIMULATION_MODEL_TAG_NAME = "projectSimulationModel";
        private static final String CATEGORY_PROBABILITY_STRING_ATT = "categoryProbabilitiesString";
        private static final String ROLE_LIST_STRING_ATT = "roleList";

        private OldProjectSimulationMigrationPolicy() {
        }

        public static void migrate(DefaultElement rootElement, PersistentProjectSimulation persistentProjectSimulation) {
            DefaultElement[] elements;
            OldProjectSimulationMigrationPolicy.migrateElement(rootElement, persistentProjectSimulation);
            for (DefaultElement element : elements = rootElement.findChildrenByClass(DefaultElement.class)) {
                OldProjectSimulationMigrationPolicy.migrateElement(element, persistentProjectSimulation);
            }
        }

        private static void migrateElement(DefaultElement element, PersistentProjectSimulation projectSimulation) {
            String tagName = element.getTagName();
            if (tagName.equals(RESOURCE_TAG_NAME)) {
                OldProjectSimulationMigrationPolicy.migrateResource(element, projectSimulation);
            } else if (tagName.equals(PROCESS_MODEL_ENTRY_TAG_NAME)) {
                OldProjectSimulationMigrationPolicy.migrateProcessModelEntry(element, projectSimulation);
            } else if (tagName.equals(PROJECT_SIMULATION_MODEL_TAG_NAME)) {
                OldProjectSimulationMigrationPolicy.migrateProjectSimulationModel(element, projectSimulation);
            }
        }

        private static void migrateProjectSimulationModel(DefaultElement element, PersistentProjectSimulation projectSimulation) {
            Map attributes = element.getAttributes();
            for (QName key : attributes.keySet()) {
                if (CATEGORY_PROBABILITY_STRING_ATT.equals(key.getLocalPart())) {
                    OldProjectSimulationMigrationPolicy.migrateCategoryProbabilities((String)attributes.get(key), projectSimulation);
                    continue;
                }
                projectSimulation.setAttribute(key, (String)attributes.get(key));
            }
        }

        private static void migrateCategoryProbabilities(String categoriesList, PersistentProjectSimulation projectSimulation) {
            String[] categories = categoriesList != null && !"".equals(categoriesList) ? Str.split((String)categoriesList, (char)',', (boolean)false) : new String[]{};
            PersistentCategoryProbabilities catProbabilities = new PersistentCategoryProbabilities();
            projectSimulation.addChild((Element)catProbabilities);
            for (String category : categories) {
                catProbabilities.addChild((Element)new PersistentCategoryProbability(Double.parseDouble(category)));
            }
        }

        private static void migrateProcessModelEntry(DefaultElement element, PersistentProjectSimulation projectSimulation) {
            PersistentModelSimulations persistentModelSimulations = projectSimulation.getModelSimulations();
            if (persistentModelSimulations == null) {
                persistentModelSimulations = new PersistentModelSimulations();
                projectSimulation.addChild((Element)persistentModelSimulations);
            }
            PersistentModelSimulation persistentModelSimulation = new PersistentModelSimulation();
            persistentModelSimulation.setModelSimulationId(element.getAttribute("modelId"));
            persistentModelSimulation.setModelId(element.getAttribute("processId"));
            persistentModelSimulations.addChild((Element)persistentModelSimulation);
            projectSimulation.removeChild((Element)element);
        }

        private static void migrateResource(DefaultElement element, PersistentProjectSimulation projectSimulation) {
            PersistentResources persistentResources = projectSimulation.getResources();
            if (persistentResources == null) {
                persistentResources = new PersistentResources();
                projectSimulation.addChild((Element)persistentResources);
            }
            PersistentResource persistentResource = new PersistentResource();
            persistentResource.setName(element.getAttribute("name"));
            persistentResource.setEfficiency(Double.valueOf(element.getAttribute("efficiency")));
            persistentResource.setCapacity(Integer.valueOf(element.getAttribute("capacity")));
            persistentResource.setVirtual(Boolean.valueOf(element.getAttribute("virtual")));
            OldProjectSimulationMigrationPolicy.migrateRoles(element, persistentResource);
            persistentResource.setSelected(Boolean.valueOf(element.getAttribute("selected")));
            persistentResource.setCost(Double.valueOf(element.getAttribute("cost")));
            persistentResource.setAvailability(Integer.valueOf(element.getAttribute("availability")));
            persistentResources.addChild((Element)persistentResource);
            projectSimulation.removeChild((Element)element);
        }

        private static void migrateRoles(DefaultElement element, PersistentResource persistentResource) {
            PersistentRoles persistentRoles = new PersistentRoles();
            OldProjectSimulationMigrationPolicy.migrateRoleList(element.getAttribute(ROLE_LIST_STRING_ATT), persistentRoles);
            persistentResource.setRoles(persistentRoles);
        }

        private static void migrateRoleList(String roleList, PersistentRoles persistentRoles) {
            String[] rolesIds;
            for (String rolesId : rolesIds = roleList != null && !"".equals(roleList) ? Str.split((String)roleList, (char)',', (boolean)false) : new String[]{}) {
                PersistentRole role = new PersistentRole();
                role.setId(rolesId);
                persistentRoles.addChild((Element)role);
            }
        }
    }
}

