/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.simulation;

import oracle.bpm.project.io.serializers.simulation.project.PersistentCategoryProbabilities;
import oracle.bpm.project.io.serializers.simulation.project.PersistentCategoryProbability;
import oracle.bpm.project.io.serializers.simulation.project.PersistentModelSimulation;
import oracle.bpm.project.io.serializers.simulation.project.PersistentModelSimulations;
import oracle.bpm.project.io.serializers.simulation.project.PersistentProjectSimulation;
import oracle.bpm.project.io.serializers.simulation.project.PersistentResource;
import oracle.bpm.project.io.serializers.simulation.project.PersistentResources;
import oracle.bpm.project.io.serializers.simulation.project.PersistentRole;
import oracle.bpm.project.io.serializers.simulation.project.PersistentRoles;
import oracle.bpm.project.model.ProjectVisitorAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.xmlparser.Element;

public class ProjectSimulationVisitor
extends ProjectVisitorAdapter {
    private PersistentProjectSimulation persistentProjectSimulation = new PersistentProjectSimulation();

    public PersistentProjectSimulation getPersistentProjectSimulation() {
        return this.persistentProjectSimulation;
    }

    @Override
    public void visit(ProjectSimulation projectSimulation) throws ProjectException {
        this.persistentProjectSimulation.setInflightFinish(projectSimulation.getInflightFinish());
        this.persistentProjectSimulation.setStartTime(projectSimulation.getStartTime());
        this.persistentProjectSimulation.setName(projectSimulation.getId());
        this.persistentProjectSimulation.setDuration(projectSimulation.getDuration().toString());
        this.persistentProjectSimulation.setUseCalendarRules(projectSimulation.getUseCalendarRules());
        this.visitCategoryProbabilities(projectSimulation);
        this.visitResources(projectSimulation);
        this.visitModels(projectSimulation);
    }

    @Override
    public void visit(SimulationResource simulationResource) throws ProjectException {
        PersistentResources persistentResources = this.persistentProjectSimulation.getResources();
        PersistentResource persistentResource = new PersistentResource();
        persistentResource.setName(simulationResource.getId());
        persistentResource.setEfficiency(simulationResource.getEfficiency());
        persistentResource.setCapacity(simulationResource.getCapacity());
        persistentResource.setVirtual(simulationResource.isVirtual());
        persistentResource.setSelected(simulationResource.getSelected());
        persistentResource.setCost(simulationResource.getCost());
        persistentResource.setAvailability(simulationResource.getAvailability());
        PersistentRoles persistentRoles = new PersistentRoles();
        for (String role : simulationResource.getRoles()) {
            PersistentRole persistentRole = new PersistentRole();
            persistentRole.setId(role);
            persistentRoles.addChild((Element)persistentRole);
        }
        persistentResource.setRoles(persistentRoles);
        persistentResources.addChild((Element)persistentResource);
    }

    private void visitModels(ProjectSimulation projectSimulation) {
        PersistentModelSimulations persistentModelSimulations = this.persistentProjectSimulation.getModelSimulations();
        if (persistentModelSimulations == null) {
            persistentModelSimulations = new PersistentModelSimulations();
            this.persistentProjectSimulation.setModelSimulations(persistentModelSimulations);
        }
        for (ModelSimulation modelSimulation : projectSimulation.getModelSimulations()) {
            PersistentModelSimulation persistentModelSimulation = new PersistentModelSimulation();
            persistentModelSimulation.setModelId(this.createModelSimulationId(modelSimulation));
            persistentModelSimulation.setModelVariation("");
            persistentModelSimulation.setModelSimulationId(modelSimulation.getId());
            persistentModelSimulations.addChild((Element)persistentModelSimulation);
        }
    }

    private String createModelSimulationId(ModelSimulation modelSimulation) {
        return "/" + modelSimulation.getProcess().getId() + ".xpdl";
    }

    private void visitResources(ProjectSimulation projectSimulation) throws ProjectException {
        PersistentResources persistentResources = this.persistentProjectSimulation.getResources();
        if (persistentResources == null) {
            this.persistentProjectSimulation.setResources(new PersistentResources());
        }
        for (SimulationResource simResource : projectSimulation.getResources()) {
            simResource.visit(this);
        }
    }

    private void visitCategoryProbabilities(ProjectSimulation projectSimulation) {
        double[] categoryProbabilities;
        PersistentCategoryProbabilities persistentCategoryProbabilities = this.persistentProjectSimulation.getCategoryProbabilities();
        if (persistentCategoryProbabilities == null) {
            persistentCategoryProbabilities = new PersistentCategoryProbabilities();
            this.persistentProjectSimulation.setCategoryProbabilities(persistentCategoryProbabilities);
        }
        for (double categoryProbability : categoryProbabilities = projectSimulation.getCategoryProbabilities()) {
            PersistentCategoryProbability persistentCategoryProbability = new PersistentCategoryProbability();
            persistentCategoryProbability.setValue(categoryProbability);
            persistentCategoryProbabilities.addChild((Element)persistentCategoryProbability);
        }
    }
}

