/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization.presentation;

import java.io.Writer;
import java.util.List;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.project.io.fs.msg.ProjectIoMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.presentation.presentations.PresentationManagerAdapter;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.io.PresentationLoader;

public class ProjectPresentationLoader
extends PresentationLoader {
    private final Project project;

    public ProjectPresentationLoader(Project project) {
        this.project = project;
    }

    public SortedStringMap<PresentationImpl> loadOrganizationPresentations() {
        try {
            List<Presentation> projectObjects = this.project.getLoader().getAllObjects(Presentation.class);
            PresentationManagerAdapter presentationManager = (PresentationManagerAdapter)this.project.getPresentationManager();
            for (Presentation presentation : projectObjects) {
                presentationManager.addPresentation(presentation);
            }
        }
        catch (ProjectException e) {
            throw ProgramException.wrap((String)ProjectIoMsg.VIEW_LOADING_ERROR.getString(), (Throwable)((Object)e));
        }
        return this.project.getPresentationManager().getSortedStringOrganizationPresentations();
    }

    public SortedStringMap<PresentationImpl> loadParticipantPresnetations(String participantId) {
        return null;
    }

    public void removeOrganizationPresentation(String presentationId) {
    }

    public void removeParticipantPresentation(String participantId, String presentationId) {
    }

    public void storeOrganizationPresentation(PresentationImpl presentation, Writer writer) {
    }

    public void storeParticipantPresentation(String participantId, PresentationImpl presentation) {
    }
}

