/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.deployment.ProcessDeployment;
import oracle.bpm.project.model.deployment.Topology;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.xml.XmlWriter;

public class XmlTopologySerializer
implements ProjectObjectSerializer {
    @Override
    public void write(Writer writer, ProjectObject object) throws ProjectException {
        XmlWriter xmlWriter = new XmlWriter(writer, Literals.DEFAULT_ENCODING);
        try {
            xmlWriter.startDocument();
            xmlWriter.startElement("publication");
            xmlWriter.printAttribute("viewsGenerationType", (Enum)((Topology)object).getViewsGenerationType());
            xmlWriter.printAttribute("inboxPresentation", ((Topology)object).getInboxViewPresentationId());
            xmlWriter.printAttribute("activitiesPresentation", ((Topology)object).getActivityViewsPresentationId());
            xmlWriter.printAttribute("processesPresentation", ((Topology)object).getProcessViewsPresentationId());
            this.write(xmlWriter, object);
            xmlWriter.endElement();
            xmlWriter.close();
        }
        catch (IOException ioe) {
            throw ProjectException.wrap(ioe);
        }
    }

    protected void write(XmlWriter xmlWriter, ProjectObject object) throws IOException {
        Topology topology = (Topology)object;
        Collection<ProcessDeployment> deployments = topology.getDeployments();
        for (ProcessDeployment deployment : deployments) {
            xmlWriter.startElement("deploy");
            xmlWriter.printAttribute("name", deployment.getProcessName());
            xmlWriter.printAttribute("ou", deployment.getOU());
            xmlWriter.endElement();
        }
    }
}

