/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.io.IOException;
import java.util.Collection;
import oracle.bpm.project.io.serializers.organization.BaseXmlSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.organization.GroupAssignment;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.ParticipantAbsence;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.xml.XmlWriter;

public class XmlParticipantSerializer
extends BaseXmlSerializer {
    @Override
    public void write(XmlWriter xmlWriter, ProjectObject object) throws IOException {
        assert (object instanceof Participant);
        Participant participant = (Participant)object;
        xmlWriter.startElement("DirHumanParticipant");
        this.writeBasicParticipantData(xmlWriter, participant);
        xmlWriter.endElement();
    }

    protected void writeBasicParticipantData(XmlWriter xmlWriter, Participant participant) throws IOException {
        xmlWriter.printValuedElement("id", participant.getId());
        xmlWriter.printValuedElement("firstName", participant.getFirstName());
        xmlWriter.printValuedElement("lastName", participant.getLastName());
        xmlWriter.printValuedElement("displayName", participant.getDisplayName());
        xmlWriter.printValuedElement("mail", participant.getMail());
        xmlWriter.printValuedElement("receivesMail", String.valueOf(participant.receivesMail()));
        xmlWriter.printValuedElement("ou", participant.getOrganizationalUnit().isRoot() ? "" : participant.getOrganizationalUnit().getInternalPath());
        xmlWriter.printValuedElement("status", this.getStatus(participant));
        xmlWriter.printValuedElement("telephone", participant.getTelephone());
        xmlWriter.printValuedElement("fax", participant.getFax());
        xmlWriter.printValuedElement("employeeId", participant.getEmployeeId());
        xmlWriter.printValuedElement("manager", participant.getManager());
        xmlWriter.printValuedElement("locale", participant.getLocale() != null ? participant.getLocale().toString() : "");
        xmlWriter.printValuedElement("timezone", participant.getTimeZone() != null ? participant.getTimeZone().getID() : "");
        xmlWriter.printValuedElement("cost", "" + participant.getCost());
        xmlWriter.printValuedElement("efficiency", "" + participant.getEfficiency());
        this.writeGroupAssigments(participant, xmlWriter);
        this.writeRoleAssigments(participant, xmlWriter);
        this.writeAbsencePeriods(participant, xmlWriter);
    }

    private void writeGroupAssigments(Participant participant, XmlWriter xmlWriter) throws IOException {
        Collection<GroupAssignment> groupAssignments = participant.getGroupAssignments();
        if (!groupAssignments.isEmpty()) {
            xmlWriter.startElement("assignedGroups");
            for (GroupAssignment groupAssignment : groupAssignments) {
                xmlWriter.printValuedElement("groupId", groupAssignment.getGroup() != null ? groupAssignment.getGroup().getId() : groupAssignment.getGroupId());
            }
            xmlWriter.endElement();
        }
    }

    private void writeAbsencePeriods(Participant participant, XmlWriter xmlWriter) throws IOException {
        Collection<ParticipantAbsence> absencePeriods = participant.getAbsencePeriods();
        if (!absencePeriods.isEmpty()) {
            xmlWriter.startElement("absences");
            for (ParticipantAbsence absence : absencePeriods) {
                xmlWriter.startElement("absence");
                xmlWriter.printValuedElement("from", absence.getFrom().toString());
                xmlWriter.printValuedElement("to", absence.getTo().toString());
                for (Participant replacement : absence.getReplacements()) {
                    xmlWriter.printValuedElement("replacement", replacement.getId());
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
    }

    private void writeRoleAssigments(Participant participant, XmlWriter xmlWriter) throws IOException {
        Collection<RoleAssignment> roleAssignments = participant.getRoleAssignments();
        if (!roleAssignments.isEmpty()) {
            xmlWriter.startElement("rolesAssignment");
            for (RoleAssignment roleAssignment : roleAssignments) {
                xmlWriter.startElement("roleAssignment");
                xmlWriter.printValuedElement("roleId", roleAssignment.getRole() != null ? roleAssignment.getRole().getId() : roleAssignment.getRoleId());
                xmlWriter.printValuedElement("parametricValue", roleAssignment.getParametricValue());
                xmlWriter.printValuedElement("permissions", String.valueOf(roleAssignment.getPermissions()));
                xmlWriter.printValuedElement("category", String.valueOf(roleAssignment.getCategory()));
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
    }

    private String getStatus(Participant participant) {
        return participant.isAdministrator() ? "S" : (participant.isEnabled() ? "A" : "D");
    }
}

