/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.io.IOException;
import oracle.bpm.project.io.serializers.organization.BaseXmlSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.project.model.variables.DefaultValueAssignment;
import oracle.bpm.xml.XmlWriter;

public class XmlBusinessParameterSerializer
extends BaseXmlSerializer {
    @Override
    public void write(XmlWriter xmlWriter, ProjectObject object) throws IOException {
        assert (object instanceof BusinessParameter);
        BusinessParameter businessParameter = (BusinessParameter)object;
        xmlWriter.startElement("DirBusinessParameter");
        xmlWriter.printValuedElement("id", businessParameter.getId());
        xmlWriter.printValuedElement("type", businessParameter.getTypeDescription().getName());
        Object defaultValue = businessParameter.getDefaultValue();
        xmlWriter.printCDATAElement("defaultValue", defaultValue == null ? "" : defaultValue.toString());
        xmlWriter.startElement("valuesMap");
        for (DefaultValueAssignment defaultValueAssignment : businessParameter.getDefaultValuesAssignment()) {
            xmlWriter.startElement("entry");
            xmlWriter.printCDATAElement("key", defaultValueAssignment.getOrganizationalUnit().getInternalPath());
            xmlWriter.printCDATAElement("value", defaultValueAssignment.getDefaultValue() != null ? defaultValueAssignment.getDefaultValue().toString() : null);
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        xmlWriter.endElement();
    }
}

