/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import oracle.bpm.project.io.exception.CheckContentTypeException;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.ProjectSourceHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.deployment.ProcessDeployment;
import oracle.bpm.project.model.deployment.Topology;
import oracle.bpm.project.model.deployment.ViewsGenerationType;
import oracle.bpm.project.model.exception.ProjectException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TopologyHandler
extends BaseSourceHandler {
    protected DeployHandler deployHandler;
    private Topology topology;

    public TopologyHandler(ProjectSourceHandler projectSourceHandler, boolean checkContentType) {
        super(projectSourceHandler, checkContentType);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String viewsGenerationType = attributes.getValue("viewsGenerationType");
        String inboxPresentation = attributes.getValue("inboxPresentation");
        String activitiesPresentation = attributes.getValue("activitiesPresentation");
        String processesPresentation = attributes.getValue("processesPresentation");
        if (viewsGenerationType == null || viewsGenerationType.equals("")) {
            viewsGenerationType = ViewsGenerationType.UNIFIED_INBOX.toString();
        }
        if (this.isCheckContentType()) {
            throw new CheckContentTypeException(ProjectObjectType.TOPOLOGY);
        }
        this.topology = this.getProject().getDeployment().createTopology();
        this.topology.setViewsGenerationType(ViewsGenerationType.valueOf(viewsGenerationType));
        this.topology.setInboxViewPresentationId(inboxPresentation);
        this.topology.setActivityViewsPresentationId(activitiesPresentation);
        this.topology.setProcessViewsPresentationId(processesPresentation);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            this.getParseListener().objectParsed(this, this.topology);
        }
        catch (ProjectException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
        this.deployHandler.addToModel(null);
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("deploy".equals(name)) {
            this.deployHandler = new DeployHandler(this);
            return this.deployHandler;
        }
        return new BaseSourceHandler(this);
    }

    private class DeployHandler
    extends BaseSourceHandler {
        ProcessDeployment deployment;

        public DeployHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String processName = attributes.getValue("name");
            String ou = attributes.getValue("ou");
            this.deployment = TopologyHandler.this.topology.createDeployment(processName, ou);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            TopologyHandler.this.topology.addDeployment(this.deployment);
        }
    }
}

