/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.deployment.Referral;
import oracle.bpm.project.model.exception.ProjectException;
import org.xml.sax.SAXException;

class ReferralHandler
extends BaseSourceHandler {
    private String organization;
    private String properties;

    ReferralHandler(BaseSourceHandler parent) {
        super(parent);
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("organization".equals(name)) {
            return new OrganizationHandler(this);
        }
        if ("properties".equals(name)) {
            return new ReferralDataHandler(this);
        }
        return super.getHandler(uri, qName, name);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            Referral.Mutable referral = this.getProject().getDeployment().createReferral(this.organization).asMutable();
            this.getParseListener().objectParsed(this, referral);
        }
        catch (ProjectException e) {
            Log.logSevere((Throwable)((Object)e));
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
        this.getProject().getDeployment().addReferral((Referral)projectObject);
    }

    private class ReferralDataHandler
    extends DataElementHandler {
        public ReferralDataHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ReferralHandler.this.properties = this.getData();
        }
    }

    private class OrganizationHandler
    extends DataElementHandler {
        public OrganizationHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ReferralHandler.this.organization = this.getData();
        }
    }
}

