/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import oracle.bpm.project.io.serializers.organization.BaseSourceHandler;
import oracle.bpm.project.io.serializers.organization.DataElementHandler;
import oracle.bpm.project.io.serializers.organization.SourceHandler;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import org.xml.sax.SAXException;

class OrganizationalUnitHandler
extends BaseSourceHandler {
    private boolean addOU;
    private String calendarRuleName;
    private String description;
    private String id;
    private String parentId;

    OrganizationalUnitHandler(BaseSourceHandler parent) {
        super(parent);
    }

    @Override
    public SourceHandler getHandler(String uri, String qName, String name) {
        if ("name".equals(name)) {
            return new NameHandler(this);
        }
        if ("description".equals(name)) {
            return new DescriptionHandler(this);
        }
        if ("parentId".equals(name)) {
            return new ParentIdHandler(this);
        }
        if ("nameCalendar".equals(name)) {
            return new CalendarRuleNameHandler(this);
        }
        return new BaseSourceHandler(this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            Organization organization = this.getProject().getOrganization();
            OrganizationalUnit parentOU = this.parentId == null ? organization.getRootOrganizationalUnit() : organization.findOrganizationalUnit(this.parentId);
            OrganizationalUnit ou = organization.findOrganizationalUnit(this.id);
            this.addOU = false;
            if (ou == null) {
                this.addOU = true;
                ou = organization.createOrganizationalUnit(this.id, parentOU);
            }
            ou.asMutable().setDescription(this.description);
            if (this.calendarRuleName != null) {
                CalendarRule calendarRule = organization.findCalendarRule(this.calendarRuleName);
                CalendarRuleAssignment.Mutable calendarRuleAssignment = ou.asMutable().createCalendarRuleAssignment();
                if (calendarRule != null) {
                    calendarRuleAssignment.setCalendarRule(calendarRule);
                    calendarRuleAssignment.addRelation();
                } else {
                    calendarRuleAssignment.setCalendarRule(this.calendarRuleName);
                    ou.asMutable().addCalendarRuleAssignment(calendarRuleAssignment);
                }
            } else {
                for (CalendarRule calendarRule : organization.getCalendarRules()) {
                    CalendarRuleAssignment calendarRuleAssignment = calendarRule.getCalendarRuleAssignment(ou.getInternalPath());
                    if (calendarRuleAssignment == null) continue;
                    calendarRule.asMutable().removeCalendarRuleAssignment(calendarRuleAssignment);
                    ou.asMutable().removeCalendarRuleAssignment();
                    break;
                }
            }
            this.getParseListener().objectParsed(this, ou);
        }
        catch (ProjectException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void addToModel(ProjectObject projectObject) throws ProjectException {
        OrganizationalUnit ou = (OrganizationalUnit)projectObject;
        OrganizationalUnit.Mutable mutableOU = ou.asMutable();
        mutableOU.setDescription(this.description);
        if (this.addOU) {
            Organization organization = this.getProject().getOrganization();
            organization.addOrganizationalObject(mutableOU);
        }
    }

    private class ParentIdHandler
    extends DataElementHandler {
        public ParentIdHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            OrganizationalUnitHandler.this.parentId = this.getData();
        }
    }

    private class NameHandler
    extends DataElementHandler {
        public NameHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            OrganizationalUnitHandler.this.id = this.getData();
        }
    }

    private class DescriptionHandler
    extends DataElementHandler {
        public DescriptionHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            OrganizationalUnitHandler.this.description = this.getData();
        }
    }

    private class CalendarRuleNameHandler
    extends DataElementHandler {
        public CalendarRuleNameHandler(BaseSourceHandler parent) {
            super(parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            OrganizationalUnitHandler.this.calendarRuleName = this.getData();
        }
    }
}

