/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.organization;

import java.io.IOException;
import java.io.Writer;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.io.serializers.organization.ProjectObjectSerializer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.xml.XmlWriter;

public abstract class BaseXmlSerializer
implements ProjectObjectSerializer {
    public static final String ATTR_INBOX_PRESENTATION = "inboxPresentation";
    public static final String ATTR_ACTIVITIES_PRESENTATION = "activitiesPresentation";
    public static final String ATTR_PROCESSES_PRESENTATION = "processesPresentation";
    public static final String ELEM_PUBLICATION = "publication";
    public static final String ELEM_FDI_OBJECT = "FDIObject";
    public static final String ELEM_ROLE = "DirOrganizationalRole";
    public static final String ELEM_ROLE_VIEW = "role";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ALLOW_ROLE_ASSIGNED = "allowRolesAssigned";
    public static final String ATTR_IS_PARAMETRIC = "isParametric";
    public static final String ELEM_PARAMETRIC_VALUES = "parametricValues";
    public static final String ATTR_VALUE = "value";
    public static final String ELEM_CALENDAR_RULES = "calendarRules";
    public static final String ELEM_CALENDAR_RULE = "calendarRule";
    public static final String ATTR_NAME_CALENDAR = "nameCalendar";
    public static final String ATTR_ORGANIZATIONAL_UNIT = "ou";
    public static final String ELEM_CAL_RULE = "DirCalendarRule";
    protected static final String ATTR_PROPERTIES = "properties";
    protected static final String ELEM_OUS = "ous";
    protected static final String OU_ROOT_VALUE = "/";
    public static final String ELEM_GROUP = "DirOrganizationalGroup";
    public static final String ATTR_STATUS = "status";
    public static final String ATTR_ALLOW_ROLES_ASSIGNED = "allowRolesAssigned";
    public static final String ELEM_ROLES_ASSIGNMENT = "rolesAssignment";
    public static final String ELEM_ROLE_ASSIGNMENT = "roleAssignment";
    public static final String ATTR_ROLES = "roles";
    public static final String ATTR_ROLE_ID = "roleId";
    public static final String ATTR_PARAMETRIC_VALUE = "parametricValue";
    public static final String ATTR_PERMISSIONS = "permissions";
    public static final String ATTR_CATEGORY = "category";
    public static final String ELEM_ASSIGNED_GROUPS = "assignedGroups";
    public static final String ATTR_GROUP_ID = "groupId";
    public static final String ELEM_ASSIGNED_PARTICIPANTS = "assignedParticipants";
    public static final String ATTR_PARTICIPANT_ID = "participantId";
    public static final String STATUS_ENABLED = "A";
    public static final String STATUS_DISABLED = "D";
    public static final String ELEM_HOL_RULE = "DirHolidayRule";
    public static final String ELEM_OU = "DirOrganizationalUnit";
    public static final String ELEM_PRESENTATION = "DirPresentation";
    public static final String ELEM_VIEW = "DirView";
    public static final String ATTR_PROCESSES = "processes";
    public static final String ELEM_PROCESS = "process";
    public static final String ATTR_PARENT_ID = "parentId";
    public static final String ELEM_PART = "DirHumanParticipant";
    public static final String ELEM_ORG_CHART = "OrganizationalChart";
    public static final String ATTR_OUS = "organizationalUnits";
    protected static final String ATTR_ID = "id";
    static final String ATTR_FIRST_NAME = "firstName";
    static final String ATTR_LAST_NAME = "lastName";
    static final String ATTR_DISPLAY_NAME = "displayName";
    static final String ATTR_MAIL = "mail";
    static final String ATTR_RECEIVES_MAIL = "receivesMail";
    static final String ATTR_TELEPHONE = "telephone";
    static final String ATTR_FAX = "fax";
    static final String ATTR_EMPLOYEE_ID = "employeeId";
    static final String ATTR_MANAGER = "manager";
    protected static final String ELEM_ABSENCES = "absences";
    protected static final String ELEM_ABSENCE = "absence";
    protected static final String ATTR_FROM = "from";
    protected static final String ATTR_TO = "to";
    protected static final String ATTR_REPLACEMENT = "replacement";
    protected static final String STATUS_ADMINISTRATOR = "S";
    protected static final String ATTR_COST = "cost";
    protected static final String ATTR_EFFICIENCY = "efficiency";
    protected static final String ATTR_DEPLOY = "deploy";
    protected static final String ELEM_MEASURED_PART = "measuredParticipant";
    protected static final String ELEM_VAR = "DirProcessVariable";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_SIZE = "size";
    protected static final String ATTR_MASK = "mask";
    protected static final String ELEM_LOCALIZED_DISPLAY_NAMES = "localizedDisplayNames";
    protected static final String ELEM_LOCALIZED_DISPLAY_NAME = "localizedDisplayName";
    protected static final String ATTR_LOCALE = "locale";
    protected static final String ATTR_TIMEZONE = "timezone";
    protected static final String ATTR_MESSAGE = "message";
    protected static final String ATTR_BUSINESS_TYPE = "businessType";
    protected static final String ATTR_BUSINESS_DATA = "businessData";
    protected static final String ELEM_BUSINESS_VARIABLE = "businessVariable";
    protected static final String ATTR_VIEWS_GENERATION_TYPE = "viewsGenerationType";
    protected static final String ELEM_PROPERTIES_SUFFIX = "Properties";
    protected static final String ELEM_PROPERTY_SUFFIX = "Property";
    protected static final String ELEM_PROP_CATEGORY = "prop_category";
    protected static final String ELEM_PROP_KEY = "prop_key";
    protected static final String ELEM_PROP_VALUE = "prop_value";
    protected static final String PROFILE_CATEGORY = "PROFILE_CATEGORY";
    protected static final String PROFILE_COST = "PROFILE_COST";
    protected static final String PROFILE_EFFICIENCY = "PROFILE_EFFICIENCY";
    protected static final String PARTICIPANTS_OU = "PARTICIPANTS_OU";
    protected static final String PARTICIPANTS_MAIL = "PARTICIPANTS_MAIL";
    protected static final String BUSINESS_CATEGORY = "BUSINESS_VARIABLE";
    protected static final String BUSINESS_TYPE = "TYPE";
    protected static final String BUSINESS_DATA = "DATA";
    protected static final String ELEM_REFERRAL = "DirReferral";
    protected static final String ATTR_ORGANIZATION = "organization";
    protected static final String ELEM_BUSINESS_PARAMETER = "DirBusinessParameter";
    protected static final String ATTR_DEFAULT_VALUE = "defaultValue";
    protected static final String ELEM_VALUES_MAP = "valuesMap";
    protected static final String ELEM_ENTRY = "entry";
    protected static final String ATTR_KEY = "key";
    protected static final String PROCESS_VARIABLE_PROPERTIES = "processVariableProperties";
    protected static final String PROCESS_VARIABLE_PROPERTY = "processVariableProperty";
    protected static final String ELEM_LAYOUT = "layout";

    public abstract void write(XmlWriter var1, ProjectObject var2) throws IOException;

    @Override
    public void write(Writer writer, ProjectObject object) throws ProjectException {
        XmlWriter xmlWriter = new XmlWriter(writer, Literals.DEFAULT_ENCODING);
        try {
            xmlWriter.startDocument();
            xmlWriter.startElement(ELEM_FDI_OBJECT);
            this.write(xmlWriter, object);
            xmlWriter.endElement();
        }
        catch (IOException io) {
            throw ProjectException.wrap(io);
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

