/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm.xpdl20;

import java.util.Map;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.model.albpm.PersistentAlbpmExtensions;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalization;
import oracle.bpm.project.io.serializers.model.albpm.PersistentSchedule;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentActivity;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentBaseTransition;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentCondition;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentConnectorGraphicsInfos;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentType4;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.Schedule;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.xmlparser.Element;

public class PersistentTransition
extends PersistentBaseTransition {
    public static final String ALBPM_TYPE = "albpmType";

    public void linkActivities(PersistentActivity from, PersistentActivity to) {
        this.setFrom(from.getId());
        this.setTo(to.getId());
        this.setId(from.getId(), to.getId());
        this.setName(this.getId());
        this.setConnectorGraphicsInfos(PersistentConnectorGraphicsInfos.createConnectorGraphicsInfos(from, to));
    }

    public void setId(String from, String to) {
        super.setId(from + "To" + to);
    }

    public PersistentAlbpmExtensions getAlbpmExtensions() {
        PersistentAlbpmExtensions albpmExtensions = (PersistentAlbpmExtensions)this.getElementByClass(PersistentAlbpmExtensions.class);
        if (albpmExtensions == null) {
            albpmExtensions = new PersistentAlbpmExtensions();
            this.addChild((Element)albpmExtensions);
        }
        return albpmExtensions;
    }

    public void addTo(SequenceFlow transition) throws ProjectException {
        if (transition != null) {
            if (this.hasAlbpmExtensions()) {
                Map<String, Object> featuresMap = this.getAlbpmExtensions().getFeatureSet().buildFeaturesMap();
                Features features = transition.getFeatures();
                for (PersistentFeature persistentFeature : features.persistentFeatures()) {
                    persistentFeature.fill(featuresMap);
                }
            }
            this.addActivitiesTo(transition);
            if (this.hasAlbpmExtensions()) {
                this.addScheduleTo(transition);
                this.addLocalizationTo(transition, this.getAlbpmExtensions().getLocalization());
            }
        }
    }

    public boolean hasExcludeAttribute() {
        return this.getExtendedAttributes() != null && this.getExtendedAttributes().hasExcludeAttribute();
    }

    public boolean hasAlbpmExtensions() {
        return this.getElementByClass(PersistentAlbpmExtensions.class) != null;
    }

    public Type getXpdlTransitionType() {
        PersistentCondition condition;
        Type type = Type.UNKNOWN;
        if (this.getCondition() != null && (condition = this.getCondition()).getType() != null) {
            PersistentType4 conditionType = condition.getType();
            switch (conditionType) {
                case CONDITION: {
                    type = Type.CONDITION;
                    break;
                }
                case DEFAULTEXCEPTION: {
                    type = Type.DEFAULT_EXCEPTION;
                    break;
                }
                case EXCEPTION: {
                    type = Type.EXCEPTION;
                    break;
                }
                case OTHERWISE: {
                    type = Type.OTHERWISE;
                }
            }
        }
        return type;
    }

    private void addLocalizationTo(Localizable localizable, PersistentLocalization localization) {
        if (localizable != null && localization != null) {
            LocaleStringMap descriptionMap = localizable.getDescriptionMap();
            LocaleStringMap documentationMap = localizable.getDocumentationMap();
            LocaleStringMap labelMap = localizable.getLabelMap();
            LocaleStringMap useCaseMap = localizable.getUseCaseDocumentationMap();
            localization.addTo(labelMap, descriptionMap, documentationMap, useCaseMap);
        }
    }

    private void addScheduleTo(SequenceFlow transition) throws ProjectException {
        PersistentSchedule persistentSchedule = this.getAlbpmExtensions().getSchedule();
        if (persistentSchedule != null) {
            Schedule schedule = new Schedule(transition.getProject());
            persistentSchedule.addTo(schedule);
        }
    }

    private void addActivitiesTo(SequenceFlow transition) throws ProjectException {
        this.addActivityFrom(transition);
        this.addActivityTo(transition);
    }

    private void addActivityTo(SequenceFlow transition) throws ProjectException {
    }

    private void addActivityFrom(SequenceFlow transition) {
        FlowNode nodeFrom = transition.getProcess().findNode(this.getFrom());
        if (nodeFrom == null) {
            nodeFrom = this.findUsingRealId(transition.getProcess(), this.getFrom());
        }
        if (nodeFrom == null) {
            if (!this.hasExcludeAttribute()) {
                Msg msg = ProjectMsg.SOURCE_ACTIVITY_NOT_FOUND((String)this.getFrom(), (String)this.getId());
                Log.logSevere((Msg)msg);
            }
        } else {
            transition.setSource(nodeFrom);
        }
    }

    private FlowNode findUsingRealId(Process model, String id) {
        FlowNode retAct = null;
        for (FlowNode act : model.getFlowNodes()) {
            if (!act.getId().equals(id)) continue;
            retAct = act;
            break;
        }
        return retAct;
    }

    public static enum Type {
        CONDITION,
        OTHERWISE,
        EXCEPTION,
        DEFAULT_EXCEPTION,
        UNKNOWN;

    }
}

