/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm.xpdl20;

import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentBasePools;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentLane;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentLanes;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentPool;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.xmlparser.Element;

public class PersistentPools
extends PersistentBasePools {
    private static final String UNIQUE_ALBPM_POOL_ID = "ALBPMPool";

    public PersistentPool getUniqueAlbpmPool() {
        for (PersistentPool persistentPool : this.getPool()) {
            if (!persistentPool.getId().equals(UNIQUE_ALBPM_POOL_ID)) continue;
            return persistentPool;
        }
        PersistentPool persistentPool = new PersistentPool();
        persistentPool.setId(UNIQUE_ALBPM_POOL_ID);
        this.addChild((Element)persistentPool);
        return persistentPool;
    }

    @Override
    public void addTo(Process process) throws ProjectException {
        if (this.hasAlbpmInfo()) {
            PersistentPool albpmPool = this.getUniqueAlbpmPool();
            if (albpmPool.getLanes() != null && !albpmPool.getLanes().isEmpty()) {
                PersistentLanes persistentLanes = albpmPool.getLanes();
                this.createLanes(process, persistentLanes);
            }
        } else {
            this.processOtherVendorsPool(process);
        }
    }

    public boolean hasLanes() {
        boolean retVal = false;
        if (this.getPool() != null) {
            for (PersistentPool pool : this.getPool()) {
                if (!pool.hasLanes()) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    private boolean hasAlbpmInfo() {
        boolean retVal = false;
        for (PersistentPool persistentPool : this.getPool()) {
            if (!persistentPool.getId().equals(UNIQUE_ALBPM_POOL_ID)) continue;
            retVal = true;
        }
        return retVal;
    }

    private void processOtherVendorsPool(Process process) throws ProjectException {
        if (this.getPool() != null && this.getPool().length > 0) {
            if (this.getPool() == null || !this.hasLanes()) {
                ModelUtils.findOrCreateAutomaticLane(process);
            } else {
                this.createAllLanes(process);
            }
        }
    }

    private void createAllLanes(Process process) throws ProjectException {
        for (PersistentPool persistentPool : this.getPool()) {
            PersistentLanes persistentLanes = persistentPool.getLanes();
            this.createLanes(process, persistentLanes);
        }
    }

    private void createLanes(Process process, PersistentLanes persistentLanes) throws ProjectException {
        for (PersistentLane persistentLane : persistentLanes.getLane()) {
            Lane lane = process.createLane(persistentLane.getName());
            persistentLane.addTo(lane);
            try {
                process.addChild(lane);
            }
            catch (ProjectException e) {
                throw ProjectException.wrap((ProjectObject)process, (Throwable)((Object)e));
            }
        }
    }
}

