/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm.xpdl20;

import oracle.bpm.lang.Str;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentBaseParticipant;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentDescription;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentParticipantType;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentType5;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.util.Identifier;

public class PersistentParticipant
extends PersistentBaseParticipant {
    public PersistentParticipant() {
    }

    public PersistentParticipant(Role role) {
        this.setId(Identifier.valid((String)role.getId()));
        this.setName(role.getId());
        PersistentParticipantType participantType = new PersistentParticipantType();
        participantType.setType(PersistentType5.ROLE);
        this.setParticipantType(participantType);
        if (!Str.isEmpty((String)role.getDescription())) {
            PersistentDescription persistentDescription = new PersistentDescription();
            persistentDescription.setValue(role.getDescription());
            this.setDescription(persistentDescription);
        }
    }

    public PersistentParticipant(Participant currentParticipant) {
        this.setId(Identifier.valid((String)currentParticipant.getId()));
        this.setName(currentParticipant.getId());
        PersistentParticipantType participantType = new PersistentParticipantType();
        participantType.setType(PersistentType5.HUMAN);
        this.setParticipantType(participantType);
        if (!Str.isEmpty((String)currentParticipant.getDisplayName())) {
            PersistentDescription persistentDescription = new PersistentDescription();
            persistentDescription.setValue(currentParticipant.getDisplayName());
            this.setDescription(persistentDescription);
        }
    }

    public PersistentParticipant(OrganizationalUnit organizationalUnit) {
        this.setId(Identifier.valid((String)organizationalUnit.getId()));
        this.setName(organizationalUnit.getId());
        PersistentParticipantType participantType = new PersistentParticipantType();
        participantType.setType(PersistentType5.ORGANIZATIONAL_UNIT);
        this.setParticipantType(participantType);
        if (!Str.isEmpty((String)organizationalUnit.getDescription())) {
            PersistentDescription persistentDescription = new PersistentDescription();
            persistentDescription.setValue(organizationalUnit.getDescription());
            this.setDescription(persistentDescription);
        }
    }

    public PersistentParticipant(String id) {
        this(id, null);
    }

    public PersistentParticipant(String id, String description) {
        if (!Str.isEmpty((String)id)) {
            this.setId(Identifier.valid((String)id));
            this.setName(id);
            PersistentParticipantType participantType = new PersistentParticipantType();
            participantType.setType(PersistentType5.SYSTEM);
            this.setParticipantType(participantType);
            if (!Str.isEmpty((String)description)) {
                PersistentDescription persistentDescription = new PersistentDescription();
                persistentDescription.setValue(description);
                this.setDescription(persistentDescription);
            }
        }
    }
}

