/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm.xpdl20;

import oracle.bpm.lang.Time;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentBasePackageHeader;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentCreated;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentPackageType;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentVendor;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentVendorExtension;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentVendorExtensions;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentXpdlVersion;

public class PersistentPackageHeader
extends PersistentBasePackageHeader {
    private static final String VENDOR = "BEA Aqualogic BPM";
    private static final String XPDL_VERSION = "2.0";

    public static PersistentPackageHeader getNewPackageHeader() {
        PersistentPackageHeader header = new PersistentPackageHeader();
        PersistentXpdlVersion version = new PersistentXpdlVersion();
        version.setValue(XPDL_VERSION);
        header.setXpdlVersion(version);
        PersistentVendor vendor = new PersistentVendor();
        vendor.setValue(VENDOR);
        header.setVendor(vendor);
        PersistentCreated creationDate = new PersistentCreated();
        creationDate.setValue(Time.now().format());
        header.setCreated(creationDate);
        PersistentVendorExtensions vendorExtensions = new PersistentVendorExtensions();
        PersistentVendorExtension albpmExtension = new PersistentVendorExtension();
        albpmExtension.setToolId(PersistentPackageType.ALBPM_TOOL_ID);
        albpmExtension.setSchemaLocation("http://www.albpm.com/2007/albpm.XPDL2 file:ALBPM_XPDL.xsd");
        vendorExtensions.setVendorExtension(new PersistentVendorExtension[]{albpmExtension});
        header.setVendorExtensions(vendorExtensions);
        return header;
    }

    public void setDate(Time time) {
        PersistentCreated creationDate = new PersistentCreated();
        creationDate.setValue(time.format());
        this.setCreated(creationDate);
    }

    public boolean isAlbpmPackageHeader() {
        boolean isAlbpmTool = false;
        boolean isAlbpmVendor = false;
        if (this.getVendorExtensions() != null) {
            for (PersistentVendorExtension ve : this.getVendorExtensions().getVendorExtension()) {
                if (!ve.getToolId().equals(PersistentPackageType.ALBPM_TOOL_ID)) continue;
                isAlbpmTool = true;
                break;
            }
        }
        if (this.getVendor() != null && VENDOR.equals(this.getVendor().getValue())) {
            isAlbpmVendor = true;
        }
        return isAlbpmTool && isAlbpmVendor;
    }
}

