/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm.xpdl20;

import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.io.serializers.model.albpm.PersistentAlbpmExtensions;
import oracle.bpm.project.io.serializers.model.albpm.PersistentFeatureSet;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalization;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalizationLabels;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalizedLabel;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentBaseLane;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentNodeGraphicsInfo;
import oracle.bpm.project.io.serializers.model.albpm.xpdl20.PersistentNodeGraphicsInfos;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.util.Locales;
import oracle.bpm.xmlparser.Element;

public class PersistentLane
extends PersistentBaseLane {
    public PersistentAlbpmExtensions getAlbpmExtensions() {
        PersistentAlbpmExtensions albpmExtensions = (PersistentAlbpmExtensions)this.getElementByClass(PersistentAlbpmExtensions.class);
        if (albpmExtensions == null) {
            albpmExtensions = new PersistentAlbpmExtensions();
            this.addChild((Element)albpmExtensions);
        }
        return albpmExtensions;
    }

    public void addTo(Lane lane) {
        PersistentNodeGraphicsInfos nodeGraphicsInfos = this.getNodeGraphicsInfos();
        boolean hasAlbpmInfo = nodeGraphicsInfos.hasAlbpmInfo();
        PersistentNodeGraphicsInfo nodeGraphicsInfo = hasAlbpmInfo ? nodeGraphicsInfos.getAlbpmNodeGraphicsInfo() : nodeGraphicsInfos.getFirstNodeGraphicsInfo();
        if (nodeGraphicsInfo != null) {
            if (nodeGraphicsInfo.getWidth() != null) {
                lane.setSize(nodeGraphicsInfo.getWidth().intValue());
            }
            if (nodeGraphicsInfo.getCoordinates().getXCoordinate() != null && hasAlbpmInfo) {
                lane.setOffset(nodeGraphicsInfo.getCoordinates().getXCoordinate().intValue());
            } else {
                this.fixLaneOffsetAndWidth(lane);
            }
        }
        if (hasAlbpmInfo) {
            PersistentLocalization tmp;
            PersistentLocalizationLabels labels;
            PersistentAlbpmExtensions persistentAlbpmExtensions = this.getAlbpmExtensions();
            PersistentFeatureSet persistentFeatureSet = persistentAlbpmExtensions.getFeatureSet();
            if (persistentFeatureSet != null) {
                lane.setParamName(persistentFeatureSet.getStringFeatureValue("paramVar"));
                Boolean parametric = persistentFeatureSet.getBooleanFeatureValue("parametric");
                lane.setIsParametric(parametric != null && parametric != false);
            }
            PersistentLocalizationLabels persistentLocalizationLabels = labels = (tmp = persistentAlbpmExtensions.getLocalization()) == null ? null : tmp.getLocalizationLabels();
            if (labels != null) {
                LocaleStringMap labelMap = LocaleStringMap.create();
                for (PersistentLocalizedLabel label : labels.getLocalizedLabel()) {
                    labelMap.put(Locales.valueOf((String)label.getAttribute("language")), label.getAttribute("label"));
                }
                ((LaneImpl)lane).setLabelMap(labelMap);
            }
        }
    }

    private void fixLaneOffsetAndWidth(Lane lane) {
        LaneUtils.setOffsetAfterLastLane(lane);
        int width = 200;
        if (this.getNodeGraphicsInfos() != null && this.getNodeGraphicsInfos().getFirstNodeGraphicsInfo() != null && this.getNodeGraphicsInfos().getFirstNodeGraphicsInfo().getHeight() != null) {
            width = this.getNodeGraphicsInfos().getFirstNodeGraphicsInfo().getHeight().intValue();
        }
        lane.asMutable().setSize(width);
    }
}

