/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm;

import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.io.serializers.model.albpm.PersistentBaseLocalization;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalizationDescription;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalizationDescriptions;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalizationDocumentation;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalizationDocumentations;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalizationLabels;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalizationUseCaseDocumentation;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalizationUseCaseDocumentations;
import oracle.bpm.project.io.serializers.model.albpm.PersistentLocalizedLabel;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.xmlparser.Element;

public class PersistentLocalization
extends PersistentBaseLocalization {
    public PersistentLocalization() {
    }

    public PersistentLocalization(LocaleStringMap labelMap, LocaleStringMap descriptionMap) {
        if (labelMap != null) {
            for (Map.Entry entry : labelMap.entrySet()) {
                this.addLabel((Locale)entry.getKey(), (String)entry.getValue());
            }
        }
        if (descriptionMap != null) {
            for (Map.Entry entry : descriptionMap.entrySet()) {
                this.addDescription((Locale)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public PersistentLocalization(LocaleStringMap labelMap, LocaleStringMap descriptionMap, LocaleStringMap documentationMap) {
        this(labelMap, descriptionMap);
        if (documentationMap != null) {
            for (Map.Entry entry : documentationMap.entrySet()) {
                this.addDocumentation((Locale)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public PersistentLocalization(LocaleStringMap labelMap, LocaleStringMap descriptionMap, LocaleStringMap documentationMap, LocaleStringMap useCaseDocumentation) {
        this(labelMap, descriptionMap, documentationMap);
        if (useCaseDocumentation != null) {
            for (Map.Entry useCase : useCaseDocumentation.entrySet()) {
                this.addUseCaseDocumentation((Locale)useCase.getKey(), (String)useCase.getValue());
            }
        }
    }

    public PersistentLocalizationLabels getLabels() {
        PersistentLocalizationLabels labels = super.getLocalizationLabels();
        if (labels == null) {
            labels = new PersistentLocalizationLabels();
            this.setLocalizationLabels(labels);
        }
        return labels;
    }

    public PersistentLocalizationDescriptions getDescriptions() {
        PersistentLocalizationDescriptions descriptions = super.getLocalizationDescriptions();
        if (descriptions == null) {
            descriptions = new PersistentLocalizationDescriptions();
            this.setLocalizationDescriptions(descriptions);
        }
        return descriptions;
    }

    public PersistentLocalizationDocumentations getDocumentations() {
        PersistentLocalizationDocumentations documentations = super.getLocalizationDocumentations();
        if (documentations == null) {
            documentations = new PersistentLocalizationDocumentations();
            this.setLocalizationDocumentations(documentations);
        }
        return documentations;
    }

    public PersistentLocalizationUseCaseDocumentations getUseCaseDocumentations() {
        PersistentLocalizationUseCaseDocumentations useCaseDocumentations = super.getLocalizationUseCaseDocumentations();
        if (useCaseDocumentations == null) {
            useCaseDocumentations = new PersistentLocalizationUseCaseDocumentations();
            this.setLocalizationUseCaseDocumentations(useCaseDocumentations);
        }
        return useCaseDocumentations;
    }

    public void addTo(LocaleStringMap labelsMap, LocaleStringMap descriptionsMap, LocaleStringMap documentationsMap, LocaleStringMap useCaseDocumentationMap) {
        if (labelsMap != null && !this.getLabels().isEmpty()) {
            this.getLabels().addTo(labelsMap);
        }
        if (descriptionsMap != null && !this.getDescriptions().isEmpty()) {
            this.getDescriptions().addTo(descriptionsMap);
        }
        if (documentationsMap != null && !this.getDocumentations().isEmpty()) {
            this.getDocumentations().addTo(documentationsMap);
        }
        if (documentationsMap != null && !this.getUseCaseDocumentations().isEmpty()) {
            this.getUseCaseDocumentations().addTo(useCaseDocumentationMap);
        }
    }

    @Override
    public void addTo(Process process) throws ProjectException {
    }

    private void addLabel(Locale locale, String label) {
        this.getLabels().addChild((Element)new PersistentLocalizedLabel(locale, label));
    }

    private void addDescription(Locale locale, String desc) {
        this.getDescriptions().addChild((Element)new PersistentLocalizationDescription(locale, desc));
    }

    private void addDocumentation(Locale locale, String documentation) {
        this.getDocumentations().addChild((Element)new PersistentLocalizationDocumentation(locale, documentation));
    }

    private void addUseCaseDocumentation(Locale locale, String useCaseDoc) {
        this.getUseCaseDocumentations().addChild((Element)new PersistentLocalizationUseCaseDocumentation(locale, useCaseDoc));
    }
}

