/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.albpm;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.project.io.serializers.model.albpm.PersistentAbstractFeature;
import oracle.bpm.project.io.serializers.model.albpm.PersistentBaseElement;
import oracle.bpm.project.io.serializers.model.albpm.PersistentBaseFeatureSet;
import oracle.bpm.project.io.serializers.model.albpm.PersistentBooleanFeature;
import oracle.bpm.project.io.serializers.model.albpm.PersistentIntegerFeature;
import oracle.bpm.project.io.serializers.model.albpm.PersistentStringFeature;
import oracle.bpm.xmlparser.Element;

public class PersistentFeatureSet
extends PersistentBaseFeatureSet {
    public PersistentFeatureSet() {
    }

    public PersistentFeatureSet(String name) {
        this.setName(name);
    }

    public PersistentAbstractFeature[] findFeatures() {
        return (PersistentAbstractFeature[])this.findChildrenByClass(PersistentAbstractFeature.class);
    }

    public void addFeature(PersistentAbstractFeature feature) {
        this.addChild((Element)feature);
    }

    public void addStringFeature(String featureName, String value) {
        PersistentStringFeature stringFeature = new PersistentStringFeature();
        stringFeature.setName(featureName);
        stringFeature.setValue(value);
        this.addChild((Element)stringFeature);
    }

    public void addBooleanFeature(String featureName, Boolean value) {
        PersistentBooleanFeature booleanFeature = new PersistentBooleanFeature();
        booleanFeature.setName(featureName);
        booleanFeature.setValue(value);
        this.addChild((Element)booleanFeature);
    }

    public void addIntegerFeature(String featureName, Long value) {
        PersistentIntegerFeature integerFeature = new PersistentIntegerFeature();
        integerFeature.setName(featureName);
        integerFeature.setValue(value);
        this.addChild((Element)integerFeature);
    }

    public <E extends PersistentAbstractFeature> E getFeature(String featureName, Class<E> clazz) {
        for (PersistentAbstractFeature childrenFeature : this.findFeatures()) {
            if (!childrenFeature.getName().equals(featureName)) continue;
            return (E)((Object)childrenFeature);
        }
        return null;
    }

    public String getStringFeatureValue(String featureName) {
        PersistentStringFeature stringFeature = this.getFeature(featureName, PersistentStringFeature.class);
        return stringFeature != null ? stringFeature.getValue() : null;
    }

    public Boolean getBooleanFeatureValue(String featureName) {
        PersistentBooleanFeature feature = this.getFeature(featureName, PersistentBooleanFeature.class);
        return feature != null ? feature.getValue() : null;
    }

    public Long getIntegerFeatureValue(String featureName) {
        PersistentIntegerFeature feature = this.getFeature(featureName, PersistentIntegerFeature.class);
        return feature != null ? feature.getValue() : null;
    }

    public void addChildFeatureSet(PersistentFeatureSet childFeatureSet) {
        this.addChild((Element)childFeatureSet);
    }

    public PersistentFeatureSet getChildFeatureSet(String childFeatureSetName) {
        for (PersistentFeatureSet childFeatureSet : (PersistentFeatureSet[])this.findChildrenByClass(PersistentFeatureSet.class)) {
            if (!childFeatureSet.getName().equals(childFeatureSetName)) continue;
            return childFeatureSet;
        }
        return null;
    }

    public Map<String, String> buildFeaturesMap() {
        return this.buildFeaturesMap(false);
    }

    public Map<String, String> buildFeaturesMap(boolean recursive) {
        HashMap<String, String> featuresMap = new HashMap<String, String>();
        for (PersistentAbstractFeature persistentAbstractFeature : this.findFeatures()) {
            featuresMap.put(persistentAbstractFeature.getName(), persistentAbstractFeature.getStringValue());
        }
        if (recursive) {
            for (PersistentBaseElement persistentBaseElement : (PersistentFeatureSet[])this.findChildrenByClass(PersistentFeatureSet.class)) {
                featuresMap.putAll(((PersistentFeatureSet)persistentBaseElement).buildFeaturesMap(recursive));
            }
        }
        return featuresMap;
    }
}

